/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.Accumulator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POMapLookUp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORelationToExprProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.UnaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSortedDistinct;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class AccumulatorOptimizer
extends MROpPlanVisitor {
    private Log log = LogFactory.getLog(this.getClass());

    public AccumulatorOptimizer(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
    }

    public void visitMROp(MapReduceOper mr) throws VisitorException {
        boolean[] isInner;
        List pos = mr.reducePlan.getRoots();
        if (pos == null || pos.size() == 0) {
            return;
        }
        PhysicalOperator po_package = (PhysicalOperator)pos.get(0);
        if (!po_package.getClass().equals(POPackage.class)) {
            return;
        }
        if (((POPackage)po_package).isDistinct()) {
            return;
        }
        for (boolean b : isInner = ((POPackage)po_package).getInner()) {
            if (!b) continue;
            return;
        }
        List<PhysicalOperator> l = mr.reducePlan.getSuccessors(po_package);
        if (l == null || l.size() == 0 || l.size() > 1) {
            return;
        }
        PhysicalOperator po_foreach = l.get(0);
        if (!(po_foreach instanceof POForEach)) {
            return;
        }
        boolean foundUDF = false;
        List<PhysicalPlan> list = ((POForEach)po_foreach).getInputPlans();
        for (PhysicalPlan p : list) {
            PhysicalOperator po = (PhysicalOperator)p.getLeaves().get(0);
            if (!(po instanceof ExpressionOperator)) {
                return;
            }
            if (((ExpressionOperator)po).containUDF()) {
                foundUDF = true;
            }
            if (this.check(po)) continue;
            return;
        }
        if (foundUDF) {
            this.log.info((Object)"Reducer is to run in accumulative mode.");
            po_package.setAccumulative();
            po_foreach.setAccumulative();
        }
    }

    private boolean check(PhysicalOperator po) {
        if (po instanceof ConstantExpression) {
            return true;
        }
        if (po instanceof POCast) {
            return this.check(po.getInputs().get(0));
        }
        if (po instanceof POMapLookUp) {
            return this.check(po.getInputs().get(0));
        }
        if (po instanceof POProject) {
            if (((POProject)po).getResultType() == 120) {
                return false;
            }
            return ((POProject)po).getResultType() != 110 || !((POProject)po).isOverloaded();
        }
        if (po instanceof UnaryExpressionOperator) {
            return this.check(((UnaryExpressionOperator)po).getExpr());
        }
        if (po instanceof BinaryExpressionOperator) {
            return this.check(((BinaryExpressionOperator)po).getLhs()) && this.check(((BinaryExpressionOperator)po).getRhs());
        }
        if (po instanceof POBinCond) {
            return this.check(((POBinCond)po).getLhs()) && this.check(((POBinCond)po).getRhs()) && this.check(((POBinCond)po).getCond());
        }
        if (po instanceof POUserFunc) {
            String className = ((POUserFunc)po).getFuncSpec().getClassName();
            Class c = null;
            try {
                c = PigContext.resolveClassName(className);
            }
            catch (Exception e) {
                return false;
            }
            if (!Accumulator.class.isAssignableFrom(c)) {
                return false;
            }
            List<PhysicalOperator> inputs = po.getInputs();
            for (PhysicalOperator p : inputs) {
                if (this.checkUDFInput(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkUDFInput(PhysicalOperator po) {
        if (po instanceof PORelationToExprProject) {
            return this.checkUDFInput(po.getInputs().get(0));
        }
        if (po instanceof POProject) {
            if (po.getInputs() == null) {
                return true;
            }
            return this.checkUDFInput(po.getInputs().get(0));
        }
        if (po instanceof ConstantExpression) {
            return true;
        }
        if (po instanceof UnaryExpressionOperator) {
            return this.checkUDFInput(((UnaryExpressionOperator)po).getExpr());
        }
        if (po instanceof BinaryExpressionOperator) {
            return this.checkUDFInput(((BinaryExpressionOperator)po).getLhs()) || this.checkUDFInput(((BinaryExpressionOperator)po).getRhs());
        }
        if (po instanceof POCast) {
            return this.checkUDFInput(po.getInputs().get(0));
        }
        if (po instanceof POBinCond) {
            return this.checkUDFInput(((POBinCond)po).getLhs()) || this.checkUDFInput(((POBinCond)po).getRhs()) || this.checkUDFInput(((POBinCond)po).getCond());
        }
        if (po instanceof POSortedDistinct) {
            return true;
        }
        if (po instanceof POForEach) {
            List<PhysicalPlan> list = ((POForEach)po).getInputPlans();
            if (list.size() != 1) {
                return false;
            }
            PhysicalOperator p = (PhysicalOperator)list.get(0).getLeaves().get(0);
            if (this.checkUDFInput(p)) {
                return this.checkUDFInput(po.getInputs().get(0));
            }
        }
        return false;
    }
}

