/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataType;
import org.apache.pig.data.SingleTupleBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPreCombinerLocalRearrange
extends PhysicalOperator {
    protected static final long serialVersionUID = 1L;
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    protected static BagFactory mBagFactory = BagFactory.getInstance();
    private static Log log = LogFactory.getLog(POPreCombinerLocalRearrange.class);
    private static final Result ERR_RESULT = new Result();
    protected List<PhysicalPlan> plans;
    protected List<ExpressionOperator> leafOps = new ArrayList<ExpressionOperator>();
    protected byte keyType;

    public POPreCombinerLocalRearrange(OperatorKey k) {
        this(k, -1, null);
    }

    public POPreCombinerLocalRearrange(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POPreCombinerLocalRearrange(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POPreCombinerLocalRearrange(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPreCombinerLocalRearrange(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Pre Combiner Local Rearrange" + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "} - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void attachInput(Tuple t) {
        super.attachInput(t);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Result inp;
        block16: {
            inp = null;
            Result res = ERR_RESULT;
            do {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break block16;
            } while (inp.returnStatus == 1);
            for (PhysicalPlan ep : this.plans) {
                ep.attachInput((Tuple)inp.result);
            }
            ArrayList<Result> resLst = new ArrayList<Result>();
            for (ExpressionOperator op : this.leafOps) {
                switch (op.getResultType()) {
                    case 120: {
                        res = op.getNext(dummyBag);
                        break;
                    }
                    case 5: {
                        res = op.getNext(dummyBool);
                        break;
                    }
                    case 50: {
                        res = op.getNext(dummyDBA);
                        break;
                    }
                    case 55: {
                        res = op.getNext(dummyString);
                        break;
                    }
                    case 25: {
                        res = op.getNext(dummyDouble);
                        break;
                    }
                    case 20: {
                        res = op.getNext(dummyFloat);
                        break;
                    }
                    case 10: {
                        res = op.getNext(dummyInt);
                        break;
                    }
                    case 15: {
                        res = op.getNext(dummyLong);
                        break;
                    }
                    case 100: {
                        res = op.getNext(dummyMap);
                        break;
                    }
                    case 110: {
                        res = op.getNext(dummyTuple);
                        break;
                    }
                    default: {
                        log.error((Object)("Invalid result type: " + DataType.findType(op.getResultType())));
                    }
                }
                if (res.returnStatus != 0 && res.returnStatus != 1) {
                    return new Result();
                }
                resLst.add(res);
            }
            res.result = this.constructLROutput(resLst, (Tuple)inp.result);
            res.returnStatus = 0;
            return res;
        }
        return inp;
    }

    protected Tuple constructLROutput(List<Result> resLst, Tuple value) throws ExecException {
        Object key;
        if (resLst.size() > 1) {
            Tuple t = mTupleFactory.newTuple(resLst.size());
            int i = -1;
            for (Result res : resLst) {
                t.set(++i, res.result);
            }
            key = t;
        } else {
            key = resLst.get((int)0).result;
        }
        Tuple output = mTupleFactory.newTuple(2);
        output.set(0, key);
        SingleTupleBag bg = new SingleTupleBag(value);
        output.set(1, bg);
        return output;
    }

    public byte getKeyType() {
        return this.keyType;
    }

    public void setKeyType(byte keyType) {
        this.keyType = keyType;
    }

    public List<PhysicalPlan> getPlans() {
        return this.plans;
    }

    public void setPlans(List<PhysicalPlan> plans) {
        this.plans = plans;
        this.leafOps.clear();
        for (PhysicalPlan plan : plans) {
            ExpressionOperator leaf = (ExpressionOperator)plan.getLeaves().get(0);
            this.leafOps.add(leaf);
        }
    }
}

