/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntMin
extends EvalFunc<Integer>
implements Algebraic,
Accumulator<Integer> {
    private Integer intermediateMin = null;

    @Override
    public Integer exec(Tuple input) throws IOException {
        try {
            return IntMin.min(input);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing min in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    protected static Integer min(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        int curMin = Integer.MAX_VALUE;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Integer i = (Integer)t.get(0);
                if (i == null) continue;
                sawNonNull = true;
                curMin = Math.min(curMin, i);
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing min of floats.";
                throw new ExecException(msg, errCode, 4, exp);
            }
        }
        if (sawNonNull) {
            return curMin;
        }
        return null;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 10));
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        try {
            Integer curMin = IntMin.min(b);
            if (curMin == null) {
                return;
            }
            if (this.intermediateMin == null) {
                this.intermediateMin = Integer.MAX_VALUE;
            }
            this.intermediateMin = Math.min(this.intermediateMin, curMin);
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing min in " + this.getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, e);
        }
    }

    @Override
    public void cleanup() {
        this.intermediateMin = null;
    }

    @Override
    public Integer getValue() {
        return this.intermediateMin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final
    extends EvalFunc<Integer> {
        @Override
        public Integer exec(Tuple input) throws IOException {
            try {
                return IntMin.min(input);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing min in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermediate
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                return tfact.newTuple(IntMin.min(input));
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing min in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends EvalFunc<Tuple> {
        private static TupleFactory tfact = TupleFactory.getInstance();

        @Override
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                Integer i = null;
                if (bg.iterator().hasNext()) {
                    Tuple tp = bg.iterator().next();
                    i = (Integer)tp.get(0);
                }
                return tfact.newTuple(i);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing min in " + this.getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, e);
            }
        }
    }
}

