/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public abstract class TypeCastInserter
extends Rule {
    public TypeCastInserter(String n) {
        super(n, true);
    }

    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LogicalRelationalOperator op = this.getOperatorClassName().equals(LOLoad.class.getName()) ? new LOLoad(null, null, plan, null) : new LOStream(plan, null, null, null);
        plan.add(op);
        return plan;
    }

    abstract String getOperatorClassName();

    public Transformer getNewTransformer() {
        return new TypeCastInserterTransformer();
    }

    public class TypeCastInserterTransformer
    extends Transformer {
        public boolean check(OperatorPlan matched) throws FrontendException {
            LogicalRelationalOperator op = (LogicalRelationalOperator)matched.getSources().get(0);
            LogicalSchema s = op.getSchema();
            if (s == null) {
                return false;
            }
            if (op instanceof LOLoad ? ((LOLoad)op).isCastInserted() : ((LOStream)op).isCastInserted()) {
                return false;
            }
            boolean sawOne = false;
            List<LogicalSchema.LogicalFieldSchema> fss = s.getFields();
            LogicalSchema determinedSchema = null;
            if (LOLoad.class.getName().equals(TypeCastInserter.this.getOperatorClassName())) {
                determinedSchema = ((LOLoad)op).getDeterminedSchema();
            }
            for (int i = 0; i < fss.size(); ++i) {
                if (fss.get((int)i).type == 50 || determinedSchema != null && fss.get(i).isEqual(determinedSchema.getField(i))) continue;
                sawOne = true;
            }
            return sawOne;
        }

        public void transform(OperatorPlan matched) throws FrontendException {
            int i;
            LogicalRelationalOperator op = (LogicalRelationalOperator)matched.getSources().get(0);
            LogicalSchema s = op.getSchema();
            LogicalPlan innerPlan = new LogicalPlan();
            LOForEach foreach = new LOForEach(TypeCastInserter.this.currentPlan);
            foreach.setInnerPlan(innerPlan);
            foreach.setAlias(op.getAlias());
            Operator next = TypeCastInserter.this.currentPlan.getSuccessors(op).get(0);
            TypeCastInserter.this.currentPlan.insertBetween(op, foreach, next);
            ArrayList<LogicalExpressionPlan> exps = new ArrayList<LogicalExpressionPlan>();
            LOGenerate gen = new LOGenerate(innerPlan, exps, new boolean[s.size()]);
            innerPlan.add(gen);
            LogicalSchema determinedSchema = null;
            if (LOLoad.class.getName().equals(TypeCastInserter.this.getOperatorClassName())) {
                determinedSchema = ((LOLoad)op).getDeterminedSchema();
            } else {
                determinedSchema = new LogicalSchema();
                for (i = 0; i < s.size(); ++i) {
                    determinedSchema.addField(new LogicalSchema.LogicalFieldSchema(null, null, 50));
                }
            }
            for (i = 0; i < s.size(); ++i) {
                LogicalSchema.LogicalFieldSchema fs = s.getField(i);
                LOInnerLoad innerLoad = new LOInnerLoad(innerPlan, foreach, i);
                innerPlan.add(innerLoad);
                innerPlan.connect(innerLoad, gen);
                LogicalExpressionPlan exp = new LogicalExpressionPlan();
                ProjectExpression prj = new ProjectExpression(exp, i, 0, gen);
                exp.add(prj);
                if (!(fs.type == 50 || determinedSchema != null && fs.isEqual(determinedSchema.getField(i)))) {
                    CastExpression cast = new CastExpression(exp, prj, new LogicalSchema.LogicalFieldSchema(fs));
                    exp.add(cast);
                    FuncSpec loadFuncSpec = null;
                    if (op instanceof LOLoad) {
                        loadFuncSpec = ((LOLoad)op).getFileSpec().getFuncSpec();
                    } else if (op instanceof LOStream) {
                        StreamingCommand command = ((LOStream)op).getStreamingCommand();
                        StreamingCommand.HandleSpec streamOutputSpec = command.getOutputSpec();
                        loadFuncSpec = new FuncSpec(streamOutputSpec.getSpec());
                    } else {
                        String msg = "TypeCastInserter invoked with an invalid operator class name: " + innerPlan.getClass().getSimpleName();
                        throw new FrontendException(msg, 2242);
                    }
                    cast.setFuncSpec(loadFuncSpec);
                }
                exps.add(exp);
            }
            if (op instanceof LOLoad) {
                ((LOLoad)op).setCastInserted(true);
            } else {
                ((LOStream)op).setCastInserted(true);
            }
        }

        public OperatorPlan reportChanges() {
            return TypeCastInserter.this.currentPlan;
        }
    }
}

