/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.sampledata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaDataParser;
import org.pentaho.reporting.engine.classic.extensions.datasources.sampledata.SampleDataModule;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializer;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class SampleDataModuleInitializer
implements ModuleInitializer {
    private static final Log logger = LogFactory.getLog(SampleDataModuleInitializer.class);

    public void performInit() throws ModuleInitializeException {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.populateDatabase();
        }
        catch (Exception e) {
            throw new ModuleInitializeException("Failed to load the HSQL-DB driver", e);
        }
        ElementMetaDataParser.initializeOptionalDataFactoryMetaData((String)"org/pentaho/reporting/engine/classic/extensions/datasources/sampledata/meta-datafactory.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateDatabase() throws SQLException, IOException {
        Connection connection = DriverManager.getConnection("jdbc:hsqldb:mem:SampleData", "sa", "");
        try {
            Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
            String location = config.getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.sampledata.SampleDataLocation");
            InputStream in = SampleDataModule.class.getResourceAsStream(location);
            if (in == null) {
                logger.warn((Object)("Invalid database init-script specified. Sample database will be empty. [" + location + "]"));
                return;
            }
            InputStreamReader inReader = new InputStreamReader(in);
            BufferedReader bin = new BufferedReader(inReader);
            try {
                Statement statement = connection.createStatement();
                try {
                    String line;
                    while ((line = bin.readLine()) != null) {
                        try {
                            statement.execute(line);
                        }
                        catch (SQLException e) {
                            if (line.startsWith("CREATE SCHEMA ") || line.startsWith("CREATE USER SA ") || line.startsWith("GRANT DBA TO SA")) continue;
                            throw e;
                            return;
                        }
                    }
                }
                finally {
                    statement.close();
                }
            }
            finally {
                bin.close();
            }
        }
        finally {
            connection.close();
        }
    }
}

