/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.gwt.widgets.client.dialogs.GlassPane;
import org.pentaho.gwt.widgets.client.dialogs.GlassPaneListener;
import org.pentaho.gwt.widgets.client.dialogs.GlassPaneNativeListener;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.LogoPanel;
import org.pentaho.mantle.client.MantleMainMenuBar;
import org.pentaho.mantle.client.XulMain;
import org.pentaho.mantle.client.commands.CommandExec;
import org.pentaho.mantle.client.commands.LoginCommand;
import org.pentaho.mantle.client.dialogs.WaitPopup;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.PluginOptionsHelper;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.SolutionDocumentManager;
import org.pentaho.mantle.client.usersettings.IMantleSettingsListener;
import org.pentaho.mantle.client.usersettings.IUserSettingsListener;
import org.pentaho.mantle.client.usersettings.MantleSettingsManager;
import org.pentaho.mantle.client.usersettings.UserSettingsManager;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MantleApplication
implements IUserSettingsListener,
IMantleSettingsListener {
    public static boolean showAdvancedFeatures = false;
    public static String mantleRevisionOverride = null;
    public static boolean submitOnEnter = true;
    private LogoPanel logoPanel;
    private MantleMainMenuBar menuBar;
    private SolutionBrowserPerspective solutionBrowserPerspective;
    private XulMain main;
    private CommandExec commandExec = (CommandExec)GWT.create(CommandExec.class);
    public static AbsolutePanel overlayPanel = new AbsolutePanel();

    public void loadApplication() {
        this.logoPanel = new LogoPanel(Messages.getString("logoPanelWebsite"));
        this.menuBar = new MantleMainMenuBar();
        this.solutionBrowserPerspective = SolutionBrowserPerspective.getInstance(this.menuBar);
        this.main = XulMain.instance(this.solutionBrowserPerspective);
        this.setupNativeHooks(this, new LoginCommand());
        UserSettingsManager.getInstance().addUserSettingsListener(this);
        MantleSettingsManager.getInstance().addMantleSettingsListener(this);
    }

    public native void setupNativeHooks(MantleApplication var1, LoginCommand var2);

    private void executeCommand(String commandName) {
        this.commandExec.execute(commandName);
    }

    private void addGlassPaneListener(JavaScriptObject obj) {
        GlassPane.getInstance().addGlassPaneListener((GlassPaneListener)new GlassPaneNativeListener(obj));
    }

    private void showMessage(String title, String message) {
        MessageDialogBox dialog = new MessageDialogBox(title, message, true, false, true);
        dialog.center();
    }

    @Override
    public void onFetchUserSettings(ArrayList<IUserSetting> settings) {
        if (settings == null) {
            return;
        }
        for (IUserSetting setting : settings) {
            try {
                if ("MANTLE_SHOW_NAVIGATOR".equals(setting.getSettingName())) {
                    boolean showNavigator = "true".equals(setting.getSettingValue());
                    this.solutionBrowserPerspective.setNavigatorShowing(showNavigator);
                    continue;
                }
                if (!"MANTLE_LOGO_LAUNCH_URL".equals(setting.getSettingName())) continue;
                String url = setting.getSettingValue();
                this.logoPanel.setLaunchURL(url);
            }
            catch (Exception e) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetUserSettings"), false, false, true);
                dialogBox.center();
            }
        }
    }

    @Override
    public void onFetchMantleSettings(HashMap<String, String> settings) {
        String startupURL;
        mantleRevisionOverride = settings.get("user-console-revision");
        FlexTable menuAndLogoPanel = new FlexTable();
        menuAndLogoPanel.setCellPadding(0);
        menuAndLogoPanel.setCellSpacing(0);
        menuAndLogoPanel.setStyleName("menuBarAndLogoPanel");
        menuAndLogoPanel.setWidth("100%");
        if ("true".equals(settings.get("show-logo-panel")) && "true".equals(settings.get("show-menu-bar")) && "true".equals(settings.get("show-main-toolbar"))) {
            menuAndLogoPanel.setWidget(0, 1, (Widget)this.logoPanel);
            menuAndLogoPanel.getFlexCellFormatter().setRowSpan(0, 1, 2);
            menuAndLogoPanel.getFlexCellFormatter().setWidth(0, 1, "180px");
            menuAndLogoPanel.getFlexCellFormatter().setHeight(0, 1, "100%");
        }
        if ("true".equals(settings.get("show-menu-bar"))) {
            menuAndLogoPanel.setWidget(0, 0, (Widget)this.menuBar);
            menuAndLogoPanel.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
        }
        if ("true".equals(settings.get("show-main-toolbar"))) {
            menuAndLogoPanel.setWidget(1, 0, (Widget)this.main);
            this.main.setWidth("100%");
        }
        VerticalPanel mainApplicationPanel = new VerticalPanel();
        mainApplicationPanel.setStyleName("applicationShell");
        mainApplicationPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        mainApplicationPanel.add((Widget)menuAndLogoPanel);
        mainApplicationPanel.setCellHeight((Widget)menuAndLogoPanel, "1px");
        PluginOptionsHelper.buildEnabledOptionsList(settings);
        mainApplicationPanel.add((Widget)this.solutionBrowserPerspective);
        RootPanel.get().add((Widget)mainApplicationPanel);
        RootPanel.get().add((Widget)WaitPopup.getInstance());
        overlayPanel.setVisible(false);
        overlayPanel.setHeight("100%");
        overlayPanel.setWidth("100%");
        overlayPanel.getElement().getStyle().setProperty("zIndex", "1000");
        overlayPanel.getElement().getStyle().setProperty("position", "absolute");
        RootPanel.get().add((Widget)overlayPanel, 0, 0);
        showAdvancedFeatures = "true".equals(settings.get("show-advanced-features"));
        boolean isAdministrator = "true".equals(settings.get("is-administrator"));
        this.solutionBrowserPerspective.setAdministrator(isAdministrator);
        this.menuBar.buildMenuBar(settings, isAdministrator);
        int numStartupURLs = Integer.parseInt(settings.get("num-startup-urls"));
        for (int i = 0; i < numStartupURLs; ++i) {
            String url = settings.get("startup-url-" + (i + 1));
            String name = settings.get("startup-name-" + (i + 1));
            if (url == null || "".equals(url)) continue;
            this.solutionBrowserPerspective.getContentTabPanel().showNewURLTab(name != null ? name : url, url, url, false);
        }
        if (this.solutionBrowserPerspective.getContentTabPanel().getWidgetCount() > 0) {
            this.solutionBrowserPerspective.getContentTabPanel().selectTab(0);
        }
        if ((startupURL = Window.Location.getParameter((String)"startup-url")) != null && !"".equals(startupURL)) {
            String title = Window.Location.getParameter((String)"name");
            startupURL = URL.decodeComponent((String)startupURL);
            this.solutionBrowserPerspective.getContentTabPanel().showNewURLTab(title, title, startupURL, false);
        }
        SolutionDocumentManager.getInstance().fetchSolutionDocument(true);
        String submitOnEnterSetting = settings.get("submit-on-enter-key");
        submitOnEnter = submitOnEnterSetting == null ? true : Boolean.parseBoolean(submitOnEnterSetting);
    }

    public MantleMainMenuBar getMenuBar() {
        return this.menuBar;
    }
}

