/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.gwt.widgets.client.menuitem.CheckBoxMenuItem;
import org.pentaho.gwt.widgets.client.menuitem.PentahoMenuItem;
import org.pentaho.mantle.client.IViewMenuCallback;
import org.pentaho.mantle.client.MantleApplication;
import org.pentaho.mantle.client.MantleMenuBar;
import org.pentaho.mantle.client.commands.AboutCommand;
import org.pentaho.mantle.client.commands.CommandExec;
import org.pentaho.mantle.client.commands.ExecuteGlobalActionsCommand;
import org.pentaho.mantle.client.commands.JavascriptObjectCommand;
import org.pentaho.mantle.client.commands.LogoutCommand;
import org.pentaho.mantle.client.commands.OpenDocCommand;
import org.pentaho.mantle.client.commands.OpenFileCommand;
import org.pentaho.mantle.client.commands.OpenURLCommand;
import org.pentaho.mantle.client.commands.PentahoHomeCommand;
import org.pentaho.mantle.client.commands.PurgeMondrianSchemaCacheCommand;
import org.pentaho.mantle.client.commands.PurgeReportingDataCacheCommand;
import org.pentaho.mantle.client.commands.RefreshMetaDataCommand;
import org.pentaho.mantle.client.commands.RefreshRepositoryCommand;
import org.pentaho.mantle.client.commands.RefreshSystemSettingsCommand;
import org.pentaho.mantle.client.commands.RefreshWorkspaceCommand;
import org.pentaho.mantle.client.commands.SaveCommand;
import org.pentaho.mantle.client.commands.ShowPreferencesCommand;
import org.pentaho.mantle.client.commands.SwitchLocaleCommand;
import org.pentaho.mantle.client.commands.SwitchThemeCommand;
import org.pentaho.mantle.client.commands.UrlCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.PluginOptionsHelper;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserListener;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;
import org.pentaho.mantle.client.usersettings.UserSettingsManager;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MantleMainMenuBar
extends MenuBar
implements IViewMenuCallback,
SolutionBrowserListener {
    private MantleMenuBar viewMenu = new MantleMenuBar(true);
    private PentahoMenuItem saveMenuItem;
    private PentahoMenuItem saveAsMenuItem;
    private PentahoMenuItem propertiesMenuItem;
    private MenuBar fileMenu;
    private MenuBar recentMenu;
    private MenuBar favoritesMenu;
    private CommandExec commandExec = (CommandExec)GWT.create(CommandExec.class);
    private FileCommand propertiesCommand;
    private Map<String, MenuBar> menuBars = new HashMap<String, MenuBar>();
    private List<UIObject> standardViewMenuItems = new ArrayList<UIObject>();
    private ArrayList<UIObject> viewMenuAdditions = new ArrayList();

    public MantleMainMenuBar() {
        super(false);
        this.getElement().setId("main_toolbar");
        this.setAutoOpen(false);
        this.setHeight("26px");
        this.setWidth("100%");
    }

    private native void setupNativeFunctions(MantleMainMenuBar var1);

    private void addMenuItemWithCommand(String key, String parent, String command) {
        Command namedCommand = this.commandExec.lookupCommand(command);
        if (namedCommand == null) {
            Window.alert((String)("Error finding command by with the name: " + command));
            return;
        }
        MenuItem newMenuItem = new MenuItem(Messages.getString(key), namedCommand);
        MenuBar targetMenuParent = this.findMenuBar(parent);
        targetMenuParent.addItem(newMenuItem);
    }

    private void addMenuItemWithFunction(String key, String parent, JavaScriptObject func) {
        MenuItem newMenuItem = new MenuItem(Messages.getString(key), (Command)new JavascriptObjectCommand(func));
        MenuBar targetMenuParent = this.findMenuBar(parent);
        targetMenuParent.addItem(newMenuItem);
    }

    private MenuBar findMenuBar(String parentId) {
        return this.menuBars.get(parentId);
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        switch (DOM.eventGetType((Event)event)) {
            case 16: {
                if ("DIV".equals(event.getTarget().getNodeName()) || this.getSelectedItem() == null) break;
                this.getSelectedItem().addStyleDependentName("selected");
            }
        }
    }

    public void onPopupClosed(PopupPanel sender, boolean autoClosed) {
        super.onPopupClosed(sender, autoClosed);
        this.getSelectedItem().removeStyleDependentName("selected");
    }

    public void buildMenuBar(HashMap<String, String> settings, boolean isAdministrator) {
        Map supportedLanguages;
        this.clearItems();
        SolutionBrowserPerspective.getInstance().addSolutionBrowserListener(this);
        this.saveMenuItem = new PentahoMenuItem(Messages.getString("save"), (Command)new SaveCommand(false));
        this.saveMenuItem.getElement().setId("save");
        this.saveAsMenuItem = new PentahoMenuItem(Messages.getString("saveAsEllipsis"), (Command)new SaveCommand(true));
        this.saveAsMenuItem.getElement().setId("saveAs");
        this.propertiesMenuItem = new PentahoMenuItem(Messages.getString("propertiesEllipsis"), null);
        this.propertiesMenuItem.getElement().setId("properties");
        this.fileMenu = new MantleMenuBar(true);
        this.fileMenu.getElement().setId("file_menu");
        this.menuBars.put("file_menu", this.fileMenu);
        MantleMenuBar newMenu = new MantleMenuBar(true);
        newMenu.getElement().setId("new_menu");
        this.menuBars.put("new_menu", newMenu);
        MenuItem waqrMenuItem = new MenuItem(Messages.getString("newAdhocReport"), PluginOptionsHelper.getNewReportCommand());
        waqrMenuItem.getElement().setId("waqr_menu_item");
        newMenu.addItem(waqrMenuItem);
        MenuItem analysisMenuItem = new MenuItem(Messages.getString("newAnalysisViewEllipsis"), PluginOptionsHelper.getNewAnalysisViewCommand());
        analysisMenuItem.getElement().setId("new_analysis_view_menu_item");
        newMenu.addItem(analysisMenuItem);
        this.customizeMenu(newMenu, "file-new", settings);
        MenuItem newMenuBar = new MenuItem(Messages.getString("_new"), (MenuBar)newMenu);
        newMenuBar.getElement().setId("new_menu_bar");
        this.fileMenu.addItem(newMenuBar);
        MenuItem openFileMenuItem = new MenuItem(Messages.getString("openEllipsis"), (Command)new OpenFileCommand());
        openFileMenuItem.getElement().setId("open_file_menu_item");
        this.fileMenu.addItem(openFileMenuItem);
        if (MantleApplication.showAdvancedFeatures) {
            this.fileMenu.addItem(Messages.getString("openURLEllipsis"), (Command)new OpenURLCommand());
        }
        this.recentMenu = new MantleMenuBar(true);
        this.recentMenu.getElement().setId("recent_menu");
        MenuItem recentMenuBar = new MenuItem(Messages.getString("recent"), this.recentMenu);
        recentMenuBar.getElement().setId("recent_menu_bar");
        this.fileMenu.addItem(recentMenuBar);
        this.fileMenu.addSeparator();
        this.fileMenu.addItem((MenuItem)this.saveMenuItem);
        this.fileMenu.addItem((MenuItem)this.saveAsMenuItem);
        this.fileMenu.addSeparator();
        if (MantleApplication.showAdvancedFeatures) {
            this.fileMenu.addItem(Messages.getString("userPreferencesEllipsis"), (Command)new ShowPreferencesCommand());
            this.fileMenu.addSeparator();
        }
        MantleMenuBar manageContentMenu = new MantleMenuBar(true);
        manageContentMenu.getElement().setId("manage_content_menu");
        this.menuBars.put("manage_content_menu", manageContentMenu);
        MenuItem editContent = new MenuItem(Messages.getString("editEllipsis"), (Command)new OpenFileCommand(FileCommand.COMMAND.EDIT));
        MenuItem shareContent = new MenuItem(Messages.getString("shareEllipsis"), (Command)new OpenFileCommand(FileCommand.COMMAND.SHARE));
        MenuItem scheduleContent = new MenuItem(Messages.getString("scheduleEllipsis"), (Command)new OpenFileCommand(FileCommand.COMMAND.SCHEDULE_NEW));
        editContent.getElement().setId("edit_content_menu_item");
        shareContent.getElement().setId("share_content_menu_item");
        scheduleContent.getElement().setId("schedule_content_menu_item");
        manageContentMenu.addItem(editContent);
        manageContentMenu.addItem(shareContent);
        manageContentMenu.addItem(scheduleContent);
        this.customizeMenu(manageContentMenu, "file-manage", settings);
        MenuItem manageContentMenuBar = new MenuItem(Messages.getString("manage"), (MenuBar)manageContentMenu);
        manageContentMenuBar.getElement().setId("manage_content_menu_bar");
        this.fileMenu.addItem(manageContentMenuBar);
        this.fileMenu.addSeparator();
        this.fileMenu.addItem((MenuItem)this.propertiesMenuItem);
        this.fileMenu.addSeparator();
        MenuItem logoutMenuItem = new MenuItem(Messages.getString("logout"), true, (Command)new LogoutCommand());
        logoutMenuItem.getElement().setId("logout_menu_item");
        this.fileMenu.addItem(logoutMenuItem);
        this.customizeMenu(this.fileMenu, "file", settings);
        MenuItem fileMenuBar = new MenuItem(Messages.getString("file"), this.fileMenu);
        fileMenuBar.getElement().setId("file_menu_bar");
        this.addItem(fileMenuBar);
        this.viewMenu.getElement().setId("view_menu");
        this.standardViewMenuItems.add((UIObject)new MenuItemSeparator());
        this.favoritesMenu = new MantleMenuBar(true);
        this.favoritesMenu.getElement().setId("favorites_menu");
        MenuItem favoritesMenuBar = new MenuItem(Messages.getString("favorites"), this.favoritesMenu);
        favoritesMenuBar.getElement().setId("favorites_menu_bar");
        this.buildFavoritesAndRecent(false);
        if ("true".equals(settings.get("show-theme-switcher"))) {
            final MantleMenuBar themeMenu = new MantleMenuBar(true);
            themeMenu.getElement().setId("theme_menu");
            MantleServiceCache.getService().getActiveTheme(new AsyncCallback<String>(){

                public void onFailure(Throwable throwable) {
                }

                public void onSuccess(final String activeTheme) {
                    MantleServiceCache.getService().getSystemThemes(new AsyncCallback<Map<String, String>>(){

                        public void onFailure(Throwable throwable) {
                        }

                        public void onSuccess(Map<String, String> strings) {
                            for (String themeId : strings.keySet()) {
                                CheckBoxMenuItem themeMenuItem = new CheckBoxMenuItem(strings.get(themeId), (Command)new SwitchThemeCommand(themeId));
                                themeMenuItem.getElement().setId(themeId + "_menu_item");
                                themeMenuItem.setChecked(themeId.equals(activeTheme));
                                themeMenu.addItem((MenuItem)themeMenuItem);
                            }
                        }
                    });
                }
            });
            MenuItem themeMenuBar = new MenuItem(Messages.getString("themes"), (MenuBar)themeMenu);
            themeMenuBar.getElement().setId("themes_menu_bar");
            this.standardViewMenuItems.add((UIObject)themeMenuBar);
        }
        if ((supportedLanguages = Messages.getResourceBundle().getSupportedLanguages()) != null && supportedLanguages.keySet() != null && !supportedLanguages.isEmpty()) {
            MantleMenuBar langMenu = new MantleMenuBar(true);
            langMenu.getElement().setId("languages_menu");
            for (String lang : supportedLanguages.keySet()) {
                MenuItem langMenuItem = new MenuItem((String)supportedLanguages.get(lang), (Command)new SwitchLocaleCommand(lang));
                langMenuItem.getElement().setId((String)supportedLanguages.get(lang) + "_menu_item");
                langMenu.addItem(langMenuItem);
            }
            MenuItem langMenuBar = new MenuItem(Messages.getString("languages"), (MenuBar)langMenu);
            langMenuBar.getElement().setId("languages_menu_bar");
            this.standardViewMenuItems.add((UIObject)langMenuBar);
        }
        this.standardViewMenuItems.add((UIObject)new MenuItemSeparator());
        MenuItem refreshItem = new MenuItem(Messages.getString("refresh"), (Command)(SolutionBrowserPerspective.getInstance().isWorkspaceShowing() ? new RefreshWorkspaceCommand() : new RefreshRepositoryCommand()));
        refreshItem.getElement().setId("view_refresh_menu_item");
        this.standardViewMenuItems.add((UIObject)refreshItem);
        this.installViewMenu(this.viewMenuAdditions);
        this.customizeMenu(this.viewMenu, "view", settings);
        MenuItem viewMenuBar = new MenuItem(Messages.getString("view"), (MenuBar)this.viewMenu);
        viewMenuBar.getElement().setId("view_menu_bar");
        this.addItem(viewMenuBar);
        MantleMenuBar adminMenu = new MantleMenuBar(true);
        this.menuBars.put("tools_menu_bar", adminMenu);
        if (isAdministrator) {
            MantleMenuBar refreshMenu = new MantleMenuBar(true);
            refreshMenu.getElement().setId("admin_menu");
            MenuItem refreshRepositoryMenuItem = new MenuItem(Messages.getString("refreshRepository"), (Command)new RefreshRepositoryCommand());
            MenuItem refreshSystemSettingsMenuItem = new MenuItem(Messages.getString("refreshSystemSettings"), (Command)new RefreshSystemSettingsCommand());
            MenuItem refreshMetadataMenuItem = new MenuItem(Messages.getString("refreshReportingMetadata"), (Command)new RefreshMetaDataCommand());
            MenuItem executeGlobalActionsMenuItem = new MenuItem(Messages.getString("executeGlobalActions"), (Command)new ExecuteGlobalActionsCommand());
            MenuItem purgeMondrianSchemaCacheMenuItem = new MenuItem(Messages.getString("purgeMondrianSchemaCache"), (Command)new PurgeMondrianSchemaCacheCommand());
            MenuItem purgeReportingDataCacheMenuItem = new MenuItem(Messages.getString("purgeReportingDataCache"), (Command)new PurgeReportingDataCacheCommand());
            refreshRepositoryMenuItem.getElement().setId("refresh_repository_menu_item");
            refreshSystemSettingsMenuItem.getElement().setId("refresh_system_settings_menu_item");
            refreshMetadataMenuItem.getElement().setId("refresh_metadata_menu_item");
            executeGlobalActionsMenuItem.getElement().setId("execute_global_actions_menu_item");
            purgeMondrianSchemaCacheMenuItem.getElement().setId("purge_mondrian_schema_cache_menu_item");
            purgeReportingDataCacheMenuItem.getElement().setId("purge_reporting_data_cache_menu_item");
            refreshMenu.addItem(refreshRepositoryMenuItem);
            refreshMenu.addItem(refreshSystemSettingsMenuItem);
            refreshMenu.addItem(refreshMetadataMenuItem);
            refreshMenu.addItem(executeGlobalActionsMenuItem);
            refreshMenu.addItem(purgeMondrianSchemaCacheMenuItem);
            refreshMenu.addItem(purgeReportingDataCacheMenuItem);
            MenuItem refreshMenuBar = new MenuItem(Messages.getString("refresh"), (MenuBar)refreshMenu);
            refreshMenuBar.getElement().setId("admin_menu_bar");
            adminMenu.addItem(refreshMenuBar);
            MenuItem toolsMenuBar = new MenuItem(Messages.getString("tools"), (MenuBar)adminMenu);
            toolsMenuBar.getElement().setId("tools_menu_bar");
            this.addItem(toolsMenuBar);
            if (settings.get("toolsMenuTitle0") != null) {
                adminMenu.addSeparator();
            }
            this.customizeMenu(adminMenu, "tools", settings);
            this.customizeMenu(refreshMenu, "tools-refresh", settings);
        }
        MenuBar helpMenu = new MenuBar(true);
        helpMenu.getElement().setId("help_menu");
        this.menuBars.put("help_menu", helpMenu);
        MenuItem docMenuItem = new MenuItem(Messages.getString("documentation"), (Command)new OpenDocCommand(settings.get("documentation-url")));
        docMenuItem.getElement().setId("doc_menu_item");
        helpMenu.addItem(docMenuItem);
        helpMenu.addSeparator();
        MenuItem pentahoHomeMenuItem = new MenuItem(Messages.getString("pentahoHomePageName"), (Command)new PentahoHomeCommand());
        pentahoHomeMenuItem.getElement().setId("pentaho_home_menu_item");
        helpMenu.addItem(pentahoHomeMenuItem);
        helpMenu.addSeparator();
        MenuItem aboutMenuItem = new MenuItem(Messages.getString("about"), (Command)new AboutCommand());
        aboutMenuItem.getElement().setId("about_menu_item");
        helpMenu.addItem(aboutMenuItem);
        this.customizeMenu(helpMenu, "help", settings);
        MenuItem helpMenuBar = new MenuItem(Messages.getString("help"), helpMenu);
        helpMenuBar.getElement().setId("help_menu_bar");
        this.addItem(helpMenuBar);
        this.setupNativeFunctions(this);
    }

    public void buildFavoritesAndRecent(boolean force) {
        this.favoritesMenu.clearItems();
        this.recentMenu.clearItems();
        UserSettingsManager.getInstance().fetchUserSettings(new AsyncCallback<ArrayList<IUserSetting>>(){

            public void onSuccess(ArrayList<IUserSetting> result) {
                for (IUserSetting setting : result) {
                    if ("favorites".equalsIgnoreCase(setting.getSettingName())) {
                        try {
                            JSONArray favorites = JSONParser.parse((String)setting.getSettingValue()).isArray();
                            for (int i = 0; i < favorites.size(); ++i) {
                                JSONValue favorite = favorites.get(i);
                                String text = favorite.isString().stringValue();
                                final String path = text.substring(0, text.lastIndexOf("/"));
                                final String name = text.substring(text.lastIndexOf("/") + 1);
                                MantleMainMenuBar.this.favoritesMenu.addItem(name, new Command(){

                                    public void execute() {
                                        SolutionBrowserPerspective.getInstance().openFile(path, name, name, FileCommand.COMMAND.RUN);
                                    }
                                });
                            }
                            continue;
                        }
                        catch (Throwable t) {
                            continue;
                        }
                    }
                    if (!"recent".equalsIgnoreCase(setting.getSettingName())) continue;
                    try {
                        JSONArray recents = JSONParser.parse((String)setting.getSettingValue()).isArray();
                        ArrayList<JSONArray> recentList = new ArrayList<JSONArray>();
                        for (int i = 0; i < recents.size(); ++i) {
                            recentList.add(recents.get(i).isArray());
                        }
                        Collections.sort(recentList, new Comparator<JSONArray>(){

                            @Override
                            public int compare(JSONArray o1, JSONArray o2) {
                                Double v1 = o1.get(1).isNumber().doubleValue();
                                Double v2 = o2.get(1).isNumber().doubleValue();
                                return v2.compareTo(v1);
                            }
                        });
                        for (JSONArray recent : recentList) {
                            String text = recent.get(0).isString().stringValue();
                            final String path = text.substring(0, text.lastIndexOf("/"));
                            final String name = text.substring(text.lastIndexOf("/") + 1);
                            MantleMainMenuBar.this.recentMenu.addItem(name, new Command(){

                                public void execute() {
                                    SolutionBrowserPerspective.getInstance().openFile(path, name, name, FileCommand.COMMAND.RUN);
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                    }
                }
            }

            public void onFailure(Throwable caught) {
            }
        }, force);
    }

    private void customizeMenu(MenuBar menu, String menuId, HashMap<String, String> settings) {
        if (settings.get(menuId + "MenuTitle0") != null) {
            int idx = 0;
            String title = settings.get(menuId + "MenuTitle" + idx);
            String command = settings.get(menuId + "MenuCommand" + idx);
            while (title != null) {
                if (!GWT.isScript() && command.indexOf("content") > -1) {
                    int index = command.indexOf("?");
                    command = index >= 0 ? "/MantleService?passthru=" + command.substring(command.indexOf("content"), index) + "&" + command.substring(index + 1) + "&userid=joe&password=password" : "/MantleService?passthru=" + command.substring(command.indexOf("content")) + "&userid=joe&password=password";
                }
                UrlCommand menuCommand = new UrlCommand(command, title);
                MenuItem item = new MenuItem(title, (Command)menuCommand);
                menu.addItem(item);
                title = settings.get(menuId + "MenuTitle" + ++idx);
                command = settings.get(menuId + "MenuCommand" + idx);
            }
        }
    }

    @Override
    public void installViewMenu(ArrayList<UIObject> viewMenuItems) {
        MenuBar menuBar;
        MenuItem menuItem;
        this.viewMenu.clearItems();
        for (UIObject widget : viewMenuItems) {
            if (widget instanceof MenuItem) {
                menuItem = (MenuItem)widget;
                this.viewMenu.addItem(menuItem);
                continue;
            }
            if (widget instanceof MenuItemSeparator) {
                this.viewMenu.addSeparator((MenuItemSeparator)widget);
                continue;
            }
            if (!(widget instanceof MenuBar)) continue;
            menuBar = (MenuBar)widget;
            this.viewMenu.addItem(menuBar.getTitle(), menuBar);
        }
        this.viewMenuAdditions = viewMenuItems;
        for (UIObject widget : this.standardViewMenuItems) {
            if (widget instanceof MenuItem) {
                menuItem = (MenuItem)widget;
                this.viewMenu.addItem(menuItem);
                continue;
            }
            if (widget instanceof MenuItemSeparator) {
                this.viewMenu.addSeparator((MenuItemSeparator)widget);
                continue;
            }
            if (!(widget instanceof MenuBar)) continue;
            menuBar = (MenuBar)widget;
            this.viewMenu.addItem(menuBar.getTitle(), menuBar);
        }
    }

    @Override
    public void solutionBrowserEvent(SolutionBrowserListener.EventType type, Widget panel, FileItem selectedFileItem) {
        boolean isEnabled;
        String selectedTabURL = null;
        boolean saveEnabled = false;
        SolutionFileInfo fileInfo = null;
        if (panel != null && panel instanceof IFrameTabPanel) {
            selectedTabURL = ((IFrameTabPanel)panel).getUrl();
            fileInfo = ((IFrameTabPanel)panel).getFileInfo();
            saveEnabled = ((IFrameTabPanel)panel).isSaveEnabled();
        }
        boolean bl = isEnabled = selectedTabURL != null && !"".equals(selectedTabURL);
        if (isEnabled) {
            if (fileInfo != null) {
                this.propertiesMenuItem.setEnabled(true);
                this.propertiesMenuItem.setCommand((Command)new FileCommand(FileCommand.COMMAND.PROPERTIES, null, fileInfo));
            } else {
                this.propertiesMenuItem.setEnabled(false);
                this.propertiesMenuItem.setCommand(null);
            }
        } else {
            this.propertiesMenuItem.setCommand(null);
        }
        this.saveMenuItem.setEnabled(saveEnabled && isEnabled);
        this.saveAsMenuItem.setEnabled(saveEnabled && isEnabled);
    }
}

