/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.toolbar.Toolbar;
import org.pentaho.mantle.client.MantleXulOverlay;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserListener;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;
import org.pentaho.mantle.client.toolbars.MainToolbarController;
import org.pentaho.mantle.client.toolbars.MainToolbarModel;
import org.pentaho.mantle.login.client.MantleLoginDialog;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.gwt.GwtXulDomContainer;
import org.pentaho.ui.xul.gwt.GwtXulRunner;
import org.pentaho.ui.xul.gwt.tags.GwtToolbar;
import org.pentaho.ui.xul.gwt.tags.GwtToolbarbutton;
import org.pentaho.ui.xul.gwt.util.AsyncXulLoader;
import org.pentaho.ui.xul.gwt.util.IXulLoaderCallback;
import org.pentaho.ui.xul.impl.XulEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XulMain
extends SimplePanel
implements IXulLoaderCallback,
SolutionBrowserListener {
    private Map<String, MantleXulOverlay> overlayMap = new HashMap<String, MantleXulOverlay>();
    private MainToolbarModel model;
    private MainToolbarController controller;
    private GwtXulDomContainer container;
    private static XulMain _instance = null;
    private SolutionBrowserPerspective solutionBrowser;

    public static synchronized XulMain instance(SolutionBrowserPerspective solutionBrowser) {
        if (null == _instance) {
            _instance = new XulMain(solutionBrowser);
        }
        return _instance;
    }

    public static XulMain getInstance() {
        return _instance;
    }

    protected XulMain(SolutionBrowserPerspective solutionBrowser) {
        this.solutionBrowser = solutionBrowser;
        this.controller = new MainToolbarController(solutionBrowser, new MainToolbarModel(solutionBrowser, this));
        AsyncXulLoader.loadXulFromUrl((String)"xul/main_toolbar.xul", (String)"messages/mantleMessages", (IXulLoaderCallback)this);
        solutionBrowser.addSolutionBrowserListener(this);
        this.setStylePrimaryName("mainToolbar-Wrapper");
    }

    public void xulLoaded(GwtXulRunner runner) {
        this.container = (GwtXulDomContainer)runner.getXulDomContainers().get(0);
        this.container.addEventHandler((XulEventHandler)this.controller);
        try {
            runner.initialize();
        }
        catch (XulException e) {
            Window.alert((String)("Error initializing XUL runner: " + e.getMessage()));
            e.printStackTrace();
            return;
        }
        this.model = new MainToolbarModel(this.solutionBrowser, this);
        this.controller.setModel(this.model);
        this.controller.setSolutionBrowser(this.solutionBrowser);
        this.model.setShowBrowserSelected(this.solutionBrowser.isNavigatorShowing());
        Toolbar bar = (Toolbar)this.container.getDocumentRoot().getElementById("mainToolbar").getManagedObject();
        bar.setStylePrimaryName("pentaho-rounded-panel2-shadowed pentaho-shine pentaho-background");
        this.add((Widget)bar);
        this.cleanImageUrlsForHostedMode();
        this.fetchOverlays();
    }

    private void fetchOverlays() {
        AsyncCallback<ArrayList<MantleXulOverlay>> callback = new AsyncCallback<ArrayList<MantleXulOverlay>>(){

            public void onFailure(Throwable caught) {
                XulMain.this.doLogin();
            }

            public void onSuccess(ArrayList<MantleXulOverlay> overlays) {
                XulMain.getInstance().loadOverlays(overlays);
            }
        };
        MantleServiceCache.getService().getOverlays(callback);
    }

    private void doLogin() {
        MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("invalidLogin"), false, false, true){};
                dialogBox.setCallback(new IDialogCallback(){

                    public void cancelPressed() {
                    }

                    public void okPressed() {
                        XulMain.this.doLogin();
                    }
                });
                dialogBox.center();
            }

            public void onSuccess(Object result) {
                XulMain.this.fetchOverlays();
            }
        });
    }

    private void cleanImageUrlsForHostedMode() {
        if (!GWT.isScript()) {
            GwtToolbar toolbar = (GwtToolbar)this.container.getDocumentRoot().getElementById("mainToolbar");
            for (XulComponent c : toolbar.getChildNodes()) {
                if (!(c instanceof XulToolbarbutton)) continue;
                GwtToolbarbutton btn = (GwtToolbarbutton)c;
                String curSrc = btn.getImage();
                btn.setImage(curSrc.replace("mantle/", ""));
                curSrc = btn.getDisabledImage();
                if (curSrc != null) {
                    btn.setDisabledImage(curSrc.replace("mantle/", ""));
                }
                if ((curSrc = btn.getDownimage()) != null) {
                    btn.setDownimage(curSrc.replace("mantle/", ""));
                }
                if ((curSrc = btn.getDownimagedisabled()) == null) continue;
                btn.setDownimagedisabled(curSrc.replace("mantle/", ""));
            }
        }
    }

    public void overlayLoaded() {
        this.cleanImageUrlsForHostedMode();
    }

    public void loadOverlays(List<MantleXulOverlay> overlays) {
        for (MantleXulOverlay overlay : overlays) {
            this.overlayMap.put(overlay.getId(), overlay);
            if (!overlay.getId().startsWith("startup")) continue;
            AsyncXulLoader.loadOverlayFromSource((String)overlay.getSource(), (String)overlay.getResourceBundleUri(), (GwtXulDomContainer)this.container, (IXulLoaderCallback)this);
        }
    }

    public void applyOverlays(Set<String> overlayIds) {
        if (overlayIds != null && !overlayIds.isEmpty()) {
            for (String overlayId : overlayIds) {
                this.applyOverlay(overlayId);
            }
        }
    }

    public void applyOverlay(String id) {
        if (this.overlayMap != null && !this.overlayMap.isEmpty() && this.overlayMap.containsKey(id)) {
            MantleXulOverlay overlay = this.overlayMap.get(id);
            AsyncXulLoader.loadOverlayFromSource((String)overlay.getOverlayXml(), (String)overlay.getResourceBundleUri(), (GwtXulDomContainer)this.container, (IXulLoaderCallback)this);
        }
    }

    public void removeOverlays(Set<String> overlayIds) {
        if (overlayIds != null && !overlayIds.isEmpty()) {
            for (String overlayId : overlayIds) {
                this.removeOverlay(overlayId);
            }
        }
    }

    public void removeOverlay(String id) {
        if (this.overlayMap != null && !this.overlayMap.isEmpty() && this.overlayMap.containsKey(id)) {
            MantleXulOverlay overlay = this.overlayMap.get(id);
            AsyncXulLoader.removeOverlayFromSource((String)overlay.getOverlayXml(), (String)overlay.getResourceBundleUri(), (GwtXulDomContainer)this.container, (IXulLoaderCallback)this);
        }
    }

    public void overlayRemoved() {
    }

    @Override
    public void solutionBrowserEvent(SolutionBrowserListener.EventType type, Widget panel, FileItem selectedFileItem) {
        if (panel instanceof IFrameTabPanel) {
            if (SolutionBrowserListener.EventType.OPEN.equals((Object)type) || SolutionBrowserListener.EventType.SELECT.equals((Object)type)) {
                if (panel != null) {
                    this.applyOverlays(((IFrameTabPanel)panel).getOverlayIds());
                }
            } else if ((SolutionBrowserListener.EventType.CLOSE.equals((Object)type) || SolutionBrowserListener.EventType.DESELECT.equals((Object)type)) && panel != null) {
                this.removeOverlays(((IFrameTabPanel)panel).getOverlayIds());
            }
        }
    }
}

