/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.MantleApplication;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;

public class AboutCommand
extends AbstractCommand {
    protected void performOperation() {
        this.performOperation(true);
    }

    protected void performOperation(boolean feedback) {
        if (MantleApplication.mantleRevisionOverride != null && MantleApplication.mantleRevisionOverride.length() > 0) {
            this.showAboutDialog(MantleApplication.mantleRevisionOverride);
        } else {
            AsyncCallback<String> callback = new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(String version) {
                    AboutCommand.this.showAboutDialog(version);
                }
            };
            MantleServiceCache.getService().getVersion(callback);
        }
    }

    private void showAboutDialog(String version) {
        String licenseInfo = Messages.getString("licenseInfo", "" + (new Date().getYear() + 1900));
        String releaseLabel = Messages.getString("release");
        PromptDialogBox dialogBox = new PromptDialogBox(Messages.getString("aboutDialogTitle"), Messages.getString("ok"), null, false, true);
        VerticalPanel aboutContent = new VerticalPanel();
        aboutContent.add((Widget)new Label(releaseLabel + " " + version));
        aboutContent.add((Widget)new HTML(licenseInfo));
        dialogBox.setContent((Widget)aboutContent);
        dialogBox.center();
    }
}

