/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.commands.CommandCallback;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.login.client.MantleLoginDialog;

public abstract class AbstractCommand
implements Command {
    private CommandCallback commandCallback;

    public void execute(final boolean feedback) {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AbstractCommand.this.performOperation(feedback);
            }

            public void onFailure(Throwable caught) {
                AbstractCommand.this.doLogin(feedback);
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    public void execute(CommandCallback commandCallback) {
        this.execute(commandCallback, false);
    }

    public void execute(final CommandCallback commandCallback, final boolean feedback) {
        this.commandCallback = commandCallback;
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AbstractCommand.this.performOperation(feedback);
                commandCallback.afterExecute();
            }

            public void onFailure(Throwable caught) {
                AbstractCommand.this.doLogin(feedback);
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    public void execute() {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AbstractCommand.this.performOperation();
            }

            public void onFailure(Throwable caught) {
                AbstractCommand.this.doLogin();
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private void doLogin(final boolean feedback) {
        MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("invalidLogin"), false, false, true){};
                dialogBox.setCallback(new IDialogCallback(){

                    public void cancelPressed() {
                    }

                    public void okPressed() {
                        AbstractCommand.this.doLogin(feedback);
                    }
                });
                dialogBox.center();
            }

            public void onSuccess(Object result) {
                if (AbstractCommand.this.commandCallback != null) {
                    AbstractCommand.this.execute(AbstractCommand.this.commandCallback, feedback);
                } else {
                    AbstractCommand.this.execute(feedback);
                }
            }
        });
    }

    private void doLogin() {
        Timer t = new Timer(){

            public void run() {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Object>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("invalidLogin"), false, false, true);
                        dialogBox.setCallback(new IDialogCallback(){

                            public void cancelPressed() {
                            }

                            public void okPressed() {
                                AbstractCommand.this.doLogin();
                            }
                        });
                        dialogBox.center();
                    }

                    public void onSuccess(Object result) {
                        if (AbstractCommand.this.commandCallback != null) {
                            AbstractCommand.this.execute(AbstractCommand.this.commandCallback);
                        } else {
                            AbstractCommand.this.execute();
                        }
                    }
                });
            }
        };
        t.schedule(1);
    }

    protected abstract void performOperation();

    protected abstract void performOperation(boolean var1);
}

