/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;

public class CheckForSoftwareUpdatesCommand
extends AbstractCommand {
    protected void performOperation() {
        this.performOperation(true);
    }

    protected void performOperation(boolean feedback) {
        AsyncCallback<String> callback = new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("softwareUpdates"), Messages.getString("noUpdatesAvailable"), false, false, true);
                dialogBox.center();
            }

            public void onSuccess(String result) {
                Document doc = XMLParser.parse((String)result);
                NodeList updates = doc.getElementsByTagName("update");
                if (updates.getLength() > 0) {
                    FlexTable updateTable = new FlexTable();
                    updateTable.setStyleName("backgroundContentTable");
                    updateTable.setWidget(0, 0, (Widget)new Label(Messages.getString("version")));
                    updateTable.setWidget(0, 1, (Widget)new Label(Messages.getString("type")));
                    updateTable.setWidget(0, 2, (Widget)new Label(Messages.getString("os")));
                    updateTable.setWidget(0, 3, (Widget)new Label(Messages.getString("link")));
                    updateTable.getCellFormatter().setStyleName(0, 0, "backgroundContentHeaderTableCell");
                    updateTable.getCellFormatter().setStyleName(0, 1, "backgroundContentHeaderTableCell");
                    updateTable.getCellFormatter().setStyleName(0, 2, "backgroundContentHeaderTableCell");
                    updateTable.getCellFormatter().setStyleName(0, 3, "backgroundContentHeaderTableCellRight");
                    for (int i = 0; i < updates.getLength(); ++i) {
                        Element updateElement = (Element)updates.item(i);
                        String version = updateElement.getAttribute("version");
                        String type = updateElement.getAttribute("type");
                        String os = updateElement.getAttribute("os");
                        String downloadURL = updateElement.getElementsByTagName("downloadurl").item(0).toString();
                        downloadURL = downloadURL.substring(downloadURL.indexOf("http"), downloadURL.indexOf("]"));
                        updateTable.setWidget(i + 1, 0, (Widget)new Label(version));
                        updateTable.setWidget(i + 1, 1, (Widget)new Label(type));
                        updateTable.setWidget(i + 1, 2, (Widget)new Label(os));
                        updateTable.setWidget(i + 1, 3, (Widget)new HTML("<A HREF=\"" + downloadURL + "\" target=\"_blank\" title=\"" + downloadURL + "\">" + Messages.getString("download") + "</A>"));
                        updateTable.getCellFormatter().setStyleName(i + 1, 0, "backgroundContentTableCell");
                        updateTable.getCellFormatter().setStyleName(i + 1, 1, "backgroundContentTableCell");
                        updateTable.getCellFormatter().setStyleName(i + 1, 2, "backgroundContentTableCell");
                        updateTable.getCellFormatter().setStyleName(i + 1, 3, "backgroundContentTableCellRight");
                        if (i != updates.getLength() - 1) continue;
                        updateTable.getCellFormatter().setStyleName(i + 1, 0, "backgroundContentTableCellBottom");
                        updateTable.getCellFormatter().setStyleName(i + 1, 1, "backgroundContentTableCellBottom");
                        updateTable.getCellFormatter().setStyleName(i + 1, 2, "backgroundContentTableCellBottom");
                        updateTable.getCellFormatter().setStyleName(i + 1, 3, "backgroundContentTableCellBottomRight");
                    }
                    PromptDialogBox versionPromptDialog = new PromptDialogBox(Messages.getString("softwareUpdateAvailable"), Messages.getString("ok"), null, false, true, (Widget)updateTable);
                    versionPromptDialog.center();
                } else {
                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("softwareUpdates"), Messages.getString("noUpdatesAvailable"), false, false, true);
                    dialogBox.center();
                }
            }
        };
        MantleServiceCache.getService().getSoftwareUpdatesDocument(callback);
    }
}

