/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.commands.RefreshRepositoryCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;

public class DeleteFileCommand
extends AbstractCommand {
    private IFileSummary fileSummary;

    public DeleteFileCommand() {
    }

    public DeleteFileCommand(IFileSummary fileSummary) {
        this.fileSummary = fileSummary;
    }

    protected void performOperation() {
        this.performOperation(true);
    }

    protected void performOperation(boolean feedback) {
        String url = "";
        if (GWT.isScript()) {
            String windowpath = Window.Location.getPath();
            if (!windowpath.endsWith("/")) {
                windowpath = windowpath.substring(0, windowpath.lastIndexOf("/") + 1);
            }
            url = windowpath + "SolutionRepositoryService?component=delete&solution=" + URL.encodeComponent((String)this.fileSummary.getSolution()) + "&path=" + URL.encodeComponent((String)this.fileSummary.getPath()) + "&name=" + URL.encodeComponent((String)this.fileSummary.getName());
        } else if (!GWT.isScript()) {
            url = "http://localhost:8080/pentaho/SolutionRepositoryService?component=delete&solution=" + URL.encodeComponent((String)this.fileSummary.getSolution()) + "&path=" + URL.encodeComponent((String)this.fileSummary.getPath()) + "&name=" + URL.encodeComponent((String)this.fileSummary.getName());
        }
        final String myurl = url;
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new Label(Messages.getString("deleteQuestion", this.fileSummary.getLocalizedName())));
        final PromptDialogBox deleteConfirmDialog = new PromptDialogBox(Messages.getString("deleteConfirm"), Messages.getString("yes"), Messages.getString("no"), false, true, (Widget)vp);
        IDialogCallback callback = new IDialogCallback(){

            public void cancelPressed() {
                deleteConfirmDialog.hide();
            }

            public void okPressed() {
                RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, myurl);
                try {
                    builder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotDelete", DeleteFileCommand.this.fileSummary.getName()), false, false, true);
                            dialogBox.center();
                        }

                        public void onResponseReceived(Request request, Response response) {
                            Document resultDoc = XMLParser.parse((String)response.getText());
                            boolean result = "true".equals(resultDoc.getDocumentElement().getFirstChild().getNodeValue());
                            if (result) {
                                new RefreshRepositoryCommand().execute(false);
                            } else {
                                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotDelete", DeleteFileCommand.this.fileSummary.getName()), false, false, true);
                                dialogBox.center();
                            }
                        }
                    });
                }
                catch (RequestException requestException) {
                    // empty catch block
                }
            }
        };
        deleteConfirmDialog.setCallback(callback);
        deleteConfirmDialog.center();
    }
}

