/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.commands.RefreshRepositoryCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;

public class NewFolderCommand
extends AbstractCommand {
    private String repoPath = "";
    private String solution = "";
    private IFileSummary fileSummary;

    public NewFolderCommand(IFileSummary fileSummary) {
        this.fileSummary = fileSummary;
    }

    protected void performOperation() {
        this.performOperation(true);
    }

    protected void performOperation(boolean feedback) {
        if (this.fileSummary == null) {
            this.repoPath = "";
            this.solution = "";
        } else {
            String tmpPath = this.fileSummary.getSolution().equals(this.fileSummary.getName()) ? "" : ("".equals(this.fileSummary.getPath()) ? this.fileSummary.getName() : this.fileSummary.getPath() + "/" + this.fileSummary.getName());
            this.repoPath = tmpPath;
            this.solution = this.fileSummary.getSolution();
        }
        final TextBox folderNameTextBox = new TextBox();
        folderNameTextBox.setTabIndex(1);
        folderNameTextBox.setVisibleLength(40);
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new Label(Messages.getString("newFolderName")));
        vp.add((Widget)folderNameTextBox);
        final PromptDialogBox newFolderDialog = new PromptDialogBox(Messages.getString("newFolder"), Messages.getString("ok"), Messages.getString("cancel"), false, true, (Widget)vp);
        newFolderDialog.setFocusWidget((FocusWidget)folderNameTextBox);
        folderNameTextBox.setFocus(true);
        IDialogCallback callback = new IDialogCallback(){

            public void cancelPressed() {
                newFolderDialog.hide();
            }

            public void okPressed() {
                String url = "";
                if (GWT.isScript()) {
                    String windowpath = Window.Location.getPath();
                    if (!windowpath.endsWith("/")) {
                        windowpath = windowpath.substring(0, windowpath.lastIndexOf("/") + 1);
                    }
                    url = windowpath + "SolutionRepositoryService?component=createNewFolder&solution=" + URL.encodeComponent((String)NewFolderCommand.this.solution) + "&path=" + URL.encodeComponent((String)NewFolderCommand.this.repoPath) + "&name=" + URL.encodeComponent((String)folderNameTextBox.getText());
                } else if (!GWT.isScript()) {
                    url = "http://localhost:8080/pentaho/SolutionRepositoryService?component=createNewFolder&solution=" + URL.encodeComponent((String)NewFolderCommand.this.solution) + "&path=" + URL.encodeComponent((String)NewFolderCommand.this.repoPath) + "&name=" + URL.encodeComponent((String)folderNameTextBox.getText());
                }
                String myurl = url;
                RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, myurl);
                try {
                    builder.sendRequest(null, new RequestCallback(){

                        public void onError(Request request, Throwable exception) {
                            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotCreateFolder", folderNameTextBox.getText()), false, false, true);
                            dialogBox.center();
                        }

                        public void onResponseReceived(Request request, Response response) {
                            Document resultDoc = XMLParser.parse((String)response.getText());
                            boolean result = "true".equals(resultDoc.getDocumentElement().getFirstChild().getNodeValue());
                            if (result) {
                                RefreshRepositoryCommand cmd = new RefreshRepositoryCommand();
                                cmd.execute(false);
                            } else {
                                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotCreateFolder", folderNameTextBox.getText()), false, false, true);
                                dialogBox.center();
                            }
                        }
                    });
                }
                catch (RequestException e) {
                    // empty catch block
                }
            }
        };
        newFolderDialog.setCallback(callback);
        newFolderDialog.center();
    }
}

