/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.xml.client.Document;
import org.pentaho.gwt.widgets.client.filechooser.FileChooser;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserDialog;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserListener;
import org.pentaho.mantle.client.MantleApplication;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.SolutionDocumentManager;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;

public class OpenFileCommand
extends AbstractCommand {
    private static String lastPath = "/";
    private FileCommand.COMMAND openMethod = FileCommand.COMMAND.RUN;

    public OpenFileCommand() {
    }

    public OpenFileCommand(FileCommand.COMMAND openMethod) {
        this.openMethod = openMethod;
    }

    protected void performOperation() {
        this.performOperation(true);
    }

    protected void performOperation(boolean feedback) {
        final SolutionBrowserPerspective solutionBrowserPerspective = SolutionBrowserPerspective.getInstance();
        SolutionDocumentManager.getInstance().fetchSolutionDocument(new AsyncCallback<Document>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Document result) {
                final FileChooserDialog dialog = new FileChooserDialog(FileChooser.FileChooserMode.OPEN, lastPath, result, false, true);
                dialog.setSubmitOnEnter(MantleApplication.submitOnEnter);
                if (!MantleApplication.showAdvancedFeatures) {
                    dialog.setShowSearch(false);
                }
                dialog.addFileChooserListener(new FileChooserListener(){

                    public void fileSelected(String solution, String path, String name, String localizedFileName) {
                        dialog.hide();
                        lastPath = "/" + solution + path;
                        if (name.contains("analysis.xaction") && OpenFileCommand.this.openMethod.equals((Object)FileCommand.COMMAND.EDIT)) {
                            solutionBrowserPerspective.openFile("/" + solution + path, name, localizedFileName, FileCommand.COMMAND.RUN);
                        } else {
                            solutionBrowserPerspective.openFile("/" + solution + path, name, localizedFileName, OpenFileCommand.this.openMethod);
                        }
                    }

                    public void fileSelectionChanged(String solution, String path, String name) {
                    }

                    public void dialogCanceled() {
                    }
                });
                dialog.center();
            }
        }, false);
    }
}

