/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import java.util.List;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.filechooser.FileChooser;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserDialog;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserListener;
import org.pentaho.gwt.widgets.client.tabs.PentahoTab;
import org.pentaho.mantle.client.MantleApplication;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.dialogs.WaitPopup;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.SolutionDocumentManager;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;

public class SaveCommand
extends AbstractCommand {
    boolean isSaveAs = false;
    private String name;
    private String solution;
    private String path;
    private SolutionFileInfo.Type type;
    private String tabName;

    public SaveCommand() {
    }

    public SaveCommand(boolean isSaveAs) {
        this.isSaveAs = isSaveAs;
    }

    protected void performOperation() {
        this.performOperation(true);
    }

    protected void performOperation(boolean feedback) {
        final SolutionBrowserPerspective navigatorPerspective = SolutionBrowserPerspective.getInstance();
        this.retrieveCachedValues(navigatorPerspective.getContentTabPanel().getCurrentFrame());
        SolutionDocumentManager.getInstance().fetchSolutionDocument(new AsyncCallback<Document>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Document result) {
                if (SaveCommand.this.isSaveAs || SaveCommand.this.name == null) {
                    final FileChooserDialog dialog = new FileChooserDialog(FileChooser.FileChooserMode.SAVE, "/", result, false, true);
                    dialog.setSubmitOnEnter(MantleApplication.submitOnEnter);
                    if (SaveCommand.this.isSaveAs) {
                        dialog.setTitle(Messages.getString("saveAs"));
                        dialog.setText(Messages.getString("saveAs"));
                    } else {
                        dialog.setTitle(Messages.getString("save"));
                    }
                    if (!MantleApplication.showAdvancedFeatures) {
                        dialog.setShowSearch(false);
                    }
                    dialog.addFileChooserListener(new FileChooserListener(){

                        public void fileSelected(final String solution, final String path, final String name, String localizedFileName) {
                            SaveCommand.this.solution = solution;
                            SaveCommand.this.path = path;
                            SaveCommand.this.name = name;
                            SaveCommand.this.type = SolutionFileInfo.Type.XACTION;
                            SaveCommand.this.tabName = name;
                            if (SaveCommand.this.tabName.indexOf("analysisview.xaction") != -1) {
                                SaveCommand.this.tabName = SaveCommand.this.tabName.substring(0, SaveCommand.this.tabName.indexOf("analysisview.xaction") - 1);
                            } else if (SaveCommand.this.tabName.indexOf("waqr.xaction") != -1) {
                                SaveCommand.this.tabName = SaveCommand.this.tabName.substring(0, SaveCommand.this.tabName.indexOf("waqr.xaction") - 1);
                            }
                            if (SaveCommand.this.doesFileExist(navigatorPerspective.getContentTabPanel().getCurrentFrameElementId(), dialog, solution, path, name)) {
                                dialog.hide();
                                PromptDialogBox overWriteDialog = new PromptDialogBox(Messages.getString("question"), Messages.getString("yes"), Messages.getString("no"), false, true);
                                overWriteDialog.setContent((Widget)new Label(Messages.getString("fileExistsOverwrite"), false));
                                overWriteDialog.setCallback(new IDialogCallback(){

                                    public void okPressed() {
                                        SaveCommand.this.doSaveAs(navigatorPerspective.getContentTabPanel().getCurrentFrameElementId(), name, solution, path, SaveCommand.this.type, true);
                                        Window.setTitle((String)(Messages.getString("productName") + " - " + name));
                                    }

                                    public void cancelPressed() {
                                        dialog.show();
                                    }
                                });
                                overWriteDialog.center();
                            } else {
                                SaveCommand.this.doSaveAs(navigatorPerspective.getContentTabPanel().getCurrentFrameElementId(), name, solution, path, SaveCommand.this.type, false);
                                Window.setTitle((String)(Messages.getString("productName") + " - " + name));
                                SaveCommand.this.persistFileInfoInFrame();
                                SaveCommand.this.clearValues();
                            }
                        }

                        public void fileSelectionChanged(String solution, String path, String name) {
                        }

                        public void dialogCanceled() {
                        }
                    });
                    dialog.center();
                } else {
                    SaveCommand.this.doSaveAs(navigatorPerspective.getContentTabPanel().getCurrentFrameElementId(), SaveCommand.this.name, SaveCommand.this.solution, SaveCommand.this.path, SaveCommand.this.type, true);
                    SaveCommand.this.clearValues();
                }
            }
        }, false);
    }

    private boolean doesFileExist(String elementId, FileChooserDialog dialog, String solution, String path, String name) {
        String absolutePath = "/" + solution + path;
        String absoluteFileName = absolutePath + (!"".equals(name) ? "/" : "") + name;
        if (name.contains(".")) {
            return dialog.doesFileExist(absoluteFileName);
        }
        JsArrayString possibleExtensions = this.getPossibleExtensions(elementId);
        if (possibleExtensions != null && possibleExtensions.length() > 0) {
            for (int i = 0; i < possibleExtensions.length(); ++i) {
                String ext = possibleExtensions.get(i);
                if (ext != null && ext.length() > 0 && !ext.startsWith(".")) {
                    ext = "." + ext;
                }
                if (!dialog.doesFileExist(absoluteFileName + ext)) continue;
                return true;
            }
        } else {
            List fileNames = dialog.getFilesInPath(absolutePath);
            for (String fileName : fileNames) {
                int dotIdx = fileName.indexOf(".");
                if (dotIdx != -1) {
                    fileName = fileName.substring(0, dotIdx);
                }
                if (!fileName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private native JsArrayString getPossibleExtensions(String var1);

    private void persistFileInfoInFrame() {
        SolutionFileInfo fileInfo = new SolutionFileInfo();
        fileInfo.setName(this.name);
        fileInfo.setPath(this.path);
        fileInfo.setSolution(this.solution);
        fileInfo.setType(this.type);
        SolutionBrowserPerspective.getInstance().getContentTabPanel().getCurrentFrame().setFileInfo(fileInfo);
    }

    private void clearValues() {
        this.name = null;
        this.solution = null;
        this.path = null;
        this.type = null;
    }

    private void retrieveCachedValues(IFrameTabPanel tabPanel) {
        this.clearValues();
        SolutionFileInfo info = tabPanel.getFileInfo();
        if (info != null) {
            this.name = info.getName();
            this.path = info.getPath();
            this.solution = info.getSolution();
            this.type = info.getType();
        }
    }

    private void doSaveAs(String elementId, String filename, String solution, String path, SolutionFileInfo.Type type, boolean overwrite, boolean showBusy) {
        WaitPopup.getInstance().setVisible(true);
        this.doSaveAs(elementId, filename, solution, path, type, overwrite);
        WaitPopup.getInstance().setVisible(false);
    }

    private native void doSaveAs(String var1, String var2, String var3, String var4, SolutionFileInfo.Type var5, boolean var6);

    private void doTabRename() {
        if (this.tabName != null) {
            PentahoTab tab = SolutionBrowserPerspective.getInstance().getContentTabPanel().getSelectedTab();
            tab.setLabelText(this.tabName);
            tab.setLabelTooltip(this.tabName);
        }
    }
}

