/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.commands;

import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;

public class UrlCommand
extends AbstractCommand {
    String url;
    String title;
    boolean showInDialog = false;
    int dialogWidth = 600;
    int dialogHeight = 400;

    public UrlCommand(String url, String title) {
        this.url = url;
        this.title = title;
    }

    public UrlCommand(String url, String title, boolean showInDialog, int dialogWidth, int dialogHeight) {
        this(url, title);
        this.showInDialog = showInDialog;
        this.dialogWidth = dialogWidth;
        this.dialogHeight = dialogHeight;
    }

    public static void _execute(String url, String title, boolean showInDialog, int dialogWidth, int dialogHeight) {
        UrlCommand cmd = new UrlCommand(url, title, showInDialog, dialogWidth, dialogHeight);
        cmd.execute();
    }

    protected void performOperation() {
        this.performOperation(false);
    }

    protected void performOperation(boolean feedback) {
        if (this.showInDialog) {
            String height = this.dialogHeight + "px";
            String width = this.dialogWidth + "px";
            Frame frame = new Frame(this.url);
            PromptDialogBox dialogBox = new PromptDialogBox(this.title, Messages.getString("ok"), null, false, false);
            dialogBox.setStylePrimaryName("pentaho-dialog");
            dialogBox.setText(this.title);
            dialogBox.setContent((Widget)frame);
            frame.setSize(width, height);
            dialogBox.center();
            frame.setSize(width, height);
        } else {
            SolutionBrowserPerspective navigatorPerspective = SolutionBrowserPerspective.getInstance();
            navigatorPerspective.getContentTabPanel().showNewURLTab(this.title, "", this.url, false);
        }
    }
}

