/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.dialogs;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;

public class AnalysisViewDialog
extends PromptDialogBox {
    private ListBox lboxSchema = new ListBox();
    private ListBox lboxCube = new ListBox();
    public static final String FOCUS_ON_TITLE = "title";
    private HashMap<String, ArrayList<String[]>> schemaCubeHashMap;

    public AnalysisViewDialog() {
        super(Messages.getString("newAnalysisView"), Messages.getString("ok"), Messages.getString("cancel"), false, true, (Widget)new VerticalPanel());
        this.buildAnalysisView();
        this.lboxSchema.getElement().setId("schemaList");
        this.lboxSchema.setTabIndex(1);
        this.lboxCube.getElement().setId("cubeList");
        this.lboxCube.setTabIndex(2);
        this.setFocusWidget((FocusWidget)this.lboxSchema);
    }

    private Widget buildAnalysisView() {
        VerticalPanel mainPanel = (VerticalPanel)this.getContent();
        mainPanel.setSpacing(5);
        Label schemaLabel = new Label(Messages.getString("schema"));
        Label cubeLabel = new Label(Messages.getString("cube"));
        this.lboxSchema.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String currentSchema = AnalysisViewDialog.this.lboxSchema.getItemText(AnalysisViewDialog.this.lboxSchema.getSelectedIndex());
                AnalysisViewDialog.this.updateCubeListBox(currentSchema);
            }
        });
        this.getSchemaAndCubeInfo();
        this.lboxSchema.setWidth("15em");
        this.lboxCube.setWidth("15em");
        mainPanel.add((Widget)schemaLabel);
        mainPanel.add((Widget)this.lboxSchema);
        mainPanel.add((Widget)cubeLabel);
        mainPanel.add((Widget)this.lboxCube);
        return mainPanel;
    }

    public String getSchema() {
        return this.lboxSchema.getItemText(this.lboxSchema.getSelectedIndex());
    }

    public String getCube() {
        return this.lboxCube.getValue(this.lboxCube.getSelectedIndex());
    }

    private void getSchemaAndCubeInfo() {
        AsyncCallback<HashMap<String, ArrayList<String[]>>> callback = new AsyncCallback<HashMap<String, ArrayList<String[]>>>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetFileProperties"), false, false, true);
                dialogBox.center();
            }

            public void onSuccess(HashMap<String, ArrayList<String[]>> result) {
                if (result != null) {
                    AnalysisViewDialog.this.schemaCubeHashMap = result;
                    if (AnalysisViewDialog.this.schemaCubeHashMap != null && AnalysisViewDialog.this.schemaCubeHashMap.size() >= 1) {
                        for (Map.Entry entry : AnalysisViewDialog.this.schemaCubeHashMap.entrySet()) {
                            AnalysisViewDialog.this.lboxSchema.addItem((String)entry.getKey());
                        }
                        AnalysisViewDialog.this.lboxSchema.setSelectedIndex(0);
                        AnalysisViewDialog.this.updateCubeListBox(AnalysisViewDialog.this.lboxSchema.getItemText(AnalysisViewDialog.this.lboxSchema.getSelectedIndex()));
                    }
                } else {
                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("noMondrianSchemas"), false, false, true);
                    dialogBox.center();
                }
            }
        };
        MantleServiceCache.getService().getMondrianCatalogs(callback);
    }

    public void updateCubeListBox(String currentSchema) {
        this.lboxCube.clear();
        ArrayList<String[]> cubeNamesList = this.schemaCubeHashMap.get(currentSchema);
        int size = cubeNamesList.size();
        for (int i = 0; i < size; ++i) {
            String name = cubeNamesList.get(i)[0];
            String id = cubeNamesList.get(i)[1];
            this.lboxCube.addItem(name, id);
        }
    }

    public boolean validate() {
        String schema = this.getSchema();
        if (schema == null || schema.length() == 0) {
            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("selectSchema"), false, false, true);
            dialogBox.setWidth("15em");
            dialogBox.center();
            return false;
        }
        String cube = this.getSchema();
        if (cube == null || cube.length() == 0) {
            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("selectCube"), false, false, true);
            dialogBox.setWidth("15em");
            dialogBox.center();
            return false;
        }
        return true;
    }
}

