/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.dialogs;

import com.google.gwt.xml.client.Document;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.dialogs.GlassPane;
import org.pentaho.gwt.widgets.client.filechooser.FileChooser;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserDialog;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserListener;
import org.pentaho.gwt.widgets.client.filechooser.FileFilter;
import org.pentaho.mantle.client.MantleApplication;

public class FileDialog {
    private static String lastPath = "";
    private ArrayList<FileChooserListener> listeners = new ArrayList();
    private Document doc;
    private String title;
    private String okText;
    private String[] fileTypes;
    private String path;

    public FileDialog(Document doc, String title, String okText, String[] fileTypes) {
        this.doc = doc;
        this.title = title;
        this.okText = okText;
        this.fileTypes = fileTypes;
    }

    public FileDialog(Document doc, String path, String title, String okText, String[] fileTypes) {
        this(doc, title, okText, fileTypes);
        this.path = path;
    }

    public void show() {
        String pathToShow = this.path != null ? this.path : lastPath;
        final FileChooserDialog dialog = new FileChooserDialog(FileChooser.FileChooserMode.OPEN, pathToShow, this.doc, false, true, this.title, this.okText){

            public void hide() {
                super.hide();
                GlassPane.getInstance().hide();
            }
        };
        dialog.setSubmitOnEnter(MantleApplication.submitOnEnter);
        dialog.addFileChooserListener(new FileChooserListener(){

            public void fileSelected(String solution, String path, String name, String localizedFileName) {
                dialog.hide();
                lastPath = "/" + solution + path;
                for (FileChooserListener listener : FileDialog.this.listeners) {
                    listener.fileSelected(solution, path, name, localizedFileName);
                }
            }

            public void fileSelectionChanged(String solution, String path, String name) {
            }

            public void dialogCanceled() {
            }
        });
        dialog.setFileFilter(new FileFilter(){

            public boolean accept(String name, boolean isDirectory, boolean isVisible) {
                if (isDirectory && isVisible) {
                    return true;
                }
                if (name.indexOf(".") == -1) {
                    return false;
                }
                String extension = name.substring(name.lastIndexOf(".") + 1);
                for (int i = 0; i < FileDialog.this.fileTypes.length; ++i) {
                    if (!FileDialog.this.fileTypes[i].trim().equalsIgnoreCase(extension) || !isVisible) continue;
                    return true;
                }
                return false;
            }
        });
        GlassPane.getInstance().show();
        dialog.center();
    }

    public void addFileChooserListener(FileChooserListener listener) {
        if (!this.listeners.contains(this.listeners)) {
            this.listeners.add(listener);
        }
    }
}

