/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;

public class FileTypeEnabledOptions {
    private String fileExtension;
    private Map<FileCommand.COMMAND, Boolean> enabledOptions = new HashMap<FileCommand.COMMAND, Boolean>();

    public FileTypeEnabledOptions(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void applyOptions(String options) {
        String[] opts;
        for (String option : opts = options.split(",")) {
            this.enabledOptions.put(FileCommand.COMMAND.valueOf(option), true);
        }
    }

    public void addCommand(FileCommand.COMMAND command) {
        this.enabledOptions.put(command, true);
    }

    public boolean isCommandEnabled(FileCommand.COMMAND command) {
        return this.enabledOptions.containsKey((Object)command);
    }

    public boolean isSupportedFile(String filename) {
        if (this.fileExtension == null) {
            return true;
        }
        return filename != null && filename.endsWith(this.fileExtension);
    }
}

