/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.mantle.client.commands.AddDatasourceCommand;
import org.pentaho.mantle.client.commands.AnalysisViewCommand;
import org.pentaho.mantle.client.commands.ManageDatasourcesCommand;
import org.pentaho.mantle.client.commands.UrlCommand;
import org.pentaho.mantle.client.commands.WAQRCommand;
import org.pentaho.mantle.client.solutionbrowser.FileTypeEnabledOptions;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginOptionsHelper {
    private static ArrayList<FileTypeEnabledOptions> enabledOptionsList = new ArrayList();
    private static ArrayList<ContentTypePlugin> contentTypePluginList = new ArrayList();
    private static String newAnalysisViewOverrideCommandUrl;
    private static String newAnalysisViewOverrideCommandTitle;
    private static String newReportOverrideCommandUrl;
    private static String newReportOverrideCommandTitle;
    private static String manageDatasourcesOverrideCommandUrl;
    private static String manageDatasourcesOverrideCommandTitle;
    private static String addDatasourceOverrideCommandUrl;
    private static String addDatasourceOverrideCommandTitle;

    public static void buildEnabledOptionsList(Map<String, String> settings) {
        enabledOptionsList.clear();
        contentTypePluginList.clear();
        if (settings.containsKey("new-analysis-view-command-url")) {
            newAnalysisViewOverrideCommandUrl = settings.get("new-analysis-view-command-url");
            newAnalysisViewOverrideCommandTitle = settings.get("new-analysis-view-command-title");
        }
        if (settings.containsKey("new-report-command-url")) {
            newReportOverrideCommandUrl = settings.get("new-report-command-url");
            newReportOverrideCommandTitle = settings.get("new-report-command-title");
        }
        if (settings.containsKey("manage-datasources-command-url")) {
            manageDatasourcesOverrideCommandUrl = settings.get("manage-datasources-command-url");
            manageDatasourcesOverrideCommandTitle = settings.get("manage-datasources-command-title");
        }
        if (settings.containsKey("add-datasource-command-url")) {
            addDatasourceOverrideCommandUrl = settings.get("add-datasource-command-url");
            addDatasourceOverrideCommandTitle = settings.get("add-datasource-command-title");
        }
        if (settings.get("file-newMenuOverrideTitle0") != null) {
            for (int i = 0; i < 2; ++i) {
                String title = settings.get("file-newMenuOverrideTitle" + i);
                String command = settings.get("file-newMenuOverrideCommand" + i);
                String menuItem = settings.get("file-newMenuOverrideMenuItem" + i);
                if (menuItem == null || command == null || title == null) continue;
                if (menuItem.equals("waqr_menu_item")) {
                    newReportOverrideCommandUrl = command;
                    newReportOverrideCommandTitle = title;
                    continue;
                }
                if (menuItem.equals("new_analysis_view_menu_item")) {
                    newAnalysisViewOverrideCommandUrl = command;
                    newAnalysisViewOverrideCommandTitle = title;
                    continue;
                }
                if (menuItem.equals("manage_datasources_menu_item")) {
                    manageDatasourcesOverrideCommandUrl = command;
                    manageDatasourcesOverrideCommandTitle = title;
                    continue;
                }
                if (!menuItem.equals("new_datasources_menu_item")) continue;
                addDatasourceOverrideCommandUrl = command;
                addDatasourceOverrideCommandTitle = title;
            }
        }
        int index = 0;
        String pluginSetting = "plugin-content-type-" + index;
        while (settings.containsKey(pluginSetting)) {
            String fileExtension = settings.get(pluginSetting);
            String fileIcon = settings.get("plugin-content-type-icon-" + index);
            FileTypeEnabledOptions pluginMenu = new FileTypeEnabledOptions(fileExtension);
            ContentTypePlugin plugin = new ContentTypePlugin(fileExtension, fileIcon);
            int cmdIndex = 0;
            String cmdSetting = pluginSetting + "-command-" + cmdIndex;
            while (settings.containsKey(cmdSetting)) {
                try {
                    FileCommand.COMMAND cmd = FileCommand.COMMAND.valueOf(settings.get(cmdSetting));
                    String url = settings.get(pluginSetting + "-command-url-" + cmdIndex);
                    pluginMenu.addCommand(cmd);
                    plugin.addUrlCommand(cmd, url);
                    cmdSetting = pluginSetting + "-command-" + ++cmdIndex;
                }
                catch (Throwable t) {
                    cmdSetting = pluginSetting + "-command-" + ++cmdIndex;
                }
            }
            pluginMenu.addCommand(FileCommand.COMMAND.SHARE);
            pluginMenu.addCommand(FileCommand.COMMAND.DELETE);
            pluginMenu.addCommand(FileCommand.COMMAND.PROPERTIES);
            contentTypePluginList.add(plugin);
            enabledOptionsList.add(pluginMenu);
            pluginSetting = "plugin-content-type-" + ++index;
        }
        FileTypeEnabledOptions waqrMenu = new FileTypeEnabledOptions(".waqr.xaction");
        waqrMenu.addCommand(FileCommand.COMMAND.RUN);
        waqrMenu.addCommand(FileCommand.COMMAND.NEWWINDOW);
        waqrMenu.addCommand(FileCommand.COMMAND.BACKGROUND);
        waqrMenu.addCommand(FileCommand.COMMAND.EDIT);
        waqrMenu.addCommand(FileCommand.COMMAND.EDIT_ACTION);
        waqrMenu.addCommand(FileCommand.COMMAND.DELETE);
        waqrMenu.addCommand(FileCommand.COMMAND.SHARE);
        waqrMenu.addCommand(FileCommand.COMMAND.SCHEDULE_NEW);
        waqrMenu.addCommand(FileCommand.COMMAND.PROPERTIES);
        enabledOptionsList.add(waqrMenu);
        FileTypeEnabledOptions analysisMenu = new FileTypeEnabledOptions(".analysisview.xaction");
        analysisMenu.addCommand(FileCommand.COMMAND.RUN);
        analysisMenu.addCommand(FileCommand.COMMAND.NEWWINDOW);
        analysisMenu.addCommand(FileCommand.COMMAND.EDIT);
        analysisMenu.addCommand(FileCommand.COMMAND.EDIT_ACTION);
        analysisMenu.addCommand(FileCommand.COMMAND.DELETE);
        analysisMenu.addCommand(FileCommand.COMMAND.SHARE);
        analysisMenu.addCommand(FileCommand.COMMAND.PROPERTIES);
        enabledOptionsList.add(analysisMenu);
        FileTypeEnabledOptions xactionMenu = new FileTypeEnabledOptions(".xaction");
        xactionMenu.addCommand(FileCommand.COMMAND.RUN);
        xactionMenu.addCommand(FileCommand.COMMAND.NEWWINDOW);
        xactionMenu.addCommand(FileCommand.COMMAND.BACKGROUND);
        xactionMenu.addCommand(FileCommand.COMMAND.EDIT_ACTION);
        xactionMenu.addCommand(FileCommand.COMMAND.DELETE);
        xactionMenu.addCommand(FileCommand.COMMAND.SCHEDULE_NEW);
        xactionMenu.addCommand(FileCommand.COMMAND.SHARE);
        xactionMenu.addCommand(FileCommand.COMMAND.PROPERTIES);
        enabledOptionsList.add(xactionMenu);
        FileTypeEnabledOptions defaultMenu = new FileTypeEnabledOptions(null);
        defaultMenu.addCommand(FileCommand.COMMAND.RUN);
        defaultMenu.addCommand(FileCommand.COMMAND.NEWWINDOW);
        defaultMenu.addCommand(FileCommand.COMMAND.DELETE);
        defaultMenu.addCommand(FileCommand.COMMAND.SHARE);
        defaultMenu.addCommand(FileCommand.COMMAND.PROPERTIES);
        enabledOptionsList.add(defaultMenu);
    }

    public static FileTypeEnabledOptions getEnabledOptions(String filename) {
        for (FileTypeEnabledOptions option : enabledOptionsList) {
            if (!option.isSupportedFile(filename)) continue;
            return option;
        }
        return null;
    }

    public static ContentTypePlugin getContentTypePlugin(String filename) {
        for (ContentTypePlugin plugin : contentTypePluginList) {
            if (!plugin.isSupportedFile(filename)) continue;
            return plugin;
        }
        return null;
    }

    public static Command getNewAnalysisViewCommand() {
        if (newAnalysisViewOverrideCommandUrl == null) {
            return new AnalysisViewCommand();
        }
        return new UrlCommand(newAnalysisViewOverrideCommandUrl, newAnalysisViewOverrideCommandTitle);
    }

    public static Command getNewReportCommand() {
        if (newReportOverrideCommandUrl == null) {
            return new WAQRCommand();
        }
        return new UrlCommand(newReportOverrideCommandUrl, newReportOverrideCommandTitle);
    }

    public static Command getManageDatasourcesCommand() {
        if (manageDatasourcesOverrideCommandUrl == null) {
            return new ManageDatasourcesCommand();
        }
        return new UrlCommand(manageDatasourcesOverrideCommandUrl, manageDatasourcesOverrideCommandTitle);
    }

    public static Command getAddDatasourceCommand() {
        if (addDatasourceOverrideCommandUrl == null) {
            return new AddDatasourceCommand();
        }
        return new UrlCommand(addDatasourceOverrideCommandUrl, addDatasourceOverrideCommandTitle);
    }

    public static String fixRelativePath(String url) {
        if (!url.startsWith("http") && GWT.isScript()) {
            String href = Window.Location.getHref().substring(0, Window.Location.getHref().indexOf("Home"));
            url = href.endsWith("/") || url.startsWith("/") ? (href = href + url) : href + "/" + url;
        }
        return url;
    }

    public static class ContentTypePlugin {
        String fileExtension;
        String fileIcon;
        Map<FileCommand.COMMAND, String> urlCommands = new HashMap<FileCommand.COMMAND, String>();

        ContentTypePlugin(String fileExtension, String fileIcon) {
            this.fileExtension = fileExtension;
            this.fileIcon = fileIcon;
        }

        public void addUrlCommand(FileCommand.COMMAND cmd, String url) {
            this.urlCommands.put(cmd, url);
        }

        public boolean isSupportedFile(String filename) {
            return filename != null && filename.endsWith(this.fileExtension);
        }

        private String replacePattern(String url, FileItem item) {
            if (url == null) {
                return null;
            }
            String localeName = StringUtils.defaultIfEmpty((String)Window.Location.getParameter((String)"locale"), (String)ContentTypePlugin.getLanguagePreference());
            String newurl = url.replaceAll("\\{solution\\}", URL.encodeComponent((String)item.getSolution()));
            newurl = newurl.replaceAll("\\{path\\}", URL.encodeComponent((String)item.getPath()));
            newurl = newurl.replaceAll("\\{name\\}", URL.encodeComponent((String)item.getName()));
            newurl = newurl.replaceAll("\\{locale\\}", localeName);
            return newurl;
        }

        private static native String getLanguagePreference();

        public boolean hasCommand(FileCommand.COMMAND cmd) {
            return this.urlCommands.containsKey((Object)cmd);
        }

        public String getCommandUrl(FileItem item, FileCommand.COMMAND cmd) {
            String url = this.replacePattern(this.urlCommands.get((Object)cmd), item);
            if (!StringUtils.isEmpty((String)url)) {
                url = PluginOptionsHelper.fixRelativePath(url);
            }
            return url;
        }

        public String getFileIcon() {
            return this.fileIcon;
        }
    }
}

