/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.VetoDragException;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.mantle.client.MantleApplication;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.ui.MantleTabPanel;

public class SolutionBrowserDragController
extends PickupDragController {
    private MantleTabPanel contentTabPanel;
    private FileItem preview;
    private FileItem currentDragItem;

    public SolutionBrowserDragController(MantleTabPanel tabs) {
        super((AbsolutePanel)RootPanel.get(), false);
        this.contentTabPanel = tabs;
        this.setBehaviorDragProxy(true);
        this.setBehaviorDragStartSensitivity(5);
    }

    protected void restoreSelectedWidgetsStyle() {
    }

    protected void saveSelectedWidgetsLocationAndStyle() {
    }

    protected void restoreSelectedWidgetsLocation() {
    }

    public void dragEnd() {
        if (!this.currentFrameAcceptsDrops()) {
            return;
        }
        FileItem item = (FileItem)this.context.draggable;
        this.context.vetoException = new Exception();
        super.dragEnd();
        this.preview.removeFromParent();
        this.preview = null;
        MantleApplication.overlayPanel.setVisible(false);
        this.notifyContentDragEnd(item.getSolution(), item.getPath(), item.getName(), item.getLocalizedName());
        this.currentDragItem = null;
    }

    public void dragMove() {
        if (!this.currentFrameAcceptsDrops()) {
            return;
        }
        super.dragMove();
        boolean validDropLocation = this.notifyContentDragMove();
        this.preview.setDroppable(validDropLocation);
    }

    public void dragStart() {
        if (!this.currentFrameAcceptsDrops()) {
            return;
        }
        this.currentDragItem = (FileItem)this.context.draggable;
        super.dragStart();
        MantleApplication.overlayPanel.setVisible(true);
    }

    protected Widget newDragProxy(DragContext context) {
        FileItem newItem;
        FileItem item = (FileItem)context.draggable;
        this.preview = newItem = item.makeDragProxy();
        return newItem;
    }

    private boolean notifyContentDragMove() {
        if (this.contentTabPanel.getCurrentFrame() == null) {
            return false;
        }
        FileItem item = (FileItem)this.context.draggable;
        int rawX = this.context.mouseX;
        int rawY = this.context.mouseY;
        int offsetX = rawX - this.contentTabPanel.getCurrentFrame().getFrame().getAbsoluteLeft();
        int offsetY = rawY - this.contentTabPanel.getCurrentFrame().getFrame().getAbsoluteTop();
        boolean validDropLocation = this.notifyFrameOfDrag(this.contentTabPanel.getCurrentFrame().getFrame().getElement(), offsetX, offsetY, this.currentDragItem.getName());
        return validDropLocation;
    }

    private boolean currentFrameAcceptsDrops() {
        return this.contentTabPanel.getCurrentFrame() != null && this.currentFrameHasDropJs(this.contentTabPanel.getCurrentFrame().getFrame().getElement());
    }

    private native boolean currentFrameHasDropJs(Element var1);

    private native boolean notifyFrameOfDrag(Element var1, int var2, int var3, String var4);

    private native void notifyFrameOfDragEnd(Element var1, int var2, int var3, String var4, String var5, String var6, String var7);

    private void notifyContentDragEnd(String solution, String path, String name, String localizedName) {
        if (this.contentTabPanel.getCurrentFrame() == null) {
            return;
        }
        int rawX = this.context.mouseX;
        int rawY = this.context.mouseY;
        int offsetX = rawX - this.contentTabPanel.getCurrentFrame().getFrame().getAbsoluteLeft();
        int offsetY = rawY - this.contentTabPanel.getCurrentFrame().getFrame().getAbsoluteTop();
        this.notifyFrameOfDragEnd(this.contentTabPanel.getCurrentFrame().getFrame().getElement(), offsetX, offsetY, solution, path, name, localizedName);
    }

    public void previewDragEnd() throws VetoDragException {
    }
}

