/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser;

import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.HorizontalSplitPanel;
import com.google.gwt.user.client.ui.HorizontalSplitPanelImages;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuItemSeparator;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.VerticalSplitPanel;
import com.google.gwt.user.client.ui.VerticalSplitPanelImages;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.menuitem.CheckBoxMenuItem;
import org.pentaho.gwt.widgets.client.tabs.PentahoTab;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.mantle.client.IViewMenuCallback;
import org.pentaho.mantle.client.MantleEntryPoint;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.commands.CommandCallback;
import org.pentaho.mantle.client.commands.ExecuteWAQRPreviewCommand;
import org.pentaho.mantle.client.commands.ShareFileCommand;
import org.pentaho.mantle.client.commands.ShowBrowserCommand;
import org.pentaho.mantle.client.commands.ToggleWorkspaceCommand;
import org.pentaho.mantle.client.commands.UrlCommand;
import org.pentaho.mantle.client.images.MantleImages;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.EmptyCallback;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.PluginOptionsHelper;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserDragController;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserListener;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.filelist.FilesListPanel;
import org.pentaho.mantle.client.solutionbrowser.launcher.LaunchPanel;
import org.pentaho.mantle.client.solutionbrowser.scheduling.ScheduleHelper;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;
import org.pentaho.mantle.client.solutionbrowser.toolbars.BrowserToolbar;
import org.pentaho.mantle.client.solutionbrowser.tree.FileTreeItem;
import org.pentaho.mantle.client.solutionbrowser.tree.SolutionTree;
import org.pentaho.mantle.client.solutionbrowser.tree.SolutionTreeWrapper;
import org.pentaho.mantle.client.solutionbrowser.workspace.WorkspacePanel;
import org.pentaho.mantle.client.ui.MantleTabPanel;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;

public class SolutionBrowserPerspective
extends HorizontalPanel {
    private static final String defaultSplitPosition = "220px";
    private HorizontalSplitPanel solutionNavigatorAndContentPanel = new HorizontalSplitPanel((HorizontalSplitPanelImages)MantleImages.images);
    private VerticalSplitPanel solutionNavigatorPanel = new VerticalSplitPanel((VerticalSplitPanelImages)MantleImages.images);
    private String pucVerticalSplitterImg;
    private boolean isMouseDown = false;
    private SolutionTree solutionTree = new SolutionTree();
    private FilesListPanel filesListPanel = new FilesListPanel();
    private DeckPanel contentPanel = new DeckPanel();
    private LaunchPanel launchPanel = new LaunchPanel();
    private WorkspacePanel workspacePanel = null;
    private MantleTabPanel contentTabPanel = new MantleTabPanel(true);
    private IViewMenuCallback viewMenuCallback;
    private boolean showSolutionBrowser = false;
    private boolean isAdministrator = false;
    private ArrayList<SolutionBrowserListener> listeners = new ArrayList();
    private PickupDragController dragController;
    private Command ToggleLocalizedNamesCommand = new Command(){

        public void execute() {
            SolutionBrowserPerspective.this.solutionTree.setShowLocalizedFileNames(!SolutionBrowserPerspective.this.solutionTree.isShowLocalizedFileNames());
            SolutionBrowserPerspective.this.updateViewMenu();
            MantleServiceCache.getService().setShowLocalizedFileNames(SolutionBrowserPerspective.this.solutionTree.isShowLocalizedFileNames(), EmptyCallback.getInstance());
        }
    };
    private Command ShowHideFilesCommand = new Command(){

        public void execute() {
            SolutionBrowserPerspective.this.solutionTree.setShowHiddenFiles(!SolutionBrowserPerspective.this.solutionTree.isShowHiddenFiles());
            SolutionBrowserPerspective.this.solutionTree.setSelectedItem(SolutionBrowserPerspective.this.solutionTree.getSelectedItem(), true);
            SolutionBrowserPerspective.this.updateViewMenu();
            MantleServiceCache.getService().setShowHiddenFiles(SolutionBrowserPerspective.this.solutionTree.isShowHiddenFiles(), EmptyCallback.getInstance());
        }
    };
    private Command UseDescriptionCommand = new Command(){

        public void execute() {
            SolutionBrowserPerspective.this.solutionTree.setUseDescriptionsForTooltip(!SolutionBrowserPerspective.this.solutionTree.isUseDescriptionsForTooltip());
            SolutionBrowserPerspective.this.solutionTree.setSelectedItem(SolutionBrowserPerspective.this.solutionTree.getSelectedItem(), true);
            SolutionBrowserPerspective.this.updateViewMenu();
            MantleServiceCache.getService().setUserSetting("MANTLE_SHOW_DESCRIPTIONS_FOR_TOOLTIPS", "" + SolutionBrowserPerspective.this.solutionTree.isUseDescriptionsForTooltip(), EmptyCallback.getInstance());
        }
    };
    private TreeListener treeListener = new TreeListener(){

        public void onTreeItemSelected(TreeItem item) {
            SolutionBrowserPerspective.this.filesListPanel.populateFilesList(SolutionBrowserPerspective.this, SolutionBrowserPerspective.this.solutionTree, item);
            SolutionBrowserPerspective.this.filesListPanel.getToolbar().setEnabled(false);
        }

        public void onTreeItemStateChanged(TreeItem item) {
            SolutionBrowserPerspective.this.solutionTree.setSelectedItem(item, false);
        }
    };
    private static SolutionBrowserPerspective instance;

    private SolutionBrowserPerspective(IViewMenuCallback viewMenuCallback) {
        RootPanel.get().getElement().getStyle().setProperty("position", "relative");
        this.dragController = new SolutionBrowserDragController(this.contentTabPanel);
        instance = this;
        this.viewMenuCallback = viewMenuCallback;
        SolutionBrowserPerspective.setupNativeHooks();
        this.solutionTree.addTreeListener(this.treeListener);
        this.buildUI();
    }

    public static SolutionBrowserPerspective getInstance(IViewMenuCallback viewMenuCallback) {
        if (instance == null) {
            instance = new SolutionBrowserPerspective(viewMenuCallback);
        }
        return instance;
    }

    public static SolutionBrowserPerspective getInstance() {
        return SolutionBrowserPerspective.getInstance(null);
    }

    private void buildUI() {
        Element elementChild;
        Node child;
        int i;
        FlowPanel topPanel = new FlowPanel();
        SimplePanel toolbarWrapper = new SimplePanel();
        toolbarWrapper.setWidget((Widget)new BrowserToolbar());
        toolbarWrapper.setStyleName("files-toolbar");
        topPanel.add((Widget)toolbarWrapper);
        topPanel.add((Widget)new SolutionTreeWrapper(this.solutionTree));
        this.solutionNavigatorPanel.setStyleName("puc-vertical-split-panel");
        this.solutionNavigatorPanel.setHeight("100%");
        this.solutionNavigatorPanel.setTopWidget((Widget)topPanel);
        this.solutionNavigatorPanel.setBottomWidget((Widget)this.filesListPanel);
        this.filesListPanel.getElement().getParentElement().addClassName("filter-list-panel-container");
        this.solutionNavigatorPanel.setSplitPosition("60%");
        this.solutionNavigatorAndContentPanel.setStyleName("puc-horizontal-split-panel");
        this.solutionNavigatorAndContentPanel.setLeftWidget((Widget)this.solutionNavigatorPanel);
        this.solutionNavigatorAndContentPanel.setRightWidget((Widget)this.contentPanel);
        this.solutionNavigatorAndContentPanel.getElement().setAttribute("id", "solutionNavigatorAndContentPanel");
        NodeList possibleChildren = this.solutionNavigatorAndContentPanel.getElement().getElementsByTagName("table");
        for (i = 0; i < possibleChildren.getLength(); ++i) {
            child = possibleChildren.getItem(i);
            if (!(child instanceof Element) || !(elementChild = (Element)child).getClassName().equalsIgnoreCase("hsplitter")) continue;
            elementChild.setAttribute("id", "pucHorizontalSplitter");
            elementChild.addClassName("pentaho-rounded-panel-top-right");
            elementChild.addClassName("pentaho-shadow-right-side");
            break;
        }
        possibleChildren = this.solutionNavigatorPanel.getElement().getElementsByTagName("div");
        for (i = 0; i < possibleChildren.getLength(); ++i) {
            child = possibleChildren.getItem(i);
            if (!(child instanceof Element) || !(elementChild = (Element)child).getClassName().equalsIgnoreCase("vsplitter")) continue;
            elementChild.setAttribute("id", "pucVerticalSplitter");
            this.pucVerticalSplitterImg = ((Element)elementChild.getChild(0)).getStyle().getBackgroundImage();
            break;
        }
        this.solutionNavigatorPanel.getElement().getParentElement().addClassName("puc-navigator-panel");
        this.solutionNavigatorPanel.getElement().getParentElement().removeAttribute("style");
        this.workspacePanel = new WorkspacePanel(this.isAdministrator);
        this.contentPanel.setAnimationEnabled(false);
        this.contentPanel.add((Widget)this.workspacePanel);
        this.contentPanel.add((Widget)this.launchPanel);
        this.contentPanel.add((Widget)this.contentTabPanel);
        if (this.showSolutionBrowser) {
            this.solutionNavigatorAndContentPanel.setSplitPosition(defaultSplitPosition);
        } else {
            this.solutionNavigatorAndContentPanel.setSplitPosition("0px");
            this.solutionNavigatorPanel.setVisible(false);
        }
        this.contentPanel.setHeight("100%");
        this.contentPanel.setWidth("100%");
        this.contentPanel.getElement().setId("contentDeck");
        this.contentPanel.getElement().getParentElement().setClassName("pucContentDeck");
        this.contentPanel.getElement().getParentElement().getStyle().clearBorderWidth();
        this.contentPanel.getElement().getParentElement().getStyle().clearBorderStyle();
        this.contentPanel.getElement().getParentElement().getStyle().clearBorderColor();
        this.contentPanel.getElement().getParentElement().getStyle().clearMargin();
        this.setStyleName("panelWithTitledToolbar");
        this.setHeight("100%");
        this.setWidth("100%");
        this.add((Widget)this.solutionNavigatorAndContentPanel);
        this.sinkEvents(124);
        this.showContent();
        ElementUtils.removeScrollingFromSplitPane((Widget)this.solutionNavigatorPanel);
        ElementUtils.removeScrollingFromUpTo((Element)this.solutionNavigatorAndContentPanel.getLeftWidget().getElement(), (Element)this.solutionNavigatorAndContentPanel.getElement());
        if (Window.Navigator.getUserAgent().toLowerCase().indexOf("webkit") != -1) {
            Timer t = new Timer(){

                public void run() {
                    int leftInt;
                    String left = DOM.getElementById((String)"pucHorizontalSplitter").getParentElement().getStyle().getLeft();
                    if (left.indexOf("px") != -1) {
                        left = left.substring(0, left.indexOf("px"));
                    }
                    if ((leftInt = Integer.parseInt(left)) <= 0) {
                        SolutionBrowserPerspective.this.setNavigatorShowing(false);
                    }
                }
            };
            t.scheduleRepeating(1000);
        }
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 4: {
                this.isMouseDown = true;
                break;
            }
            case 8: {
                this.isMouseDown = false;
                DOM.releaseCapture((com.google.gwt.user.client.Element)this.getElement());
                break;
            }
            case 64: {
                int leftInt;
                if (!this.isMouseDown) break;
                String left = DOM.getElementById((String)"pucHorizontalSplitter").getParentElement().getStyle().getLeft();
                if (left.indexOf("px") != -1) {
                    left = left.substring(0, left.indexOf("px"));
                }
                if ((leftInt = Integer.parseInt(left)) > 0) {
                    this.solutionNavigatorAndContentPanel.setLeftWidget((Widget)this.solutionNavigatorPanel);
                    this.solutionNavigatorPanel.setVisible(true);
                }
                if (leftInt <= 50) {
                    com.google.gwt.user.client.Element vSplitter = DOM.getElementById((String)"pucVerticalSplitter");
                    if (vSplitter == null) break;
                    ((Element)vSplitter.getChild(0)).getStyle().setBackgroundImage("");
                    break;
                }
                com.google.gwt.user.client.Element vSplitter = DOM.getElementById((String)"pucVerticalSplitter");
                if (vSplitter == null) break;
                ((Element)vSplitter.getChild(0)).getStyle().setBackgroundImage(this.pucVerticalSplitterImg);
            }
        }
        super.onBrowserEvent(event);
    }

    private static void setupNativeHooks() {
        ExecuteWAQRPreviewCommand.setupNativeHooks();
        SolutionBrowserPerspective.setupNativeHooks(SolutionBrowserPerspective.getInstance());
    }

    private static native void setupNativeHooks(SolutionBrowserPerspective var0);

    public void confirmBackgroundExecutionDialog(final String url) {
        String title = Messages.getString("confirm");
        String message = Messages.getString("userParamBackgroundWarning");
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new Label(Messages.getString(message)));
        final PromptDialogBox scheduleInBackground = new PromptDialogBox(title, Messages.getString("yes"), Messages.getString("no"), false, true, (Widget)vp);
        IDialogCallback callback = new IDialogCallback(){

            public void cancelPressed() {
                scheduleInBackground.hide();
            }

            public void okPressed() {
                SolutionBrowserPerspective.this.runInBackground(url);
            }
        };
        scheduleInBackground.setCallback(callback);
        scheduleInBackground.center();
    }

    private void runInBackground(String url) {
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, url);
        try {
            builder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotBackgroundExecute"), false, false, true);
                    dialogBox.center();
                }

                public void onResponseReceived(Request request, Response response) {
                    if ("true".equals(response.getHeader("background_execution"))) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("backgroundJobScheduled"), false, false, true);
                        dialogBox.center();
                    }
                }
            });
        }
        catch (RequestException e) {
            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotBackgroundExecute"), false, false, true);
            dialogBox.center();
        }
    }

    private void mouseUp(Event e) {
        this.solutionNavigatorAndContentPanel.onBrowserEvent(e);
    }

    public boolean isWorkspaceShowing() {
        if (this.contentPanel.getWidgetCount() > 0) {
            return this.contentPanel.getWidgetIndex((Widget)this.workspacePanel) == this.contentPanel.getVisibleWidget();
        }
        return false;
    }

    public void showWorkspace() {
        this.workspacePanel.refreshWorkspace();
        this.contentPanel.showWidget(this.contentPanel.getWidgetIndex((Widget)this.workspacePanel));
        this.fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.UNDEFINED, -1);
        this.updateViewMenu();
    }

    public void showContent() {
        int showIndex = -1;
        if (this.contentTabPanel.getTabCount() == 0) {
            showIndex = this.contentPanel.getWidgetIndex((Widget)this.launchPanel);
            Window.setTitle((String)Messages.getString("productName"));
        } else {
            showIndex = this.contentPanel.getWidgetIndex((Widget)this.contentTabPanel);
        }
        if (showIndex != -1) {
            this.contentPanel.showWidget(showIndex);
        }
        if (this.contentTabPanel.getSelectedTabIndex() != -1) {
            this.contentTabPanel.selectTab(this.contentTabPanel.getSelectedTab());
        }
        this.fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.SELECT, this.contentTabPanel.getSelectedTabIndex());
        this.updateViewMenu();
    }

    private void addRecent(IUserSetting recentSetting, String path, String name) {
        String fullpath = path + "/" + name;
        JSONArray recents = new JSONArray();
        if (recentSetting != null && !StringUtils.isEmpty((String)recentSetting.getSettingValue())) {
            recents = JSONParser.parse((String)recentSetting.getSettingValue()).isArray();
            ArrayList<Recent> recentsList = new ArrayList<Recent>();
            for (int i = 0; i < recents.size(); ++i) {
                JSONArray recent = recents.get(i).isArray();
                if (recent.get(0).isString().stringValue().equals(fullpath)) continue;
                recentsList.add(new Recent(recent.get(0).isString().stringValue(), (long)recent.get(1).isNumber().doubleValue()));
            }
            recentsList.add(0, new Recent(fullpath, System.currentTimeMillis()));
            Recent[] recentsArray = new Recent[]{};
            recentsArray = recentsList.toArray(recentsArray);
            Arrays.sort(recentsArray, new Comparator<Recent>(){

                @Override
                public int compare(Recent o1, Recent o2) {
                    return (int)(o2.getLastUse() - o1.getLastUse());
                }
            });
            recents = new JSONArray();
            int maxLength = recentsList.size() < 10 ? recentsList.size() : 10;
            for (int i = 0; i < maxLength; ++i) {
                JSONArray recent = new JSONArray();
                recent.set(0, (JSONValue)new JSONString(((Recent)recentsList.get(i)).getFullPath()));
                recent.set(1, (JSONValue)new JSONNumber((double)((Recent)recentsList.get(i)).getLastUse()));
                recents.set(recents.size(), (JSONValue)recent);
            }
        }
        MantleServiceCache.getService().setUserSetting("recent", recents.toString(), new AsyncCallback<Void>(){

            public void onSuccess(Void result) {
                MantleEntryPoint.getMantle().getMenuBar().buildFavoritesAndRecent(true);
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    public void openFile(final String path, final String name, String localizedFileName, FileCommand.COMMAND mode) {
        ArrayList<String> pathSegments = this.solutionTree.getPathSegments(path);
        boolean fileExists = this.solutionTree.doesFileExist(pathSegments, name);
        if (!fileExists) {
            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("open"), Messages.getString("fileDoesNotExist", name), false, false, true);
            dialogBox.center();
            return;
        }
        String repoPath = "";
        for (int i = 1; i < pathSegments.size(); ++i) {
            repoPath = repoPath + "/" + pathSegments.get(i);
        }
        FileItem selectedFileItem = new FileItem(name, localizedFileName, localizedFileName, pathSegments.get(0), repoPath, "", null, null, null, false, null);
        this.filesListPanel.setSelectedFileItem(selectedFileItem);
        this.solutionTree.setSelectedItem(null);
        FileTreeItem fileTreeItem = this.solutionTree.getTreeItem(pathSegments);
        this.solutionTree.setSelectedItem(fileTreeItem, true);
        for (FileTreeItem tmpTreeItem = fileTreeItem; tmpTreeItem != null; tmpTreeItem = tmpTreeItem.getParentItem()) {
            tmpTreeItem.setState(true);
        }
        fileTreeItem.setSelected(true);
        ArrayList files = (ArrayList)fileTreeItem.getUserObject();
        if (files != null) {
            for (com.google.gwt.xml.client.Element fileElement : files) {
                if (!name.equals(fileElement.getAttribute("name")) && !name.equals(fileElement.getAttribute("localized-name"))) continue;
                selectedFileItem.setURL(fileElement.getAttribute("url"));
            }
        }
        if (mode == FileCommand.COMMAND.EDIT) {
            this.editFile();
        } else if (mode == FileCommand.COMMAND.SCHEDULE_NEW) {
            ScheduleHelper.createSchedule(this.filesListPanel.getSelectedFileItem());
        } else if (mode == FileCommand.COMMAND.SHARE) {
            new ShareFileCommand().execute();
        } else {
            MantleServiceCache.getService().getUserSetting("recent", new AsyncCallback<IUserSetting>(){

                public void onSuccess(IUserSetting setting) {
                    SolutionBrowserPerspective.this.addRecent(setting, path, name);
                }

                public void onFailure(Throwable caught) {
                    SolutionBrowserPerspective.this.addRecent(null, path, name);
                }
            });
            if (name.endsWith(".xaction")) {
                this.executeActionSequence(mode);
            } else if (name.endsWith(".url")) {
                if (mode == FileCommand.COMMAND.NEWWINDOW) {
                    Window.open((String)this.filesListPanel.getSelectedFileItem().getURL(), (String)"_blank", (String)"menubar=yes,location=no,resizable=yes,scrollbars=yes,status=no");
                } else {
                    this.contentTabPanel.showNewURLTab(this.filesListPanel.getSelectedFileItem().getLocalizedName(), this.filesListPanel.getSelectedFileItem().getLocalizedName(), this.filesListPanel.getSelectedFileItem().getURL(), true);
                }
            } else {
                String url;
                PluginOptionsHelper.ContentTypePlugin plugin = PluginOptionsHelper.getContentTypePlugin(this.filesListPanel.getSelectedFileItem().getName());
                if (plugin != null && plugin.hasCommand(mode)) {
                    url = plugin.getCommandUrl(this.filesListPanel.getSelectedFileItem(), mode);
                    if (StringUtils.isEmpty((String)url)) {
                        url = this.filesListPanel.getSelectedFileItem().getURL();
                    }
                    if (GWT.isScript()) {
                        if (url != null && !"".equals(url)) {
                            if (mode == FileCommand.COMMAND.NEWWINDOW) {
                                Window.open((String)url, (String)"_blank", (String)"menubar=yes,location=no,resizable=yes,scrollbars=yes,status=no");
                            } else if (mode == FileCommand.COMMAND.BACKGROUND) {
                                RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, url);
                                try {
                                    builder.sendRequest(null, new RequestCallback(){

                                        public void onError(Request request, Throwable exception) {
                                            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotBackgroundExecute"), false, false, true);
                                            dialogBox.center();
                                        }

                                        public void onResponseReceived(Request request, Response response) {
                                            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("backgroundExecutionWarning"), true, false, true);
                                            dialogBox.setCallback(new IDialogCallback(){

                                                public void cancelPressed() {
                                                }

                                                public void okPressed() {
                                                    if (SolutionBrowserPerspective.this.isWorkspaceShowing()) {
                                                        SolutionBrowserPerspective.this.workspacePanel.refreshWorkspace();
                                                    }
                                                }
                                            });
                                            dialogBox.center();
                                        }
                                    });
                                }
                                catch (RequestException e) {
                                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), e.getMessage(), true, false, true);
                                    dialogBox.center();
                                }
                            } else {
                                UrlCommand cmd = new UrlCommand(url, this.filesListPanel.getSelectedFileItem().getLocalizedName());
                                cmd.execute(new CommandCallback(){

                                    public void afterExecute() {
                                        SolutionBrowserPerspective.this.contentTabPanel.setFileInfoInFrame(SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem());
                                    }
                                });
                            }
                        }
                    } else if (url != null && !"".equals(url)) {
                        String updateUrl = "/MantleService?passthru=" + url;
                        if (mode == FileCommand.COMMAND.NEWWINDOW) {
                            Window.open((String)updateUrl, (String)"_blank", (String)"menubar=yes,location=no,resizable=yes,scrollbars=yes,status=no");
                        } else {
                            this.contentTabPanel.showNewURLTab(this.filesListPanel.getSelectedFileItem().getLocalizedName(), this.filesListPanel.getSelectedFileItem().getLocalizedName(), updateUrl, true);
                        }
                    }
                } else {
                    url = this.filesListPanel.getSelectedFileItem().getURL();
                    if (url != null && !"".equals(url)) {
                        if (mode == FileCommand.COMMAND.NEWWINDOW) {
                            Window.open((String)this.filesListPanel.getSelectedFileItem().getURL(), (String)"_blank", (String)"menubar=yes,location=no,resizable=yes,scrollbars=yes,status=no");
                        } else {
                            this.contentTabPanel.showNewURLTab(this.filesListPanel.getSelectedFileItem().getLocalizedName(), this.filesListPanel.getSelectedFileItem().getLocalizedName(), this.filesListPanel.getSelectedFileItem().getURL(), true);
                        }
                    }
                }
            }
        }
    }

    public void editFile() {
        if (this.filesListPanel.getSelectedFileItem().getName().endsWith(".waqr.xaction")) {
            String filename = this.filesListPanel.getSelectedFileItem().getName().substring(0, this.filesListPanel.getSelectedFileItem().getName().indexOf(".waqr.xaction")) + ".waqr.xreportspec";
            String url = "adhoc/waqr.html?solution=" + URL.encodeComponent((String)this.filesListPanel.getSelectedFileItem().getSolution()) + "&path=" + URL.encodeComponent((String)this.filesListPanel.getSelectedFileItem().getPath()) + "&filename=" + URL.encodeComponent((String)filename);
            if (!GWT.isScript()) {
                url = "http://localhost:8080/pentaho/adhoc/waqr.html?solution=" + this.filesListPanel.getSelectedFileItem().getSolution() + "&path=" + this.filesListPanel.getSelectedFileItem().getPath() + "&filename=" + filename;
            }
            for (int i = 0; i < this.contentTabPanel.getTabCount(); ++i) {
                Widget w = this.contentTabPanel.getTab(i).getContent();
                if (!(w instanceof IFrameTabPanel) || !((IFrameTabPanel)w).getUrl().endsWith(url)) continue;
                this.contentTabPanel.selectTab(i);
                return;
            }
            this.contentTabPanel.showNewURLTab(Messages.getString("editingColon") + this.filesListPanel.getSelectedFileItem().getLocalizedName(), Messages.getString("editingColon") + this.filesListPanel.getSelectedFileItem().getLocalizedName(), url, true);
            this.contentTabPanel.getCurrentFrame().setFileInfo(this.filesListPanel.getSelectedFileItem());
        } else if (this.filesListPanel.getSelectedFileItem().getName().endsWith(".analysisview.xaction")) {
            this.openFile("/" + this.filesListPanel.getSelectedFileItem().getSolution() + this.filesListPanel.getSelectedFileItem().getPath(), this.filesListPanel.getSelectedFileItem().getName(), this.filesListPanel.getSelectedFileItem().getLocalizedName(), FileCommand.COMMAND.RUN);
        } else {
            PluginOptionsHelper.ContentTypePlugin plugin = PluginOptionsHelper.getContentTypePlugin(this.filesListPanel.getSelectedFileItem().getName());
            if (plugin != null && plugin.hasCommand(FileCommand.COMMAND.EDIT)) {
                String editUrl = plugin.getCommandUrl(this.filesListPanel.getSelectedFileItem(), FileCommand.COMMAND.EDIT);
                for (int i = 0; i < this.contentTabPanel.getTabCount(); ++i) {
                    Widget w = this.contentTabPanel.getTab(i).getContent();
                    if (!(w instanceof IFrameTabPanel) || !((IFrameTabPanel)w).getUrl().endsWith(editUrl)) continue;
                    this.contentTabPanel.selectTab(i);
                    return;
                }
                if (GWT.isScript()) {
                    this.contentTabPanel.showNewURLTab(Messages.getString("editingColon") + this.filesListPanel.getSelectedFileItem().getLocalizedName(), Messages.getString("editingColon") + this.filesListPanel.getSelectedFileItem().getLocalizedName(), editUrl, true);
                } else {
                    String updateUrl = "/MantleService?passthru=" + editUrl;
                    this.contentTabPanel.showNewURLTab(this.filesListPanel.getSelectedFileItem().getLocalizedName(), this.filesListPanel.getSelectedFileItem().getLocalizedName(), updateUrl, true);
                }
                this.contentTabPanel.getCurrentFrame().setFileInfo(this.filesListPanel.getSelectedFileItem());
            } else {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("cannotEditFileType"), true, false, true);
                dialogBox.center();
            }
        }
    }

    public void executeActionSequence(final FileCommand.COMMAND mode) {
        AbstractCommand authCmd = new AbstractCommand(){

            protected void performOperation() {
                this.performOperation(false);
            }

            protected void performOperation(boolean feedback) {
                String url = null;
                String path = SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (GWT.isScript()) {
                    url = "ViewAction?solution=" + URL.encodeComponent((String)SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getSolution()) + "&path=" + URL.encodeComponent((String)path) + "&action=" + URL.encodeComponent((String)SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getName());
                    String mypath = Window.Location.getPath();
                    if (!mypath.endsWith("/")) {
                        mypath = mypath.substring(0, mypath.lastIndexOf("/") + 1);
                    }
                    if (!(mypath = mypath.replaceAll("/mantle/", "/")).endsWith("/")) {
                        mypath = "/" + mypath;
                    }
                    url = mypath + url;
                } else {
                    url = "/MantleService?passthru=ViewAction&solution=" + SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getSolution() + "&path=" + path + "&action=" + SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getName() + "&userid=joe&password=password";
                }
                if (mode == FileCommand.COMMAND.BACKGROUND) {
                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("backgroundExecutionWarning"), true, false, true);
                    dialogBox.center();
                    url = url + "&background=true";
                    RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, url);
                    try {
                        builder.sendRequest(null, new RequestCallback(){

                            public void onError(Request request, Throwable exception) {
                                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotBackgroundExecute"), false, false, true);
                                dialogBox.center();
                            }

                            public void onResponseReceived(Request request, Response response) {
                            }
                        });
                    }
                    catch (RequestException e) {}
                } else if (mode == FileCommand.COMMAND.NEWWINDOW) {
                    Window.open((String)url, (String)"_blank", (String)"menubar=yes,location=no,resizable=yes,scrollbars=yes,status=no");
                } else if (mode == FileCommand.COMMAND.SUBSCRIBE) {
                    final String myurl = url + "&subscribepage=yes";
                    AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetFileProperties"), false, false, true);
                            dialogBox.center();
                        }

                        public void onSuccess(Boolean subscribable) {
                            if (subscribable.booleanValue()) {
                                SolutionBrowserPerspective.this.contentTabPanel.showNewURLTab(SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getLocalizedName(), SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getLocalizedName(), myurl, true);
                            } else {
                                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("noSchedulePermission"), false, false, true);
                                dialogBox.center();
                            }
                        }
                    };
                    MantleServiceCache.getService().hasAccess(SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getSolution(), SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getPath(), SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getName(), 3, callback);
                } else {
                    SolutionBrowserPerspective.this.contentTabPanel.showNewURLTab(SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getLocalizedName(), SolutionBrowserPerspective.this.filesListPanel.getSelectedFileItem().getLocalizedName(), url, true);
                }
            }
        };
        authCmd.execute();
    }

    public void updateViewMenu() {
        ArrayList<UIObject> viewMenuItems = new ArrayList<UIObject>();
        CheckBoxMenuItem showWorkspaceMenuItem = new CheckBoxMenuItem(Messages.getString("workspace"), (Command)new ToggleWorkspaceCommand());
        CheckBoxMenuItem showHiddenFilesMenuItem = new CheckBoxMenuItem(Messages.getString("showHiddenFiles"), this.ShowHideFilesCommand);
        CheckBoxMenuItem showLocalizedFileNamesMenuItem = new CheckBoxMenuItem(Messages.getString("showLocalizedFileNames"), this.ToggleLocalizedNamesCommand);
        CheckBoxMenuItem showSolutionBrowserMenuItem = new CheckBoxMenuItem(Messages.getString("showSolutionBrowser"), (Command)new ShowBrowserCommand());
        CheckBoxMenuItem useDescriptionsMenuItem = new CheckBoxMenuItem(Messages.getString("useDescriptionsForTooltips"), this.UseDescriptionCommand);
        showWorkspaceMenuItem.setChecked(this.isWorkspaceShowing());
        showLocalizedFileNamesMenuItem.setChecked(this.solutionTree.isShowLocalizedFileNames());
        showHiddenFilesMenuItem.setChecked(this.solutionTree.isShowHiddenFiles());
        showSolutionBrowserMenuItem.setChecked(this.showSolutionBrowser);
        useDescriptionsMenuItem.setChecked(this.solutionTree.isUseDescriptionsForTooltip());
        viewMenuItems.add((UIObject)showSolutionBrowserMenuItem);
        viewMenuItems.add((UIObject)showWorkspaceMenuItem);
        viewMenuItems.add((UIObject)new MenuItemSeparator());
        viewMenuItems.add((UIObject)useDescriptionsMenuItem);
        this.viewMenuCallback.installViewMenu(viewMenuItems);
    }

    public WorkspacePanel getWorkspacePanel() {
        return this.workspacePanel;
    }

    public MantleTabPanel getContentTabPanel() {
        return this.contentTabPanel;
    }

    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public void setAdministrator(boolean isAdministrator) {
        this.isAdministrator = isAdministrator;
        this.solutionTree.setAdministrator(isAdministrator);
        this.workspacePanel.setAdministrator(isAdministrator);
    }

    public boolean isNavigatorShowing() {
        return this.showSolutionBrowser;
    }

    public void setNavigatorShowing(boolean showSolutionBrowser) {
        boolean prevVal = this.showSolutionBrowser;
        this.showSolutionBrowser = showSolutionBrowser;
        if (showSolutionBrowser) {
            this.solutionNavigatorAndContentPanel.setLeftWidget((Widget)this.solutionNavigatorPanel);
            this.solutionNavigatorAndContentPanel.setSplitPosition(defaultSplitPosition);
            this.solutionNavigatorPanel.setVisible(true);
            this.solutionNavigatorPanel.setSplitPosition("60%");
            com.google.gwt.user.client.Element vSplitter = DOM.getElementById((String)"pucVerticalSplitter");
            if (vSplitter != null) {
                ((Element)vSplitter.getChild(0)).getStyle().setBackgroundImage(this.pucVerticalSplitterImg);
            }
        } else {
            this.solutionNavigatorAndContentPanel.setLeftWidget((Widget)new SimplePanel());
            this.solutionNavigatorAndContentPanel.setSplitPosition("0px");
            this.solutionNavigatorPanel.setVisible(false);
        }
        this.updateViewMenu();
        if (this.showSolutionBrowser == prevVal) {
            return;
        }
        this.fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.UNDEFINED, -1);
    }

    public void addSolutionBrowserListener(SolutionBrowserListener listener) {
        this.listeners.add(listener);
    }

    public void removeSolutionBrowserListener(SolutionBrowserListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType type, int tabIndex) {
        if (tabIndex == -1) {
            tabIndex = this.contentTabPanel.getSelectedTabIndex();
        }
        PentahoTab tab = this.contentTabPanel.getTab(tabIndex);
        Widget tabContent = null;
        if (tab != null) {
            tabContent = tab.getContent();
        }
        for (SolutionBrowserListener listener : this.listeners) {
            try {
                if (this.isWorkspaceShowing()) {
                    listener.solutionBrowserEvent(null, null, null);
                    continue;
                }
                listener.solutionBrowserEvent(type, tabContent, this.filesListPanel.getSelectedFileItem());
            }
            catch (Exception e) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), e.toString(), false, false, true);
                dialogBox.center();
            }
        }
    }

    public SolutionTree getSolutionTree() {
        return this.solutionTree;
    }

    public FilesListPanel getFilesListPanel() {
        return this.filesListPanel;
    }

    public PickupDragController getDragController() {
        return this.dragController;
    }

    public void setDragController(PickupDragController dragController) {
        this.dragController = dragController;
    }

    private class Recent {
        String fullPath;
        long lastUse;

        public Recent(String fullPath, long lastUse) {
            this.fullPath = fullPath;
            this.lastUse = lastUse;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public long getLastUse() {
            return this.lastUse;
        }
    }
}

