/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.dialogs.WaitPopup;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.ISolutionDocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionDocumentManager {
    private ArrayList<ISolutionDocumentListener> listeners = new ArrayList();
    private Document solutionDocument;
    private static SolutionDocumentManager instance;
    private static boolean fetching;

    private SolutionDocumentManager() {
        this.flagSolutionDocumentLoaded(false);
    }

    private native void flagSolutionDocumentLoaded(boolean var1);

    public static SolutionDocumentManager getInstance() {
        if (instance == null) {
            instance = new SolutionDocumentManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSolutionDocumentListener(ISolutionDocumentListener listener) {
        this.listeners.add(listener);
        Class<SolutionDocumentManager> clazz = SolutionDocumentManager.class;
        synchronized (SolutionDocumentManager.class) {
            if (!fetching && this.solutionDocument != null) {
                listener.beforeFetchSolutionDocument();
                listener.onFetchSolutionDocument(this.solutionDocument);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removeSolutionDocumentListener(ISolutionDocumentListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSolutionDocumentFetched() {
        fetching = false;
        for (ISolutionDocumentListener listener : this.listeners) {
            listener.onFetchSolutionDocument(this.solutionDocument);
        }
        this.flagSolutionDocumentLoaded(true);
    }

    public void beforeFetchSolutionDocument() {
        for (ISolutionDocumentListener listener : this.listeners) {
            listener.beforeFetchSolutionDocument();
        }
    }

    public void fetchSolutionDocument(boolean forceReload) {
        if (forceReload || this.solutionDocument == null) {
            this.fetchSolutionDocument(null);
        }
    }

    public void fetchSolutionDocument(AsyncCallback<Document> callback, boolean forceReload) {
        if (forceReload || this.solutionDocument == null) {
            this.fetchSolutionDocument(callback);
        } else {
            callback.onSuccess((Object)this.solutionDocument);
        }
    }

    public void fetchSolutionDocument(final AsyncCallback<Document> callback) {
        WaitPopup.getInstance().setVisible(true);
        this.beforeFetchSolutionDocument();
        RequestBuilder builder = null;
        if (GWT.isScript()) {
            String path = Window.Location.getPath();
            if (!path.endsWith("/")) {
                path = path.substring(0, path.lastIndexOf("/") + 1);
            }
            builder = new RequestBuilder(RequestBuilder.GET, path + "SolutionRepositoryService?component=getSolutionRepositoryDoc");
        } else {
            builder = new RequestBuilder(RequestBuilder.GET, "/MantleService?passthru=SolutionRepositoryService&component=getSolutionRepositoryDoc&userid=joe&password=password");
        }
        RequestCallback internalCallback = new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                WaitPopup.getInstance().setVisible(false);
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetRepositoryDocument"), false, false, true);
                dialogBox.center();
            }

            public void onResponseReceived(Request request, Response response) {
                SolutionDocumentManager.this.solutionDocument = XMLParser.parse((String)response.getText());
                SolutionDocumentManager.this.fireSolutionDocumentFetched();
                if (callback != null) {
                    callback.onSuccess((Object)SolutionDocumentManager.this.solutionDocument);
                }
                WaitPopup.getInstance().setVisible(false);
            }
        };
        try {
            builder.sendRequest(null, internalCallback);
        }
        catch (RequestException e) {
            WaitPopup.getInstance().setVisible(false);
            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetRepositoryDocument"), false, false, true);
            dialogBox.center();
        }
    }

    static {
        fetching = false;
    }
}

