/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.filelist;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.PopupPanel;
import org.pentaho.mantle.client.commands.DeleteFileCommand;
import org.pentaho.mantle.client.commands.FilePropertiesCommand;
import org.pentaho.mantle.client.commands.NewFolderCommand;
import org.pentaho.mantle.client.commands.ShareFileCommand;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.IFileSummaryProvider;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FilesListPanel;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.FilePropertiesDialog;
import org.pentaho.mantle.client.solutionbrowser.scheduling.ScheduleHelper;

public class FileCommand
implements Command {
    COMMAND mode = COMMAND.RUN;
    PopupPanel popupMenu;
    private IFileSummaryProvider fileSummaryProvider;
    private IFileSummary fileSummary;

    public FileCommand(COMMAND inMode, PopupPanel popupMenu, IFileSummaryProvider fileSummaryProvider) {
        this.mode = inMode;
        this.popupMenu = popupMenu;
        this.fileSummaryProvider = fileSummaryProvider;
    }

    public FileCommand(COMMAND inMode, PopupPanel popupMenu, IFileSummary fileSummary) {
        this.mode = inMode;
        this.popupMenu = popupMenu;
        this.fileSummary = fileSummary;
    }

    public void execute() {
        if (this.popupMenu != null) {
            this.popupMenu.hide();
        }
        SolutionBrowserPerspective sbp = SolutionBrowserPerspective.getInstance();
        if (this.mode == COMMAND.RUN || this.mode == COMMAND.BACKGROUND || this.mode == COMMAND.NEWWINDOW) {
            FilesListPanel flp = sbp.getFilesListPanel();
            sbp.openFile("/" + flp.getSelectedFileItem().getSolution() + flp.getSelectedFileItem().getPath(), flp.getSelectedFileItem().getName(), flp.getSelectedFileItem().getLocalizedName(), this.mode);
        } else if (this.mode == COMMAND.PROPERTIES) {
            IFileSummary summary = this.fileSummary;
            if (summary == null) {
                summary = this.fileSummaryProvider.getFileSummary();
            }
            new FilePropertiesCommand(summary, FilePropertiesDialog.Tabs.GENERAL).execute();
        } else if (this.mode == COMMAND.EDIT) {
            sbp.editFile();
        } else if (this.mode == COMMAND.DELETE) {
            IFileSummary summary = this.fileSummary;
            if (summary == null) {
                summary = this.fileSummaryProvider.getFileSummary();
            }
            new DeleteFileCommand(summary).execute();
        } else if (this.mode == COMMAND.CREATE_FOLDER) {
            IFileSummary summary = this.fileSummary;
            new NewFolderCommand(summary).execute();
        } else if (this.mode == COMMAND.SCHEDULE_NEW) {
            ScheduleHelper.createSchedule(sbp.getFilesListPanel().getSelectedFileItem());
        } else if (this.mode == COMMAND.SHARE) {
            new ShareFileCommand().execute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COMMAND {
        RUN,
        EDIT,
        DELETE,
        PROPERTIES,
        BACKGROUND,
        NEWWINDOW,
        SCHEDULE_CUSTOM,
        SCHEDULE_NEW,
        SUBSCRIBE,
        SHARE,
        EDIT_ACTION,
        CREATE_FOLDER;

    }
}

