/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.filelist;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;
import org.pentaho.mantle.client.MantleApplication;
import org.pentaho.mantle.client.images.MantleImages;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.FileTypeEnabledOptions;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.MantlePopupPanel;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.filelist.FilesListPanel;
import org.pentaho.mantle.client.solutionbrowser.filelist.IFileItemListener;

public class FileItem
extends FlexTable
implements HasAllMouseHandlers,
IFileSummary {
    public static final String ANALYSIS_VIEW_SUFFIX = ".analysisview.xaction";
    public static final String WAQR_VIEW_SUFFIX = ".waqr.xaction";
    public static final String XACTION_SUFFIX = ".xaction";
    public static final String URL_SUFFIX = ".url";
    private static String SEPARATOR = "separator";
    private static final String[] menuItems = new String[]{"open", "openInNewWindow", "runInBackground", "edit", "editAction", "delete", SEPARATOR, "share", "scheduleEllipsis", SEPARATOR, "propertiesEllipsis"};
    FileCommand.COMMAND[] menuCommands = new FileCommand.COMMAND[]{FileCommand.COMMAND.RUN, FileCommand.COMMAND.NEWWINDOW, FileCommand.COMMAND.BACKGROUND, FileCommand.COMMAND.EDIT, FileCommand.COMMAND.EDIT_ACTION, FileCommand.COMMAND.DELETE, null, FileCommand.COMMAND.SHARE, FileCommand.COMMAND.SCHEDULE_NEW, null, FileCommand.COMMAND.PROPERTIES};
    static PopupPanel popupMenu = new MantlePopupPanel(true);
    private Label fileLabel = new Label();
    private String name;
    private String solution;
    private String path;
    private String lastModifiedDateStr;
    private String url;
    private String localizedName;
    private FileTypeEnabledOptions options;
    private boolean supportsACLs;
    private FilesListPanel filesListPanel;
    private String iconStr;
    private Image dropIndicator = new Image();
    private boolean canDrop = false;
    private ArrayList<IFileItemListener> listeners = new ArrayList();

    public FileItem(String name, String localizedName, String tooltip, String solution, String path, String lastModifiedDateStr, String url, FilesListPanel filesListPanel, FileTypeEnabledOptions options, boolean supportsACLs, String fileIconStr) {
        this.filesListPanel = filesListPanel;
        this.iconStr = fileIconStr;
        this.sinkEvents(10);
        DOM.setElementAttribute((com.google.gwt.user.client.Element)this.getElement(), (String)"oncontextmenu", (String)"return false;");
        DOM.setElementAttribute((com.google.gwt.user.client.Element)popupMenu.getElement(), (String)"oncontextmenu", (String)"return false;");
        this.fileLabel.setWordWrap(false);
        this.fileLabel.setText(localizedName);
        this.fileLabel.setTitle(tooltip);
        this.setStyleName("fileLabel");
        this.setCellPadding(0);
        this.setCellSpacing(0);
        ElementUtils.preventTextSelection((Element)this.fileLabel.getElement());
        Image fileIcon = new Image();
        if (fileIconStr != null) {
            fileIcon.setUrl(fileIconStr);
        } else if (name.endsWith(WAQR_VIEW_SUFFIX)) {
            MantleImages.images.file_report().applyTo(fileIcon);
        } else if (name.endsWith(ANALYSIS_VIEW_SUFFIX)) {
            MantleImages.images.file_analysis().applyTo(fileIcon);
        } else if (name.endsWith(XACTION_SUFFIX)) {
            MantleImages.images.file_action().applyTo(fileIcon);
        } else if (name.endsWith(URL_SUFFIX)) {
            MantleImages.images.file_url().applyTo(fileIcon);
        } else {
            MantleImages.images.fileIcon().applyTo(fileIcon);
        }
        fileIcon.setWidth("16px");
        this.fileLabel.setWidth("100%");
        this.setWidget(0, 0, (Widget)fileIcon);
        this.getCellFormatter().setWidth(0, 0, "16px");
        this.setWidget(0, 1, (Widget)this.fileLabel);
        this.getCellFormatter().setWidth(0, 1, "100%");
        this.name = name;
        this.localizedName = localizedName;
        this.solution = solution;
        this.path = path;
        this.lastModifiedDateStr = lastModifiedDateStr;
        this.url = url;
        this.options = options;
        this.supportsACLs = supportsACLs;
    }

    private void select() {
        if (this.filesListPanel.getSelectedFileItem() != null) {
            this.filesListPanel.getSelectedFileItem().setStyleName("fileLabel");
        }
        this.filesListPanel.setSelectedFileItem(this);
        this.filesListPanel.getSelectedFileItem().setStyleName("fileLabelSelected");
    }

    public void onBrowserEvent(Event event) {
        if ((DOM.eventGetType((Event)event) & 2) == 2) {
            this.select();
            SolutionBrowserPerspective.getInstance().openFile("/" + this.filesListPanel.getSelectedFileItem().getSolution() + this.filesListPanel.getSelectedFileItem().getPath(), this.filesListPanel.getSelectedFileItem().getName(), this.filesListPanel.getSelectedFileItem().getLocalizedName(), FileCommand.COMMAND.RUN);
        } else if ((DOM.eventGetType((Event)event) & 8) == 8) {
            if (DOM.eventGetButton((Event)event) == 1) {
                this.select();
                this.fireFileSelectionEvent();
            } else if (DOM.eventGetButton((Event)event) == 2) {
                int left = Window.getScrollLeft() + DOM.eventGetClientX((Event)event);
                int top = Window.getScrollTop() + DOM.eventGetClientY((Event)event);
                this.handleRightClick(left, top);
                this.fireFileSelectionEvent();
            }
        }
        super.onBrowserEvent(event);
    }

    public boolean isCommandEnabled(FileCommand.COMMAND command) {
        return this.options != null && this.options.isCommandEnabled(command);
    }

    public void handleRightClick(final int left, final int top) {
        this.select();
        this.fireFileSelectionEvent();
        popupMenu.setPopupPosition(left, top);
        MenuBar menuBar = new MenuBar(true);
        menuBar.setAutoOpen(true);
        for (int i = 0; i < menuItems.length; ++i) {
            if (!MantleApplication.showAdvancedFeatures && this.menuCommands[i] == FileCommand.COMMAND.EDIT_ACTION) continue;
            if (menuItems[i].equals(SEPARATOR)) {
                menuBar.addSeparator();
                continue;
            }
            if (this.options != null && this.options.isCommandEnabled(this.menuCommands[i])) {
                menuBar.addItem(new MenuItem(Messages.getString(menuItems[i]), (Command)new FileCommand(this.menuCommands[i], popupMenu, this)));
                continue;
            }
            MenuItem item = new MenuItem(Messages.getString(menuItems[i]), (Command)null);
            item.setStyleName("disabledMenuItem");
            menuBar.addItem(item);
        }
        popupMenu.setWidget((Widget)menuBar);
        Timer t = new Timer(){

            public void run() {
                popupMenu.hide();
                popupMenu.show();
                if (top + popupMenu.getOffsetHeight() > Window.getClientHeight()) {
                    popupMenu.setPopupPosition(left, top - popupMenu.getOffsetHeight());
                    popupMenu.hide();
                    popupMenu.show();
                    DOM.scrollIntoView((com.google.gwt.user.client.Element)popupMenu.getElement());
                }
            }
        };
        t.schedule(250);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLastModifiedDateStr() {
        return this.lastModifiedDateStr;
    }

    public void setLastModifiedDateStr(String lastModifiedDateStr) {
        this.lastModifiedDateStr = lastModifiedDateStr;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public String getFullPath() {
        return this.solution + this.path + this.name;
    }

    public void fireFileSelectionEvent() {
        for (IFileItemListener listener : this.listeners) {
            listener.itemSelected(this);
        }
    }

    public String getIcon() {
        return this.iconStr;
    }

    public void addFileSelectionChangedListener(IFileItemListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileSelectionChangedListener(IFileItemListener listener) {
        this.listeners.remove(listener);
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseUpEvent.getType());
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseMoveEvent.getType());
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseWheelEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseOverEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler((EventHandler)handler, MouseDownEvent.getType());
    }

    public FileItem makeDragProxy() {
        FileItem f = new FileItem(this.getName(), this.getLocalizedName(), "", this.getSolution(), this.getPath(), "", this.getURL(), this.filesListPanel, this.options, false, this.getIcon());
        f.enableDrag();
        return f;
    }

    public void enableDrag() {
        this.setWidget(0, 0, (Widget)this.dropIndicator);
        this.addStyleName("fileItemDragProxy");
        this.setDroppable(false);
        MantleImages.images.drop_invalid().applyTo(this.dropIndicator);
    }

    public void setDroppable(boolean canDrop) {
        if (this.canDrop == canDrop) {
            return;
        }
        if (canDrop) {
            MantleImages.images.drop_valid().applyTo(this.dropIndicator);
            this.addStyleName("validDrop");
        } else {
            MantleImages.images.drop_invalid().applyTo(this.dropIndicator);
            this.removeStyleName("validDrop");
        }
        this.canDrop = canDrop;
    }
}

