/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.filelist;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.pentaho.gwt.widgets.client.filechooser.FileChooserListener;
import org.pentaho.gwt.widgets.client.toolbar.Toolbar;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.mantle.client.dialogs.FileDialog;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.IFileSummaryProvider;
import org.pentaho.mantle.client.solutionbrowser.ISolutionDocumentListener;
import org.pentaho.mantle.client.solutionbrowser.PluginOptionsHelper;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.SolutionDocumentManager;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.toolbars.FilesToolbar;
import org.pentaho.mantle.client.solutionbrowser.tree.SolutionTree;

public class FilesListPanel
extends FlowPanel
implements ISolutionDocumentListener,
IFileSummaryProvider {
    protected String FILES_LABEL_STYLE_NAME = "filesPanelMenuLabel";
    private FlexTable filesList = new FlexTable();
    private FilesToolbar toolbar = new FilesToolbar(this);
    private FileItem selectedFileItem;

    public FilesListPanel() {
        SimplePanel toolbarWrapper = new SimplePanel();
        toolbarWrapper.add((Widget)this.toolbar);
        toolbarWrapper.setStyleName("files-toolbar");
        this.add((Widget)toolbarWrapper);
        SimplePanel filesListWrapper = new SimplePanel();
        FocusPanel fp = new FocusPanel((Widget)this.filesList){

            public void onBrowserEvent(Event event) {
                if ((DOM.eventGetType((Event)event) & 0x80) == 128) {
                    if (event.getKeyCode() == 38) {
                        FilesListPanel.this.selectPreviousItem(FilesListPanel.this.selectedFileItem);
                    } else if (event.getKeyCode() == 40) {
                        FilesListPanel.this.selectNextItem(FilesListPanel.this.selectedFileItem);
                    } else if (event.getKeyCode() == 13) {
                        SolutionBrowserPerspective sbp = SolutionBrowserPerspective.getInstance();
                        FilesListPanel flp = sbp.getFilesListPanel();
                        sbp.openFile("/" + flp.getSelectedFileItem().getSolution() + flp.getSelectedFileItem().getPath(), flp.getSelectedFileItem().getName(), flp.getSelectedFileItem().getLocalizedName(), FileCommand.COMMAND.RUN);
                    }
                }
                super.onBrowserEvent(event);
            }
        };
        this.filesList.setCellPadding(1);
        this.filesList.setWidth("100%");
        AbsolutePanel bounderyPanel = new AbsolutePanel();
        bounderyPanel.add((Widget)fp);
        fp.sinkEvents(896);
        filesListWrapper.add((Widget)bounderyPanel);
        fp.getElement().getStyle().setProperty("margin", "29px 0px 10px 0px");
        filesListWrapper.setStyleName("files-list-panel");
        this.add((Widget)filesListWrapper);
        this.setStyleName("panelWithTitledToolbar");
        this.setWidth("100%");
        this.getElement().setId("filesListPanel");
        FilesListPanel.setupNativeHooks(this);
        SolutionDocumentManager.getInstance().addSolutionDocumentListener(this);
    }

    public void beforeFetchSolutionDocument() {
        this.filesList.clear();
    }

    public void onFetchSolutionDocument(Document solutionDocument) {
    }

    private void showOpenFileDialog(final JavaScriptObject callback, final String path, final String title, final String okText, final String fileTypes) {
        SolutionDocumentManager.getInstance().fetchSolutionDocument(new AsyncCallback<Document>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Document result) {
                FileDialog dialog = new FileDialog(result, path, title, okText, fileTypes.split(","));
                dialog.addFileChooserListener(new FileChooserListener(){

                    public void fileSelected(String solution, String path, String name, String localizedFileName) {
                        FilesListPanel.this.notifyOpenFileCallback(callback, solution, path, name, localizedFileName);
                    }

                    public void fileSelectionChanged(String solution, String path, String name) {
                    }

                    public void dialogCanceled() {
                    }
                });
                dialog.show();
            }
        }, false);
    }

    private native void notifyOpenFileCallback(JavaScriptObject var1, String var2, String var3, String var4, String var5);

    private static native void setupNativeHooks(FilesListPanel var0);

    public void populateFilesList(SolutionBrowserPerspective perspective, SolutionTree solutionTree, TreeItem item) {
        this.filesList.clear();
        ArrayList files = (ArrayList)item.getUserObject();
        Collections.sort(files, new Comparator<com.google.gwt.xml.client.Element>(){

            @Override
            public int compare(com.google.gwt.xml.client.Element o1, com.google.gwt.xml.client.Element o2) {
                String name1 = o1.getAttribute("localized-name");
                String name2 = o2.getAttribute("localized-name");
                return name1.compareTo(name2);
            }
        });
        if (files != null) {
            int rowCounter = 0;
            for (int i = 0; i < files.size(); ++i) {
                com.google.gwt.xml.client.Element fileElement = (com.google.gwt.xml.client.Element)files.get(i);
                if (!"false".equals(fileElement.getAttribute("isDirectory"))) continue;
                String name = fileElement.getAttribute("name");
                String solution = solutionTree.getSolution();
                String path = solutionTree.getPath();
                String lastModifiedDateStr = fileElement.getAttribute("lastModifiedDate");
                String url = fileElement.getAttribute("url");
                PluginOptionsHelper.ContentTypePlugin plugin = PluginOptionsHelper.getContentTypePlugin(name);
                String icon = null;
                if (plugin != null) {
                    icon = plugin.getFileIcon();
                }
                String localizedName = fileElement.getAttribute("localized-name");
                String description = fileElement.getAttribute("description");
                String tooltip = localizedName;
                if (solutionTree.isUseDescriptionsForTooltip() && !StringUtils.isEmpty((String)description)) {
                    tooltip = description;
                }
                FileItem fileLabel = new FileItem(name, localizedName, tooltip, solution, path, lastModifiedDateStr, url, this, PluginOptionsHelper.getEnabledOptions(name), this.toolbar.getSupportsACLs(), icon);
                fileLabel.getElement().setId("file-" + name);
                fileLabel.addFileSelectionChangedListener(this.toolbar);
                fileLabel.setWidth("100%");
                try {
                    perspective.getDragController().makeDraggable((Widget)fileLabel);
                }
                catch (Exception e) {
                    Throwable throwable = e;
                    String text = "Uncaught exception: ";
                    while (throwable != null) {
                        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
                        text = text + throwable.toString() + "\n";
                        for (int ii = 0; ii < stackTraceElements.length; ++ii) {
                            text = text + "    at " + stackTraceElements[ii] + "\n";
                        }
                        if ((throwable = throwable.getCause()) == null) continue;
                        text = text + "Caused by: ";
                    }
                    DialogBox dialogBox = new DialogBox(true);
                    DOM.setStyleAttribute((Element)dialogBox.getElement(), (String)"backgroundColor", (String)"#ABCDEF");
                    System.err.print(text);
                    text = text.replaceAll(" ", "&nbsp;");
                    dialogBox.setHTML("<pre>" + text + "</pre>");
                    dialogBox.center();
                }
                this.filesList.setWidget(rowCounter++, 0, (Widget)fileLabel);
                if (this.selectedFileItem != null && this.selectedFileItem.getFullPath().equals(fileLabel.getFullPath())) {
                    fileLabel.setStyleName("fileLabelSelected");
                    this.selectedFileItem = fileLabel;
                    continue;
                }
                fileLabel.setStyleName("fileLabel");
            }
        }
    }

    public void deselect() {
        for (int i = 0; i < this.filesList.getRowCount(); ++i) {
            FileItem item = (FileItem)this.filesList.getWidget(i, 0);
            item.setStyleName("fileLabel");
        }
    }

    public FileItem getSelectedFileItem() {
        return this.selectedFileItem;
    }

    public void setSelectedFileItem(FileItem fileItem) {
        this.selectedFileItem = fileItem;
    }

    public void selectNextItem(FileItem currentItem) {
        if (currentItem == null) {
            return;
        }
        int myIndex = -1;
        for (int i = 0; i < this.getFileCount(); ++i) {
            FileItem fileItem = this.getFileItem(i);
            if (fileItem != currentItem) continue;
            myIndex = i;
        }
        if (myIndex >= 0 && myIndex < this.getFileCount() - 1) {
            currentItem.setStyleName("fileLabel");
            FileItem nextItem = this.getFileItem(myIndex + 1);
            nextItem.setStyleName("fileLabelSelected");
            this.setSelectedFileItem(nextItem);
            nextItem.fireFileSelectionEvent();
        }
    }

    public void selectPreviousItem(FileItem currentItem) {
        if (currentItem == null) {
            return;
        }
        int myIndex = -1;
        for (int i = 0; i < this.getFileCount(); ++i) {
            FileItem fileItem = this.getFileItem(i);
            if (fileItem != currentItem) continue;
            myIndex = i;
        }
        if (myIndex > 0 && myIndex < this.getFileCount()) {
            currentItem.setStyleName("fileLabel");
            FileItem nextItem = this.getFileItem(myIndex - 1);
            nextItem.setStyleName("fileLabelSelected");
            this.setSelectedFileItem(nextItem);
            nextItem.fireFileSelectionEvent();
        }
    }

    public FileItem getFileItem(int index) {
        return (FileItem)this.filesList.getWidget(index, 0);
    }

    public int getFileCount() {
        return this.filesList.getRowCount();
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public IFileSummary getFileSummary() {
        return this.getSelectedFileItem();
    }
}

