/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.fileproperties;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.tabs.PentahoTabPanel;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.FileTypeEnabledOptions;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.GeneralPanel;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.IFileModifier;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.PermissionsPanel;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.SubscriptionsPanel;

public class FilePropertiesDialog
extends PromptDialogBox {
    private PentahoTabPanel propertyTabs;
    private GeneralPanel generalTab;
    private PermissionsPanel permissionsTab;
    private SubscriptionsPanel subscriptionsTab;
    private IFileSummary fileSummary;
    private FileTypeEnabledOptions options;
    private boolean isAdministrator = false;
    private Tabs defaultTab = Tabs.GENERAL;

    public FilePropertiesDialog(IFileSummary fileSummary, FileTypeEnabledOptions options, boolean isAdministrator, PentahoTabPanel propertyTabs, final IDialogCallback callback, Tabs defaultTab) {
        super(Messages.getString("properties"), Messages.getString("ok"), Messages.getString("cancel"), false, true);
        this.setContent((Widget)propertyTabs);
        this.generalTab = new GeneralPanel();
        this.permissionsTab = new PermissionsPanel();
        this.subscriptionsTab = new SubscriptionsPanel();
        this.generalTab.getElement().setId("filePropertiesGeneralTab");
        this.permissionsTab.getElement().setId("filePropertiesPermissionsTab");
        this.subscriptionsTab.getElement().setId("filePropertiesSubscriptionsTab");
        this.okButton.getElement().setId("filePropertiesOKButton");
        this.cancelButton.getElement().setId("filePropertiesCancelButton");
        this.defaultTab = defaultTab;
        super.setCallback(new IDialogCallback(){

            public void cancelPressed() {
                if (callback != null) {
                    callback.cancelPressed();
                }
            }

            public void okPressed() {
                FilePropertiesDialog.this.applyPanel();
                if (callback != null) {
                    callback.okPressed();
                }
            }
        });
        this.fileSummary = fileSummary;
        this.options = options;
        this.propertyTabs = propertyTabs;
        this.isAdministrator = isAdministrator;
        propertyTabs.addTab(Messages.getString("general"), Messages.getString("general"), false, (Widget)this.generalTab);
        this.fetchFileInfoAndInitTabs();
        this.getWidget().setHeight("100%");
        this.getWidget().setWidth("100%");
        this.setPixelSize(390, 420);
    }

    private void applyPanel() {
        for (int i = 0; i < this.propertyTabs.getTabCount(); ++i) {
            Widget w = this.propertyTabs.getTab(i).getContent();
            if (!(w instanceof IFileModifier)) continue;
            ((IFileModifier)w).apply();
        }
    }

    public void fetchFileInfoAndInitTabs() {
        AsyncCallback<SolutionFileInfo> callback = new AsyncCallback<SolutionFileInfo>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetFileProperties"), false, false, true);
                dialogBox.center();
            }

            public void onSuccess(SolutionFileInfo fileInfo) {
                if (FilePropertiesDialog.this.isAdministrator && !fileInfo.isDirectory() && FilePropertiesDialog.this.options != null && FilePropertiesDialog.this.options.isCommandEnabled(FileCommand.COMMAND.SCHEDULE_NEW)) {
                    FilePropertiesDialog.this.propertyTabs.addTab(Messages.getString("advanced"), Messages.getString("advanced"), false, (Widget)FilePropertiesDialog.this.subscriptionsTab);
                }
                if (fileInfo.supportsAccessControls && fileInfo.canEffectiveUserManage) {
                    FilePropertiesDialog.this.propertyTabs.addTab(Messages.getString("share"), Messages.getString("share"), false, (Widget)FilePropertiesDialog.this.permissionsTab);
                }
                for (int i = 0; i < FilePropertiesDialog.this.propertyTabs.getTabCount(); ++i) {
                    Widget w = FilePropertiesDialog.this.propertyTabs.getTab(i).getContent();
                    if (!(w instanceof IFileModifier)) continue;
                    ((IFileModifier)w).init(FilePropertiesDialog.this.fileSummary, fileInfo);
                }
                FilePropertiesDialog.this.showTab(FilePropertiesDialog.this.defaultTab);
            }
        };
        if ((this.fileSummary.getPath() == null || "".equals(this.fileSummary.getPath())) && this.fileSummary.getSolution().equals(this.fileSummary.getName())) {
            AbstractCommand getSolutionFileCmd = new AbstractCommand((AsyncCallback)callback){
                final /* synthetic */ AsyncCallback val$callback;
                {
                    this.val$callback = asyncCallback;
                }

                private void getFileInfo() {
                    MantleServiceCache.getService().getSolutionFileInfo(FilePropertiesDialog.this.fileSummary.getSolution(), "", "", (AsyncCallback<SolutionFileInfo>)this.val$callback);
                }

                protected void performOperation() {
                    this.getFileInfo();
                }

                protected void performOperation(boolean feedback) {
                    this.getFileInfo();
                }
            };
            getSolutionFileCmd.execute();
        } else {
            AbstractCommand getSolutionFileCmd = new AbstractCommand((AsyncCallback)callback){
                final /* synthetic */ AsyncCallback val$callback;
                {
                    this.val$callback = asyncCallback;
                }

                private void getFileInfo() {
                    MantleServiceCache.getService().getSolutionFileInfo(FilePropertiesDialog.this.fileSummary.getSolution(), FilePropertiesDialog.this.fileSummary.getPath(), FilePropertiesDialog.this.fileSummary.getName(), (AsyncCallback<SolutionFileInfo>)this.val$callback);
                }

                protected void performOperation() {
                    this.getFileInfo();
                }

                protected void performOperation(boolean feedback) {
                    this.getFileInfo();
                }
            };
            getSolutionFileCmd.execute();
        }
    }

    public void showTab(Tabs tab) {
        this.defaultTab = tab;
        if (tab == Tabs.GENERAL && this.propertyTabs.getWidgetIndex((Widget)this.generalTab) > -1) {
            this.propertyTabs.selectTab(this.propertyTabs.getWidgetIndex((Widget)this.generalTab));
        } else if (tab == Tabs.PERMISSION && this.propertyTabs.getWidgetIndex((Widget)this.permissionsTab) > -1) {
            this.propertyTabs.selectTab(this.propertyTabs.getWidgetIndex((Widget)this.permissionsTab));
        } else if (tab == Tabs.SUBSCRIBE && this.propertyTabs.getWidgetIndex((Widget)this.subscriptionsTab) > -1) {
            this.propertyTabs.selectTab(this.propertyTabs.getWidgetIndex((Widget)this.subscriptionsTab));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tabs {
        GENERAL,
        PERMISSION,
        SUBSCRIBE;

    }
}

