/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.fileproperties;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.IFileModifier;

public class GeneralPanel
extends FlexTable
implements IFileModifier {
    Label nameLabel = new Label();
    Label locationLabel = new Label();
    Label sourceLabel = new Label();
    Label typeLabel = new Label();
    Label sizeLabel = new Label();
    Label lastModifiedDateLabel = new Label();
    IFileSummary fileSummary;

    public GeneralPanel() {
        this.setWidget(0, 0, (Widget)new Label(Messages.getString("name") + ":"));
        this.setWidget(0, 1, (Widget)this.nameLabel);
        this.setWidget(1, 0, (Widget)new Label(Messages.getString("location") + ":"));
        this.setWidget(1, 1, (Widget)this.locationLabel);
        this.setWidget(2, 0, (Widget)new Label(Messages.getString("source") + ":"));
        this.setWidget(2, 1, (Widget)this.sourceLabel);
        this.setWidget(3, 0, (Widget)new Label(Messages.getString("type") + ":"));
        this.setWidget(3, 1, (Widget)this.typeLabel);
        this.setWidget(4, 0, (Widget)new Label(Messages.getString("size") + ":"));
        this.setWidget(4, 1, (Widget)this.sizeLabel);
        Label lbl = new Label(Messages.getString("lastModified") + ":");
        lbl.addStyleName("nowrap");
        this.setWidget(5, 0, (Widget)lbl);
        this.setWidget(5, 1, (Widget)this.lastModifiedDateLabel);
    }

    public void apply() {
    }

    public void init(IFileSummary file, SolutionFileInfo fileInfo) {
        this.fileSummary = file;
        if (fileInfo == null) {
            this.populateUIFromServer();
        } else {
            this.nameLabel.setText(fileInfo.localizedName);
            this.locationLabel.setText(fileInfo.solution + fileInfo.path);
            this.sourceLabel.setText(fileInfo.solution + fileInfo.path + "/" + fileInfo.name);
            this.typeLabel.setText(this.getFileTypeDescription(fileInfo.type, fileInfo.pluginTypeName));
            NumberFormat numberFormat = NumberFormat.getDecimalFormat();
            this.sizeLabel.setText(numberFormat.format((double)fileInfo.size / 1000.0) + " KB");
            this.lastModifiedDateLabel.setText(fileInfo.lastModifiedDate.toString());
        }
    }

    private String getFileTypeDescription(SolutionFileInfo.Type type, String pluginTypeName) {
        switch (type) {
            case FOLDER: {
                return Messages.getString("folder");
            }
            case ANALYSIS_VIEW: {
                return Messages.getString("analysisView");
            }
            case XACTION: {
                return Messages.getString("xaction");
            }
            case URL: {
                return "URL";
            }
            case REPORT: {
                return Messages.getString("report");
            }
            case PLUGIN: {
                return pluginTypeName;
            }
        }
        return "";
    }

    public void populateUIFromServer() {
        AbstractCommand getSolutionFileCmd = new AbstractCommand(){

            private void getFileInfo() {
                AsyncCallback<SolutionFileInfo> callback = new AsyncCallback<SolutionFileInfo>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetFileProperties"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(SolutionFileInfo fileInfo) {
                        GeneralPanel.this.init(GeneralPanel.this.fileSummary, fileInfo);
                    }
                };
                MantleServiceCache.getService().getSolutionFileInfo(GeneralPanel.this.fileSummary.getSolution(), GeneralPanel.this.fileSummary.getPath(), GeneralPanel.this.fileSummary.getName(), callback);
            }

            protected void performOperation() {
                this.getFileInfo();
            }

            protected void performOperation(boolean feedback) {
                this.getFileInfo();
            }
        };
        getSolutionFileCmd.execute();
    }
}

