/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.fileproperties;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.RolePermission;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.objects.UserPermission;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.IFileModifier;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.IUserRoleSelectedCallback;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.SelectUserOrRoleDialog;

public class PermissionsPanel
extends FlexTable
implements IFileModifier {
    public static final int PERM_ALL = -1;
    public static final int PERM_NOTHING = 0;
    public static final int PERM_EXECUTE = 1;
    public static final int PERM_SUBSCRIBE = 2;
    public static final int PERM_CREATE = 4;
    public static final int PERM_UPDATE = 8;
    public static final int PERM_DELETE = 16;
    public static final int PERM_UPDATE_PERMS = 32;
    private boolean dirty = false;
    ArrayList<String> existingUsersAndRoles = new ArrayList();
    IFileSummary fileSummary;
    SolutionFileInfo fileInfo;
    ListBox usersAndRolesList = new ListBox(false);
    Label permissionsLabel = new Label(Messages.getString("permissionsColon"));
    FlexTable permissionsTable = new FlexTable();
    Button removeButton = new Button(Messages.getString("remove"));
    Button addButton = new Button(Messages.getString("addPeriods"));

    public PermissionsPanel() {
        this.removeButton.setStylePrimaryName("pentaho-button");
        this.addButton.setStylePrimaryName("pentaho-button");
        this.usersAndRolesList.getElement().setId("sharePanelUsersAndRolesList");
        this.addButton.getElement().setId("sharePanelAddButton");
        this.removeButton.getElement().setId("sharePanelRemoveButton");
        this.removeButton.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                if (PermissionsPanel.this.usersAndRolesList.getItemCount() == 0) {
                    return;
                }
                PermissionsPanel.this.dirty = true;
                String userOrRoleString = PermissionsPanel.this.usersAndRolesList.getValue(PermissionsPanel.this.usersAndRolesList.getSelectedIndex());
                for (UserPermission userPermission : PermissionsPanel.this.fileInfo.userPermissions) {
                    if (!userOrRoleString.equals(userPermission.name)) continue;
                    PermissionsPanel.this.existingUsersAndRoles.remove(userPermission.name);
                    PermissionsPanel.this.fileInfo.userPermissions.remove(userPermission);
                    break;
                }
                for (RolePermission rolePermission : PermissionsPanel.this.fileInfo.rolePermissions) {
                    if (!userOrRoleString.equals(rolePermission.name)) continue;
                    PermissionsPanel.this.existingUsersAndRoles.remove(rolePermission.name);
                    PermissionsPanel.this.fileInfo.rolePermissions.remove(rolePermission);
                    break;
                }
                PermissionsPanel.this.usersAndRolesList.removeItem(PermissionsPanel.this.usersAndRolesList.getSelectedIndex());
            }
        });
        this.addButton.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.dirty = true;
                SelectUserOrRoleDialog pickUserRoleDialog = new SelectUserOrRoleDialog(PermissionsPanel.this.existingUsersAndRoles, new IUserRoleSelectedCallback(){

                    public void roleSelected(String role) {
                        PermissionsPanel.this.fileInfo.rolePermissions.add(new RolePermission(role, 0));
                        PermissionsPanel.this.usersAndRolesList.addItem(role + Messages.getString("role", role), role);
                        PermissionsPanel.this.existingUsersAndRoles.add(role);
                        PermissionsPanel.this.usersAndRolesList.setSelectedIndex(PermissionsPanel.this.usersAndRolesList.getItemCount() - 1);
                        PermissionsPanel.this.buildPermissionsTable();
                    }

                    public void userSelected(String user) {
                        PermissionsPanel.this.fileInfo.userPermissions.add(new UserPermission(user, 0));
                        PermissionsPanel.this.usersAndRolesList.addItem(Messages.getString("user", user), user);
                        PermissionsPanel.this.existingUsersAndRoles.add(user);
                        PermissionsPanel.this.usersAndRolesList.setSelectedIndex(PermissionsPanel.this.usersAndRolesList.getItemCount() - 1);
                        PermissionsPanel.this.buildPermissionsTable();
                    }
                });
                pickUserRoleDialog.center();
            }
        });
        FlowPanel buttonPanel = new FlowPanel();
        buttonPanel.add((Widget)this.addButton);
        buttonPanel.add((Widget)this.removeButton);
        this.usersAndRolesList.setVisibleItemCount(7);
        this.usersAndRolesList.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.buildPermissionsTable();
            }
        });
        this.usersAndRolesList.setWidth("100%");
        buttonPanel.setWidth("100%");
        this.permissionsTable.setStyleName("permissionsTable");
        this.permissionsTable.setWidth("100%");
        this.permissionsTable.setHeight("100%");
        int row = 0;
        this.setWidget(row++, 0, (Widget)new Label(Messages.getString("usersAndRoles")));
        this.setWidget(row++, 0, (Widget)this.usersAndRolesList);
        this.setWidget(row++, 0, (Widget)buttonPanel);
        this.setWidget(row++, 0, (Widget)this.permissionsLabel);
        this.setWidget(row++, 0, (Widget)this.permissionsTable);
        this.setWidth("100%");
    }

    public void buildPermissionsTable() {
        String userOrRoleString = "";
        this.permissionsTable.clear();
        if (this.usersAndRolesList.getItemCount() == 0) {
            this.permissionsLabel.setText(Messages.getString("permissionsColon"));
        } else {
            userOrRoleString = this.usersAndRolesList.getValue(this.usersAndRolesList.getSelectedIndex());
            this.permissionsLabel.setText(Messages.getString("permissionsFor", userOrRoleString));
        }
        int mask = 0;
        for (UserPermission userPermission : this.fileInfo.userPermissions) {
            if (!userOrRoleString.equals(userPermission.name)) continue;
            mask = userPermission.mask;
            break;
        }
        for (RolePermission rolePermission : this.fileInfo.rolePermissions) {
            if (!userOrRoleString.equals(rolePermission.name)) continue;
            mask = rolePermission.mask;
            break;
        }
        final CheckBox allPermissionCheckBox = new CheckBox(Messages.getString("allPermissions"));
        final CheckBox createPermissionCheckBox = new CheckBox(Messages.getString("create"));
        final CheckBox updatePermissionCheckBox = new CheckBox(Messages.getString("update"));
        final CheckBox executePermissionCheckBox = new CheckBox(Messages.getString("execute"));
        final CheckBox deletePermissionCheckBox = new CheckBox(Messages.getString("delete"));
        final CheckBox grantPermissionCheckBox = new CheckBox(Messages.getString("grantPermissions"));
        final CheckBox subscribePermissionCheckBox = new CheckBox(Messages.getString("schedule"));
        allPermissionCheckBox.getElement().setId("sharePermissionAll");
        createPermissionCheckBox.getElement().setId("sharePermissionCreate");
        updatePermissionCheckBox.getElement().setId("sharePermissionUpdate");
        executePermissionCheckBox.getElement().setId("sharePermissionExecute");
        deletePermissionCheckBox.getElement().setId("sharePermissionDelete");
        grantPermissionCheckBox.getElement().setId("sharePermissionGrant");
        subscribePermissionCheckBox.getElement().setId("sharePermissionSubscribe");
        if ("".equals(userOrRoleString)) {
            allPermissionCheckBox.setEnabled(false);
            createPermissionCheckBox.setEnabled(false);
            updatePermissionCheckBox.setEnabled(false);
            executePermissionCheckBox.setEnabled(false);
            deletePermissionCheckBox.setEnabled(false);
            grantPermissionCheckBox.setEnabled(false);
            subscribePermissionCheckBox.setEnabled(false);
        }
        if ((mask & 0xFFFFFFFF) == -1) {
            allPermissionCheckBox.setChecked(true);
            createPermissionCheckBox.setEnabled(false);
            updatePermissionCheckBox.setEnabled(false);
            executePermissionCheckBox.setEnabled(false);
            deletePermissionCheckBox.setEnabled(false);
            grantPermissionCheckBox.setEnabled(false);
            subscribePermissionCheckBox.setEnabled(false);
        }
        createPermissionCheckBox.setChecked((mask & 4) == 4);
        updatePermissionCheckBox.setChecked((mask & 8) == 8);
        executePermissionCheckBox.setChecked((mask & 1) == 1);
        deletePermissionCheckBox.setChecked((mask & 0x10) == 16);
        grantPermissionCheckBox.setChecked((mask & 0x20) == 32);
        subscribePermissionCheckBox.setChecked((mask & 2) == 2);
        allPermissionCheckBox.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.updatePermissionMask(allPermissionCheckBox.isChecked(), -1);
                createPermissionCheckBox.setChecked(allPermissionCheckBox.isChecked());
                updatePermissionCheckBox.setChecked(allPermissionCheckBox.isChecked());
                executePermissionCheckBox.setChecked(allPermissionCheckBox.isChecked());
                deletePermissionCheckBox.setChecked(allPermissionCheckBox.isChecked());
                grantPermissionCheckBox.setChecked(allPermissionCheckBox.isChecked());
                subscribePermissionCheckBox.setChecked(allPermissionCheckBox.isChecked());
                createPermissionCheckBox.setEnabled(!allPermissionCheckBox.isChecked());
                updatePermissionCheckBox.setEnabled(!allPermissionCheckBox.isChecked());
                executePermissionCheckBox.setEnabled(!allPermissionCheckBox.isChecked());
                deletePermissionCheckBox.setEnabled(!allPermissionCheckBox.isChecked());
                grantPermissionCheckBox.setEnabled(!allPermissionCheckBox.isChecked());
                subscribePermissionCheckBox.setEnabled(!allPermissionCheckBox.isChecked());
            }
        });
        createPermissionCheckBox.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.updatePermissionMask(createPermissionCheckBox.isChecked(), 4);
            }
        });
        updatePermissionCheckBox.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.updatePermissionMask(updatePermissionCheckBox.isChecked(), 8);
            }
        });
        executePermissionCheckBox.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.updatePermissionMask(executePermissionCheckBox.isChecked(), 1);
            }
        });
        deletePermissionCheckBox.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.updatePermissionMask(deletePermissionCheckBox.isChecked(), 16);
            }
        });
        grantPermissionCheckBox.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.updatePermissionMask(grantPermissionCheckBox.isChecked(), 32);
            }
        });
        subscribePermissionCheckBox.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PermissionsPanel.this.updatePermissionMask(subscribePermissionCheckBox.isChecked(), 2);
            }
        });
        this.permissionsTable.setWidget(0, 0, (Widget)allPermissionCheckBox);
        this.permissionsTable.setWidget(1, 0, (Widget)createPermissionCheckBox);
        this.permissionsTable.setWidget(2, 0, (Widget)updatePermissionCheckBox);
        this.permissionsTable.setWidget(3, 0, (Widget)executePermissionCheckBox);
        this.permissionsTable.setWidget(4, 0, (Widget)deletePermissionCheckBox);
        this.permissionsTable.setWidget(5, 0, (Widget)grantPermissionCheckBox);
        this.permissionsTable.setWidget(6, 0, (Widget)subscribePermissionCheckBox);
    }

    public void updatePermissionMask(boolean grant, int mask) {
        if (this.usersAndRolesList.getSelectedIndex() >= 0) {
            this.dirty = true;
            String userOrRoleString = this.usersAndRolesList.getValue(this.usersAndRolesList.getSelectedIndex());
            for (UserPermission userPermission : this.fileInfo.userPermissions) {
                if (!userOrRoleString.equals(userPermission.name)) continue;
                if (grant) {
                    userPermission.mask |= mask;
                    break;
                }
                userPermission.mask &= ~mask;
                break;
            }
            for (RolePermission rolePermission : this.fileInfo.rolePermissions) {
                if (!userOrRoleString.equals(rolePermission.name)) continue;
                if (grant) {
                    rolePermission.mask |= mask;
                    break;
                }
                rolePermission.mask &= ~mask;
                break;
            }
        }
    }

    public void apply() {
        if (!this.dirty) {
            return;
        }
        AsyncCallback<Void> callback = new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), caught.toString(), false, false, true);
                dialogBox.center();
            }

            public void onSuccess(Void nothing) {
                PermissionsPanel.this.dirty = false;
            }
        };
        MantleServiceCache.getService().setSolutionFileInfo(this.fileInfo, callback);
    }

    public void init(IFileSummary fileSummary, SolutionFileInfo fileInfo) {
        this.fileSummary = fileSummary;
        this.fileInfo = fileInfo;
        this.usersAndRolesList.clear();
        this.existingUsersAndRoles.clear();
        for (UserPermission userPermission : fileInfo.userPermissions) {
            this.usersAndRolesList.addItem(Messages.getString("user", userPermission.name), userPermission.name);
            this.existingUsersAndRoles.add(userPermission.name);
        }
        for (RolePermission rolePermission : fileInfo.rolePermissions) {
            this.usersAndRolesList.addItem(Messages.getString("role", rolePermission.name), rolePermission.name);
            this.existingUsersAndRoles.add(rolePermission.name);
        }
        if (this.usersAndRolesList.getItemCount() > 0) {
            this.usersAndRolesList.setSelectedIndex(0);
        }
        this.buildPermissionsTable();
    }
}

