/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.fileproperties;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.IUserRoleSelectedCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectUserOrRoleDialog
extends PromptDialogBox {
    private static FlexTable contentTable = new FlexTable();
    private static ListBox usersListBox = new ListBox(false);
    private static ListBox rolesListBox = new ListBox(false);

    public SelectUserOrRoleDialog(ArrayList<String> existing, final IUserRoleSelectedCallback callback) {
        super(Messages.getString("selectUserOrRole"), Messages.getString("ok"), Messages.getString("cancel"), false, true, (Widget)contentTable);
        this.setCallback(new IDialogCallback(){

            public void cancelPressed() {
            }

            public void okPressed() {
                if (SelectUserOrRoleDialog.getSelectedUser() != null) {
                    callback.userSelected(SelectUserOrRoleDialog.getSelectedUser());
                } else {
                    callback.roleSelected(SelectUserOrRoleDialog.getSelectedRole());
                }
            }
        });
        contentTable.getElement().setId("userOrRoleDialogContentTable");
        usersListBox.getElement().setId("userOrRoleDialogUsersList");
        rolesListBox.getElement().setId("userOrRoleDialogRolesList");
        this.okButton.getElement().setId("userOrRoleDialogOkButton");
        this.cancelButton.getElement().setId("userOrRoleDialogCancelButton");
        usersListBox.setVisibleItemCount(5);
        rolesListBox.setVisibleItemCount(5);
        rolesListBox.setWidth("100%");
        usersListBox.setWidth("100%");
        contentTable.clear();
        contentTable.setWidth("100%");
        contentTable.setWidget(0, 0, (Widget)new Label(Messages.getString("users")));
        contentTable.setWidget(1, 0, (Widget)usersListBox);
        contentTable.setWidget(2, 0, (Widget)new Label(Messages.getString("roles")));
        contentTable.setWidget(3, 0, (Widget)rolesListBox);
        this.fetchAllUsers(existing);
        this.fetchAllRoles(existing);
        this.setWidth("200px");
    }

    public void fetchAllRoles(final ArrayList<String> existing) {
        AsyncCallback<ArrayList<String>> callback = new AsyncCallback<ArrayList<String>>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetRoles"), false, false, true);
                dialogBox.center();
            }

            public void onSuccess(ArrayList<String> roles) {
                rolesListBox.clear();
                for (String role : roles) {
                    if (existing.contains(role)) continue;
                    rolesListBox.addItem(role);
                }
            }
        };
        MantleServiceCache.getService().getAllRoles(callback);
    }

    public void fetchAllUsers(final ArrayList<String> existing) {
        AsyncCallback<ArrayList<String>> callback = new AsyncCallback<ArrayList<String>>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetUsers"), false, false, true);
                dialogBox.center();
            }

            public void onSuccess(ArrayList<String> users) {
                usersListBox.clear();
                for (String user : users) {
                    if (existing.contains(user)) continue;
                    usersListBox.addItem(user);
                }
            }
        };
        MantleServiceCache.getService().getAllUsers(callback);
    }

    public static String getSelectedUser() {
        if (usersListBox.getSelectedIndex() >= 0) {
            return usersListBox.getItemText(usersListBox.getSelectedIndex());
        }
        return null;
    }

    public static String getSelectedRole() {
        if (rolesListBox.getSelectedIndex() >= 0) {
            return rolesListBox.getItemText(rolesListBox.getSelectedIndex());
        }
        return null;
    }

    static {
        usersListBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                rolesListBox.setSelectedIndex(-1);
            }
        });
        rolesListBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                usersListBox.setSelectedIndex(-1);
            }
        });
    }
}

