/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.fileproperties;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.objects.SubscriptionSchedule;
import org.pentaho.mantle.client.objects.SubscriptionState;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.fileproperties.IFileModifier;

public class SubscriptionsPanel
extends VerticalPanel
implements IFileModifier {
    private boolean dirty = false;
    private boolean wasEnabled = false;
    private CheckBox enableSubscriptions = new CheckBox(Messages.getString("enableSubscription"));
    private ListBox availableLB = new ListBox(true);
    private ListBox appliedLB = new ListBox(true);
    private Button moveRightBtn = new Button();
    private Button moveLeftBtn = new Button();
    private Button moveAllRightBtn = new Button();
    private Button moveAllLeftBtn = new Button();
    private IFileSummary fileSummary = null;

    public SubscriptionsPanel() {
        this.layout();
        this.dirty = false;
        this.moveRightBtn.setStylePrimaryName("pentaho-button");
        this.moveLeftBtn.setStylePrimaryName("pentaho-button");
        this.moveAllRightBtn.setStylePrimaryName("pentaho-button");
        this.moveAllLeftBtn.setStylePrimaryName("pentaho-button");
        this.enableSubscriptions.getElement().setId("subscriptionPanelEnableCheck");
        this.availableLB.getElement().setId("subscriptionPanelAvailableList");
        this.appliedLB.getElement().setId("subscriptionPanelAppliedList");
        this.moveRightBtn.getElement().setId("subscriptionPanelMoveRightButton");
        this.moveLeftBtn.getElement().setId("subscriptionPanelMoveLeftButton");
        this.moveAllRightBtn.getElement().setId("subscriptionPanelMoveAllRightButton");
        this.moveAllLeftBtn.getElement().setId("subscriptionPanelMoveAllLeftButton");
    }

    public void layout() {
        this.setSize("100%", "100%");
        this.enableSubscriptions.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubscriptionsPanel.this.dirty = true;
                SubscriptionsPanel.this.updateControls();
            }
        });
        this.add((Widget)this.enableSubscriptions);
        this.setSpacing(10);
        CaptionPanel scheduleCaptionPanel = new CaptionPanel(Messages.getString("schedule"));
        FlexTable schedulePanel = new FlexTable();
        schedulePanel.setSize("100%", "100%");
        VerticalPanel availablePanel = new VerticalPanel();
        availablePanel.add((Widget)new Label(Messages.getString("available")));
        availablePanel.add((Widget)this.availableLB);
        this.availableLB.setVisibleItemCount(9);
        this.availableLB.setWidth("100%");
        VerticalPanel appliedPanel = new VerticalPanel();
        appliedPanel.add((Widget)new Label(Messages.getString("current")));
        appliedPanel.add((Widget)this.appliedLB);
        this.appliedLB.setVisibleItemCount(9);
        this.appliedLB.setWidth("100%");
        VerticalPanel buttonGrid = new VerticalPanel();
        buttonGrid.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        buttonGrid.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        buttonGrid.setSpacing(2);
        this.moveRightBtn.setText(">");
        this.moveRightBtn.setTitle(Messages.getString("add"));
        this.moveRightBtn.setWidth("30px");
        this.moveRightBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubscriptionsPanel.this.moveSelectedToRight();
            }
        });
        buttonGrid.add((Widget)this.moveRightBtn);
        this.moveAllRightBtn.setText(">>");
        this.moveAllRightBtn.setTitle(Messages.getString("addAll"));
        this.moveAllRightBtn.setWidth("30px");
        this.moveAllRightBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubscriptionsPanel.this.moveAllToRight();
            }
        });
        buttonGrid.add((Widget)this.moveAllRightBtn);
        this.moveLeftBtn.setText("<");
        this.moveLeftBtn.setTitle(Messages.getString("remove"));
        this.moveLeftBtn.setWidth("30px");
        this.moveLeftBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubscriptionsPanel.this.moveSelectedToLeft();
            }
        });
        buttonGrid.add((Widget)this.moveLeftBtn);
        this.moveAllLeftBtn.setText("<<");
        this.moveAllLeftBtn.setTitle(Messages.getString("removeAll"));
        this.moveAllLeftBtn.setWidth("30px");
        this.moveAllLeftBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubscriptionsPanel.this.moveAllToLeft();
            }
        });
        buttonGrid.add((Widget)this.moveAllLeftBtn);
        schedulePanel.setWidget(0, 0, (Widget)availablePanel);
        schedulePanel.setWidget(0, 1, (Widget)buttonGrid);
        schedulePanel.setWidget(0, 2, (Widget)appliedPanel);
        scheduleCaptionPanel.add((Widget)schedulePanel);
        this.add((Widget)scheduleCaptionPanel);
        this.setCellHorizontalAlignment((Widget)schedulePanel, HasHorizontalAlignment.ALIGN_CENTER);
        availablePanel.setWidth("100%");
        buttonGrid.setWidth("100%");
        appliedPanel.setWidth("100%");
        schedulePanel.getCellFormatter().setWidth(0, 0, "50%");
        schedulePanel.getCellFormatter().setWidth(0, 2, "50%");
    }

    protected void moveSelectedToRight() {
        this.moveItems(this.availableLB, this.appliedLB, false);
    }

    protected void moveAllToRight() {
        this.moveItems(this.availableLB, this.appliedLB, true);
    }

    protected void moveSelectedToLeft() {
        this.moveItems(this.appliedLB, this.availableLB, false);
    }

    protected void moveAllToLeft() {
        this.moveItems(this.appliedLB, this.availableLB, true);
    }

    protected void moveItems(ListBox srcLB, ListBox destLB, boolean moveAll) {
        this.dirty = true;
        int itemCount = srcLB.getItemCount();
        int srcSelectionIndex = srcLB.getSelectedIndex();
        this.deselectAll(destLB);
        for (int i = 0; i < itemCount; ++i) {
            if (!moveAll && !srcLB.isItemSelected(i)) continue;
            String value = srcLB.getValue(i);
            String name = srcLB.getItemText(i);
            destLB.addItem(name, value);
            destLB.setItemSelected(destLB.getItemCount() - 1, true);
        }
        this.removeItems(srcLB, moveAll);
        if (srcLB.getItemCount() > 0) {
            if (srcLB.getItemCount() - 1 < srcSelectionIndex) {
                srcLB.setSelectedIndex(srcLB.getItemCount() - 1);
            } else {
                srcLB.setSelectedIndex(srcSelectionIndex);
            }
        }
    }

    private void removeItems(ListBox targetListBox, boolean removeAll) {
        int itemCount = targetListBox.getItemCount();
        for (int i = itemCount - 1; i >= 0; --i) {
            if (!removeAll && !targetListBox.isItemSelected(i)) continue;
            targetListBox.removeItem(i);
        }
    }

    private void deselectAll(ListBox targetListBox) {
        for (int i = 0; i < targetListBox.getItemCount(); ++i) {
            targetListBox.setItemSelected(i, false);
        }
    }

    public void apply() {
        if (this.dirty && (this.wasEnabled && !this.enableSubscriptions.getValue().booleanValue() && Window.confirm((String)Messages.getString("appliedSchedulesWillBeLost")) || !this.wasEnabled)) {
            AsyncCallback<Void> callback = new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), caught.toString(), false, false, true);
                    dialogBox.center();
                }

                public void onSuccess(Void nothing) {
                    SubscriptionsPanel.this.dirty = false;
                }
            };
            ArrayList<SubscriptionSchedule> currentSchedules = new ArrayList<SubscriptionSchedule>();
            for (int i = 0; i < this.appliedLB.getItemCount(); ++i) {
                SubscriptionSchedule subSchedule = new SubscriptionSchedule();
                subSchedule.title = this.appliedLB.getItemText(i);
                subSchedule.id = this.appliedLB.getValue(i);
                currentSchedules.add(subSchedule);
            }
            MantleServiceCache.getService().setSubscriptions(this.fileSummary.getSolution(), this.fileSummary.getPath(), this.fileSummary.getName(), this.enableSubscriptions.isChecked(), currentSchedules, callback);
        }
    }

    public void init(IFileSummary fileSummary, SolutionFileInfo fileInfo) {
        this.fileSummary = fileSummary;
        this.updateState();
        this.wasEnabled = this.enableSubscriptions.getValue();
    }

    protected void updateControls() {
        this.availableLB.setEnabled(this.enableSubscriptions.getValue().booleanValue());
        this.appliedLB.setEnabled(this.enableSubscriptions.getValue().booleanValue());
        this.moveAllLeftBtn.setEnabled(this.enableSubscriptions.getValue().booleanValue());
        this.moveAllRightBtn.setEnabled(this.enableSubscriptions.getValue().booleanValue());
        this.moveLeftBtn.setEnabled(this.enableSubscriptions.getValue().booleanValue());
        this.moveRightBtn.setEnabled(this.enableSubscriptions.getValue().booleanValue());
    }

    private void updateState() {
        AsyncCallback<SubscriptionState> callBack = new AsyncCallback<SubscriptionState>(){

            public void onSuccess(SubscriptionState state) {
                SubscriptionsPanel.this.enableSubscriptions.setValue(state.subscriptionsEnabled);
                for (SubscriptionSchedule schedule : state.availableSchedules) {
                    SubscriptionsPanel.this.availableLB.addItem(schedule.title, schedule.id);
                }
                for (SubscriptionSchedule schedule : state.appliedSchedules) {
                    SubscriptionsPanel.this.appliedLB.addItem(schedule.title, schedule.id);
                }
                SubscriptionsPanel.this.updateControls();
            }

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), caught.toString(), false, false, true);
                dialogBox.center();
            }
        };
        MantleServiceCache.getService().getSubscriptionState(this.fileSummary.getSolution(), this.fileSummary.getPath(), this.fileSummary.getName(), callBack);
    }
}

