/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.scheduling;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Date;
import org.pentaho.gwt.widgets.client.controls.schededitor.ScheduleEditor;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.wizards.AbstractWizardDialog;
import org.pentaho.gwt.widgets.client.wizards.IWizardPanel;
import org.pentaho.gwt.widgets.client.wizards.panels.ScheduleEditorWizardPanel;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;

public class NewScheduleDialog
extends AbstractWizardDialog {
    FileItem fileItem = null;
    ScheduleEditorWizardPanel scheduleEditorWizardPanel = new ScheduleEditorWizardPanel();
    String solutionName;
    String path;
    String actionName;
    Boolean done = false;

    public NewScheduleDialog(String solutionName, String path, String actionName) {
        super(Messages.getString("newSchedule"), null, false, true);
        this.solutionName = solutionName;
        this.path = path;
        this.actionName = actionName;
        IWizardPanel[] wizardPanels = new IWizardPanel[]{this.scheduleEditorWizardPanel};
        this.setWizardPanels(wizardPanels);
        this.setPixelSize(475, 465);
    }

    protected boolean onFinish() {
        AsyncCallback scheduleCallback = new AsyncCallback(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), caught.toString(), false, false, true);
                dialogBox.center();
                NewScheduleDialog.this.setDone(false);
            }

            public void onSuccess(Object result) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("actionSequenceScheduledSuccess"), true, false, true);
                dialogBox.center();
                NewScheduleDialog.this.setDone(true);
                NewScheduleDialog.this.hide();
            }
        };
        ScheduleEditor.ScheduleType scheduleType = this.scheduleEditorWizardPanel.getScheduleType();
        String triggerName = this.scheduleEditorWizardPanel.getTriggerName();
        String triggerGroup = this.scheduleEditorWizardPanel.getTriggerGroup();
        String description = this.scheduleEditorWizardPanel.getDescription();
        String cronExpression = this.scheduleEditorWizardPanel.getCronString();
        Date startDate = this.scheduleEditorWizardPanel.getStartDate();
        Date endDate = this.scheduleEditorWizardPanel.getEndDate();
        String startTime = this.scheduleEditorWizardPanel.getStartTime();
        int startHour = this.getStartHour(startTime);
        int startMin = this.getStartMin(startTime);
        int startYear = startDate.getYear();
        int startMonth = startDate.getMonth();
        int startDay = startDate.getDate();
        Date startDateTime = new Date(startYear, startMonth, startDay, startHour, startMin);
        int repeatCount = this.scheduleEditorWizardPanel.getRepeatCount();
        int repeatInterval = 0;
        try {
            repeatInterval = Integer.parseInt(this.scheduleEditorWizardPanel.getRepeatInterval()) * 1000;
        }
        catch (Exception e) {
            repeatInterval = 0;
        }
        if (scheduleType == ScheduleEditor.ScheduleType.RUN_ONCE) {
            MantleServiceCache.getService().createSimpleTriggerJob(triggerName, triggerGroup, description, startDateTime, null, 0, 0, this.solutionName, this.path, this.actionName, (AsyncCallback<Void>)scheduleCallback);
        } else if (cronExpression == null) {
            MantleServiceCache.getService().createSimpleTriggerJob(triggerName, triggerGroup, description, startDateTime, endDate, repeatCount, repeatInterval, this.solutionName, this.path, this.actionName, (AsyncCallback<Void>)scheduleCallback);
        } else {
            MantleServiceCache.getService().createCronJob(this.solutionName, this.path, this.actionName, triggerName, triggerGroup, description, cronExpression, (AsyncCallback<Void>)scheduleCallback);
        }
        return this.getDone();
    }

    private int getStartMin(String startTime) {
        if (startTime == null || startTime.length() < 1) {
            return 0;
        }
        int firstSeparator = startTime.indexOf(58);
        int secondSeperator = startTime.indexOf(58, firstSeparator + 1);
        int min = Integer.parseInt(startTime.substring(firstSeparator + 1, secondSeperator));
        return min;
    }

    private int getStartHour(String startTime) {
        if (startTime == null || startTime.length() < 1) {
            return 0;
        }
        int afternoonOffset = startTime.endsWith("PM") ? 12 : 0;
        int hour = Integer.parseInt(startTime.substring(0, startTime.indexOf(58)));
        return hour += afternoonOffset;
    }

    public Boolean getDone() {
        return this.done;
    }

    public void setDone(Boolean done) {
        this.done = done;
    }

    protected boolean onNext(IWizardPanel nextPanel, IWizardPanel previousPanel) {
        return true;
    }

    protected boolean onPrevious(IWizardPanel previousPanel, IWizardPanel currentPanel) {
        return true;
    }

    public void center() {
        super.center();
        this.scheduleEditorWizardPanel.setFocus();
    }
}

