/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.scheduling;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.PluginOptionsHelper;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.scheduling.NewScheduleDialog;
import org.pentaho.mantle.login.client.MantleLoginDialog;

public class ScheduleHelper {
    private static native void setupNativeHooks(ScheduleHelper var0);

    private static void showScheduleDialog(final SolutionFileInfo fileInfo, final FileItem selectedFileItem) {
        AsyncCallback callback = new AsyncCallback(){

            public void onSuccess(Object result) {
                AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetFileProperties"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(Boolean subscribable) {
                        if (subscribable.booleanValue()) {
                            NewScheduleDialog dialog = new NewScheduleDialog(fileInfo.getSolution(), fileInfo.getPath(), fileInfo.getName());
                            dialog.center();
                        } else {
                            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("noSchedulePermission"), false, false, true);
                            dialogBox.center();
                        }
                    }
                };
                MantleServiceCache.getService().hasAccess(selectedFileItem.getSolution(), selectedFileItem.getPath(), selectedFileItem.getName(), 3, callback);
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        ScheduleHelper.showScheduleDialog(fileInfo, selectedFileItem);
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated((AsyncCallback<Boolean>)callback);
    }

    public static void createSchedule(final FileItem selectedFileItem) {
        AbstractCommand scheduleCommand = new AbstractCommand(){

            private void schedule() {
                AsyncCallback<SolutionFileInfo> callback = new AsyncCallback<SolutionFileInfo>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), caught.toString(), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(SolutionFileInfo fileInfo) {
                        if (fileInfo.isSubscribable) {
                            if (fileInfo.getType().equals((Object)SolutionFileInfo.Type.PLUGIN)) {
                                PluginOptionsHelper.ContentTypePlugin plugin = PluginOptionsHelper.getContentTypePlugin(fileInfo.getName());
                                String url = plugin.getCommandUrl(selectedFileItem, FileCommand.COMMAND.SCHEDULE_NEW);
                                String displayName = fileInfo.getLocalizedName();
                                if (displayName == null || displayName.length() < 1) {
                                    displayName = fileInfo.getName();
                                }
                                SolutionBrowserPerspective.getInstance().getContentTabPanel().showNewURLTab(displayName, displayName, url, false);
                            } else {
                                SolutionBrowserPerspective.getInstance().executeActionSequence(FileCommand.COMMAND.SUBSCRIBE);
                            }
                        } else if (fileInfo.getType().equals((Object)SolutionFileInfo.Type.PLUGIN)) {
                            PluginOptionsHelper.ContentTypePlugin plugin = PluginOptionsHelper.getContentTypePlugin(fileInfo.getName());
                            String url = plugin.getCommandUrl(selectedFileItem, FileCommand.COMMAND.SCHEDULE_NEW);
                            if (StringUtils.isEmpty((String)url)) {
                                final MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("open"), Messages.getString("scheduleInvalidFileType", selectedFileItem.getName()), false, false, true);
                                dialogBox.setCallback(new IDialogCallback(){

                                    public void cancelPressed() {
                                    }

                                    public void okPressed() {
                                        dialogBox.hide();
                                    }
                                });
                                dialogBox.center();
                                return;
                            }
                            ScheduleHelper.showScheduleDialog(fileInfo, selectedFileItem);
                        } else {
                            ScheduleHelper.showScheduleDialog(fileInfo, selectedFileItem);
                        }
                    }
                };
                MantleServiceCache.getService().getSolutionFileInfo(selectedFileItem.getSolution(), selectedFileItem.getPath(), selectedFileItem.getName(), callback);
            }

            protected void performOperation() {
                this.schedule();
            }

            protected void performOperation(boolean feedback) {
                this.schedule();
            }
        };
        scheduleCommand.execute();
    }

    private static void runInBackground(String url) {
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, url);
        try {
            builder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotBackgroundExecute"), false, false, true);
                    dialogBox.center();
                }

                public void onResponseReceived(Request request, Response response) {
                    if ("true".equals(response.getHeader("background_execution"))) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("backgroundJobScheduled"), false, false, true);
                        dialogBox.center();
                    }
                }
            });
        }
        catch (RequestException e) {
            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotBackgroundExecute"), false, false, true);
            dialogBox.center();
        }
    }

    public static void confirmBackgroundExecutionDialog(final String url) {
        String title = Messages.getString("confirm");
        String message = Messages.getString("userParamBackgroundWarning");
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)new Label(Messages.getString(message)));
        final PromptDialogBox scheduleInBackground = new PromptDialogBox(title, Messages.getString("yes"), Messages.getString("no"), false, true, (Widget)vp);
        IDialogCallback callback = new IDialogCallback(){

            public void cancelPressed() {
                scheduleInBackground.hide();
            }

            public void okPressed() {
                ScheduleHelper.runInBackground(url);
            }
        };
        scheduleInBackground.setCallback(callback);
        scheduleInBackground.center();
    }

    static {
        ScheduleHelper.setupNativeHooks(new ScheduleHelper());
    }
}

