/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.tabs;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import java.util.Stack;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFrameTabPanel
extends VerticalPanel {
    private String url;
    private String name;
    private CustomFrame frame;
    private SolutionFileInfo fileInfo;
    private FormPanel form;
    private boolean saveEnabled;
    private boolean editContentEnabled;
    private boolean editContentSelected;
    private boolean printVisible;
    protected JavaScriptObject jsCallback;
    private Set<String> overlayIds;

    public IFrameTabPanel() {
        this.name = "" + System.currentTimeMillis();
        this.frame = new CustomFrame(this.name, "about:blank");
        this.add((Widget)this.frame);
    }

    public IFrameTabPanel(String name) {
        this.name = name;
        this.frame = new CustomFrame(name);
        this.frame.getElement().setAttribute("id", name + System.currentTimeMillis());
        this.frame.setWidth("100%");
        this.frame.setHeight("100%");
        this.add((Widget)this.frame);
    }

    public void reload() {
        if (this.form != null) {
            this.form.submit();
        } else {
            this.reloadFrame((Element)this.frame.getElement());
        }
    }

    public native void reloadFrame(Element var1);

    public void back() {
        this.frame.back();
    }

    public void setFileInfo(SolutionFileInfo info) {
        this.fileInfo = info;
    }

    public void setFileInfo(FileItem item) {
        SolutionFileInfo fileInfo = new SolutionFileInfo();
        fileInfo.setName(item.getName());
        fileInfo.setSolution(item.getSolution());
        fileInfo.setPath(item.getPath());
        this.setFileInfo(fileInfo);
    }

    public SolutionFileInfo getFileInfo() {
        return this.fileInfo;
    }

    private String getCurrentUrl() {
        return IFrameElement.as((Element)this.frame.getElement()).getContentDocument().getURL();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.setSaveEnabled(url.contains("analysisview.xaction"));
        IFrameTabPanel.setUrl((Element)this.frame.getElement(), url);
    }

    public static native void setUrl(Element var0, String var1);

    public void openTabInNewWindow() {
        Window.open((String)this.getCurrentUrl(), (String)"_blank", (String)"");
    }

    public NamedFrame getFrame() {
        return this.frame;
    }

    public void setFrame(CustomFrame frame) {
        this.frame = frame;
    }

    public FormPanel getForm() {
        return this.form;
    }

    public void setForm(FormPanel form) {
        this.form = form;
    }

    public boolean isSaveEnabled() {
        return this.saveEnabled;
    }

    public void setSaveEnabled(boolean enabled) {
        this.saveEnabled = enabled;
    }

    public Set<String> getOverlayIds() {
        return this.overlayIds;
    }

    public void addOverlay(String id) {
        this.overlayIds.add(id);
    }

    public void setEditEnabled(boolean enable) {
        this.editContentEnabled = enable;
    }

    public boolean isEditEnabled() {
        return this.editContentEnabled;
    }

    public void setEditSelected(boolean selected) {
        this.editContentSelected = selected;
    }

    public boolean isEditSelected() {
        return this.editContentSelected;
    }

    public boolean isPrintVisible() {
        return this.checkFrameWindowPrintVisible((Element)this.frame.getElement());
    }

    private native boolean checkFrameWindowPrintVisible(Element var1);

    public void setId(String id) {
        this.frame.getElement().setAttribute("id", id);
    }

    public class CustomFrame
    extends NamedFrame {
        private boolean ignoreNextHistoryAdd;
        private Stack<String> history;
        private static final String ALLOW_TRANSPARENCY_ATTRIBUTE = "allowTransparency";

        private CustomFrame(String name) {
            super(name);
            this.ignoreNextHistoryAdd = false;
            this.history = new Stack();
            this.getElement().setAttribute(ALLOW_TRANSPARENCY_ATTRIBUTE, "true");
        }

        private CustomFrame(String name, String url) {
            super(name);
            this.ignoreNextHistoryAdd = false;
            this.history = new Stack();
            this.setUrl(url);
            IFrameTabPanel.setUrl((Element)this.getElement(), url);
            this.getElement().setAttribute(ALLOW_TRANSPARENCY_ATTRIBUTE, "true");
        }

        public void back() {
            if (!this.history.empty()) {
                this.ignoreNextHistoryAdd = true;
                IFrameTabPanel.setUrl((Element)IFrameTabPanel.this.frame.getElement(), this.history.pop());
            }
        }

        public void addHistory(String url) {
            if (this.ignoreNextHistoryAdd || url.equals("about:blank")) {
                this.ignoreNextHistoryAdd = false;
                return;
            }
            this.history.add(url);
        }

        protected void onAttach() {
            super.onAttach();
            this.attachEventListeners((Element)IFrameTabPanel.this.frame.getElement(), this);
        }

        public native void attachEventListeners(Element var1, CustomFrame var2);
    }
}

