/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.toolbars;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.PopupPanel;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.toolbar.Toolbar;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarButton;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarComboButton;
import org.pentaho.gwt.widgets.client.toolbar.ToolbarGroup;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;
import org.pentaho.gwt.widgets.client.utils.FrameUtils;
import org.pentaho.mantle.client.MantleApplication;
import org.pentaho.mantle.client.MantleMenuBar;
import org.pentaho.mantle.client.images.MantleImages;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.IFileSummaryProvider;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.filelist.IFileItemListener;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;

public class FilesToolbar
extends Toolbar
implements IFileItemListener {
    private static final String SEPARATOR = "separator";
    protected String FILE_GROUP_STYLE_NAME = "filesToolbarGroup";
    private IFileSummaryProvider fileSummaryProvider;
    private static final String[] menuItemNames = new String[]{"openInNewWindow", "runInBackground", "editAction", "delete", "separator", "share", "scheduleEllipsis", "separator", "propertiesEllipsis"};
    FileCommand.COMMAND[] menuCommands = new FileCommand.COMMAND[]{FileCommand.COMMAND.NEWWINDOW, FileCommand.COMMAND.BACKGROUND, FileCommand.COMMAND.EDIT_ACTION, FileCommand.COMMAND.DELETE, null, FileCommand.COMMAND.SHARE, FileCommand.COMMAND.SCHEDULE_NEW, null, FileCommand.COMMAND.PROPERTIES};
    ToolbarComboButton miscComboBtn;
    ToolbarButton runBtn;
    ToolbarButton editBtn;
    FileCommand runCmd;
    FileCommand editCmd;
    MenuItem[] menuItems = null;
    FileCommand[] menuFileCommands = null;
    boolean supportsACLs = false;
    MenuBar miscMenus = new MantleMenuBar(true);

    public FilesToolbar(IFileSummaryProvider fileSummaryProvider) {
        this.fileSummaryProvider = fileSummaryProvider;
        this.setHorizontalAlignment(ALIGN_RIGHT);
        this.setStyleName("pentaho-titled-toolbar");
        this.setSize("100%", "29px");
        this.createMenus();
    }

    private void createMenus() {
        this.addSpacer(5);
        Label label = new Label(Messages.getString("files"));
        label.setStyleName("pentaho-titled-toolbar-label");
        this.add(label);
        this.add(2);
        Image runImage = new Image();
        MantleImages.images.run().applyTo(runImage);
        Image runDisabledImage = new Image();
        MantleImages.images.runDisabled().applyTo(runDisabledImage);
        this.runBtn = new ToolbarButton(runImage, runDisabledImage);
        this.runBtn.setId("filesToolbarRun");
        this.runCmd = new FileCommand(FileCommand.COMMAND.RUN, null, this.fileSummaryProvider);
        this.runBtn.setCommand((Command)this.runCmd);
        this.runBtn.setToolTip(Messages.getString("open"));
        this.add(this.runBtn);
        Image editImage = new Image();
        MantleImages.images.update().applyTo(editImage);
        Image editDisabledImage = new Image();
        MantleImages.images.updateDisabled().applyTo(editDisabledImage);
        this.editBtn = new ToolbarButton(editImage, editDisabledImage);
        this.editBtn.setId("filesToolbarEdit");
        this.editCmd = new FileCommand(FileCommand.COMMAND.EDIT, null, this.fileSummaryProvider);
        this.editBtn.setCommand((Command)this.editCmd);
        this.editBtn.setToolTip(Messages.getString("edit"));
        this.add(this.editBtn);
        Image miscImage = new Image();
        MantleImages.images.misc().applyTo(miscImage);
        Image miscDisabledImage = new Image();
        MantleImages.images.miscDisabled().applyTo(miscDisabledImage);
        this.miscComboBtn = new ToolbarComboButton(miscImage, miscDisabledImage);
        this.miscComboBtn.setId("filesToolbarOptions");
        MantleServiceCache.getService().repositorySupportsACLS(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)"FilesToolbar begin");
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), caught.toString(), false, false, true);
                dialogBox.center();
                FilesToolbar.this.createMenuItems(false);
                Window.alert((String)"FilesToolbar end");
            }

            public void onSuccess(Boolean result) {
                FilesToolbar.this.createMenuItems(result);
            }
        });
        this.miscComboBtn.setToolTip(Messages.getString("options"));
        this.miscComboBtn.setStylePrimaryName("mantle-toolbar-combo-button");
        this.add((ToolbarButton)this.miscComboBtn);
        this.setEnabled(false);
    }

    private void createMenuItems(boolean supportsACLs) {
        this.supportsACLs = supportsACLs;
        this.menuItems = new MenuItem[this.menuCommands.length];
        this.menuFileCommands = new FileCommand[this.menuCommands.length];
        for (int i = 0; i < this.menuCommands.length; ++i) {
            if (!supportsACLs && this.menuCommands[i] == FileCommand.COMMAND.SHARE || !MantleApplication.showAdvancedFeatures && this.menuCommands[i] == FileCommand.COMMAND.EDIT_ACTION) continue;
            if (this.menuCommands[i] == null) {
                this.miscMenus.addSeparator();
                continue;
            }
            this.menuFileCommands[i] = new FileCommand(this.menuCommands[i], this.miscComboBtn.getPopup(), this.fileSummaryProvider);
            this.menuItems[i] = this.miscMenus.addItem(Messages.getString(menuItemNames[i]), (Command)this.menuFileCommands[i]);
            this.menuItems[i].getElement().setId(this.makeSafeId("file_toolbar_menuitem_" + Messages.getString(menuItemNames[i])));
        }
        this.miscComboBtn.setMenu(this.miscMenus);
    }

    private String makeSafeId(String id) {
        String safeid = id.replace(' ', '_').replaceAll("\\.", "").replaceAll(":", "");
        return safeid.toLowerCase();
    }

    public void popupClosed(PopupPanel panel) {
        IFrameTabPanel iframeTab = SolutionBrowserPerspective.getInstance().getContentTabPanel().getCurrentFrame();
        if (iframeTab == null || iframeTab.getFrame() == null) {
            return;
        }
        NamedFrame currentFrame = iframeTab.getFrame();
        FrameUtils.setEmbedVisibility((Frame)currentFrame, (boolean)true);
    }

    public void popupOpened(PopupPanel panel) {
        IFrameTabPanel iframeTab = SolutionBrowserPerspective.getInstance().getContentTabPanel().getCurrentFrame();
        if (iframeTab == null || iframeTab.getFrame() == null) {
            return;
        }
        NamedFrame currentFrame = iframeTab.getFrame();
        if (ElementUtils.elementsOverlap((Element)panel.getElement(), (Element)currentFrame.getElement())) {
            FrameUtils.setEmbedVisibility((Frame)currentFrame, (boolean)false);
        }
    }

    public void itemSelected(FileItem item) {
        this.updateMenus(item);
    }

    private void updateMenus(FileItem selectedFileItem) {
        this.setEnabled(selectedFileItem != null);
        this.runBtn.setEnabled(selectedFileItem != null && selectedFileItem.isCommandEnabled(FileCommand.COMMAND.RUN));
        this.editBtn.setEnabled(selectedFileItem != null && selectedFileItem.isCommandEnabled(FileCommand.COMMAND.EDIT));
        for (int i = 0; i < this.menuCommands.length; ++i) {
            if (!this.supportsACLs && this.menuCommands[i] == FileCommand.COMMAND.SHARE || this.menuCommands[i] == null || this.menuItems[i] == null) continue;
            if (selectedFileItem != null && selectedFileItem.isCommandEnabled(this.menuCommands[i])) {
                this.menuItems[i].setCommand((Command)this.menuFileCommands[i]);
                this.menuItems[i].setStyleName("gwt-MenuItem");
                continue;
            }
            this.menuItems[i].setCommand(null);
            this.menuItems[i].setStyleName("disabledMenuItem");
        }
        this.miscComboBtn.setMenu(this.miscMenus);
    }

    public boolean getSupportsACLs() {
        return this.supportsACLs;
    }

    public class FilesToolbarGroup
    extends ToolbarGroup {
        public FilesToolbarGroup(String groupName) {
            super(groupName);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(true);
        }

        public void setTempDisabled(boolean disable) {
            super.setTempDisabled(false);
        }
    }
}

