/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.tree;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeImages;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NodeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;
import org.pentaho.gwt.widgets.client.utils.string.StringTokenizer;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.mantle.client.dialogs.WaitPopup;
import org.pentaho.mantle.client.images.MantleImages;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.IFileSummary;
import org.pentaho.mantle.client.solutionbrowser.IFileSummaryProvider;
import org.pentaho.mantle.client.solutionbrowser.ISolutionDocumentListener;
import org.pentaho.mantle.client.solutionbrowser.MantlePopupPanel;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.SolutionDocumentManager;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileCommand;
import org.pentaho.mantle.client.solutionbrowser.tree.FileTreeItem;
import org.pentaho.mantle.client.usersettings.IUserSettingsListener;
import org.pentaho.mantle.client.usersettings.UserSettingsManager;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionTree
extends Tree
implements ISolutionDocumentListener,
IUserSettingsListener,
IFileSummaryProvider {
    private boolean showLocalizedFileNames = true;
    private boolean showHiddenFiles = false;
    private Document solutionDocument;
    private boolean isAdministrator = false;
    private boolean createRootNode = false;
    private boolean useDescriptionsForTooltip = false;
    private FileTreeItem selectedItem = null;
    FocusPanel focusable = new FocusPanel();

    public SolutionTree() {
        super((TreeImages)MantleImages.images, true);
        this.setAnimationEnabled(true);
        this.sinkEvents(2);
        DOM.setElementAttribute((com.google.gwt.user.client.Element)this.getElement(), (String)"oncontextmenu", (String)"return false;");
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"fontSize", (String)"0");
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"outline", (String)"0px");
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"width", (String)"1px");
        DOM.setStyleAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"height", (String)"1px");
        DOM.setElementAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"hideFocus", (String)"true");
        DOM.setIntStyleAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"zIndex", (int)-1);
        DOM.appendChild((com.google.gwt.user.client.Element)this.getElement(), (com.google.gwt.user.client.Element)this.focusable.getElement());
        DOM.sinkEvents((com.google.gwt.user.client.Element)this.focusable.getElement(), (int)6144);
        this.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> event) {
                SolutionTree.this.setSelectedItem((TreeItem)event.getTarget());
            }
        });
        this.getElement().setId("solutionTree");
        this.getElement().getStyle().setProperty("margin", "29px 0px 10px 0px");
        SolutionDocumentManager.getInstance().addSolutionDocumentListener(this);
        UserSettingsManager.getInstance().addUserSettingsListener(this);
    }

    @Override
    public void onFetchUserSettings(ArrayList<IUserSetting> settings) {
        if (settings == null) {
            return;
        }
        for (IUserSetting setting : settings) {
            if ("MANTLE_SHOW_LOCALIZED_FILENAMES".equals(setting.getSettingName())) {
                boolean showLocalizedFileNames = "true".equals(setting.getSettingValue());
                this.setShowLocalizedFileNames(showLocalizedFileNames);
                continue;
            }
            if ("MANTLE_SHOW_DESCRIPTIONS_FOR_TOOLTIPS".equals(setting.getSettingName())) {
                boolean useDescriptions = "true".equals(setting.getSettingValue());
                this.setUseDescriptionsForTooltip(useDescriptions);
                continue;
            }
            if (!"MANTLE_SHOW_HIDDEN_FILES".equals(setting.getSettingName())) continue;
            boolean showHiddenFiles = "true".equals(setting.getSettingValue());
            this.setShowHiddenFiles(showHiddenFiles);
        }
        SolutionBrowserPerspective.getInstance().updateViewMenu();
    }

    public void onBrowserEvent(Event event) {
        int eventType = DOM.eventGetType((Event)event);
        switch (eventType) {
            case 1: 
            case 4: 
            case 8: {
                try {
                    int[] scrollOffsets = ElementUtils.calculateScrollOffsets((Element)this.getElement());
                    int[] offsets = ElementUtils.calculateOffsets((Element)this.getElement());
                    DOM.setStyleAttribute((com.google.gwt.user.client.Element)this.focusable.getElement(), (String)"top", (String)(event.getClientY() + scrollOffsets[1] - offsets[1] + "px"));
                    break;
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        try {
            if (DOM.eventGetButton((Event)event) == 2) {
                int left = Window.getScrollLeft() + DOM.eventGetClientX((Event)event);
                int top = Window.getScrollTop() + DOM.eventGetClientY((Event)event);
                MantlePopupPanel popupMenu = MantlePopupPanel.getInstance(true);
                popupMenu.setPopupPosition(left, top);
                MenuBar menuBar = new MenuBar(true);
                menuBar.setAutoOpen(true);
                menuBar.addItem(new MenuItem(Messages.getString("createNewFolderEllipsis"), (Command)new FileCommand(FileCommand.COMMAND.CREATE_FOLDER, (PopupPanel)popupMenu, this.getFileSummary())));
                menuBar.addItem(new MenuItem(Messages.getString("delete"), (Command)new FileCommand(FileCommand.COMMAND.DELETE, (PopupPanel)popupMenu, this.getFileSummary())));
                menuBar.addSeparator();
                menuBar.addItem(new MenuItem(Messages.getString("properties"), (Command)new FileCommand(FileCommand.COMMAND.PROPERTIES, (PopupPanel)popupMenu, this.getFileSummary())));
                popupMenu.setWidget((Widget)menuBar);
                popupMenu.hide();
                popupMenu.show();
            } else if (DOM.eventGetType((Event)event) == 2) {
                this.getSelectedItem().setState(!this.getSelectedItem().getState(), true);
            } else {
                super.onBrowserEvent(event);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        TreeItem selItem = this.getSelectedItem();
        if (selItem != null) {
            DOM.scrollIntoView((com.google.gwt.user.client.Element)selItem.getElement());
        }
    }

    @Override
    public void beforeFetchSolutionDocument() {
        WaitPopup.getInstance().setVisible(true);
        if (this.getSelectedItem() != null) {
            this.selectedItem = (FileTreeItem)this.getSelectedItem();
        }
        this.clear();
        this.addItem(new TreeItem(Messages.getString("loadingEllipsis")));
        WaitPopup.getInstance().setVisible(false);
    }

    @Override
    public void onFetchSolutionDocument(Document solutionDocument) {
        if (solutionDocument == null) {
            WaitPopup.getInstance().setVisible(false);
            return;
        }
        this.solutionDocument = solutionDocument;
        this.clear();
        com.google.gwt.xml.client.Element solutionRoot = solutionDocument.getDocumentElement();
        if (this.createRootNode) {
            FileTreeItem rootItem = new FileTreeItem();
            rootItem.setText(solutionRoot.getAttribute("path"));
            rootItem.setTitle(solutionRoot.getAttribute("path"));
            rootItem.getElement().setId(solutionRoot.getAttribute("path"));
            ElementUtils.killAllTextSelection((Element)rootItem.getElement());
            rootItem.setFileName("/");
            this.addItem(rootItem);
            this.buildSolutionTree(rootItem, solutionRoot);
        } else {
            this.buildSolutionTree(null, solutionRoot);
            ArrayList<TreeItem> roots = new ArrayList<TreeItem>();
            for (int i = 0; i < this.getItemCount(); ++i) {
                roots.add(this.getItem(i));
            }
            Collections.sort(roots, new Comparator<TreeItem>(){

                @Override
                public int compare(TreeItem o1, TreeItem o2) {
                    return o1.getText().compareTo(o2.getText());
                }
            });
            this.clear();
            for (TreeItem myRootItem : roots) {
                this.addItem(myRootItem);
            }
        }
        if (this.selectedItem != null) {
            ArrayList<FileTreeItem> parents = new ArrayList<FileTreeItem>();
            while (this.selectedItem != null) {
                parents.add(this.selectedItem);
                this.selectedItem = (FileTreeItem)this.selectedItem.getParentItem();
            }
            Collections.reverse(parents);
            this.selectFromList(parents);
        } else {
            for (int i = 0; i < this.getItemCount(); ++i) {
                ((FileTreeItem)this.getItem(i)).setState(true);
            }
        }
        WaitPopup.getInstance().setVisible(false);
    }

    public ArrayList<FileTreeItem> getAllNodes() {
        ArrayList<FileTreeItem> nodeList = new ArrayList<FileTreeItem>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            nodeList.add((FileTreeItem)this.getItem(i));
            this.getAllNodes((FileTreeItem)this.getItem(i), nodeList);
        }
        return nodeList;
    }

    private void getAllNodes(FileTreeItem parent, ArrayList<FileTreeItem> nodeList) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            FileTreeItem child = (FileTreeItem)parent.getChild(i);
            nodeList.add(child);
            this.getAllNodes(child, nodeList);
        }
    }

    public ArrayList<String> getPathSegments(String path) {
        ArrayList<String> pathSegments = new ArrayList<String>();
        if (path != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            StringTokenizer st = new StringTokenizer(path, '/');
            for (int i = 0; i < st.countTokens(); ++i) {
                pathSegments.add(st.tokenAt(i));
            }
        }
        return pathSegments;
    }

    public boolean doesFileExist(ArrayList<String> pathSegments, String pFileName) {
        block3: {
            ArrayList filesInCurrDirectory;
            block2: {
                if (pathSegments.size() != 0) break block2;
                int itemCount = this.getItemCount();
                for (int x = 0; x < itemCount; ++x) {
                    FileTreeItem selectedItem = (FileTreeItem)this.getItem(x);
                    if (!selectedItem.fileName.equalsIgnoreCase(pFileName)) continue;
                    return true;
                }
                break block3;
            }
            FileTreeItem directoryItem = this.getTreeItem(pathSegments);
            if (directoryItem == null || (filesInCurrDirectory = (ArrayList)directoryItem.getUserObject()) == null) break block3;
            for (com.google.gwt.xml.client.Element fileElement : filesInCurrDirectory) {
                String currentFileName = fileElement.getAttribute("name");
                if (currentFileName == null || !currentFileName.equalsIgnoreCase(pFileName)) continue;
                return true;
            }
        }
        return false;
    }

    public FileTreeItem getTreeItem(ArrayList<String> pathSegments) {
        if (pathSegments.size() > 0) {
            String rootSegment = pathSegments.get(0);
            for (int i = 0; i < this.getItemCount(); ++i) {
                FileTreeItem root = (FileTreeItem)this.getItem(i);
                if (!root.getFileName().equalsIgnoreCase(rootSegment)) continue;
                ArrayList tmpPathSegs = (ArrayList)pathSegments.clone();
                tmpPathSegs.remove(0);
                return this.getTreeItem(root, tmpPathSegs);
            }
        }
        return null;
    }

    private FileTreeItem getTreeItem(FileTreeItem root, ArrayList<String> pathSegments) {
        int depth;
        FileTreeItem currentItem = root;
        for (depth = 0; depth < pathSegments.size(); ++depth) {
            String pathSegment = pathSegments.get(depth);
            for (int i = 0; i < currentItem.getChildCount(); ++i) {
                FileTreeItem childItem = (FileTreeItem)currentItem.getChild(i);
                if (!childItem.getFileName().equalsIgnoreCase(pathSegment)) continue;
                currentItem = childItem;
            }
        }
        FileTreeItem tmpItem = currentItem;
        for (depth = pathSegments.size() - 1; tmpItem != null && depth >= 0; tmpItem = (FileTreeItem)tmpItem.getParentItem(), --depth) {
            if (tmpItem.getFileName().equalsIgnoreCase(pathSegments.get(depth))) {
                continue;
            }
            return null;
        }
        return currentItem;
    }

    private void selectFromList(ArrayList<FileTreeItem> parents) {
        FileTreeItem pathDown = null;
        block0: for (int i = 0; i < parents.size(); ++i) {
            FileTreeItem possibleItem;
            int j;
            FileTreeItem parent = parents.get(i);
            if (pathDown == null) {
                for (j = 0; j < this.getItemCount(); ++j) {
                    possibleItem = (FileTreeItem)this.getItem(j);
                    if (!parent.getFileName().equals(possibleItem.getFileName())) continue;
                    pathDown = possibleItem;
                    pathDown.setState(true, true);
                    pathDown.setSelected(true);
                    continue block0;
                }
                continue;
            }
            for (j = 0; j < pathDown.getChildCount(); ++j) {
                possibleItem = (FileTreeItem)pathDown.getChild(j);
                if (!parent.getFileName().equals(possibleItem.getFileName())) continue;
                pathDown = possibleItem;
                pathDown.setState(true, true);
                continue block0;
            }
        }
        if (pathDown != null) {
            this.setSelectedItem(pathDown);
            pathDown.setState(true, true);
        }
    }

    private void buildSolutionTree(FileTreeItem parentTreeItem, com.google.gwt.xml.client.Element parentElement) {
        NodeList children = parentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            FileTreeItem childTreeItem;
            boolean isDirectory;
            com.google.gwt.xml.client.Element childElement;
            block28: {
                childElement = (com.google.gwt.xml.client.Element)children.item(i);
                if (childElement == this.focusable) continue;
                boolean isVisible = "true".equals(childElement.getAttribute("visible"));
                isDirectory = "true".equals(childElement.getAttribute("isDirectory"));
                if (!isVisible && !this.showHiddenFiles) continue;
                String fileName = childElement.getAttribute("name");
                String localizedName = childElement.getAttribute("localized-name");
                String description = childElement.getAttribute("description");
                childTreeItem = new FileTreeItem();
                String id = null;
                com.google.gwt.xml.client.Element parent = childElement;
                while (parent != null) {
                    if (StringUtils.isEmpty((String)parent.getAttribute("name"))) {
                        try {
                            parent = (com.google.gwt.xml.client.Element)parent.getParentNode();
                        }
                        catch (Throwable t) {
                            parent = null;
                        }
                        continue;
                    }
                    id = id != null ? parent.getAttribute("name") + "/" + id : parent.getAttribute("name");
                    if (parent.getParentNode() == null) break;
                    try {
                        parent = (com.google.gwt.xml.client.Element)parent.getParentNode();
                    }
                    catch (Throwable t) {
                        parent = null;
                    }
                }
                childTreeItem.getElement().setAttribute("id", id);
                ElementUtils.killAllTextSelection((Element)childTreeItem.getElement());
                childTreeItem.setURL(childElement.getAttribute("url"));
                if (this.showLocalizedFileNames) {
                    childTreeItem.setText(localizedName);
                    if (this.isUseDescriptionsForTooltip() && !StringUtils.isEmpty((String)description)) {
                        childTreeItem.setTitle(description);
                    } else {
                        childTreeItem.setTitle(fileName);
                    }
                } else {
                    childTreeItem.setText(fileName);
                    if (this.isUseDescriptionsForTooltip() && !StringUtils.isEmpty((String)description)) {
                        childTreeItem.setTitle(description);
                    } else {
                        childTreeItem.setTitle(localizedName);
                    }
                }
                childTreeItem.setFileName(fileName);
                if (parentTreeItem == null && isDirectory) {
                    this.addItem(childTreeItem);
                } else {
                    try {
                        if (parentTreeItem.getChildCount() == 0) {
                            parentTreeItem.addItem(childTreeItem);
                            break block28;
                        }
                        boolean inserted = false;
                        for (int j = 0; j < parentTreeItem.getChildCount(); ++j) {
                            FileTreeItem kid = (FileTreeItem)parentTreeItem.getChild(j);
                            if (this.showLocalizedFileNames) {
                                if (childTreeItem.getText().compareTo(kid.getText()) > 0) continue;
                                ArrayList<FileTreeItem> removedItems = new ArrayList<FileTreeItem>();
                                for (int x = j; x < parentTreeItem.getChildCount(); ++x) {
                                    FileTreeItem removedItem = (FileTreeItem)parentTreeItem.getChild(x);
                                    removedItems.add(removedItem);
                                }
                                for (FileTreeItem removedItem : removedItems) {
                                    parentTreeItem.removeItem(removedItem);
                                }
                                parentTreeItem.addItem(childTreeItem);
                                inserted = true;
                                for (FileTreeItem removedItem : removedItems) {
                                    parentTreeItem.addItem(removedItem);
                                }
                                break;
                            }
                            parentTreeItem.addItem(childTreeItem);
                            inserted = true;
                        }
                        if (!inserted) {
                            parentTreeItem.addItem(childTreeItem);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            FileTreeItem tmpParent = childTreeItem;
            String pathToChild = tmpParent.getFileName();
            while (tmpParent.getParentItem() != null) {
                tmpParent = (FileTreeItem)tmpParent.getParentItem();
                pathToChild = tmpParent.getFileName() + "/" + pathToChild;
            }
            if (parentTreeItem != null) {
                ArrayList<com.google.gwt.xml.client.Element> files = (ArrayList<com.google.gwt.xml.client.Element>)parentTreeItem.getUserObject();
                if (files == null) {
                    files = new ArrayList<com.google.gwt.xml.client.Element>();
                    parentTreeItem.setUserObject(files);
                }
                files.add(childElement);
            }
            if (isDirectory) {
                this.buildSolutionTree(childTreeItem, childElement);
                continue;
            }
            if (parentTreeItem == null) continue;
            parentTreeItem.removeItem(childTreeItem);
        }
    }

    public void setShowLocalizedFileNames(boolean showLocalizedFileNames) {
        this.showLocalizedFileNames = showLocalizedFileNames;
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.toggleLocalizedFileNames((FileTreeItem)this.getItem(i));
        }
    }

    private void toggleLocalizedFileNames(FileTreeItem parentTreeItem) {
        String title = parentTreeItem.getTitle();
        String text = parentTreeItem.getText();
        parentTreeItem.setTitle(text);
        parentTreeItem.setText(title);
        for (int i = 0; i < parentTreeItem.getChildCount(); ++i) {
            this.toggleLocalizedFileNames((FileTreeItem)parentTreeItem.getChild(i));
        }
    }

    public String getSolution() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getSelectedItem() != this.getItem(i)) continue;
            return ((FileTreeItem)this.getItem(i)).getFileName();
        }
        ArrayList<FileTreeItem> parents = new ArrayList<FileTreeItem>();
        for (FileTreeItem tmpParent = (FileTreeItem)this.getSelectedItem(); tmpParent != null; tmpParent = (FileTreeItem)tmpParent.getParentItem()) {
            parents.add(tmpParent);
        }
        return ((FileTreeItem)((Object)parents.get(parents.size() - (this.isCreateRootNode() ? 2 : 1)))).getFileName();
    }

    public String getPath() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getSelectedItem() != this.getItem(i)) continue;
            return "/";
        }
        ArrayList<FileTreeItem> parents = new ArrayList<FileTreeItem>();
        for (FileTreeItem tmpParent = (FileTreeItem)this.getSelectedItem(); tmpParent != null; tmpParent = (FileTreeItem)tmpParent.getParentItem()) {
            parents.add(tmpParent);
        }
        String path = "";
        for (int i = parents.size() - 1 - (this.isCreateRootNode() ? 2 : 1); i >= 0; --i) {
            FileTreeItem parent = (FileTreeItem)((Object)parents.get(i));
            path = path + "/" + parent.getFileName();
        }
        return path;
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
        this.onFetchSolutionDocument(this.solutionDocument);
    }

    public boolean isShowLocalizedFileNames() {
        return this.showLocalizedFileNames;
    }

    public boolean isUseDescriptionsForTooltip() {
        return this.useDescriptionsForTooltip;
    }

    public void setUseDescriptionsForTooltip(boolean useDescriptionsForTooltip) {
        this.useDescriptionsForTooltip = useDescriptionsForTooltip;
        this.onFetchSolutionDocument(this.solutionDocument);
    }

    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public void setAdministrator(boolean isAdministrator) {
        this.isAdministrator = isAdministrator;
    }

    public boolean isCreateRootNode() {
        return this.createRootNode;
    }

    Focusable getFocusable() {
        return this.focusable;
    }

    @Override
    public IFileSummary getFileSummary() {
        final FileTreeItem selectedTreeItem = (FileTreeItem)this.getSelectedItem();
        if (selectedTreeItem == null) {
            return null;
        }
        String tmpPath = this.getPath();
        if (!"".equals(this.getPath())) {
            tmpPath = tmpPath.substring(0, tmpPath.lastIndexOf("/"));
        }
        final String path = tmpPath;
        final String solution = this.getSolution();
        IFileSummary fileSummary = new IFileSummary(){

            public String getLocalizedName() {
                return selectedTreeItem != null ? selectedTreeItem.getText() : null;
            }

            public String getName() {
                return selectedTreeItem != null ? selectedTreeItem.getFileName() : null;
            }

            public String getPath() {
                return path;
            }

            public String getSolution() {
                return solution;
            }
        };
        return fileSummary;
    }
}

