/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.solutionbrowser.workspace;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.mantle.client.images.MantleImages;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.JobDetail;
import org.pentaho.mantle.client.objects.JobSchedule;
import org.pentaho.mantle.client.objects.SimpleMessageException;
import org.pentaho.mantle.client.objects.SubscriptionBean;
import org.pentaho.mantle.client.objects.WorkspaceContent;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.login.client.MantleLoginDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspacePanel
extends ScrollPanel {
    public DeleteSubscriptionClickHandler deleteSubscriptionClickHandler;
    private static final int WAITING = 0;
    private static final int COMPLETE = 1;
    private static final int MYSCHEDULES = 2;
    private static final int ALLSCHEDULES = 3;
    private static final String DELETE = "delete";
    private DisclosurePanel allScheduledContentDisclosure = new DisclosurePanel((DisclosurePanelImages)MantleImages.images, Messages.getString("allSchedulesAdminOnly"), false);
    private DisclosurePanel subscriptionsContentDisclosure = new DisclosurePanel((DisclosurePanelImages)MantleImages.images, Messages.getString("publicSchedules"), false);
    private DisclosurePanel myScheduledContentDisclosure = new DisclosurePanel((DisclosurePanelImages)MantleImages.images, Messages.getString("mySchedules"), false);
    private DisclosurePanel waitingContentDisclosure = new DisclosurePanel((DisclosurePanelImages)MantleImages.images, Messages.getString("waiting"), false);
    private DisclosurePanel completedContentDisclosure = new DisclosurePanel((DisclosurePanelImages)MantleImages.images, Messages.getString("complete"), false);
    private FlexTable allScheduledContentTable;
    private FlexTable subscriptionsContentTable;
    private FlexTable myScheduledContentTable;
    private FlexTable waitingContentTable;
    private FlexTable completedContentTable;
    private FlexTable workspaceTable = new FlexTable();
    private boolean isAdministrator = false;

    public WorkspacePanel(boolean isAdministrator) {
        this.getElement().setAttribute("id", "workspacePanel");
        this.setStyleName("workspacePanel");
        this.isAdministrator = isAdministrator;
        this.buildScheduledAndCompletedContentPanel(isAdministrator);
    }

    private FlexTable buildEmptyBackgroundItemTable(int tableType) {
        FlexTable table = new FlexTable();
        table.setWidth("100%");
        table.setStyleName("backgroundContentTable");
        table.setWidget(0, 0, (Widget)new Label(Messages.getString("name")));
        table.setWidget(0, 1, (Widget)new Label(Messages.getString("date")));
        if (tableType == 1) {
            table.setWidget(0, 2, (Widget)new Label(Messages.getString("size")));
            table.getCellFormatter().setHorizontalAlignment(0, 2, HasHorizontalAlignment.ALIGN_RIGHT);
            table.setWidget(0, 3, (Widget)new Label(Messages.getString("type")));
            table.setWidget(0, 4, (Widget)new Label(Messages.getString("actions")));
            table.getCellFormatter().setStyleName(0, 0, "backgroundContentHeaderTableCell");
            table.getCellFormatter().setStyleName(0, 1, "backgroundContentHeaderTableCell");
            table.getCellFormatter().setStyleName(0, 2, "backgroundContentHeaderTableCell");
            table.getCellFormatter().setStyleName(0, 3, "backgroundContentHeaderTableCell");
            table.getCellFormatter().setStyleName(0, 4, "backgroundContentHeaderTableCellRight");
        } else {
            table.setWidget(0, 2, (Widget)new Label(Messages.getString("actions")));
            table.getCellFormatter().setStyleName(0, 0, "backgroundContentHeaderTableCell");
            table.getCellFormatter().setStyleName(0, 1, "backgroundContentHeaderTableCell");
            table.getCellFormatter().setStyleName(0, 2, "backgroundContentHeaderTableCellRight");
        }
        return table;
    }

    private FlexTable buildEmptyScheduleTable() {
        FlexTable table = new FlexTable();
        table.setWidth("100%");
        table.setStyleName("backgroundContentTable");
        table.setWidget(0, 0, (Widget)new Label(Messages.getString("jobName")));
        table.setWidget(0, 1, (Widget)new Label(Messages.getString("jobGroup")));
        table.setWidget(0, 2, (Widget)new Label(Messages.getString("description")));
        table.setWidget(0, 3, (Widget)new Label(Messages.getString("lastRunNextRun")));
        table.setWidget(0, 4, (Widget)new Label(Messages.getString("state")));
        table.setWidget(0, 5, (Widget)new Label(Messages.getString("actions")));
        table.getCellFormatter().setStyleName(0, 0, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 1, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 2, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 3, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 4, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 5, "backgroundContentHeaderTableCellRight");
        return table;
    }

    private FlexTable buildEmptySubscriptionsTable() {
        FlexTable table = new FlexTable();
        table.setWidth("100%");
        table.setStyleName("backgroundContentTable");
        table.setWidget(0, 0, (Widget)new Label(Messages.getString("name")));
        table.setWidget(0, 1, (Widget)new Label(Messages.getString("scheduleDate")));
        table.setWidget(0, 2, (Widget)new Label(Messages.getString("type")));
        table.setWidget(0, 3, (Widget)new Label(Messages.getString("size")));
        table.setWidget(0, 4, (Widget)new Label(Messages.getString("actions")));
        table.getFlexCellFormatter().setWidth(1, 0, "200em");
        table.getFlexCellFormatter().setWidth(1, 1, "200em");
        table.getFlexCellFormatter().setWidth(1, 2, "100em");
        table.getFlexCellFormatter().setWidth(1, 3, "100em");
        table.getFlexCellFormatter().setWidth(1, 4, "450em");
        table.getCellFormatter().setStyleName(0, 0, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 1, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 2, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 3, "backgroundContentHeaderTableCell");
        table.getCellFormatter().setStyleName(0, 4, "backgroundContentHeaderTableCell");
        return table;
    }

    public void setAdministrator(boolean isAdministrator) {
        this.isAdministrator = isAdministrator;
        this.buildScheduledAndCompletedContentPanel(isAdministrator);
    }

    private void buildScheduledAndCompletedContentPanel(boolean isAdministrator) {
        this.workspaceTable = new FlexTable();
        HTML workspaceMessage = new HTML(Messages.getString("workspaceMessage"));
        workspaceMessage.setStylePrimaryName("workspaceMessage");
        this.workspaceTable.setWidget(0, 0, (Widget)workspaceMessage);
        this.workspaceTable.setWidget(1, 0, (Widget)this.waitingContentDisclosure);
        this.workspaceTable.setWidget(2, 0, (Widget)this.completedContentDisclosure);
        this.workspaceTable.setWidget(3, 0, (Widget)this.myScheduledContentDisclosure);
        if (isAdministrator) {
            this.workspaceTable.setWidget(4, 0, (Widget)this.allScheduledContentDisclosure);
        }
        this.workspaceTable.setWidget(5, 0, (Widget)this.subscriptionsContentDisclosure);
        DOM.setStyleAttribute((Element)this.workspaceTable.getElement(), (String)"margin", (String)"10px");
        this.setWidget((Widget)this.workspaceTable);
    }

    private void buildJobTable(ArrayList<JobDetail> jobDetails, FlexTable jobTable, DisclosurePanel disclosurePanel, int tableType) {
        disclosurePanel.setOpen(jobDetails != null && jobDetails.size() > 0);
        for (int row = 0; row < jobDetails.size(); ++row) {
            final JobDetail jobDetail = jobDetails.get(row);
            HorizontalPanel actionPanel = new HorizontalPanel();
            if (tableType == 1) {
                Label viewLabel = new Label(Messages.getString("view"));
                viewLabel.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        SolutionBrowserPerspective.getInstance().getContentTabPanel().showNewURLTab(jobDetail.name, jobDetail.name, "GetContent?action=view&id=" + jobDetail.id, false);
                    }
                });
                viewLabel.setStyleName("backgroundContentAction");
                viewLabel.setTitle(Messages.getString("viewContent"));
                Label deleteLabel = new Label(Messages.getString(DELETE));
                deleteLabel.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        WorkspacePanel.this.deleteContentItem(jobDetail.id);
                    }
                });
                deleteLabel.setStyleName("backgroundContentAction");
                deleteLabel.setTitle(Messages.getString("deleteContent"));
                actionPanel.add((Widget)viewLabel);
                actionPanel.add((Widget)new HTML("&nbsp;|&nbsp;"));
                actionPanel.add((Widget)deleteLabel);
            } else if (tableType == 0) {
                Label cancelLabel = new Label(Messages.getString("cancel"));
                cancelLabel.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        WorkspacePanel.this.cancelBackgroundJob(jobDetail.id, jobDetail.group);
                    }
                });
                cancelLabel.setStyleName("backgroundContentAction");
                cancelLabel.setTitle(Messages.getString("cancelExecution"));
                actionPanel.add((Widget)cancelLabel);
            }
            jobTable.setWidget(row + 1, 0, (Widget)new Label(jobDetail.name == null ? (jobDetail.id == null ? "-" : jobDetail.id) : jobDetail.name));
            jobTable.setWidget(row + 1, 1, (Widget)new Label(jobDetail.timestamp == null ? "-" : jobDetail.timestamp));
            if (tableType == 1) {
                jobTable.setWidget(row + 1, 2, (Widget)new Label("" + jobDetail.size));
                jobTable.setWidget(row + 1, 3, (Widget)new Label(jobDetail.type));
                jobTable.setWidget(row + 1, 4, (Widget)actionPanel);
                jobTable.getCellFormatter().setStyleName(row + 1, 0, "backgroundContentTableCell");
                jobTable.getCellFormatter().setStyleName(row + 1, 1, "backgroundContentTableCell");
                jobTable.getCellFormatter().setStyleName(row + 1, 2, "backgroundContentTableCell");
                jobTable.getCellFormatter().setHorizontalAlignment(row + 1, 2, HasHorizontalAlignment.ALIGN_RIGHT);
                jobTable.getCellFormatter().setStyleName(row + 1, 3, "backgroundContentTableCell");
                jobTable.getCellFormatter().setStyleName(row + 1, 4, "backgroundContentTableCellRight");
                if (row != jobDetails.size() - 1) continue;
                jobTable.getCellFormatter().setStyleName(row + 1, 0, "backgroundContentTableCellBottom");
                jobTable.getCellFormatter().setStyleName(row + 1, 1, "backgroundContentTableCellBottom");
                jobTable.getCellFormatter().setStyleName(row + 1, 2, "backgroundContentTableCellBottom");
                jobTable.getCellFormatter().setHorizontalAlignment(row + 1, 2, HasHorizontalAlignment.ALIGN_RIGHT);
                jobTable.getCellFormatter().setStyleName(row + 1, 3, "backgroundContentTableCellBottom");
                jobTable.getCellFormatter().setStyleName(row + 1, 4, "backgroundContentTableCellBottomRight");
                continue;
            }
            jobTable.setWidget(row + 1, 2, (Widget)actionPanel);
            jobTable.getCellFormatter().setStyleName(row + 1, 0, "backgroundContentTableCell");
            jobTable.getCellFormatter().setStyleName(row + 1, 1, "backgroundContentTableCell");
            jobTable.getCellFormatter().setStyleName(row + 1, 2, "backgroundContentTableCellRight");
            if (row != jobDetails.size() - 1) continue;
            jobTable.getCellFormatter().setStyleName(row + 1, 0, "backgroundContentTableCellBottom");
            jobTable.getCellFormatter().setStyleName(row + 1, 1, "backgroundContentTableCellBottom");
            jobTable.getCellFormatter().setStyleName(row + 1, 2, "backgroundContentTableCellBottomRight");
        }
    }

    private void buildSubscriptionsTable(ArrayList<SubscriptionBean> subscriptionsInfo, FlexTable subscrTable, DisclosurePanel disclosurePanel) {
        disclosurePanel.setOpen(subscriptionsInfo != null && subscriptionsInfo.size() > 0);
        subscrTable.setCellSpacing(2);
        int row = 0;
        Iterator<SubscriptionBean> subscrIter = subscriptionsInfo.iterator();
        while (subscrIter.hasNext()) {
            ++row;
            final SubscriptionBean currentSubscr = subscrIter.next();
            VerticalPanel namePanel = new VerticalPanel();
            namePanel.add((Widget)new Label(currentSubscr.getName()));
            namePanel.add((Widget)new Label(currentSubscr.getXactionName()));
            Label scheduleDate = new Label(currentSubscr.getScheduleDate());
            Label size = new Label(currentSubscr.getSize());
            Label type = new Label(currentSubscr.getType());
            HorizontalPanel buttonsPanel = new HorizontalPanel();
            final String subscriptionId = currentSubscr.getId();
            Label lblRunNow = new Label(Messages.getString("run"));
            lblRunNow.setStyleName("backgroundContentAction");
            lblRunNow.addClickHandler((ClickHandler)new RunSubscriptionClickHandler(currentSubscr));
            Label lblArchive = new Label(Messages.getString("archive"));
            lblArchive.setStyleName("backgroundContentAction");
            lblArchive.addClickHandler((ClickHandler)new RunAndArchiveClickHandler(subscriptionId));
            Label lblEdit = new Label(Messages.getString("edit"));
            lblEdit.setStyleName("backgroundContentAction");
            lblEdit.addClickHandler((ClickHandler)new EditSubscriptionClickHandler(currentSubscr));
            Label lblDelete = new Label(Messages.getString(DELETE));
            lblDelete.setStyleName("backgroundContentAction");
            this.deleteSubscriptionClickHandler = new DeleteSubscriptionClickHandler(currentSubscr, lblDelete);
            lblDelete.addClickHandler((ClickHandler)this.deleteSubscriptionClickHandler);
            buttonsPanel.add((Widget)lblRunNow);
            buttonsPanel.add((Widget)new HTML("&nbsp;|&nbsp;"));
            buttonsPanel.add((Widget)lblArchive);
            buttonsPanel.add((Widget)new HTML("&nbsp;|&nbsp;"));
            buttonsPanel.add((Widget)lblEdit);
            buttonsPanel.add((Widget)new HTML("&nbsp;|&nbsp;"));
            buttonsPanel.add((Widget)lblDelete);
            subscrTable.setWidget(row, 0, (Widget)namePanel);
            subscrTable.setWidget(row, 1, (Widget)scheduleDate);
            subscrTable.setWidget(row, 2, (Widget)size);
            subscrTable.setWidget(row, 3, (Widget)type);
            subscrTable.setWidget(row, 4, (Widget)buttonsPanel);
            subscrTable.getCellFormatter().setStyleName(row, 0, "backgroundContentTableCell");
            subscrTable.getCellFormatter().setStyleName(row, 1, "backgroundContentTableCell");
            subscrTable.getCellFormatter().setStyleName(row, 2, "backgroundContentTableCell");
            subscrTable.getCellFormatter().setHorizontalAlignment(row, 2, HasHorizontalAlignment.ALIGN_RIGHT);
            subscrTable.getCellFormatter().setStyleName(row, 3, "backgroundContentTableCell");
            subscrTable.getCellFormatter().setStyleName(row, 4, "backgroundContentTableCellRight");
            ArrayList<String[]> scheduleList = currentSubscr.getContent();
            if (scheduleList == null) continue;
            int scheduleSize = scheduleList.size();
            for (int j = 0; j < scheduleSize; ++j) {
                final String[] currSchedule = scheduleList.get(j);
                subscrTable.setWidget(++row, 1, (Widget)new Label(currSchedule[0]));
                subscrTable.setWidget(row, 2, (Widget)new Label(currSchedule[1]));
                subscrTable.setWidget(row, 3, (Widget)new Label(currSchedule[2]));
                HorizontalPanel actionButtonsPanel = new HorizontalPanel();
                Label lblViewContent = new Label(Messages.getString("view"));
                lblViewContent.setStyleName("backgroundContentAction");
                lblViewContent.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        String fileId = currSchedule[3];
                        String name = subscriptionId;
                        WorkspacePanel.this.performActionOnSubscriptionContent("archived", currentSubscr, name, fileId);
                    }
                });
                actionButtonsPanel.add((Widget)lblViewContent);
                Label lblDeleteContent = new Label(Messages.getString(DELETE));
                lblDeleteContent.setStyleName("backgroundContentAction");
                lblDeleteContent.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        WorkspacePanel.this.doDelete(false, currentSubscr, currSchedule[3]);
                    }
                });
                actionButtonsPanel.add((Widget)new HTML("&nbsp;|&nbsp;"));
                actionButtonsPanel.add((Widget)lblDeleteContent);
                subscrTable.setWidget(row, 4, (Widget)actionButtonsPanel);
                subscrTable.getCellFormatter().setStyleName(row, 0, "backgroundContentTableCell");
                subscrTable.getCellFormatter().setStyleName(row, 1, "backgroundContentTableCell");
                subscrTable.getCellFormatter().setStyleName(row, 2, "backgroundContentTableCell");
                subscrTable.getCellFormatter().setHorizontalAlignment(row, 2, HasHorizontalAlignment.ALIGN_RIGHT);
                subscrTable.getCellFormatter().setStyleName(row, 3, "backgroundContentTableCell");
                subscrTable.getCellFormatter().setStyleName(row, 4, "backgroundContentTableCellRight");
                if (row != scheduleSize - 1) continue;
                subscrTable.getCellFormatter().setStyleName(row, 0, "backgroundContentTableCellBottom");
                subscrTable.getCellFormatter().setStyleName(row, 1, "backgroundContentTableCellBottom");
                subscrTable.getCellFormatter().setStyleName(row, 2, "backgroundContentTableCellBottom");
                subscrTable.getCellFormatter().setHorizontalAlignment(row, 2, HasHorizontalAlignment.ALIGN_RIGHT);
                subscrTable.getCellFormatter().setStyleName(row, 3, "backgroundContentTableCellBottom");
                subscrTable.getCellFormatter().setStyleName(row, 4, "backgroundContentTableCellBottomRight");
            }
        }
    }

    private void runAndArchive(String publicSchedule) {
        AsyncCallback<String> callback = null;
        if (publicSchedule != null) {
            callback = new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    if (caught instanceof SimpleMessageException) {
                        new MessageDialogBox(Messages.getString("error"), caught.getMessage(), false, false, true).center();
                    } else {
                        new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotSchedule"), false, false, true).center();
                    }
                }

                public void onSuccess(String result) {
                    MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("runInBackground"), Messages.getString("reportIsScheduledForBE"), false, false, true);
                    dialogBox.center();
                }
            };
            MantleServiceCache.getService().runAndArchivePublicSchedule(publicSchedule, callback);
        }
    }

    private void doDelete(boolean isPublicSchedule, final SubscriptionBean currentSubscr, String fileId) {
        if (isPublicSchedule) {
            VerticalPanel vp = new VerticalPanel();
            vp.add((Widget)new Label(Messages.getString("deletePublicSchedule")));
            final PromptDialogBox deleteConfirmDialog = new PromptDialogBox(Messages.getString(DELETE), Messages.getString("ok"), Messages.getString("cancel"), false, true, (Widget)vp);
            IDialogCallback callback = new IDialogCallback(){

                public void cancelPressed() {
                    deleteConfirmDialog.hide();
                    WorkspacePanel.this.deleteSubscriptionClickHandler.getLblDelete().setVisible(true);
                }

                public void okPressed() {
                    WorkspacePanel.this.deletePublicScheduleAndContents(currentSubscr);
                }
            };
            deleteConfirmDialog.setCallback(callback);
            deleteConfirmDialog.center();
        } else {
            this.deleteContentItem(currentSubscr.getId(), fileId);
        }
    }

    private void deletePublicScheduleAndContents(SubscriptionBean currPublicSchedule) {
        String subscrName = currPublicSchedule.getId();
        ArrayList<String[]> scheduleList = currPublicSchedule.getContent() == null ? new ArrayList<String[]>() : currPublicSchedule.getContent();
        ArrayList<String> fileList = new ArrayList<String>();
        AsyncCallback<String> callback = new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotDeletePublicScheduleAndContents"), false, false, true).center();
            }

            public void onSuccess(String result) {
                WorkspacePanel.this.refreshWorkspace();
            }
        };
        int scheduleSize = scheduleList.size();
        for (int j = 0; j < scheduleSize; ++j) {
            String[] currSchedule = scheduleList.get(j);
            String fileId = currSchedule[3];
            fileList.add(fileId);
        }
        MantleServiceCache.getService().deletePublicScheduleAndContents(subscrName, fileList, callback);
    }

    private void performActionOnSubscriptionContent(String action, SubscriptionBean subscription, String subscrName, String contentID) {
        this.performActionOnSubscription(action, subscription, subscrName + ":" + contentID);
    }

    private void performActionOnSubscription(final String action, SubscriptionBean subscription, String subscrName) {
        String url;
        final PromptDialogBox viewDialog = new PromptDialogBox(Messages.getString("view"), Messages.getString("close"), null, false, false);
        viewDialog.setContent((Widget)new VerticalPanel());
        viewDialog.setCallback(new IDialogCallback(){

            public void okPressed() {
                viewDialog.hide();
                if (action.equals("archive") || action.equals(WorkspacePanel.DELETE)) {
                    WorkspacePanel.this.refreshWorkspace();
                }
            }

            public void cancelPressed() {
            }
        });
        if (action.equals("edit") && !StringUtils.isEmpty((String)subscription.getPluginUrl())) {
            url = subscription.getPluginUrl();
            if (!GWT.isScript()) {
                url = "http://localhost:8080/pentaho/" + url;
            }
        } else {
            url = "ViewAction?subscribe=" + action + "&subscribe-name=" + subscrName;
            if (!GWT.isScript()) {
                url = "http://localhost:8080/pentaho/" + url;
            }
        }
        if (action.equals("archived") || action.equals("run") || action.equals("edit")) {
            SolutionBrowserPerspective.getInstance().getContentTabPanel().showNewURLTab(subscription.getName(), subscription.getId(), url, false);
        } else {
            viewDialog.center();
            Frame iframe = new Frame(url);
            if (action.equals(DELETE)) {
                iframe.setSize("100%", "100%");
            } else {
                iframe.setPixelSize(800, 600);
            }
            ((VerticalPanel)viewDialog.getContent()).add((Widget)iframe);
        }
    }

    private void buildScheduleTable(ArrayList<JobSchedule> scheduleDetails, FlexTable scheduleTable, DisclosurePanel disclosurePanel, final int jobSource) {
        disclosurePanel.setOpen(scheduleDetails != null && scheduleDetails.size() > 0);
        for (int row = 0; row < scheduleDetails.size(); ++row) {
            final JobSchedule jobSchedule = scheduleDetails.get(row);
            HorizontalPanel actionPanel = new HorizontalPanel();
            Label suspendJobLabel = new Label(Messages.getString("suspend"));
            suspendJobLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WorkspacePanel.this.suspendJob(jobSchedule.jobName, jobSchedule.jobGroup, jobSource);
                }
            });
            suspendJobLabel.setStyleName("backgroundContentAction");
            suspendJobLabel.setTitle(Messages.getString("suspendThisJob"));
            Label resumeJobLabel = new Label(Messages.getString("resume"));
            resumeJobLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WorkspacePanel.this.resumeJob(jobSchedule.jobName, jobSchedule.jobGroup, jobSource);
                }
            });
            resumeJobLabel.setStyleName("backgroundContentAction");
            resumeJobLabel.setTitle(Messages.getString("resumeThisJob"));
            Label runJobLabel = new Label(Messages.getString("run"));
            runJobLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WorkspacePanel.this.runJob(jobSchedule.jobName, jobSchedule.jobGroup, jobSource);
                }
            });
            runJobLabel.setStyleName("backgroundContentAction");
            runJobLabel.setTitle(Messages.getString("runThisJob"));
            Label deleteJobLabel = new Label(Messages.getString(DELETE));
            deleteJobLabel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    WorkspacePanel.this.deleteJob(jobSchedule.jobName, jobSchedule.jobGroup, jobSource);
                }
            });
            deleteJobLabel.setStyleName("backgroundContentAction");
            deleteJobLabel.setTitle(Messages.getString("deleteThisJob"));
            if (jobSchedule.triggerState == 0) {
                actionPanel.add((Widget)suspendJobLabel);
                actionPanel.add((Widget)new HTML("&nbsp;|&nbsp;"));
            }
            if (jobSchedule.triggerState == 1) {
                actionPanel.add((Widget)resumeJobLabel);
                actionPanel.add((Widget)new HTML("&nbsp;|&nbsp;"));
            }
            if (jobSchedule.triggerState != 2) {
                actionPanel.add((Widget)runJobLabel);
            }
            if (actionPanel.getWidgetCount() == 0) {
                actionPanel.add((Widget)new HTML("&nbsp;"));
            }
            scheduleTable.setWidget(row + 1, 0, (Widget)new HTML(jobSchedule.jobName));
            scheduleTable.setWidget(row + 1, 1, (Widget)new HTML(jobSchedule.jobGroup));
            scheduleTable.setWidget(row + 1, 2, (Widget)new HTML(jobSchedule.jobDescription == null || jobSchedule.jobDescription.trim().length() == 0 ? "&nbsp;" : jobSchedule.jobDescription));
            scheduleTable.setWidget(row + 1, 3, (Widget)new HTML((jobSchedule.previousFireTime == null ? Messages.getString("never") : jobSchedule.previousFireTime.toString()) + "<BR>" + (jobSchedule.nextFireTime == null ? "-" : jobSchedule.nextFireTime.toString())));
            scheduleTable.setWidget(row + 1, 4, (Widget)new HTML(this.getTriggerStateName(jobSchedule.triggerState)));
            scheduleTable.setWidget(row + 1, 5, (Widget)actionPanel);
            scheduleTable.getCellFormatter().setStyleName(row + 1, 0, "backgroundContentTableCell");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 1, "backgroundContentTableCell");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 2, "backgroundContentTableCell");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 3, "backgroundContentTableCell");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 4, "backgroundContentTableCell");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 5, "backgroundContentTableCellRight");
            if (row != scheduleDetails.size() - 1) continue;
            scheduleTable.getCellFormatter().setStyleName(row + 1, 0, "backgroundContentTableCellBottom");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 1, "backgroundContentTableCellBottom");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 2, "backgroundContentTableCellBottom");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 3, "backgroundContentTableCellBottom");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 4, "backgroundContentTableCellBottom");
            scheduleTable.getCellFormatter().setStyleName(row + 1, 5, "backgroundContentTableCellBottomRight");
        }
    }

    private String getTriggerStateName(int state) {
        if (state == 0) {
            return Messages.getString("normal");
        }
        if (state == 1) {
            return Messages.getString("paused");
        }
        if (state == 2) {
            return Messages.getString("running");
        }
        return Messages.getString("unknown");
    }

    private void deleteContentItem(String subscriptionName, String fileId) {
        AsyncCallback<String> callback = new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotDeleteContentItem"), false, false, true);
                dialogBox.center();
            }

            public void onSuccess(String message) {
                WorkspacePanel.this.refreshWorkspace();
            }
        };
        MantleServiceCache.getService().deleteSubscriptionArchive(subscriptionName, fileId, callback);
    }

    public void refreshWorkspace() {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                WorkspacePanel.this.fetchWorkspaceContent();
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.refreshWorkspace();
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private void fetchWorkspaceContent() {
        AsyncCallback<WorkspaceContent> callback = new AsyncCallback<WorkspaceContent>(){

            public void onSuccess(WorkspaceContent result) {
                WorkspacePanel.this.waitingContentTable = WorkspacePanel.this.buildEmptyBackgroundItemTable(0);
                WorkspacePanel.this.buildJobTable(result.getScheduledJobs(), WorkspacePanel.this.waitingContentTable, WorkspacePanel.this.waitingContentDisclosure, 0);
                SimplePanel waitingWrapper = new SimplePanel();
                waitingWrapper.setStyleName("pentaho-rounded-panel-bottom-lr");
                waitingWrapper.getElement().addClassName("workspaceDisclosureContentWrapper");
                waitingWrapper.getElement().addClassName("pentaho-shadow");
                waitingWrapper.setWidget((Widget)WorkspacePanel.this.waitingContentTable);
                WorkspacePanel.this.waitingContentDisclosure.setStyleName("pentaho-disclosure-panel");
                WorkspacePanel.this.waitingContentDisclosure.setContent((Widget)waitingWrapper);
                WorkspacePanel.this.completedContentTable = WorkspacePanel.this.buildEmptyBackgroundItemTable(1);
                WorkspacePanel.this.buildJobTable(result.getCompletedJobs(), WorkspacePanel.this.completedContentTable, WorkspacePanel.this.completedContentDisclosure, 1);
                SimplePanel completedWrapper = new SimplePanel();
                completedWrapper.setStyleName("pentaho-rounded-panel-bottom-lr");
                completedWrapper.getElement().addClassName("workspaceDisclosureContentWrapper");
                completedWrapper.getElement().addClassName("pentaho-shadow");
                completedWrapper.setWidget((Widget)WorkspacePanel.this.completedContentTable);
                WorkspacePanel.this.completedContentDisclosure.setStyleName("pentaho-disclosure-panel");
                WorkspacePanel.this.completedContentDisclosure.setContent((Widget)completedWrapper);
                WorkspacePanel.this.myScheduledContentTable = WorkspacePanel.this.buildEmptyScheduleTable();
                WorkspacePanel.this.buildScheduleTable(result.getMySchedules(), WorkspacePanel.this.myScheduledContentTable, WorkspacePanel.this.myScheduledContentDisclosure, 2);
                SimplePanel myScheduledWrapper = new SimplePanel();
                myScheduledWrapper.setStyleName("pentaho-rounded-panel-bottom-lr");
                myScheduledWrapper.getElement().addClassName("workspaceDisclosureContentWrapper");
                myScheduledWrapper.getElement().addClassName("pentaho-shadow");
                myScheduledWrapper.setWidget((Widget)WorkspacePanel.this.myScheduledContentTable);
                WorkspacePanel.this.myScheduledContentDisclosure.setStyleName("pentaho-disclosure-panel");
                WorkspacePanel.this.myScheduledContentDisclosure.setContent((Widget)myScheduledWrapper);
                WorkspacePanel.this.allScheduledContentTable = WorkspacePanel.this.buildEmptyScheduleTable();
                WorkspacePanel.this.buildScheduleTable(result.getAllSchedules(), WorkspacePanel.this.allScheduledContentTable, WorkspacePanel.this.allScheduledContentDisclosure, 3);
                SimplePanel allSchedulesWrapper = new SimplePanel();
                allSchedulesWrapper.setStyleName("pentaho-rounded-panel-bottom-lr");
                allSchedulesWrapper.getElement().addClassName("workspaceDisclosureContentWrapper");
                allSchedulesWrapper.getElement().addClassName("pentaho-shadow");
                allSchedulesWrapper.setWidget((Widget)WorkspacePanel.this.allScheduledContentTable);
                WorkspacePanel.this.allScheduledContentDisclosure.setStyleName("pentaho-disclosure-panel");
                WorkspacePanel.this.allScheduledContentDisclosure.setContent((Widget)allSchedulesWrapper);
                WorkspacePanel.this.subscriptionsContentTable = WorkspacePanel.this.buildEmptySubscriptionsTable();
                WorkspacePanel.this.buildSubscriptionsTable(result.getSubscriptions(), WorkspacePanel.this.subscriptionsContentTable, WorkspacePanel.this.subscriptionsContentDisclosure);
                SimplePanel subscriptionsWrapper = new SimplePanel();
                subscriptionsWrapper.setStyleName("pentaho-rounded-panel-bottom-lr");
                subscriptionsWrapper.getElement().addClassName("workspaceDisclosureContentWrapper");
                subscriptionsWrapper.getElement().addClassName("pentaho-shadow");
                subscriptionsWrapper.setWidget((Widget)WorkspacePanel.this.subscriptionsContentTable);
                WorkspacePanel.this.subscriptionsContentDisclosure.setStyleName("pentaho-disclosure-panel");
                WorkspacePanel.this.subscriptionsContentDisclosure.setContent((Widget)subscriptionsWrapper);
            }

            public void onFailure(Throwable caught) {
            }
        };
        MantleServiceCache.getService().getWorkspaceContent(callback);
    }

    private void cancelBackgroundJob(final String jobName, final String jobGroup) {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotCancelBackgroundJob"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.fetchWorkspaceContent();
                    }
                };
                MantleServiceCache.getService().cancelBackgroundJob(jobName, jobGroup, callback);
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.cancelBackgroundJob(jobName, jobGroup);
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private void deleteContentItem(final String contentId) {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotDeleteContentItem"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.fetchWorkspaceContent();
                    }
                };
                MantleServiceCache.getService().deleteContentItem(contentId, callback);
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.deleteContentItem(contentId);
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private void suspendJob(final String jobName, final String jobGroup, final int jobSource) {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AsyncCallback<Void> callback = new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotSuspendJob"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(Void result) {
                        WorkspacePanel.this.refreshWorkspace();
                    }
                };
                MantleServiceCache.getService().suspendJob(jobName, jobGroup, callback);
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.suspendJob(jobName, jobGroup, jobSource);
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private void resumeJob(final String jobName, final String jobGroup, final int jobSource) {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AsyncCallback<Void> callback = new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotResumeJob"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(Void nothing) {
                        WorkspacePanel.this.refreshWorkspace();
                    }
                };
                MantleServiceCache.getService().resumeJob(jobName, jobGroup, callback);
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.resumeJob(jobName, jobGroup, jobSource);
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private void deleteJob(final String jobName, final String jobGroup, final int jobSource) {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AsyncCallback<Void> callback = new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotDeleteJob"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(Void nothing) {
                        WorkspacePanel.this.refreshWorkspace();
                    }
                };
                MantleServiceCache.getService().deleteJob(jobName, jobGroup, callback);
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.deleteJob(jobName, jobGroup, jobSource);
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private void runJob(final String jobName, final String jobGroup, final int jobSource) {
        AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AsyncCallback<Void> callback = new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotBackgroundExecute"), false, false, true);
                        dialogBox.center();
                    }

                    public void onSuccess(Void nothing) {
                        WorkspacePanel.this.refreshWorkspace();
                    }
                };
                MantleServiceCache.getService().runJob(jobName, jobGroup, callback);
            }

            public void onFailure(Throwable caught) {
                MantleLoginDialog.performLogin((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Boolean result) {
                        WorkspacePanel.this.runJob(jobName, jobGroup, jobSource);
                    }
                });
            }
        };
        MantleServiceCache.getService().isAuthenticated(callback);
    }

    private class DeleteSubscriptionClickHandler
    implements ClickHandler {
        SubscriptionBean subscription;
        Label lblDelete;

        public Label getLblDelete() {
            return this.lblDelete;
        }

        public void setLblDelete(Label lblDelete) {
            this.lblDelete = lblDelete;
        }

        public DeleteSubscriptionClickHandler(SubscriptionBean subscription, Label lblDelete) {
            this.subscription = subscription;
            this.lblDelete = lblDelete;
        }

        public void onClick(ClickEvent event) {
            this.lblDelete.setVisible(false);
            WorkspacePanel.this.doDelete(true, this.subscription, "");
        }
    }

    private class EditSubscriptionClickHandler
    implements ClickHandler {
        SubscriptionBean subscription;

        public EditSubscriptionClickHandler(SubscriptionBean subscription) {
            this.subscription = subscription;
        }

        public void onClick(ClickEvent event) {
            WorkspacePanel.this.performActionOnSubscription("edit", this.subscription, this.subscription.getId());
        }
    }

    private class RunSubscriptionClickHandler
    implements ClickHandler {
        SubscriptionBean subscription;

        public RunSubscriptionClickHandler(SubscriptionBean subscription) {
            this.subscription = subscription;
        }

        public void onClick(ClickEvent event) {
            WorkspacePanel.this.performActionOnSubscription("run", this.subscription, this.subscription.getId());
        }
    }

    private class RunAndArchiveClickHandler
    implements ClickHandler {
        String subscriptionId;

        public RunAndArchiveClickHandler(String subscriptionID) {
            this.subscriptionId = subscriptionID;
        }

        public void onClick(ClickEvent event) {
            WorkspacePanel.this.runAndArchive(this.subscriptionId);
        }
    }
}

