/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.toolbars;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;
import java.lang.reflect.InvocationTargetException;
import org.pentaho.mantle.client.commands.ShowBrowserCommand;
import org.pentaho.mantle.client.commands.ToggleWorkspaceCommand;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.toolbars.MainToolbarModel;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MainToolbarController
extends AbstractXulEventHandler {
    private MainToolbarModel model;
    private XulToolbarbutton openBtn;
    private XulToolbarbutton saveBtn;
    private XulToolbarbutton saveAsBtn;
    private XulToolbarbutton newAdhocBtn;
    private XulToolbarbutton newAnalysisBtn;
    private XulToolbarbutton workspaceBtn;
    private XulToolbarbutton showBrowserBtn;
    private XulToolbarbutton contentEditBtn;
    private XulToolbarbutton printBtn;
    private SolutionBrowserPerspective solutionBrowser;
    private boolean ignoreBrowserCommand;

    public MainToolbarController(SolutionBrowserPerspective solutionBrowser, MainToolbarModel model) {
        this.solutionBrowser = solutionBrowser;
        this.model = model;
    }

    @Bindable
    public void init() {
        this.openBtn = (XulToolbarbutton)this.document.getElementById("openButton");
        this.saveBtn = (XulToolbarbutton)this.document.getElementById("saveButton");
        this.saveAsBtn = (XulToolbarbutton)this.document.getElementById("saveAsButton");
        this.newAdhocBtn = (XulToolbarbutton)this.document.getElementById("newAdhocButton");
        this.newAnalysisBtn = (XulToolbarbutton)this.document.getElementById("newAnalysisButton");
        this.workspaceBtn = (XulToolbarbutton)this.document.getElementById("workspaceButton");
        this.showBrowserBtn = (XulToolbarbutton)this.document.getElementById("showBrowserButton");
        this.contentEditBtn = (XulToolbarbutton)this.document.getElementById("editContentButton");
        this.printBtn = (XulToolbarbutton)this.document.getElementById("printButton");
        GwtBindingFactory bf = new GwtBindingFactory(this.document);
        bf.createBinding((Object)this.model, "saveEnabled", (Object)this.saveBtn, "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.model, "saveAsEnabled", (Object)this.saveAsBtn, "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.model, "contentEditEnabled", (Object)this.contentEditBtn, "!disabled", new BindingConvertor[0]);
        bf.createBinding((Object)this.model, "contentEditSelected", (Object)this, "editContentSelected", new BindingConvertor[0]);
        bf.createBinding((Object)this.model, "printVisible", (Object)this.printBtn, "visible", new BindingConvertor[0]);
        Binding b = bf.createBinding((Object)this.model, "showBrowserSelected", (Object)this, "showBrowserSelected", new BindingConvertor[0]);
        try {
            b.fireSourceChanged();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void setEditContentSelected(boolean selected) {
        this.contentEditBtn.setSelected(selected, false);
    }

    @Bindable
    public void openClicked() {
        this.model.executeOpenFileCommand();
    }

    @Bindable
    public void newAnalysisClicked() {
        this.model.executeAnalysisViewCommand();
    }

    @Bindable
    public void newAdhocClicked() {
        this.model.executeWAQRCommand();
    }

    @Bindable
    public void printClicked() {
        this.model.executePrintCommand();
    }

    @Bindable
    public void saveClicked() {
        this.model.executeSaveCommand();
    }

    @Bindable
    public void saveAsClicked() {
        this.model.executeSaveAsCommand();
    }

    @Bindable
    public void workspaceClicked() {
        ToggleWorkspaceCommand toggleWorkspaceCommand = new ToggleWorkspaceCommand();
        toggleWorkspaceCommand.execute();
        this.model.setWorkspaceSelected(this.solutionBrowser.isWorkspaceShowing());
    }

    @Bindable
    public void showBrowserClicked() {
        if (this.ignoreBrowserCommand) {
            this.ignoreBrowserCommand = false;
            return;
        }
        ShowBrowserCommand showBrowserCommand = new ShowBrowserCommand();
        showBrowserCommand.execute();
    }

    @Bindable
    public void setShowBrowserSelected(boolean flag) {
        if (this.showBrowserBtn.isSelected() != flag) {
            this.ignoreBrowserCommand = true;
            this.showBrowserBtn.setSelected(flag);
        }
    }

    @Bindable
    public void setWorkspaceSelected(boolean flag) {
        this.workspaceBtn.setSelected(flag);
    }

    @Bindable
    public void setSaveEnabled(boolean flag) {
        this.saveBtn.setDisabled(!flag);
    }

    @Bindable
    public void setSaveAsEnabled(boolean flag) {
        this.saveAsBtn.setDisabled(!flag);
    }

    @Bindable
    public void setNewAnalysisEnabled(boolean flag) {
        this.newAnalysisBtn.setDisabled(!flag);
    }

    public String getName() {
        return "mainToolbarHandler";
    }

    @Bindable
    public void executeCallback(String jsScript) {
        this.executeJS(this.model.getCallback(), jsScript);
    }

    @Bindable
    public void executeMantleFunc(String funct) {
        this.executeMantleCall(funct);
    }

    private native void executeMantleCall(String var1);

    private native void executeJS(JavaScriptObject var1, String var2);

    @Bindable
    public native void openUrl(String var1, String var2, String var3);

    @Bindable
    public void setContentEditEnabled(boolean enable) {
        this.contentEditBtn.setDisabled(!enable);
    }

    @Bindable
    public void setContentEditSelected(boolean selected) {
        this.contentEditBtn.setSelected(selected);
    }

    @Bindable
    public void editContentClicked() {
        this.model.setContentEditToggled();
        this.executeEditContentCallback(SolutionBrowserPerspective.getInstance().getContentTabPanel().getCurrentFrame().getFrame().getElement(), this.model.isContentEditSelected());
    }

    private native void executeEditContentCallback(Element var1, boolean var2);

    public MainToolbarModel getModel() {
        return this.model;
    }

    public void setModel(MainToolbarModel model) {
        this.model = model;
    }

    public SolutionBrowserPerspective getSolutionBrowser() {
        return this.solutionBrowser;
    }

    public void setSolutionBrowser(SolutionBrowserPerspective solutionBrowser) {
        this.solutionBrowser = solutionBrowser;
    }
}

