/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.toolbars;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.mantle.client.XulMain;
import org.pentaho.mantle.client.commands.OpenFileCommand;
import org.pentaho.mantle.client.commands.PrintCommand;
import org.pentaho.mantle.client.commands.SaveCommand;
import org.pentaho.mantle.client.solutionbrowser.PluginOptionsHelper;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserListener;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MainToolbarModel
extends XulEventSourceAdapter
implements SolutionBrowserListener {
    private SolutionBrowserPerspective solutionBrowser;
    private XulMain main;
    private boolean saveEnabled;
    private boolean saveAsEnabled;
    private boolean newAnalysisEnabled;
    private boolean contentEditEnabled;
    private boolean contentEditSelected;
    private boolean showBrowserSelected;
    private boolean workspaceSelected;
    private boolean printVisible;
    private JavaScriptObject callback;

    public MainToolbarModel(SolutionBrowserPerspective solutionBrowser, XulMain main) {
        this.solutionBrowser = solutionBrowser;
        this.solutionBrowser.addSolutionBrowserListener(this);
        this.main = main;
    }

    @Bindable
    public void setPrintVisible(Boolean visible) {
        boolean prevVal = this.printVisible;
        this.printVisible = visible;
        this.firePropertyChange("printVisible", prevVal, this.printVisible);
    }

    @Bindable
    public boolean isPrintVisible() {
        return this.printVisible;
    }

    @Bindable
    public void setSaveEnabled(Boolean enabled) {
        boolean prevVal = this.saveEnabled;
        this.saveEnabled = enabled;
        this.firePropertyChange("saveEnabled", prevVal, this.saveEnabled);
    }

    @Bindable
    public boolean isSaveEnabled() {
        return this.saveEnabled;
    }

    @Bindable
    public void setSaveAsEnabled(Boolean enabled) {
        boolean prevVal = this.saveAsEnabled;
        this.saveAsEnabled = enabled;
        this.firePropertyChange("saveAsEnabled", prevVal, this.saveAsEnabled);
    }

    @Bindable
    public void setNewAnalysisEnabled(Boolean enabled) {
        boolean prevVal = this.newAnalysisEnabled;
        this.newAnalysisEnabled = enabled;
        this.firePropertyChange("newAnalysisEnabled", prevVal, this.newAnalysisEnabled);
    }

    @Bindable
    public void executeOpenFileCommand() {
        OpenFileCommand openFileCommand = new OpenFileCommand();
        openFileCommand.execute();
    }

    @Bindable
    public void executeAnalysisViewCommand() {
        Command analysisViewCommand = PluginOptionsHelper.getNewAnalysisViewCommand();
        analysisViewCommand.execute();
    }

    @Bindable
    public void executePrintCommand() {
        PrintCommand printCommand = new PrintCommand();
        printCommand.execute();
    }

    @Bindable
    public void executeSaveCommand() {
        SaveCommand saveCommand = new SaveCommand(false);
        saveCommand.execute();
    }

    @Bindable
    public void executeSaveAsCommand() {
        SaveCommand saveCommand = new SaveCommand(true);
        saveCommand.execute();
    }

    @Bindable
    public void executeWAQRCommand() {
        Command wAQRCommand = PluginOptionsHelper.getNewReportCommand();
        wAQRCommand.execute();
    }

    public void solutionBrowserEvent(SolutionBrowserListener.EventType type, Widget panel, FileItem selectedFileItem) {
        String selectedTabURL = null;
        boolean saveEnabled = false;
        boolean editIsEnabled = false;
        boolean editSelected = false;
        boolean printVisible = false;
        JavaScriptObject callback = null;
        if (panel != null && panel instanceof IFrameTabPanel) {
            IFrameTabPanel tbp = (IFrameTabPanel)panel;
            selectedTabURL = tbp.getUrl();
            saveEnabled = tbp.isSaveEnabled();
            editIsEnabled = tbp.isEditEnabled();
            editSelected = tbp.isEditSelected();
            printVisible = tbp.isPrintVisible();
        }
        this.setSaveEnabled(saveEnabled);
        this.setSaveAsEnabled(saveEnabled);
        this.setContentEditEnabled(editIsEnabled);
        this.setContentEditSelected(editSelected);
        this.setPrintVisible(printVisible);
        this.setCallback(callback);
        this.setWorkspaceSelected(this.solutionBrowser.isWorkspaceShowing());
        this.setShowBrowserSelected(this.solutionBrowser.isNavigatorShowing());
        if (panel instanceof IFrameTabPanel) {
            if (SolutionBrowserListener.EventType.OPEN.equals((Object)type) || SolutionBrowserListener.EventType.SELECT.equals((Object)type)) {
                if (panel != null) {
                    this.main.applyOverlays(((IFrameTabPanel)panel).getOverlayIds());
                }
            } else if ((SolutionBrowserListener.EventType.CLOSE.equals((Object)type) || SolutionBrowserListener.EventType.DESELECT.equals((Object)type)) && panel != null) {
                this.main.removeOverlays(((IFrameTabPanel)panel).getOverlayIds());
            }
        }
    }

    @Bindable
    public boolean isShowBrowserSelected() {
        return this.showBrowserSelected;
    }

    @Bindable
    public boolean isWorkspaceSelected() {
        return this.workspaceSelected;
    }

    @Bindable
    public void setShowBrowserSelected(boolean showBrowserSelected) {
        boolean prevVal = this.showBrowserSelected;
        this.showBrowserSelected = showBrowserSelected;
        this.firePropertyChange("showBrowserSelected", prevVal, showBrowserSelected);
    }

    @Bindable
    public void setWorkspaceSelected(boolean workspaceSelected) {
        boolean prevVal = this.workspaceSelected;
        this.workspaceSelected = workspaceSelected;
        this.firePropertyChange("workspaceSelected", prevVal, workspaceSelected);
    }

    @Bindable
    public void setContentEditEnabled(boolean enable) {
        boolean prevVal = this.contentEditEnabled;
        this.contentEditEnabled = enable;
        this.firePropertyChange("contentEditEnabled", prevVal, this.contentEditEnabled);
    }

    @Bindable
    public void setContentEditSelected(boolean selected) {
        boolean prevVal = this.contentEditSelected;
        this.contentEditSelected = selected;
        this.firePropertyChange("contentEditSelected", prevVal, this.contentEditSelected);
    }

    @Bindable
    public boolean isContentEditSelected() {
        return this.contentEditSelected;
    }

    @Bindable
    public void setContentEditToggled() {
        this.setContentEditSelected(!this.contentEditSelected);
    }

    @Bindable
    public boolean isContentEditEnabled() {
        return this.contentEditEnabled;
    }

    public JavaScriptObject getCallback() {
        return this.callback;
    }

    public void setCallback(JavaScriptObject callback) {
        this.callback = callback;
    }
}

