/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.ui;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.tabs.PentahoTab;
import org.pentaho.gwt.widgets.client.tabs.PentahoTabPanel;
import org.pentaho.gwt.widgets.client.utils.FrameUtils;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.solutionbrowser.MantlePopupPanel;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;
import org.pentaho.mantle.client.ui.MantleTabPanel;

public class MantleTab
extends PentahoTab {
    private PopupPanel popupMenu = new MantlePopupPanel(true);

    public void createDeepLink() {
        if (this.getContent() instanceof IFrameTabPanel) {
            PromptDialogBox dialogBox = new PromptDialogBox(Messages.getString("deepLink"), Messages.getString("ok"), Messages.getString("cancel"), false, true);
            String url = Window.Location.getProtocol() + "//" + Window.Location.getHostName() + ":" + Window.Location.getPort() + Window.Location.getPath() + "?name=" + this.getLabelText() + "&startup-url=";
            String startup = ((IFrameTabPanel)this.getContent()).getUrl();
            final TextArea urlbox = new TextArea();
            urlbox.setText(url + URL.encodeComponent((String)startup));
            urlbox.setReadOnly(true);
            urlbox.setVisibleLines(3);
            dialogBox.setContent((Widget)urlbox);
            urlbox.setHeight("80px");
            urlbox.setWidth("600px");
            urlbox.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    urlbox.selectAll();
                }
            });
            dialogBox.center();
            urlbox.selectAll();
        }
    }

    public void openTabInNewWindow() {
        if (this.getContent() instanceof IFrameTabPanel) {
            VerticalPanel vp = new VerticalPanel();
            vp.add((Widget)new Label(Messages.getString("openWindowQuestion")));
            final PromptDialogBox openNewWindowConfirmDialog = new PromptDialogBox(Messages.getString("openWindowConfirm"), Messages.getString("yes"), Messages.getString("no"), false, true, (Widget)vp);
            IDialogCallback callback = new IDialogCallback(){

                public void cancelPressed() {
                    openNewWindowConfirmDialog.hide();
                }

                public void okPressed() {
                    ((IFrameTabPanel)MantleTab.this.getContent()).openTabInNewWindow();
                    openNewWindowConfirmDialog.hide();
                }
            };
            openNewWindowConfirmDialog.setCallback(callback);
            openNewWindowConfirmDialog.center();
        }
    }

    public void back() {
        ((IFrameTabPanel)this.getContent()).back();
    }

    public void reloadTab() {
        if (this.getContent() instanceof IFrameTabPanel) {
            VerticalPanel vp = new VerticalPanel();
            vp.add((Widget)new Label(Messages.getString("reloadQuestion")));
            final PromptDialogBox reloadConfirmDialog = new PromptDialogBox(Messages.getString("reloadConfirm"), Messages.getString("yes"), Messages.getString("no"), false, true, (Widget)vp);
            IDialogCallback callback = new IDialogCallback(){

                public void cancelPressed() {
                    reloadConfirmDialog.hide();
                }

                public void okPressed() {
                    ((IFrameTabPanel)MantleTab.this.getContent()).reload();
                    reloadConfirmDialog.hide();
                }
            };
            reloadConfirmDialog.setCallback(callback);
            reloadConfirmDialog.center();
        }
    }

    public void reloadAllTabs() {
        for (int i = 0; i < this.getTabPanel().getTabCount(); ++i) {
            if (!(this.getTabPanel().getTab(i).getContent() instanceof IFrameTabPanel)) continue;
            ((IFrameTabPanel)this.getTabPanel().getTab(i).getContent()).reload();
        }
    }

    public MantleTab(String text, String tooltip, MantleTabPanel tabPanel, Widget content, boolean closeable) {
        super(text, tooltip, (PentahoTabPanel)tabPanel, content, closeable);
        this.popupMenu.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                FrameUtils.setEmbedVisibility((Frame)((IFrameTabPanel)MantleTab.this.getTabPanel().getSelectedTab().getContent()).getFrame(), (boolean)true);
                new Timer(){

                    public void run() {
                        MantleTab.this.getContent().getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
                    }
                }.schedule(250);
            }
        });
    }

    public void onDoubleClick(Event event) {
        this.openTabInNewWindow();
    }

    public void onRightClick(Event event) {
        MenuItem closeAllTabsMenuItem;
        MenuItem closeOtherTabsMenuItem;
        MenuItem reloadAllTabsMenuItem;
        FrameUtils.setEmbedVisibility((Frame)((IFrameTabPanel)this.getTabPanel().getSelectedTab().getContent()).getFrame(), (boolean)false);
        int left = Window.getScrollLeft() + DOM.eventGetClientX((Event)event);
        int top = Window.getScrollTop() + DOM.eventGetClientY((Event)event);
        this.popupMenu.setPopupPosition(left, top);
        MenuBar menuBar = new MenuBar(true);
        menuBar.setAutoOpen(true);
        if (this.getContent() instanceof IFrameTabPanel) {
            MenuItem backMenuItem = new MenuItem(Messages.getString("back"), (Command)new TabCommand(TABCOMMANDTYPE.BACK, this.popupMenu));
            menuBar.addItem(backMenuItem);
            backMenuItem.getElement().setId("back");
            menuBar.addSeparator();
            MenuItem reloadTabMenuItem = new MenuItem(Messages.getString("reloadTab"), (Command)new TabCommand(TABCOMMANDTYPE.RELOAD, this.popupMenu));
            menuBar.addItem(reloadTabMenuItem);
            reloadTabMenuItem.getElement().setId("reloadTab");
        }
        if (this.getTabPanel().getTabCount() > 1) {
            reloadAllTabsMenuItem = new MenuItem(Messages.getString("reloadAllTabs"), (Command)new TabCommand(TABCOMMANDTYPE.RELOAD_ALL, this.popupMenu));
            menuBar.addItem(reloadAllTabsMenuItem);
            reloadAllTabsMenuItem.getElement().setId("reloadAllTabs");
        } else {
            reloadAllTabsMenuItem = new MenuItem(Messages.getString("reloadAllTabs"), (Command)null);
            menuBar.addItem(reloadAllTabsMenuItem);
            reloadAllTabsMenuItem.getElement().setId("reloadAllTabs");
            reloadAllTabsMenuItem.setStyleName("disabledMenuItem");
        }
        menuBar.addSeparator();
        if (this.getContent() instanceof IFrameTabPanel) {
            MenuItem openTabInNewWindowMenuItem = new MenuItem(Messages.getString("openTabInNewWindow"), (Command)new TabCommand(TABCOMMANDTYPE.NEW_WINDOW, this.popupMenu));
            menuBar.addItem(openTabInNewWindowMenuItem);
            openTabInNewWindowMenuItem.getElement().setId("openTabInNewWindow");
            MenuItem createDeepLinkMenuItem = new MenuItem(Messages.getString("createDeepLink"), (Command)new TabCommand(TABCOMMANDTYPE.CREATE_DEEP_LINK, this.popupMenu));
            menuBar.addItem(createDeepLinkMenuItem);
            createDeepLinkMenuItem.getElement().setId("deepLink");
            menuBar.addSeparator();
        }
        menuBar.addItem(new MenuItem(Messages.getString("closeTab"), (Command)new TabCommand(TABCOMMANDTYPE.CLOSE, this.popupMenu)));
        if (this.getTabPanel().getTabCount() > 1) {
            closeOtherTabsMenuItem = new MenuItem(Messages.getString("closeOtherTabs"), (Command)new TabCommand(TABCOMMANDTYPE.CLOSE_OTHERS, this.popupMenu));
            menuBar.addItem(closeOtherTabsMenuItem);
            closeOtherTabsMenuItem.getElement().setId("closeOtherTabs");
            closeAllTabsMenuItem = new MenuItem(Messages.getString("closeAllTabs"), (Command)new TabCommand(TABCOMMANDTYPE.CLOSE_ALL, this.popupMenu));
            menuBar.addItem(closeAllTabsMenuItem);
            closeAllTabsMenuItem.getElement().setId("closeAllTabs");
        } else {
            closeOtherTabsMenuItem = new MenuItem(Messages.getString("closeOtherTabs"), (Command)null);
            closeOtherTabsMenuItem.setStyleName("disabledMenuItem");
            closeAllTabsMenuItem = new MenuItem(Messages.getString("closeAllTabs"), (Command)null);
            closeAllTabsMenuItem.setStyleName("disabledMenuItem");
            menuBar.addItem(closeOtherTabsMenuItem);
            menuBar.addItem(closeAllTabsMenuItem);
            closeOtherTabsMenuItem.getElement().setId("closeOtherTabs");
            closeAllTabsMenuItem.getElement().setId("closeAllTabs");
        }
        this.popupMenu.setWidget((Widget)menuBar);
        this.popupMenu.hide();
        this.popupMenu.show();
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        if (this.getContent() instanceof IFrameTabPanel) {
            ((IFrameTabPanel)this.getContent()).setId(text + System.currentTimeMillis());
        }
    }

    private class TabCommand
    implements Command {
        TABCOMMANDTYPE mode = TABCOMMANDTYPE.RELOAD;
        PopupPanel popupMenu;

        public TabCommand(TABCOMMANDTYPE inMode, PopupPanel popupMenu) {
            this.mode = inMode;
            this.popupMenu = popupMenu;
        }

        public void execute() {
            this.popupMenu.hide();
            if (this.mode == TABCOMMANDTYPE.RELOAD) {
                MantleTab.this.reloadTab();
            } else if (this.mode == TABCOMMANDTYPE.RELOAD_ALL) {
                MantleTab.this.reloadAllTabs();
            } else if (this.mode == TABCOMMANDTYPE.CLOSE) {
                MantleTab.this.closeTab();
            } else if (this.mode == TABCOMMANDTYPE.CLOSE_OTHERS) {
                MantleTab.this.getTabPanel().closeOtherTabs((PentahoTab)MantleTab.this);
            } else if (this.mode == TABCOMMANDTYPE.CLOSE_ALL) {
                MantleTab.this.getTabPanel().closeAllTabs();
            } else if (this.mode == TABCOMMANDTYPE.NEW_WINDOW) {
                MantleTab.this.openTabInNewWindow();
            } else if (this.mode == TABCOMMANDTYPE.CREATE_DEEP_LINK) {
                MantleTab.this.createDeepLink();
            } else if (this.mode == TABCOMMANDTYPE.BACK) {
                MantleTab.this.back();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TABCOMMANDTYPE {
        BACK,
        RELOAD,
        RELOAD_ALL,
        CLOSE,
        CLOSE_ALL,
        CLOSE_OTHERS,
        NEW_WINDOW,
        CREATE_DEEP_LINK;

    }
}

