/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.tabs.PentahoTab;
import org.pentaho.gwt.widgets.client.tabs.PentahoTabPanel;
import org.pentaho.gwt.widgets.client.utils.FrameUtils;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.mantle.client.dialogs.WaitPopup;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserListener;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;
import org.pentaho.mantle.client.solutionbrowser.filelist.FileItem;
import org.pentaho.mantle.client.solutionbrowser.tabs.IFrameTabPanel;
import org.pentaho.mantle.client.ui.MantleTab;

public class MantleTabPanel
extends PentahoTabPanel {
    final PopupPanel waitPopup = new PopupPanel(false, true);
    private static final String FRAME_ID_PRE = "frame_";
    private static int frameIdCount = 0;

    public MantleTabPanel() {
        this(false);
    }

    public MantleTabPanel(boolean setupNativeHooks) {
        if (setupNativeHooks) {
            this.setupNativeHooks(this);
        }
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                if (MantleTabPanel.this.getTabCount() > 0) {
                    for (int i = 0; i < MantleTabPanel.this.getTabCount(); ++i) {
                        com.google.gwt.user.client.Element frameElement = MantleTabPanel.this.getFrameElement(MantleTabPanel.this.getTab(i));
                        if (!MantleTabPanel.hasUnsavedChanges(frameElement)) continue;
                        event.setMessage(Messages.getString("windowCloseWarning"));
                        return;
                    }
                }
            }
        });
    }

    public void addTab(String text, String tooltip, boolean closeable, Widget content) {
        MantleTab tab = new MantleTab(text, tooltip, this, content, closeable);
        this.getTabBar().add((Widget)tab);
        this.getTabDeck().add(content);
        if (this.getSelectedTab() == null) {
            this.selectTab(tab);
        }
    }

    public void showNewURLTab(String tabName, String tabTooltip, String url, boolean setFileInfoInFrame, String frameName) {
        this.showLoadingIndicator();
        if (url.indexOf("http") != 0 && url.indexOf("/") != 0) {
            url = GWT.getHostPageBaseURL() + url;
        }
        int elementId = this.getTabCount();
        if (frameName == null || "".equals(frameName.trim())) {
            frameName = this.getUniqueFrameName();
        }
        if (this.existingTabMatchesName(tabName)) {
            int counter = 2;
            while (this.existingTabMatchesName(tabName + " (" + counter + ")")) {
                ++counter;
            }
            tabName = tabName + " (" + counter + ")";
            tabTooltip = tabTooltip + " (" + counter + ")";
        }
        IFrameTabPanel panel = new IFrameTabPanel(frameName);
        this.addTab(tabName, tabTooltip, true, (Widget)panel);
        this.selectTab(elementId);
        if (url.indexOf("content/") == -1) {
            panel.getElement().addClassName("mantle-default-tab-background");
        }
        ArrayList<com.google.gwt.user.client.Element> parentList = new ArrayList<com.google.gwt.user.client.Element>();
        for (com.google.gwt.user.client.Element parent = panel.getFrame().getElement(); parent != this.getElement(); parent = parent.getParentElement()) {
            parentList.add(parent);
        }
        Collections.reverse(parentList);
        for (int i = 1; i < parentList.size(); ++i) {
            ((Element)parentList.get(i)).getStyle().setProperty("height", "100%");
        }
        SolutionBrowserPerspective.getInstance().showContent();
        SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.OPEN, this.getSelectedTabIndex());
        panel.setUrl(url);
        SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.SELECT, this.getSelectedTabIndex());
        if (setFileInfoInFrame) {
            this.setFileInfoInFrame(SolutionBrowserPerspective.getInstance().getFilesListPanel().getSelectedFileItem());
        }
        Timer t = new Timer(){

            public void run() {
                com.google.gwt.user.client.Element frameElement = MantleTabPanel.this.getFrameElement(MantleTabPanel.this.getSelectedTab());
                if (MantleTabPanel.supportsReadyFeedback(frameElement)) {
                    this.cancel();
                } else if ("complete".equalsIgnoreCase(MantleTabPanel.getReadyState(frameElement))) {
                    MantleTabPanel.this.hideLoadingIndicator();
                    this.cancel();
                } else if (StringUtils.isEmpty((String)MantleTabPanel.getReadyState(frameElement)) || "undefined".equals(MantleTabPanel.getReadyState(frameElement))) {
                    MantleTabPanel.this.hideLoadingIndicator();
                    this.cancel();
                }
            }
        };
        t.scheduleRepeating(1000);
    }

    private void showNewURLTab(String tabName, String tabTooltip, String url) {
        this.showNewURLTab(tabName, tabTooltip, url, false);
    }

    private void showNewNamedFrameURLTab(String tabName, String tabTooltip, String frameName, String url) {
        this.showNewURLTab(tabName, tabTooltip, url, false, frameName);
    }

    public void showNewURLTab(String tabName, String tabTooltip, String url, boolean setFileInfoInFrame) {
        this.showNewURLTab(tabName, tabTooltip, url, setFileInfoInFrame, null);
    }

    private String getUniqueFrameName() {
        return FRAME_ID_PRE + frameIdCount++;
    }

    public boolean existingTabMatchesName(String name) {
        name = name.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;");
        String key = ">" + name + "<";
        NodeList divs = this.getTabBar().getElement().getElementsByTagName("div");
        for (int i = 0; i < divs.getLength(); ++i) {
            String tabHtml = ((Element)divs.getItem(i)).getInnerHTML();
            if (tabHtml.indexOf(key) <= -1) continue;
            return true;
        }
        return false;
    }

    private native void setupNativeHooks(MantleTabPanel var1);

    public void showLoadingIndicator() {
        WaitPopup.getInstance().setVisible(true);
    }

    public void hideLoadingIndicator() {
        WaitPopup.getInstance().setVisible(false);
    }

    public void setCurrentTabSaveEnabled(boolean enabled) {
        IFrameTabPanel panel = this.getCurrentFrame();
        if (panel != null) {
            panel.setSaveEnabled(enabled);
            SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.SELECT, this.getSelectedTabIndex());
        }
    }

    public void registerContentOverlay(String id) {
        IFrameTabPanel panel = this.getCurrentFrame();
        if (panel != null) {
            panel.addOverlay(id);
            SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.OPEN, this.getSelectedTabIndex());
        }
    }

    public void enableContentEdit(boolean enable) {
        IFrameTabPanel panel = this.getCurrentFrame();
        if (panel != null) {
            panel.setEditEnabled(enable);
            SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.UNDEFINED, this.getSelectedTabIndex());
        }
    }

    public void setContentEditSelected(boolean selected) {
        IFrameTabPanel panel = this.getCurrentFrame();
        if (panel != null) {
            panel.setEditSelected(selected);
            SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.UNDEFINED, this.getSelectedTabIndex());
        }
    }

    public void setFileInfoInFrame(FileItem selectedFileItem) {
        IFrameTabPanel tp = this.getCurrentFrame();
        if (tp != null && selectedFileItem != null) {
            SolutionFileInfo fileInfo = new SolutionFileInfo();
            fileInfo.setName(selectedFileItem.getName());
            fileInfo.setSolution(selectedFileItem.getSolution());
            fileInfo.setPath(selectedFileItem.getPath());
            tp.setFileInfo(fileInfo);
        }
    }

    public IFrameTabPanel getCurrentFrame() {
        return this.getFrame(this.getSelectedTab());
    }

    public IFrameTabPanel getFrame(PentahoTab tab) {
        if (tab != null && tab.getContent() instanceof IFrameTabPanel) {
            return (IFrameTabPanel)tab.getContent();
        }
        return null;
    }

    public com.google.gwt.user.client.Element getFrameElement(PentahoTab tab) {
        if (this.getFrame(tab) != null && this.getFrame(tab) instanceof IFrameTabPanel) {
            return this.getFrame(tab).getFrame().getElement();
        }
        return null;
    }

    public String getCurrentFrameElementId() {
        if (this.getCurrentFrame() == null) {
            return null;
        }
        return this.getCurrentFrame().getFrame().getElement().getAttribute("id");
    }

    public static native String getReadyState(com.google.gwt.user.client.Element var0);

    public static native boolean supportsReadyFeedback(com.google.gwt.user.client.Element var0);

    public static native boolean hasUnsavedChanges(com.google.gwt.user.client.Element var0);

    public static native boolean preTabCloseHook(com.google.gwt.user.client.Element var0);

    public void closeTab(final PentahoTab closeTab, final boolean invokePreTabCloseHook) {
        if (closeTab.getContent() instanceof IFrameTabPanel) {
            final com.google.gwt.user.client.Element frameElement = ((IFrameTabPanel)closeTab.getContent()).getFrame().getElement();
            if (invokePreTabCloseHook && MantleTabPanel.hasUnsavedChanges(frameElement)) {
                VerticalPanel vp = new VerticalPanel();
                vp.add((Widget)new Label(Messages.getString("confirmTabClose")));
                PromptDialogBox confirmDialog = new PromptDialogBox(Messages.getString("confirm"), Messages.getString("yes"), Messages.getString("no"), false, true, (Widget)vp);
                confirmDialog.setCallback(new IDialogCallback(){

                    public void cancelPressed() {
                    }

                    public void okPressed() {
                        MantleTabPanel.clearClosingFrame(frameElement);
                        MantleTabPanel.super.closeTab(closeTab, invokePreTabCloseHook);
                        if (MantleTabPanel.this.getTabCount() == 0) {
                            SolutionBrowserPerspective.getInstance().showContent();
                            SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.CLOSE, -1);
                        }
                    }
                });
                confirmDialog.center();
                return;
            }
            MantleTabPanel.clearClosingFrame(frameElement);
        }
        super.closeTab(closeTab, invokePreTabCloseHook);
        if (this.getTabCount() == 0) {
            SolutionBrowserPerspective.getInstance().showContent();
            SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.CLOSE, -1);
        }
    }

    public static native void clearClosingFrame(com.google.gwt.user.client.Element var0);

    private void closeTab(String url) {
        int curpos = this.getSelectedTabIndex();
        if (StringUtils.isEmpty((String)url)) {
            if (curpos >= 0 && this.getTabCount() > 0) {
                this.closeTab(curpos, true);
            }
            return;
        }
        IFrameTabPanel curPanel = (IFrameTabPanel)this.getTab(curpos).getContent();
        if (url.contains(curPanel.getUrl())) {
            this.closeTab(curpos, true);
            return;
        }
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            curPanel = (IFrameTabPanel)this.getTab(i).getContent();
            if (!url.contains(curPanel.getUrl())) continue;
            this.closeTab(i, true);
            return;
        }
    }

    public void closeOtherTabs(PentahoTab exceptThisTab) {
        while (exceptThisTab != this.getTab(0)) {
            this.closeTab(this.getTab(0), true);
        }
        while (exceptThisTab != this.getTab(this.getTabCount() - 1)) {
            this.closeTab(this.getTab(this.getTabCount() - 1), true);
        }
        this.selectTab(exceptThisTab);
    }

    public void closeAllTabs() {
        ArrayList<PentahoTab> tabs = new ArrayList<PentahoTab>(this.getTabCount());
        for (int i = 0; i < this.getTabCount(); ++i) {
            tabs.add(this.getTab(i));
        }
        for (PentahoTab tab : tabs) {
            this.closeTab(tab, true);
        }
    }

    public void selectTab(PentahoTab selectedTab) {
        super.selectTab(selectedTab);
        if (selectedTab == null) {
            return;
        }
        SolutionBrowserPerspective.getInstance().fireSolutionBrowserListenerEvent(SolutionBrowserListener.EventType.SELECT, this.getSelectedTabIndex());
        Window.setTitle((String)(Messages.getString("productName") + " - " + selectedTab.getLabelText()));
        for (int i = 0; i < this.getTabCount(); ++i) {
            PentahoTab tab = this.getTab(i);
            if (!(tab.getContent() instanceof IFrameTabPanel) || tab.getContent() == selectedTab.getContent()) continue;
            FrameUtils.setEmbedVisibility((Frame)((IFrameTabPanel)tab.getContent()).getFrame(), (boolean)false);
        }
        if (selectedTab.getContent() instanceof IFrameTabPanel) {
            FrameUtils.setEmbedVisibility((Frame)((IFrameTabPanel)selectedTab.getContent()).getFrame(), (boolean)true);
            this.ieFix(((IFrameTabPanel)selectedTab.getContent()).getFrame().getElement());
        }
    }

    private native void ieFix(com.google.gwt.user.client.Element var1);
}

