/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.usersettings;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.usersettings.IMantleSettingsListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MantleSettingsManager {
    private ArrayList<IMantleSettingsListener> listeners = new ArrayList();
    private HashMap<String, String> settings;
    private boolean isAdministrator = false;
    private static MantleSettingsManager instance;

    private MantleSettingsManager() {
    }

    public static MantleSettingsManager getInstance() {
        if (instance == null) {
            instance = new MantleSettingsManager();
        }
        return instance;
    }

    public void addMantleSettingsListener(IMantleSettingsListener listener) {
        this.listeners.add(listener);
        if (this.settings == null) {
            this.fetchMantleSettings(true);
        }
    }

    public void removeMantleSettingsListener(IMantleSettingsListener listener) {
        this.listeners.remove(listener);
    }

    public void fireMantleSettingsFetched() {
        for (IMantleSettingsListener listener : this.listeners) {
            listener.onFetchMantleSettings(this.settings);
        }
    }

    public void fetchMantleSettings(boolean forceReload) {
        if (forceReload || this.settings == null) {
            this.fetchMantleSettings(null);
        }
    }

    public void fetchMantleSettings(AsyncCallback<HashMap<String, String>> callback, boolean forceReload) {
        if (forceReload || this.settings == null) {
            this.fetchMantleSettings(callback);
        } else {
            callback.onSuccess(this.settings);
        }
    }

    public void fetchMantleSettings(final AsyncCallback<HashMap<String, String>> callback) {
        AsyncCallback<HashMap<String, String>> internalCallback = new AsyncCallback<HashMap<String, String>>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialog = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetUserSettings"), true, false, true);
                dialog.center();
            }

            public void onSuccess(HashMap<String, String> settings) {
                MantleSettingsManager.getInstance().settings = settings;
                settings.put("is-administrator", "" + MantleSettingsManager.this.isAdministrator);
                if (callback != null) {
                    callback.onSuccess(settings);
                }
                MantleSettingsManager.this.fireMantleSettingsFetched();
            }
        };
        AsyncCallback<Boolean> isAdministratorCallback = new AsyncCallback<Boolean>((AsyncCallback)internalCallback){
            final /* synthetic */ AsyncCallback val$internalCallback;
            {
                this.val$internalCallback = asyncCallback;
            }

            public void onSuccess(Boolean isAdministrator) {
                MantleServiceCache.getService().getMantleSettings((AsyncCallback<HashMap<String, String>>)this.val$internalCallback);
                MantleSettingsManager.getInstance().isAdministrator = isAdministrator;
            }

            public void onFailure(Throwable caught) {
                MantleServiceCache.getService().getMantleSettings((AsyncCallback<HashMap<String, String>>)this.val$internalCallback);
                MantleSettingsManager.getInstance().isAdministrator = false;
            }
        };
        MantleServiceCache.getService().isAdministrator(isAdministratorCallback);
    }
}

