/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.usersettings;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.usersettings.IUserSettingsListener;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSettingsManager {
    private ArrayList<IUserSettingsListener> listeners = new ArrayList();
    private ArrayList<IUserSetting> settings;
    private static UserSettingsManager instance;

    private UserSettingsManager() {
    }

    public static UserSettingsManager getInstance() {
        if (instance == null) {
            instance = new UserSettingsManager();
        }
        return instance;
    }

    public void addUserSettingsListener(IUserSettingsListener listener) {
        this.listeners.add(listener);
        if (this.settings == null) {
            this.fetchUserSettings(true);
        }
    }

    public void removeUserSettingsListener(IUserSettingsListener listener) {
        this.listeners.remove(listener);
    }

    public void fireUserSettingsFetched() {
        for (IUserSettingsListener listener : this.listeners) {
            listener.onFetchUserSettings(this.settings);
        }
    }

    public void fetchUserSettings(boolean forceReload) {
        if (forceReload || this.settings == null) {
            this.fetchUserSettings(null);
        }
    }

    public void fetchUserSettings(AsyncCallback<ArrayList<IUserSetting>> callback, boolean forceReload) {
        if (forceReload || this.settings == null) {
            this.fetchUserSettings(callback);
        } else {
            callback.onSuccess(this.settings);
        }
    }

    public void fetchUserSettings(final AsyncCallback<ArrayList<IUserSetting>> callback) {
        AsyncCallback<ArrayList<IUserSetting>> internalCallback = new AsyncCallback<ArrayList<IUserSetting>>(){

            public void onFailure(Throwable caught) {
                MessageDialogBox dialog = new MessageDialogBox(Messages.getString("error"), Messages.getString("couldNotGetUserSettings"), true, false, true);
                dialog.center();
            }

            public void onSuccess(ArrayList<IUserSetting> settings) {
                UserSettingsManager.getInstance().settings = settings;
                if (callback != null) {
                    callback.onSuccess(settings);
                }
                UserSettingsManager.this.fireUserSettingsFetched();
            }
        };
        MantleServiceCache.getService().getUserSettings(internalCallback);
    }
}

