/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.usersettings.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.service.MantleServiceCache;
import org.pentaho.mantle.client.usersettings.UserSettingsManager;
import org.pentaho.mantle.client.usersettings.ui.UserPreferencesPanel;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;

public class RepositoryPanel
extends UserPreferencesPanel {
    VerticalPanel content = new VerticalPanel();
    CheckBox showNavigatorCB = new CheckBox();
    CheckBox showLocalizedFileNamesCB = new CheckBox();
    CheckBox showHiddenFilesCB = new CheckBox();
    boolean showNavigator = true;
    boolean showLocalizedFileNames = true;
    boolean showHiddenFiles = false;

    public RepositoryPanel() {
        this.init();
    }

    public void init() {
        this.content.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.content.setWidth("100%");
        ScrollPanel scroller = new ScrollPanel();
        scroller.add((Widget)this.content);
        this.add((Widget)scroller);
        scroller.setHeight("400px");
        scroller.setWidth("400px");
        this.showNavigatorCB.setText(Messages.getString("showSolutionBrowser"));
        this.showLocalizedFileNamesCB.setText(Messages.getString("showLocalizedFileNames"));
        this.showHiddenFilesCB.setText(Messages.getString("showHiddenFiles"));
        this.loadAndApplyUserSettings();
    }

    public void loadAndApplyUserSettings() {
        AsyncCallback<ArrayList<IUserSetting>> callback = new AsyncCallback<ArrayList<IUserSetting>>(){

            public void onFailure(Throwable caught) {
                caught.printStackTrace();
            }

            public void onSuccess(ArrayList<IUserSetting> settings) {
                RepositoryPanel.this.content.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
                RepositoryPanel.this.content.add((Widget)RepositoryPanel.this.showNavigatorCB);
                RepositoryPanel.this.content.add((Widget)RepositoryPanel.this.showLocalizedFileNamesCB);
                RepositoryPanel.this.content.add((Widget)RepositoryPanel.this.showHiddenFilesCB);
                for (IUserSetting setting : settings) {
                    if ("MANTLE_SHOW_NAVIGATOR".equals(setting.getSettingName())) {
                        RepositoryPanel.this.showNavigator = "true".equals(setting.getSettingValue());
                    } else if ("MANTLE_SHOW_LOCALIZED_FILENAMES".equals(setting.getSettingName())) {
                        RepositoryPanel.this.showLocalizedFileNames = "true".equals(setting.getSettingValue());
                    } else if ("MANTLE_SHOW_HIDDEN_FILES".equals(setting.getSettingName())) {
                        RepositoryPanel.this.showHiddenFiles = "true".equals(setting.getSettingValue());
                    }
                    RepositoryPanel.this.showLocalizedFileNamesCB.setValue(Boolean.valueOf(RepositoryPanel.this.showLocalizedFileNames));
                    RepositoryPanel.this.showHiddenFilesCB.setValue(Boolean.valueOf(RepositoryPanel.this.showHiddenFiles));
                    RepositoryPanel.this.showNavigatorCB.setValue(Boolean.valueOf(RepositoryPanel.this.showNavigator));
                }
            }
        };
        UserSettingsManager.getInstance().fetchUserSettings(callback, false);
    }

    public void setShowHiddenFiles(boolean show) {
        AsyncCallback callback = new AsyncCallback(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Object result) {
            }
        };
        MantleServiceCache.getService().setShowHiddenFiles(show, (AsyncCallback<Void>)callback);
    }

    public void setShowLocalizedFileNames(boolean show) {
        AsyncCallback callback = new AsyncCallback(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Object result) {
            }
        };
        MantleServiceCache.getService().setShowLocalizedFileNames(show, (AsyncCallback<Void>)callback);
    }

    public void setShowNavigator(boolean show) {
        AsyncCallback callback = new AsyncCallback(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Object result) {
            }
        };
        MantleServiceCache.getService().setShowNavigator(show, (AsyncCallback<Void>)callback);
    }

    public boolean onApply() {
        boolean anythingSet = false;
        if (this.showHiddenFilesCB.isChecked() != this.showHiddenFiles) {
            this.setShowHiddenFiles(this.showHiddenFilesCB.isChecked());
            anythingSet = true;
        }
        if (this.showNavigatorCB.isChecked() != this.showNavigator) {
            this.setShowNavigator(this.showNavigatorCB.isChecked());
            anythingSet = true;
        }
        if (this.showLocalizedFileNamesCB.isChecked() != this.showLocalizedFileNames) {
            this.setShowLocalizedFileNames(this.showLocalizedFileNamesCB.isChecked());
            anythingSet = true;
        }
        if (anythingSet) {
            MessageDialogBox dialogBox = new MessageDialogBox(Messages.getString("info"), Messages.getString("preferencesSetSuccess"), true, false, true);
            dialogBox.center();
        }
        return true;
    }

    public void onCancel() {
    }
}

