/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.client.usersettings.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.IDialogValidatorCallback;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.mantle.client.messages.Messages;
import org.pentaho.mantle.client.usersettings.ui.RepositoryPanel;
import org.pentaho.mantle.client.usersettings.ui.UserPreferencesPanel;

public class UserPreferencesDialog
extends PromptDialogBox
implements ChangeHandler,
IDialogValidatorCallback,
IDialogCallback {
    VerticalPanel preferencesContent = new VerticalPanel();
    ListBox preferencesList = new ListBox();
    HashMap<String, UserPreferencesPanel> preferencesPanelMap = new HashMap();
    PREFERENCE initialSelectedPreference = PREFERENCE.STYLES;

    public UserPreferencesDialog(PREFERENCE initialSelectedPreference) {
        super(Messages.getString("userPreferences"), Messages.getString("ok"), Messages.getString("cancel"), false, true, (Widget)new HorizontalPanel());
        this.setCallback(this);
        this.setValidatorCallback(this);
        this.initialSelectedPreference = initialSelectedPreference;
        this.init();
    }

    public void init() {
        this.preferencesPanelMap.put(Messages.getString("repository"), new RepositoryPanel());
        HorizontalPanel content = (HorizontalPanel)this.getContent();
        content.setSpacing(10);
        content.add((Widget)this.preferencesList);
        content.add((Widget)this.preferencesContent);
        this.preferencesList.setVisibleItemCount(10);
        this.preferencesList.setWidth("120px");
        for (String key : this.preferencesPanelMap.keySet()) {
            this.preferencesList.addItem(key);
        }
        this.preferencesList.addChangeHandler((ChangeHandler)this);
        for (int i = 0; i < this.preferencesList.getItemCount(); ++i) {
            String item = this.preferencesList.getItemText(i);
            if (this.initialSelectedPreference.equals((Object)PREFERENCE.STYLES) && item.equalsIgnoreCase(Messages.getString("styles"))) {
                this.preferencesList.setSelectedIndex(i);
                continue;
            }
            if (this.initialSelectedPreference.equals((Object)PREFERENCE.REPOSITORY) && item.equalsIgnoreCase(Messages.getString("repository"))) {
                this.preferencesList.setSelectedIndex(i);
                continue;
            }
            if (!this.initialSelectedPreference.equals((Object)PREFERENCE.FAVORITES) || !item.equalsIgnoreCase(Messages.getString("favorites"))) continue;
            this.preferencesList.setSelectedIndex(i);
        }
        this.onChange(null);
    }

    public void onChange(ChangeEvent event) {
        String preferenceName = this.preferencesList.getItemText(this.preferencesList.getSelectedIndex());
        Widget content = (Widget)this.preferencesPanelMap.get(preferenceName);
        this.preferencesContent.clear();
        this.preferencesContent.add(content);
    }

    public void cancelPressed() {
        for (UserPreferencesPanel preferencesPanel : this.preferencesPanelMap.values()) {
            preferencesPanel.onCancel();
        }
    }

    public void okPressed() {
    }

    public boolean validate() {
        for (UserPreferencesPanel preferencesPanel : this.preferencesPanelMap.values()) {
            if (preferencesPanel.onApply()) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PREFERENCE {
        STYLES,
        REPOSITORY,
        FAVORITES;

    }
}

