/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.login.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.gwt.widgets.client.dialogs.PromptDialogBox;
import org.pentaho.gwt.widgets.client.utils.PropertiesUtil;
import org.pentaho.gwt.widgets.client.utils.StringTokenizer;
import org.pentaho.mantle.login.client.MantleLoginService;
import org.pentaho.mantle.login.client.MantleLoginServiceAsync;
import org.pentaho.mantle.login.client.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MantleLoginDialog
extends PromptDialogBox {
    private AsyncCallback<Boolean> outerCallback;
    private final TextBox userTextBox = new TextBox();
    private final ListBox usersListBox = new ListBox();
    private final PasswordTextBox passwordTextBox = new PasswordTextBox();
    private CheckBox newWindowChk = new CheckBox();
    private String returnLocation = null;
    private static boolean showUsersList = false;
    private static boolean showNewWindowOption = true;
    private static boolean openInNewWindowDefault = false;
    private static MantleLoginServiceAsync SERVICE;
    private static LinkedHashMap<String, String[]> defaultUsers;
    private final IDialogCallback myCallback = new IDialogCallback(){

        public void cancelPressed() {
        }

        public void okPressed() {
            String path = Window.Location.getPath();
            if (!path.endsWith("/")) {
                path = path.substring(0, path.lastIndexOf("/") + 1);
            }
            RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, path + "j_spring_security_check");
            builder.setHeader("Content-Type", "application/x-www-form-urlencoded");
            RequestCallback callback = new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    MantleLoginDialog.this.outerCallback.onFailure(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    AsyncCallback<Boolean> callback = new AsyncCallback<Boolean>(){

                        public void onSuccess(Boolean result) {
                            if (result.booleanValue()) {
                                long year = 1471228928L;
                                Date expirationDate = new Date(System.currentTimeMillis() + year);
                                Cookies.setCookie((String)"loginNewWindowChecked", (String)("" + MantleLoginDialog.this.newWindowChk.isChecked()), (Date)expirationDate);
                                MantleLoginDialog.this.outerCallback.onSuccess((Object)(MantleLoginDialog.this.newWindowChk != null && MantleLoginDialog.this.newWindowChk.isChecked() ? 1 : 0));
                            } else {
                                MantleLoginDialog.this.outerCallback.onFailure(new Throwable(Messages.getString("authFailed")));
                            }
                        }

                        public void onFailure(final Throwable caught) {
                            MessageDialogBox errBox = new MessageDialogBox(Messages.getString("loginError"), Messages.getString("authFailed"), false, false, true);
                            errBox.setCallback(new IDialogCallback(){

                                public void cancelPressed() {
                                }

                                public void okPressed() {
                                    MantleLoginDialog.this.outerCallback.onFailure(caught);
                                }
                            });
                            errBox.show();
                        }
                    };
                    SERVICE.isAuthenticated((AsyncCallback)callback);
                }
            };
            try {
                String username = MantleLoginDialog.this.userTextBox.getText();
                String password = MantleLoginDialog.this.passwordTextBox.getText();
                builder.sendRequest("j_username=" + URL.encodeComponent((String)username) + "&j_password=" + URL.encodeComponent((String)password), callback);
            }
            catch (RequestException e) {
                e.printStackTrace();
            }
        }
    };

    public MantleLoginDialog() {
        super(Messages.getString("login"), Messages.getString("login"), Messages.getString("cancel"), false, true);
        this.setCallback(this.myCallback);
        SERVICE.isShowUsersList((AsyncCallback)new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                MantleLoginDialog.this.getLoginSettingsAndShow(false);
            }

            public void onSuccess(Boolean showUsersList) {
                MantleLoginDialog.this.getLoginSettingsAndShow(showUsersList);
            }
        });
        super.setStylePrimaryName("pentaho-dialog");
    }

    public void getLoginSettingsAndShow(boolean showUsersListDefault) {
        block4: {
            showUsersList = showUsersListDefault;
            String path = Window.Location.getPath();
            if (!path.endsWith("/")) {
                path = path.substring(0, path.lastIndexOf("/") + 1);
            }
            if ((path = path.replaceAll("/mantle/", "/mantleLogin/")).indexOf("mantleLogin") == -1) {
                path = path + "mantleLogin/";
            }
            RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, path + "loginsettings.properties");
            try {
                requestBuilder.sendRequest(null, new RequestCallback(){

                    public void onError(Request request, Throwable exception) {
                        MantleLoginDialog.this.setContent(MantleLoginDialog.this.buildLoginPanel(false));
                        if (MantleLoginDialog.this.isAttached() && MantleLoginDialog.this.isVisible()) {
                            MantleLoginDialog.this.center();
                        }
                    }

                    public void onResponseReceived(Request request, Response response) {
                        String propertiesFileText = response.getText();
                        HashMap settings = PropertiesUtil.buildProperties((String)propertiesFileText);
                        StringTokenizer useridTokenizer = new StringTokenizer((String)settings.get("userIds"), ',');
                        StringTokenizer passwordTokenizer = new StringTokenizer((String)settings.get("userPasswords"), ',');
                        StringTokenizer userdisplayTokenizer = new StringTokenizer((String)settings.get("userDisplayNames"), ',');
                        defaultUsers.clear();
                        defaultUsers.put(Messages.getString("selectUser"), new String[]{"", ""});
                        for (int i = 0; i < useridTokenizer.countTokens(); ++i) {
                            defaultUsers.put(userdisplayTokenizer.tokenAt(i), new String[]{useridTokenizer.tokenAt(i).trim(), passwordTokenizer.tokenAt(i).trim()});
                        }
                        if (settings.get("showUsersList") != null) {
                            showUsersList = "true".equalsIgnoreCase((String)settings.get("showUsersList"));
                        }
                        openInNewWindowDefault = "true".equalsIgnoreCase((String)settings.get("openInNewWindow"));
                        MantleLoginDialog.this.setContent(MantleLoginDialog.this.buildLoginPanel(openInNewWindowDefault));
                        if (MantleLoginDialog.this.isAttached() && MantleLoginDialog.this.isVisible()) {
                            MantleLoginDialog.this.center();
                        }
                    }
                });
            }
            catch (RequestException e) {
                this.setContent(this.buildLoginPanel(openInNewWindowDefault));
                if (!this.isAttached() || !this.isVisible()) break block4;
                this.center();
            }
        }
    }

    public MantleLoginDialog(AsyncCallback callback, boolean showNewWindowOption) {
        this();
        this.setCallback((AsyncCallback<Boolean>)callback);
        this.setShowNewWindowOption(showNewWindowOption);
    }

    public void setShowNewWindowOption(boolean show) {
        showNewWindowOption = show;
    }

    public static void performLogin(final AsyncCallback callback) {
        SERVICE.isAuthenticated((AsyncCallback)new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                MantleLoginDialog dialog = new MantleLoginDialog(callback, false);
                dialog.show();
            }

            public void onSuccess(Boolean result) {
                if (!result.booleanValue()) {
                    MantleLoginDialog dialog = new MantleLoginDialog(callback, false);
                    dialog.show();
                }
            }
        });
    }

    private Widget buildLoginPanel(boolean openInNewWindowDefault) {
        SimplePanel spacer;
        this.userTextBox.setWidth("100%");
        this.passwordTextBox.setWidth("100%");
        this.usersListBox.setWidth("100%");
        this.userTextBox.setStyleName("login-panel-label");
        this.passwordTextBox.setStyleName("login-panel-label");
        this.newWindowChk.setStyleName("login-panel-label");
        VerticalPanel credentialsPanel = new VerticalPanel();
        credentialsPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        credentialsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        if (showUsersList) {
            this.addDefaultUsers();
            Label sampleUsersLabel = new Label(Messages.getString("sampleUser") + ":");
            sampleUsersLabel.setStyleName("login-panel-label");
            credentialsPanel.add((Widget)sampleUsersLabel);
            credentialsPanel.add((Widget)this.usersListBox);
            spacer = new SimplePanel();
            spacer.setHeight("8px");
            credentialsPanel.add((Widget)spacer);
        }
        Label usernameLabel = new Label(Messages.getString("username") + ":");
        usernameLabel.setStyleName("login-panel-label");
        credentialsPanel.add((Widget)usernameLabel);
        credentialsPanel.add((Widget)this.userTextBox);
        spacer = new SimplePanel();
        spacer.setHeight("8px");
        credentialsPanel.add((Widget)spacer);
        credentialsPanel.setCellHeight((Widget)spacer, "8px");
        HTML passwordLabel = new HTML(Messages.getString("password") + ":");
        passwordLabel.setStyleName("login-panel-label");
        credentialsPanel.add((Widget)passwordLabel);
        credentialsPanel.add((Widget)this.passwordTextBox);
        boolean reallyShowNewWindowOption = showNewWindowOption;
        String showNewWindowOverride = Window.Location.getParameter((String)"showNewWindowOption");
        if (showNewWindowOverride != null && !"".equals(showNewWindowOverride)) {
            reallyShowNewWindowOption = "true".equals(showNewWindowOverride);
        } else if (this.getReturnLocation() != null && !"".equals(this.getReturnLocation())) {
            StringTokenizer st = new StringTokenizer(this.getReturnLocation(), "?&");
            for (int i = 1; i < st.countTokens(); ++i) {
                StringTokenizer paramTokenizer = new StringTokenizer(st.tokenAt(i), "=");
                if (paramTokenizer.countTokens() != 2 || !paramTokenizer.tokenAt(0).equalsIgnoreCase("showNewWindowOption")) continue;
                reallyShowNewWindowOption = "true".equals(paramTokenizer.tokenAt(1));
                break;
            }
        }
        if (reallyShowNewWindowOption) {
            spacer = new SimplePanel();
            spacer.setHeight("8px");
            credentialsPanel.add((Widget)spacer);
            credentialsPanel.setCellHeight((Widget)spacer, "8px");
            this.newWindowChk.setText(Messages.getString("launchInNewWindow"));
            String cookieCheckedVal = Cookies.getCookie((String)"loginNewWindowChecked");
            if (cookieCheckedVal != null) {
                this.newWindowChk.setChecked(Boolean.parseBoolean(cookieCheckedVal));
            } else {
                this.newWindowChk.setChecked(openInNewWindowDefault);
            }
            credentialsPanel.add((Widget)this.newWindowChk);
        }
        this.userTextBox.setTabIndex(1);
        this.passwordTextBox.setTabIndex(2);
        if (reallyShowNewWindowOption) {
            this.newWindowChk.setTabIndex(3);
        }
        this.passwordTextBox.setText("");
        this.setFocusWidget((FocusWidget)this.userTextBox);
        Image lockImage = new Image(GWT.getModuleBaseURL() + "images/icon_login_lock.png");
        HorizontalPanel loginPanel = new HorizontalPanel();
        loginPanel.setSpacing(5);
        loginPanel.setStyleName("login-panel");
        loginPanel.add((Widget)lockImage);
        loginPanel.add((Widget)credentialsPanel);
        return loginPanel;
    }

    public void setCallback(AsyncCallback<Boolean> callback) {
        this.outerCallback = callback;
    }

    public void addDefaultUsers() {
        this.usersListBox.clear();
        for (Map.Entry<String, String[]> entry : defaultUsers.entrySet()) {
            this.usersListBox.addItem(entry.getKey());
        }
        this.usersListBox.addChangeListener(new ChangeListener(){

            public void onChange(Widget sender) {
                String key = MantleLoginDialog.this.usersListBox.getValue(MantleLoginDialog.this.usersListBox.getSelectedIndex());
                MantleLoginDialog.this.userTextBox.setText(((String[])defaultUsers.get(key))[0]);
                MantleLoginDialog.this.passwordTextBox.setText(((String[])defaultUsers.get(key))[1]);
            }
        });
    }

    public String getReturnLocation() {
        return this.returnLocation;
    }

    public void setReturnLocation(String returnLocation) {
        this.returnLocation = returnLocation;
        this.setContent(this.buildLoginPanel(openInNewWindowDefault));
    }

    static {
        defaultUsers = new LinkedHashMap();
        SERVICE = (MantleLoginServiceAsync)GWT.create(MantleLoginService.class);
        ServiceDefTarget endpoint = (ServiceDefTarget)SERVICE;
        String moduleRelativeURL = GWT.getModuleBaseURL() + "MantleLoginService";
        endpoint.setServiceEntryPoint(moduleRelativeURL);
    }
}

