/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.pentaho.mantle.client.commands.AbstractCommand;
import org.pentaho.mantle.client.commands.CommandExec;
import org.pentaho.mantle.client.solutionbrowser.SolutionBrowserPerspective;

public class CommandExecGenerator
extends Generator {
    private String packageName;
    private String className;
    private TypeOracle typeOracle;
    private TreeLogger logger;

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        this.logger = logger;
        this.typeOracle = context.getTypeOracle();
        try {
            JClassType classType = this.typeOracle.getType(typeName);
            this.packageName = classType.getPackage().getName();
            this.className = classType.getSimpleSourceName() + "Impl";
            this.generateClass(logger, context);
        }
        catch (Exception e) {
            logger.log(TreeLogger.ERROR, "PropertyMap ERROR!!!", (Throwable)e);
        }
        return this.packageName + "." + this.className;
    }

    private void generateClass(TreeLogger logger, GeneratorContext context) {
        PrintWriter printWriter = null;
        printWriter = context.tryCreate(logger, this.packageName, this.className);
        if (printWriter == null) {
            return;
        }
        ClassSourceFileComposerFactory composer = null;
        composer = new ClassSourceFileComposerFactory(this.packageName, this.className);
        composer.addImplementedInterface(CommandExec.class.getName());
        composer.addImport(SolutionBrowserPerspective.class.getName());
        composer.addImport(Command.class.getName());
        SourceWriter sourceWriter = null;
        sourceWriter = composer.createSourceWriter(context, printWriter);
        sourceWriter.indent();
        this.generateConstructor(sourceWriter);
        this.generateMethods(sourceWriter);
        sourceWriter.outdent();
        sourceWriter.println("}");
        context.commit(logger, printWriter);
    }

    private void generateMethods(SourceWriter sourceWriter) {
        JClassType eventSourceType;
        JPackage pack;
        ArrayList<JClassType> implementingTypes;
        sourceWriter.println("public void execute(String commandName) { ");
        sourceWriter.indent();
        try {
            implementingTypes = new ArrayList<JClassType>();
            pack = this.typeOracle.getPackage(AbstractCommand.class.getPackage().getName());
            eventSourceType = this.typeOracle.getType(Command.class.getName());
            for (JClassType type : pack.getTypes()) {
                if (!type.isAssignableTo(eventSourceType)) continue;
                implementingTypes.add(type);
            }
            sourceWriter.println("if(false){}");
            for (JClassType implementingType : implementingTypes) {
                sourceWriter.println("else if(commandName.equals(\"" + implementingType.getSimpleSourceName() + "\")){");
                if (implementingType.isDefaultInstantiable()) {
                    sourceWriter.println("new " + implementingType.getSimpleSourceName() + "().execute();");
                } else {
                    this.logger.log(TreeLogger.WARN, "Cannot generate auto-scripts for Command type (" + implementingType.getSimpleSourceName() + "), needs at least a no-arg constructor");
                }
                sourceWriter.println("}");
            }
        }
        catch (Exception e) {
            this.logger.log(TreeLogger.ERROR, "Error generating BindingContext!!!", (Throwable)e);
        }
        sourceWriter.outdent();
        sourceWriter.println("}");
        sourceWriter.println("public Command lookupCommand(String commandName){ ");
        sourceWriter.indent();
        try {
            implementingTypes = new ArrayList();
            pack = this.typeOracle.getPackage(AbstractCommand.class.getPackage().getName());
            eventSourceType = this.typeOracle.getType(Command.class.getName());
            for (JClassType type : pack.getTypes()) {
                if (!type.isAssignableTo(eventSourceType)) continue;
                implementingTypes.add(type);
            }
            sourceWriter.println("if(false){}");
            for (JClassType implementingType : implementingTypes) {
                sourceWriter.println("else if(commandName.equals(\"" + implementingType.getSimpleSourceName() + "\")){");
                if (implementingType.isDefaultInstantiable()) {
                    sourceWriter.println("return new " + implementingType.getSimpleSourceName() + "();");
                } else {
                    this.logger.log(TreeLogger.WARN, "Cannot generate auto-scripts for Command type (" + implementingType.getSimpleSourceName() + "), needs at least a no-arg constructor");
                }
                sourceWriter.println("}");
            }
        }
        catch (Exception e) {
            this.logger.log(TreeLogger.ERROR, "Error generating BindingContext!!!", (Throwable)e);
        }
        sourceWriter.println("return null;");
        sourceWriter.outdent();
        sourceWriter.println("}");
    }

    private void generateConstructor(SourceWriter sourceWriter) {
        sourceWriter.println("public " + this.className + "() { ");
        sourceWriter.indent();
        sourceWriter.println("super();");
        sourceWriter.outdent();
        sourceWriter.println("}");
    }

    private String boxPrimative(JType type) {
        if (type.isPrimitive() != null) {
            JPrimitiveType primative = type.isPrimitive();
            return primative.getQualifiedBoxedSourceName();
        }
        return type.getQualifiedSourceName();
    }
}

