/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mantle.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.mantle.client.MantleXulOverlay;
import org.pentaho.mantle.client.objects.JobDetail;
import org.pentaho.mantle.client.objects.JobSchedule;
import org.pentaho.mantle.client.objects.RolePermission;
import org.pentaho.mantle.client.objects.SimpleMessageException;
import org.pentaho.mantle.client.objects.SolutionFileInfo;
import org.pentaho.mantle.client.objects.SubscriptionBean;
import org.pentaho.mantle.client.objects.SubscriptionSchedule;
import org.pentaho.mantle.client.objects.SubscriptionState;
import org.pentaho.mantle.client.objects.UserPermission;
import org.pentaho.mantle.client.objects.WorkspaceContent;
import org.pentaho.mantle.client.service.MantleService;
import org.pentaho.mantle.server.ServerMessages;
import org.pentaho.platform.api.engine.IAclSolutionFile;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IBackgroundExecution;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginOperation;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.api.repository.ISchedule;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.repository.ISubscribeContent;
import org.pentaho.platform.api.repository.ISubscription;
import org.pentaho.platform.api.repository.ISubscriptionRepository;
import org.pentaho.platform.api.scheduler.BackgroundExecutionException;
import org.pentaho.platform.api.scheduler.IJobDetail;
import org.pentaho.platform.api.scheduler.IJobSchedule;
import org.pentaho.platform.api.ui.IThemeManager;
import org.pentaho.platform.api.ui.Theme;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.GlobalListsPublisher;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.SettingsPublisher;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.security.SimplePermissionMask;
import org.pentaho.platform.engine.security.SimpleRole;
import org.pentaho.platform.engine.security.SimpleUser;
import org.pentaho.platform.engine.services.metadata.MetadataPublisher;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogHelper;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCube;
import org.pentaho.platform.plugin.services.versionchecker.PentahoVersionCheckReflectHelper;
import org.pentaho.platform.repository.content.ContentItemFile;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.subscription.Schedule;
import org.pentaho.platform.repository.subscription.Subscription;
import org.pentaho.platform.repository.subscription.SubscriptionHelper;
import org.pentaho.platform.scheduler.SchedulerHelper;
import org.pentaho.platform.util.VersionHelper;
import org.pentaho.platform.util.VersionInfo;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.http.session.PentahoHttpSession;
import org.pentaho.platform.web.refactor.UserFilesComponent;
import org.pentaho.ui.xul.IMenuCustomization;
import org.pentaho.ui.xul.XulOverlay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MantleServlet
extends RemoteServiceServlet
implements MantleService {
    protected static final Log logger = LogFactory.getLog(MantleServlet.class);
    private static final String DESC_SEPERATOR = " : ";

    protected void onBeforeRequestDeserialized(String serializedRequest) {
        PentahoSystem.systemEntryPoint();
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
        PentahoSystem.systemExitPoint();
    }

    protected void doUnexpectedFailure(Throwable e) {
        try {
            this.getThreadLocalResponse().sendRedirect("../Home");
            PentahoSystem.systemExitPoint();
        }
        catch (IOException e1) {
            logger.error((Object)"doUnexpectedFailure", e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.warn((Object)"GET request not supported");
        try {
            resp.sendRedirect("../Home");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private IPentahoSession getPentahoSession() {
        HttpSession session = this.getThreadLocalRequest().getSession();
        IPentahoSession userSession = (IPentahoSession)session.getAttribute("pentaho-session");
        LocaleHelper.setLocale((Locale)this.getThreadLocalRequest().getLocale());
        if (userSession != null) {
            return userSession;
        }
        userSession = new PentahoHttpSession(this.getThreadLocalRequest().getRemoteUser(), this.getThreadLocalRequest().getSession(), this.getThreadLocalRequest().getLocale(), null);
        LocaleHelper.setLocale((Locale)this.getThreadLocalRequest().getLocale());
        session.setAttribute("pentaho-session", (Object)userSession);
        return userSession;
    }

    @Override
    public boolean isAdministrator() {
        return SecurityHelper.isPentahoAdministrator((IPentahoSession)this.getPentahoSession());
    }

    private UserFilesComponent getUserFilesComponent() {
        UserFilesComponent userFiles = (UserFilesComponent)PentahoSystem.get(UserFilesComponent.class, (String)"IUserFilesComponent", (IPentahoSession)this.getPentahoSession());
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        String thisUrl = requestContext.getContextPath() + "UserContent?";
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(thisUrl);
        userFiles.setUrlFactory((IPentahoUrlFactory)urlFactory);
        userFiles.setRequest(this.getThreadLocalRequest());
        userFiles.setResponse(this.getThreadLocalResponse());
        userFiles.setMessages(new ArrayList());
        userFiles.validate(this.getPentahoSession(), null);
        return userFiles;
    }

    @Override
    public String getSoftwareUpdatesDocument() {
        if (PentahoVersionCheckReflectHelper.isVersionCheckerAvailable()) {
            List results = PentahoVersionCheckReflectHelper.performVersionCheck((boolean)false, (int)-1);
            return PentahoVersionCheckReflectHelper.logVersionCheck((List)results, (Log)logger);
        }
        return "<vercheck><error><[!CDATA[Version Checker is disabled]]></error></vercheck>";
    }

    @Override
    public void executeGlobalActions() {
        if (this.isAdministrator()) {
            PentahoSystem.publish((IPentahoSession)this.getPentahoSession(), (String)GlobalListsPublisher.class.getName());
        }
    }

    @Override
    public String refreshMetadata() {
        String result = null;
        if (this.isAdministrator()) {
            result = PentahoSystem.publish((IPentahoSession)this.getPentahoSession(), (String)MetadataPublisher.class.getName());
        }
        return result;
    }

    @Override
    public void refreshSystemSettings() {
        if (this.isAdministrator()) {
            PentahoSystem.publish((IPentahoSession)this.getPentahoSession(), (String)SettingsPublisher.class.getName());
        }
    }

    @Override
    public boolean isAuthenticated() {
        return this.getPentahoSession() != null && this.getPentahoSession().isAuthenticated();
    }

    @Override
    public WorkspaceContent getWorkspaceContent() {
        WorkspaceContent content = new WorkspaceContent();
        content.setAllSchedules(this.getAllSchedules());
        content.setCompletedJobs(this.getCompletedBackgroundContent());
        content.setMySchedules(this.getMySchedules());
        content.setScheduledJobs(this.getScheduledBackgroundContent());
        content.setSubscriptions(this.getSubscriptionsForMyWorkspace());
        return content;
    }

    public ArrayList<JobDetail> getScheduledBackgroundContent() {
        this.getPentahoSession().resetBackgroundExecutionAlert();
        IBackgroundExecution backgroundExecution = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)this.getPentahoSession());
        if (backgroundExecution != null) {
            try {
                List jobsList = backgroundExecution.getScheduledAndExecutingBackgroundJobs(this.getPentahoSession());
                ArrayList<JobDetail> myJobs = new ArrayList<JobDetail>(jobsList.size());
                for (IJobDetail jobDetail : jobsList) {
                    JobDetail myJobDetail = new JobDetail();
                    myJobDetail.id = jobDetail.getName();
                    myJobDetail.name = jobDetail.getActionName();
                    myJobDetail.fullname = jobDetail.getFullName();
                    myJobDetail.description = jobDetail.getDescription();
                    myJobDetail.timestamp = jobDetail.getSubmissionDate();
                    myJobDetail.group = jobDetail.getGroupName();
                    myJobs.add(myJobDetail);
                }
                return myJobs;
            }
            catch (BackgroundExecutionException bee) {
                return new ArrayList<JobDetail>();
            }
        }
        return new ArrayList<JobDetail>();
    }

    public ArrayList<JobDetail> getCompletedBackgroundContent() {
        this.getPentahoSession().resetBackgroundExecutionAlert();
        IBackgroundExecution backgroundExecution = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)this.getPentahoSession());
        if (backgroundExecution != null) {
            List jobsList = backgroundExecution.getBackgroundExecutedContentList(this.getPentahoSession());
            ArrayList<JobDetail> myJobs = new ArrayList<JobDetail>(jobsList.size());
            SimpleDateFormat fmt = new SimpleDateFormat();
            for (IContentItem contentItem : jobsList) {
                JobDetail myJobDetail = new JobDetail();
                myJobDetail.id = contentItem.getId();
                String dateStr = "";
                Date time = contentItem.getFileDateTime();
                if (time != null) {
                    dateStr = fmt.format(time);
                }
                if (StringUtils.isEmpty((String)dateStr) || contentItem.getFileSize() <= 0L) continue;
                myJobDetail.name = contentItem.getTitle();
                myJobDetail.fullname = contentItem.getActionName();
                myJobDetail.description = contentItem.getActionName();
                myJobDetail.timestamp = dateStr;
                myJobDetail.size = Long.toString(contentItem.getFileSize());
                myJobDetail.type = contentItem.getMimeType();
                myJobs.add(myJobDetail);
            }
            return myJobs;
        }
        return new ArrayList<JobDetail>();
    }

    @Override
    public boolean cancelBackgroundJob(String jobName, String jobGroup) {
        UserFilesComponent userFiles = this.getUserFilesComponent();
        boolean status = userFiles.cancelJob(jobName, jobGroup);
        return status;
    }

    @Override
    public boolean deleteContentItem(String contentId) {
        UserFilesComponent userFiles = this.getUserFilesComponent();
        boolean status = userFiles.deleteContent(contentId);
        return status;
    }

    @Override
    public void refreshRepository() {
        if (this.isAdministrator()) {
            ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getPentahoSession())).reloadSolutionRepository(this.getPentahoSession(), this.getPentahoSession().getLoggingLevel());
        }
    }

    @Override
    public int cleanContentRepository(int daysBack) {
        int deleteCount = 0;
        if (this.isAdministrator()) {
            daysBack = Math.abs(daysBack) * -1;
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, daysBack);
            Date agedDate = new Date(calendar.getTimeInMillis());
            IContentRepository contentRepository = (IContentRepository)PentahoSystem.get(IContentRepository.class, (IPentahoSession)this.getPentahoSession());
            deleteCount = contentRepository.deleteContentOlderThanDate(agedDate);
        }
        return deleteCount;
    }

    @Override
    public void flushMondrianSchemaCache() {
        if (this.isAdministrator()) {
            MondrianCatalogHelper.getInstance().reInit(this.getPentahoSession());
        }
    }

    public ArrayList<JobSchedule> getMySchedules() {
        ArrayList<JobSchedule> jobSchedules = null;
        try {
            List schedules = SchedulerHelper.getMySchedules((IPentahoSession)this.getPentahoSession());
            jobSchedules = this.iJobSchedule2JobSchedule(schedules);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            jobSchedules = new ArrayList();
        }
        return jobSchedules;
    }

    public ArrayList<JobSchedule> getAllSchedules() {
        ArrayList<JobSchedule> jobSchedules = null;
        try {
            List schedules = SchedulerHelper.getAllSchedules((IPentahoSession)this.getPentahoSession());
            jobSchedules = this.iJobSchedule2JobSchedule(schedules);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            jobSchedules = new ArrayList();
        }
        return jobSchedules;
    }

    private ArrayList<JobSchedule> iJobSchedule2JobSchedule(List<IJobSchedule> iJobSchedules) {
        ArrayList<JobSchedule> jobSchedules = new ArrayList<JobSchedule>();
        for (IJobSchedule iJobSchedule : iJobSchedules) {
            JobSchedule jobSchedule = new JobSchedule();
            jobSchedule.fullname = iJobSchedule.getFullname();
            jobSchedule.jobDescription = iJobSchedule.getJobDescription();
            jobSchedule.jobGroup = iJobSchedule.getJobGroup();
            jobSchedule.jobName = iJobSchedule.getJobName();
            jobSchedule.name = iJobSchedule.getName();
            jobSchedule.nextFireTime = iJobSchedule.getNextFireTime();
            jobSchedule.previousFireTime = iJobSchedule.getPreviousFireTime();
            jobSchedule.triggerGroup = iJobSchedule.getTriggerGroup();
            jobSchedule.triggerName = iJobSchedule.getTriggerName();
            jobSchedule.triggerState = iJobSchedule.getTriggerState();
            jobSchedules.add(jobSchedule);
        }
        return jobSchedules;
    }

    @Override
    public void deleteJob(String jobName, String jobGroup) {
        SchedulerHelper.deleteJob((IPentahoSession)this.getPentahoSession(), (String)jobName, (String)jobGroup);
    }

    @Override
    public void runJob(String jobName, String jobGroup) {
        SchedulerHelper.runJob((IPentahoSession)this.getPentahoSession(), (String)jobName, (String)jobGroup);
    }

    @Override
    public void resumeJob(String jobName, String jobGroup) {
        SchedulerHelper.resumeJob((IPentahoSession)this.getPentahoSession(), (String)jobName, (String)jobGroup);
    }

    @Override
    public void suspendJob(String jobName, String jobGroup) {
        SchedulerHelper.suspendJob((IPentahoSession)this.getPentahoSession(), (String)jobName, (String)jobGroup);
    }

    @Override
    public void createCronJob(String solutionName, String path, String actionName, String triggerName, String triggerGroup, String description, String cronExpression) throws SimpleMessageException {
        if (!this.hasAccess(solutionName, path, actionName, 2)) {
            throw new SimpleMessageException(ServerMessages.getString("noSchedulePermission"));
        }
        if ("true".equalsIgnoreCase(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            throw new SimpleMessageException(ServerMessages.getString("featureDisabled"));
        }
        try {
            IBackgroundExecution backgroundExecutionHandler = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)this.getPentahoSession());
            SimpleParameterProvider parameterProvider = new SimpleParameterProvider();
            parameterProvider.setParameter("solution", solutionName);
            parameterProvider.setParameter("path", path);
            parameterProvider.setParameter("action", actionName);
            parameterProvider.setParameter("cron-string", cronExpression);
            parameterProvider.setParameter("jobName", triggerName);
            parameterProvider.setParameter("jobGroup", this.getPentahoSession().getName());
            parameterProvider.setParameter("description", triggerGroup + DESC_SEPERATOR + description);
            backgroundExecutionHandler.backgroundExecuteAction(this.getPentahoSession(), (IParameterProvider)parameterProvider);
        }
        catch (Exception e) {
            throw new SimpleMessageException(e.getMessage());
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    @Override
    public void createSimpleTriggerJob(String triggerName, String triggerGroup, String description, Date startDate, Date endDate, int repeatCount, int repeatInterval, String solutionName, String path, String actionName) throws SimpleMessageException {
        if (!this.hasAccess(solutionName, path, actionName, 2)) {
            throw new SimpleMessageException(ServerMessages.getString("noSchedulePermission"));
        }
        if ("true".equalsIgnoreCase(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            throw new SimpleMessageException(ServerMessages.getString("featureDisabled"));
        }
        try {
            IBackgroundExecution backgroundExecutionHandler = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)this.getPentahoSession());
            SimpleParameterProvider parameterProvider = new SimpleParameterProvider();
            parameterProvider.setParameter("solution", solutionName);
            parameterProvider.setParameter("path", path);
            parameterProvider.setParameter("action", actionName);
            parameterProvider.setParameter("repeat-count", Integer.toString(repeatCount));
            parameterProvider.setParameter("repeat-time-millisecs", Integer.toString(repeatInterval));
            parameterProvider.setParameter("start-date-time", startDate);
            parameterProvider.setParameter("end-date-time", endDate);
            parameterProvider.setParameter("jobName", triggerName);
            parameterProvider.setParameter("jobGroup", this.getPentahoSession().getName());
            parameterProvider.setParameter("description", triggerGroup + DESC_SEPERATOR + description);
            backgroundExecutionHandler.backgroundExecuteAction(this.getPentahoSession(), (IParameterProvider)parameterProvider);
        }
        catch (Exception e) {
            throw new SimpleMessageException(e.getMessage());
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    @Override
    public ArrayList<String> getAllRoles() {
        IUserDetailsRoleListService userDetailsRoleListService = PentahoSystem.getUserDetailsRoleListService();
        return (ArrayList)userDetailsRoleListService.getAllRoles();
    }

    @Override
    public ArrayList<String> getAllUsers() {
        IUserDetailsRoleListService userDetailsRoleListService = PentahoSystem.getUserDetailsRoleListService();
        return (ArrayList)userDetailsRoleListService.getAllUsers();
    }

    @Override
    public SolutionFileInfo getSolutionFileInfo(String solutionName, String path, String fileName) {
        ISubscriptionRepository subscriptionRepository;
        ISubscribeContent subscribeContent;
        String fullPath;
        if (fileName == null || path == null || solutionName == null) {
            throw new IllegalArgumentException("getSolutionFileInfo called with null parameters");
        }
        SolutionFileInfo solutionFileInfo = new SolutionFileInfo();
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getPentahoSession());
        ISolutionFile solutionFile = repository.getSolutionFile(fullPath = ActionInfo.buildSolutionPath((String)solutionName, (String)path, (String)fileName), 1);
        if (solutionFile == null) {
            throw new NullPointerException("Could not find file: " + fullPath);
        }
        solutionFileInfo.solution = solutionName;
        solutionFileInfo.path = path;
        solutionFileInfo.name = fileName;
        if (!solutionFile.isDirectory()) {
            solutionFileInfo.localizedName = repository.getLocalizedFileProperty(solutionFile, "title", 1);
        }
        if (StringUtils.isEmpty((String)solutionFileInfo.localizedName)) {
            solutionFileInfo.localizedName = repository.getLocalizedFileProperty(solutionFile, "name", 1);
        }
        int lastDot = -1;
        if (solutionFile.isDirectory()) {
            solutionFileInfo.type = SolutionFileInfo.Type.FOLDER;
        } else {
            lastDot = fileName.lastIndexOf(46);
            if (lastDot > -1 && !fileName.startsWith(".")) {
                String extension = fileName.substring(lastDot + 1);
                boolean isPlugin = false;
                IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.getPentahoSession());
                if (pluginManager != null) {
                    Set types = pluginManager.getContentTypes();
                    boolean bl = isPlugin = types != null && types.contains(extension);
                }
                if (isPlugin) {
                    IContentGeneratorInfo info = pluginManager.getDefaultContentGeneratorInfoForType(extension, this.getPentahoSession());
                    solutionFileInfo.type = SolutionFileInfo.Type.PLUGIN;
                    solutionFileInfo.pluginTypeName = info.getDescription();
                    InputStream inputStream = null;
                    try {
                        inputStream = repository.getResourceInputStream(solutionFile.getFullPath(), true, 1);
                    }
                    catch (FileNotFoundException e) {
                        logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    IFileInfo fileInfo = pluginManager.getFileInfo(extension, this.getPentahoSession(), solutionFile, inputStream);
                    solutionFileInfo.localizedName = fileInfo.getTitle();
                } else {
                    solutionFileInfo.type = fileName.endsWith("waqr.xaction") ? SolutionFileInfo.Type.REPORT : (fileName.endsWith("analysisview.xaction") ? SolutionFileInfo.Type.ANALYSIS_VIEW : (fileName.endsWith(".url") ? SolutionFileInfo.Type.URL : SolutionFileInfo.Type.XACTION));
                }
            }
        }
        solutionFileInfo.size = solutionFile.getData() == null ? 0L : (long)solutionFile.getData().length;
        solutionFileInfo.lastModifiedDate = new Date(solutionFile.getLastModified());
        solutionFileInfo.isDirectory = solutionFile.isDirectory();
        solutionFileInfo.isSubscribable = !solutionFile.isDirectory() ? (subscribeContent = (subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession())).getContentByActionReference(fullPath)) != null && subscribeContent.getSchedules() != null && subscribeContent.getSchedules().size() > 0 : false;
        solutionFileInfo.canEffectiveUserManage = this.isAdministrator() || repository.hasAccess(solutionFile, 32);
        solutionFileInfo.supportsAccessControls = repository.supportsAccessControls();
        if (solutionFileInfo.canEffectiveUserManage && solutionFileInfo.supportsAccessControls) {
            ArrayList<RolePermission> rolePermissions = new ArrayList<RolePermission>();
            ArrayList<UserPermission> userPermissions = new ArrayList<UserPermission>();
            if (solutionFile instanceof IAclSolutionFile) {
                Map filePermissions = repository.getEffectivePermissions(solutionFile);
                for (Map.Entry filePerm : filePermissions.entrySet()) {
                    IPermissionRecipient permRecipient = (IPermissionRecipient)filePerm.getKey();
                    if (permRecipient instanceof SimpleRole) {
                        rolePermissions.add(new RolePermission(permRecipient.getName(), ((IPermissionMask)filePerm.getValue()).getMask()));
                        continue;
                    }
                    userPermissions.add(new UserPermission(permRecipient.getName(), ((IPermissionMask)filePerm.getValue()).getMask()));
                }
            }
            solutionFileInfo.userPermissions = userPermissions;
            solutionFileInfo.rolePermissions = rolePermissions;
        }
        return solutionFileInfo;
    }

    @Override
    public boolean hasAccess(String solutionName, String path, String fileName, int actionOperation) {
        String fullPath;
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getPentahoSession());
        ISolutionFile solutionFile = repository.getSolutionFile(fullPath = ActionInfo.buildSolutionPath((String)solutionName, (String)path, (String)fileName), actionOperation);
        return solutionFile != null;
    }

    @Override
    public void setSolutionFileInfo(SolutionFileInfo fileInfo) throws SimpleMessageException {
        if ("true".equalsIgnoreCase(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            throw new SimpleMessageException(ServerMessages.getString("featureDisabled"));
        }
        try {
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getPentahoSession());
            if (repository.supportsAccessControls()) {
                String fullPath = ActionInfo.buildSolutionPath((String)fileInfo.solution, (String)fileInfo.path, (String)fileInfo.name);
                ISolutionFile solutionFile = repository.getSolutionFile(fullPath, 32);
                Map origAcl = repository.getEffectivePermissions(solutionFile);
                HashMap<Object, SimplePermissionMask> acl = new HashMap<Object, SimplePermissionMask>();
                for (UserPermission userPermission : fileInfo.userPermissions) {
                    acl.put(new SimpleUser(userPermission.name), new SimplePermissionMask(userPermission.mask));
                }
                for (RolePermission rolePermission : fileInfo.rolePermissions) {
                    acl.put(new SimpleRole(rolePermission.name), new SimplePermissionMask(rolePermission.mask));
                }
                if (!((Object)origAcl).equals(acl)) {
                    repository.setPermissions(solutionFile, acl);
                    repository.resetRepository();
                }
                if (!solutionFile.isDirectory()) {
                    ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession());
                    String actionRef = fileInfo.solution + fileInfo.path + "/" + fileInfo.name;
                    ISubscribeContent subscribeContent = subscriptionRepository.getContentByActionReference(actionRef);
                    if (fileInfo.isSubscribable && subscribeContent == null) {
                        subscriptionRepository.addContent(actionRef, "");
                    } else if (!fileInfo.isSubscribable && subscribeContent != null) {
                        subscriptionRepository.deleteSubscribeContent(subscribeContent);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SimpleMessageException(e.getMessage());
        }
    }

    @Override
    public boolean doesSolutionRepositorySupportPermissions() {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getPentahoSession());
        return repository.supportsAccessControls();
    }

    @Override
    public HashMap<String, String> getMantleSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        Properties props = new Properties();
        try {
            IPluginManager pluginManager;
            props.load(this.getClass().getResourceAsStream("/org/pentaho/mantle/server/MantleSettings.properties"));
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                settings.put(key, value);
            }
            settings.put("login-show-users-list", PentahoSystem.getSystemSetting((String)"login-show-users-list", (String)""));
            settings.put("documentation-url", PentahoSystem.getSystemSetting((String)"documentation-url", (String)""));
            String overrideNewAnalysisViewCommmand = PentahoSystem.getSystemSetting((String)"new-analysis-view/command-url", null);
            String overrideNewAnalysisViewTitle = PentahoSystem.getSystemSetting((String)"new-analysis-view/command-title", null);
            if (overrideNewAnalysisViewCommmand != null && overrideNewAnalysisViewTitle != null) {
                settings.put("new-analysis-view-command-url", overrideNewAnalysisViewCommmand);
                settings.put("new-analysis-view-command-title", overrideNewAnalysisViewTitle);
            }
            String overrideNewReportCommmand = PentahoSystem.getSystemSetting((String)"new-report/command-url", null);
            String overrideNewReportTitle = PentahoSystem.getSystemSetting((String)"new-report/command-title", null);
            if (overrideNewReportCommmand != null && overrideNewReportTitle != null) {
                settings.put("new-report-command-url", overrideNewReportCommmand);
                settings.put("new-report-command-title", overrideNewReportTitle);
            }
            if ((pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.getPentahoSession())) != null) {
                List customs = pluginManager.getMenuCustomizations();
                int fileIdx = 0;
                int fileNewIdx = 0;
                int fileManageIdx = 0;
                int viewIdx = 0;
                int toolsIdx = 0;
                int toolsRefreshIdx = 0;
                int aboutIdx = 0;
                int overrideIdx = 0;
                for (IMenuCustomization custom : customs) {
                    String anchorStart;
                    String anchor;
                    if (custom.getCustomizationType() == IMenuCustomization.CustomizationType.LAST_CHILD) {
                        anchor = custom.getAnchorId();
                        if ("file-submenu".equals(anchor)) {
                            settings.put("fileMenuTitle" + fileIdx, custom.getLabel());
                            settings.put("fileMenuCommand" + fileIdx, custom.getCommand());
                            ++fileIdx;
                            continue;
                        }
                        if ("file-new-submenu".equals(anchor)) {
                            settings.put("file-newMenuTitle" + fileNewIdx, custom.getLabel());
                            settings.put("file-newMenuCommand" + fileNewIdx, custom.getCommand());
                            ++fileNewIdx;
                            continue;
                        }
                        if ("file-manage-submenu".equals(anchor)) {
                            settings.put("file-manageMenuTitle" + fileManageIdx, custom.getLabel());
                            settings.put("file-manageMenuCommand" + fileManageIdx, custom.getCommand());
                            ++fileManageIdx;
                            continue;
                        }
                        if ("view-submenu".equals(anchor)) {
                            settings.put("viewMenuTitle" + viewIdx, custom.getLabel());
                            settings.put("viewMenuCommand" + viewIdx, custom.getCommand());
                            ++viewIdx;
                            continue;
                        }
                        if ("tools-submenu".equals(anchor)) {
                            settings.put("toolsMenuTitle" + toolsIdx, custom.getLabel());
                            settings.put("toolsMenuCommand" + toolsIdx, custom.getCommand());
                            ++toolsIdx;
                            continue;
                        }
                        if ("tools-refresh-submenu".equals(anchor)) {
                            settings.put("tools-refreshMenuTitle" + toolsRefreshIdx, custom.getLabel());
                            settings.put("tools-refreshMenuCommand" + toolsRefreshIdx, custom.getCommand());
                            ++toolsRefreshIdx;
                            continue;
                        }
                        if (!"about-submenu".equals(anchor)) continue;
                        settings.put("helpMenuTitle" + aboutIdx, custom.getLabel());
                        settings.put("helpMenuCommand" + aboutIdx, custom.getCommand());
                        ++aboutIdx;
                        continue;
                    }
                    if (custom.getCustomizationType() != IMenuCustomization.CustomizationType.REPLACE || !(anchor = custom.getAnchorId()).startsWith(anchorStart = "file-new-submenu-")) continue;
                    String overrideMenuItem = anchor.substring(anchorStart.length());
                    settings.put("file-newMenuOverrideTitle" + overrideIdx, custom.getLabel());
                    settings.put("file-newMenuOverrideCommand" + overrideIdx, custom.getCommand());
                    settings.put("file-newMenuOverrideMenuItem" + overrideIdx, overrideMenuItem);
                    ++overrideIdx;
                }
                int i = 0;
                for (String contentType : pluginManager.getContentTypes()) {
                    IContentInfo info = pluginManager.getContentInfoFromExtension(contentType, this.getPentahoSession());
                    if (info == null) continue;
                    settings.put("plugin-content-type-" + i, "." + contentType);
                    settings.put("plugin-content-type-icon-" + i, info.getIconUrl());
                    int j = 0;
                    for (IPluginOperation operation : info.getOperations()) {
                        settings.put("plugin-content-type-" + i + "-command-" + j, operation.getId());
                        settings.put("plugin-content-type-" + i + "-command-url-" + j, operation.getCommand());
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settings;
    }

    @Override
    public Boolean isSubscriptionContent(String actionRef) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession());
        return new Boolean(subscriptionRepository.getContentByActionReference(actionRef) != null && subscriptionRepository.getContentByActionReference(actionRef).getSchedules().size() > 0);
    }

    @Override
    public ArrayList<SubscriptionSchedule> getAvailableSubscriptionSchedules(String actionRef) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession());
        ISubscribeContent subscribeContent = subscriptionRepository.getContentByActionReference(actionRef);
        List appliedList = subscribeContent == null ? new ArrayList() : subscribeContent.getSchedules();
        List availableList = subscriptionRepository.getSchedules();
        ArrayList<SubscriptionSchedule> unusedScheduleList = new ArrayList<SubscriptionSchedule>();
        for (ISchedule schedule : availableList) {
            if (appliedList.contains(schedule)) continue;
            SubscriptionSchedule subSchedule = new SubscriptionSchedule();
            subSchedule.id = schedule.getId();
            subSchedule.title = schedule.getTitle();
            subSchedule.scheduleReference = schedule.getScheduleReference();
            subSchedule.description = schedule.getDescription();
            subSchedule.cronString = schedule.getCronString();
            subSchedule.group = schedule.getGroup();
            subSchedule.lastTrigger = schedule.getLastTrigger();
            unusedScheduleList.add(subSchedule);
        }
        return unusedScheduleList;
    }

    @Override
    public String runAndArchivePublicSchedule(String publicScheduleName) throws SimpleMessageException {
        IPentahoSession userSession = this.getPentahoSession();
        HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
        String response = null;
        try {
            response = SubscriptionHelper.createSubscriptionArchive((String)publicScheduleName, (IPentahoSession)userSession, null, (IParameterProvider)sessionParameters);
        }
        catch (BackgroundExecutionException bex) {
            response = bex.getLocalizedMessage();
            throw new SimpleMessageException(Messages.getErrorString((String)"ViewAction.ViewAction.ERROR_UNABLE_TO_CREATE_SUBSCRIPTION_ARCHIVE"));
        }
        return response;
    }

    @Override
    public String deletePublicScheduleAndContents(String publicScheduleName, ArrayList<String> contentItemList) {
        Iterator<String> iter;
        if (contentItemList != null && (iter = contentItemList.iterator()) != null) {
            while (iter.hasNext()) {
                this.deleteSubscriptionArchive(publicScheduleName, iter.next());
            }
        }
        String result = SubscriptionHelper.deleteSubscription((String)publicScheduleName, (IPentahoSession)this.getPentahoSession());
        return result;
    }

    @Override
    public String deleteSubscriptionArchive(String publicScheduleName, String contentId) {
        IPentahoSession session = this.getPentahoSession();
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession());
        ISubscription subscription = subscriptionRepository.getSubscription(publicScheduleName, session);
        if (subscription == null) {
            return Messages.getString((String)"SubscriptionHelper.USER_SUBSCRIPTION_DOES_NOT_EXIST");
        }
        IContentItem contentItem = subscriptionRepository.getContentItem(publicScheduleName, session);
        if (contentItem == null) {
            return Messages.getString((String)"SubscriptionHelper.USER_CONTENT_ITEM_DOES_NOT_EXIST");
        }
        contentItem.removeVersion(contentId);
        return Messages.getString((String)"SubscriptionHelper.USER_ARCHIVE_DELETED");
    }

    public ArrayList<SubscriptionBean> getSubscriptionsForMyWorkspace() {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession());
        String currentUser = this.getPentahoSession().getName();
        List userSubscriptionList = subscriptionRepository.getUserSubscriptions(currentUser);
        ArrayList<SubscriptionBean> opSubscrList = new ArrayList<SubscriptionBean>();
        for (ISubscription currentSubscr : userSubscriptionList) {
            ActionInfo actionInfo = ActionInfo.parseActionString((String)currentSubscr.getContent().getActionReference());
            String localizedName = actionInfo.getActionName();
            try {
                SolutionFileInfo info = this.getSolutionFileInfo(actionInfo.getSolutionName(), actionInfo.getPath(), actionInfo.getActionName());
                localizedName = info.getLocalizedName();
            }
            catch (NullPointerException npe) {
                logger.error((Object)npe.getMessage(), (Throwable)npe);
                continue;
            }
            Schedule schedule = null;
            Iterator schedIterator = currentSubscr.getSchedules().iterator();
            if (schedIterator != null && schedIterator.hasNext()) {
                schedule = (Schedule)schedIterator.next();
            }
            SubscriptionBean subscriptionBean = new SubscriptionBean();
            subscriptionBean.setId(currentSubscr.getId());
            subscriptionBean.setName(currentSubscr.getTitle());
            subscriptionBean.setXactionName(localizedName);
            if (!actionInfo.getActionName().endsWith(".")) {
                int lastDot = actionInfo.getActionName().lastIndexOf(46);
                String type = actionInfo.getActionName().substring(lastDot + 1);
                IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.getPentahoSession());
                IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
                String contextPath = requestContext.getContextPath();
                IContentInfo contentInfo = pluginManager.getContentInfoFromExtension(type, this.getPentahoSession());
                String editSubscriptionUrl = null;
                if (contentInfo != null) {
                    for (IPluginOperation operation : contentInfo.getOperations()) {
                        if (!operation.getId().equals("SCHEDULE_EDIT")) continue;
                        editSubscriptionUrl = contextPath + operation.getCommand();
                        editSubscriptionUrl = editSubscriptionUrl.replaceAll("\\{subscription-id\\}", currentSubscr.getId());
                        break;
                    }
                }
                subscriptionBean.setPluginUrl(editSubscriptionUrl);
            }
            if (schedule != null) {
                subscriptionBean.setScheduleDate(schedule.getTitle());
            }
            subscriptionBean.setSize("---");
            subscriptionBean.setType("---");
            subscriptionBean.setContent(this.getContentItems(subscriptionRepository, (Subscription)currentSubscr));
            opSubscrList.add(subscriptionBean);
        }
        return opSubscrList;
    }

    private String getActionSequenceTitle(Subscription currentSubscr) {
        String actionSeqPath = currentSubscr.getContent().getActionReference();
        ActionInfo actionInfo = ActionInfo.parseActionString((String)actionSeqPath);
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getPentahoSession());
        IActionSequence action = repository.getActionSequence(actionInfo.getSolutionName(), actionInfo.getPath(), actionInfo.getActionName(), repository.getLoggingLevel(), 1);
        return action.getTitle();
    }

    private ArrayList<String[]> getContentItems(ISubscriptionRepository subscriptionRepository, Subscription currentSubscr) {
        List contentItemFileList = subscriptionRepository.getSubscriptionArchives(currentSubscr.getId(), this.getPentahoSession());
        ArrayList<String[]> archiveList = null;
        if (contentItemFileList != null) {
            archiveList = new ArrayList<String[]>();
            for (ContentItemFile contentItemFile : contentItemFileList) {
                Date fileItemDate = contentItemFile.getFileDateTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy h:mm a");
                String formattedDateStr = dateFormat.format(fileItemDate);
                String fileType = contentItemFile.getParent().getMimeType();
                String fileSize = String.valueOf(contentItemFile.getFileSize());
                String[] tempArchiveArr = new String[]{formattedDateStr, fileType, fileSize, contentItemFile.getId(), contentItemFile.getOsFileName(), contentItemFile.getOsPath()};
                archiveList.add(tempArchiveArr);
            }
        }
        return archiveList;
    }

    public String deleteArchive(String subscrName, String fileId) {
        String result = SubscriptionHelper.deleteSubscriptionArchive((String)subscrName, (String)fileId, (IPentahoSession)this.getPentahoSession());
        return result;
    }

    @Override
    public ArrayList<SubscriptionSchedule> getAppliedSubscriptionSchedules(String actionRef) {
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession());
        ISubscribeContent subscribeContent = subscriptionRepository.getContentByActionReference(actionRef);
        List appliedList = subscribeContent == null ? new ArrayList() : subscribeContent.getSchedules();
        ArrayList<SubscriptionSchedule> appliedScheduleList = new ArrayList<SubscriptionSchedule>();
        for (ISchedule schedule : appliedList) {
            SubscriptionSchedule subSchedule = new SubscriptionSchedule();
            subSchedule.id = schedule.getId();
            subSchedule.title = schedule.getTitle();
            subSchedule.scheduleReference = schedule.getScheduleReference();
            subSchedule.description = schedule.getDescription();
            subSchedule.cronString = schedule.getCronString();
            subSchedule.group = schedule.getGroup();
            subSchedule.lastTrigger = schedule.getLastTrigger();
            appliedScheduleList.add(subSchedule);
        }
        return appliedScheduleList;
    }

    @Override
    public void setSubscriptions(String solutionName, String solutionPath, String fileName, boolean enabled, ArrayList<SubscriptionSchedule> currentSchedules) {
        String filePath = ActionInfo.buildSolutionPath((String)solutionName, (String)solutionPath, (String)fileName);
        if ("true".equalsIgnoreCase(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            throw new RuntimeException(ServerMessages.getString("featureDisabled"));
        }
        ISubscriptionRepository subscriptionRepository = (ISubscriptionRepository)PentahoSystem.get(ISubscriptionRepository.class, (IPentahoSession)this.getPentahoSession());
        ISubscribeContent subscribeContent = subscriptionRepository.getContentByActionReference(filePath);
        if (enabled) {
            if (subscribeContent == null) {
                subscribeContent = subscriptionRepository.addContent(filePath, "");
            }
            subscribeContent.clearsSchedules();
            ArrayList<ISchedule> updatedSchedules = new ArrayList<ISchedule>();
            List availableSchedules = subscriptionRepository.getSchedules();
            for (SubscriptionSchedule currentSchedule : currentSchedules) {
                for (ISchedule availableSchedule : availableSchedules) {
                    if (!currentSchedule.id.equals(availableSchedule.getId())) continue;
                    updatedSchedules.add(availableSchedule);
                }
            }
            subscribeContent.setSchedules(updatedSchedules);
        } else if (subscribeContent != null) {
            subscribeContent.clearsSchedules();
        }
    }

    @Override
    public HashMap<String, ArrayList<String[]>> getMondrianCatalogs() {
        LinkedHashMap<String, ArrayList<String[]>> catalogCubeHashMap = new LinkedHashMap<String, ArrayList<String[]>>();
        List catalogs = MondrianCatalogHelper.getInstance().listCatalogs(this.getPentahoSession(), true);
        for (MondrianCatalog cat : catalogs) {
            ArrayList<String[]> cubes = new ArrayList<String[]>();
            catalogCubeHashMap.put(cat.getName(), cubes);
            for (MondrianCube cube : cat.getSchema().getCubes()) {
                cubes.add(new String[]{cube.getName(), cube.getId()});
            }
            Collections.sort(cubes, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return o1[0].compareTo(o2[0]);
                }
            });
        }
        return catalogCubeHashMap;
    }

    @Override
    public SubscriptionState getSubscriptionState(String solutionName, String solutionPath, String fileName) {
        String filePath = ActionInfo.buildSolutionPath((String)solutionName, (String)solutionPath, (String)fileName);
        SubscriptionState state = new SubscriptionState();
        state.subscriptionsEnabled = this.isSubscriptionContent(filePath);
        state.availableSchedules = this.getAvailableSubscriptionSchedules(filePath);
        state.appliedSchedules = this.getAppliedSubscriptionSchedules(filePath);
        return state;
    }

    @Override
    public ArrayList<IUserSetting> getUserSettings() {
        try {
            IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
            ArrayList settings = (ArrayList)settingsService.getUserSettings();
            return settings;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IUserSetting getUserSetting(String settingName) throws SimpleMessageException {
        try {
            IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
            IUserSetting setting = settingsService.getUserSetting(settingName, null);
            return setting;
        }
        catch (Exception e) {
            throw new SimpleMessageException(e.getMessage());
        }
    }

    @Override
    public void setLocaleOverride(String locale) {
        this.getThreadLocalRequest().getSession().setAttribute("locale_override", (Object)locale);
        if (!StringUtils.isEmpty((String)locale)) {
            LocaleHelper.setLocaleOverride((Locale)new Locale(locale));
        } else {
            LocaleHelper.setLocaleOverride(null);
        }
    }

    @Override
    public Map<String, String> getSystemThemes() {
        IThemeManager themeManager = (IThemeManager)PentahoSystem.get(IThemeManager.class);
        List ids = themeManager.getSystemThemeIds();
        HashMap<String, String> themes = new HashMap<String, String>();
        for (String id : ids) {
            Theme theme = themeManager.getSystemTheme(id);
            if (theme.isHidden()) continue;
            themes.put(id, theme.getName());
        }
        return themes;
    }

    @Override
    public void setTheme(String theme) throws SimpleMessageException {
        PentahoSessionHolder.getSession().setAttribute("pentaho-user-theme", (Object)theme);
        try {
            IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
            settingsService.setUserSetting("pentaho-user-theme", theme);
        }
        catch (Exception e) {
            throw new SimpleMessageException(e.getMessage());
        }
    }

    @Override
    public String getActiveTheme() {
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        return StringUtils.defaultIfEmpty((String)((String)PentahoSessionHolder.getSession().getAttribute("pentaho-user-theme")), (String)settingsService.getUserSetting("pentaho-user-theme", PentahoSystem.getSystemSetting((String)"default-theme", (String)"onyx")).getSettingValue());
    }

    @Override
    public void setUserSetting(String settingName, String settingValue) throws SimpleMessageException {
        try {
            IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
            settingsService.setUserSetting(settingName, settingValue);
        }
        catch (Exception e) {
            throw new SimpleMessageException(e.getMessage());
        }
    }

    @Override
    public void setShowNavigator(boolean showNavigator) {
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        settingsService.setUserSetting("MANTLE_SHOW_NAVIGATOR", "" + showNavigator);
    }

    @Override
    public void setShowLocalizedFileNames(boolean showLocalizedFileNames) {
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        settingsService.setUserSetting("MANTLE_SHOW_LOCALIZED_FILENAMES", "" + showLocalizedFileNames);
    }

    @Override
    public void setShowHiddenFiles(boolean showHiddenFiles) {
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        settingsService.setUserSetting("MANTLE_SHOW_HIDDEN_FILES", "" + showHiddenFiles);
    }

    @Override
    public boolean repositorySupportsACLS() {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getPentahoSession());
        return repository.supportsAccessControls();
    }

    @Override
    public String getVersion() {
        VersionInfo versionInfo = VersionHelper.getVersionInfo(PentahoSystem.class);
        return versionInfo.getVersionNumber();
    }

    @Override
    public ArrayList<MantleXulOverlay> getOverlays() {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.getPentahoSession());
        List overlays = pluginManager.getOverlays();
        ArrayList<MantleXulOverlay> result = new ArrayList<MantleXulOverlay>();
        for (XulOverlay overlay : overlays) {
            MantleXulOverlay tempOverlay = new MantleXulOverlay(overlay.getId(), overlay.getOverlayUri(), overlay.getSource(), overlay.getResourceBundleUri());
            result.add(tempOverlay);
        }
        if (pluginManager != null) {
            return result;
        }
        return null;
    }

    @Override
    public void purgeReportingDataCache() {
        ICacheManager cacheManager = (ICacheManager)PentahoSystem.get(ICacheManager.class);
        cacheManager.clearRegionCache("report-dataset-cache");
        cacheManager.clearRegionCache("report-output-handlers");
    }
}

