package org.pentaho.gwt.widgets.client.colorpicker;

/**
 * Copyright (c) 2007, AurorisNET.
 *
 * Everyone is permitted to copy and distribute verbatim copies of this license
 * document, but changing it is not allowed.
 *
 * Preamble
 *
 * This license establishes the terms under which a given free software Package
 * may be copied, modified, distributed, and/or redistributed. The intent is
 * that the Copyright Holder maintains some artistic control over the
 * development of that Package while still keeping the Package available as open
 * source and free software.
 *
 * You are always permitted to make arrangements wholly outside of this license
 * directly with the Copyright Holder of a given Package. If the terms of this
 * license do not permit the full use that you propose to make of the Package,
 * you should contact the Copyright Holder and seek a different licensing
 * arrangement.
 *
 * Definitions
 *
 * "Copyright Holder" means the individual(s) or organization(s) named in the
 * copyright notice for the entire Package.
 *
 * "Contributor" means any party that has contributed code or other material to
 * the Package, in accordance with the Copyright Holder's procedures.
 *
 * "You" and "your" means any person who would like to copy, distribute, or
 * modify the Package.
 *
 * "Package" means the collection of files distributed by the Copyright Holder,
 * and derivatives of that collection and/or of those files. A given Package may
 * consist of either the Standard Version, or a Modified Version.
 *
 * "Distribute" means providing a copy of the Package or making it accessible to
 * anyone else, or in the case of a company or organization, to others outside
 * of your company or organization.
 *
 * "Distributor Fee" means any fee that you charge for Distributing this Package
 * or providing support for this Package to another party. It does not mean
 * licensing fees.
 *
 * "Standard Version" refers to the Package if it has not been modified, or has
 * been modified only in ways explicitly requested by the Copyright Holder.
 *
 * "Modified Version" means the Package, if it has been changed, and such
 * changes were not explicitly requested by the Copyright Holder.
 *
 * "Original License" means this Artistic License as Distributed with the
 * Standard Version of the Package, in its current version or as it may be
 * modified by The Perl Foundation in the future.
 *
 * "Source" form means the source code, documentation source, and configuration
 * files for the Package.
 *
 * "Compiled" form means the compiled bytecode, object code, binary, or any
 * other form resulting from mechanical transformation or translation of the
 * Source form.
 *
 * Permission for Use and Modification Without Distribution
 *
 * (1) You are permitted to use the Standard Version and create and use Modified
 * Versions for any purpose without restriction, provided that you do not
 * Distribute the Modified Version.
 *
 * Permissions for Redistribution of the Standard Version
 *
 * (2) You may Distribute verbatim copies of the Source form of the Standard
 * Version of this Package in any medium without restriction, either gratis or
 * for a Distributor Fee, provided that you duplicate all of the original
 * copyright notices and associated disclaimers. At your discretion, such
 * verbatim copies may or may not include a Compiled form of the Package.
 *
 * (3) You may apply any bug fixes, portability changes, and other modifications
 * made available from the Copyright Holder. The resulting Package will still be
 * considered the Standard Version, and as such will be subject to the Original
 * License.
 *
 * Distribution of Modified Versions of the Package as Source
 *
 * (4) You may Distribute your Modified Version as Source (either gratis or for
 * a Distributor Fee, and with or without a Compiled form of the Modified
 * Version) provided that you clearly document how it differs from the Standard
 * Version, including, but not limited to, documenting any non-standard
 * features, executables, or modules, and provided that you do at least ONE of
 * the following:
 *
 *      (a) make the Modified Version available to the Copyright Holder of the
 *          Standard Version, under the Original License, so that the Copyright
 *          Holder may include your modifications in the Standard Version.
 *
 *      (b) ensure that installation of your Modified Version does not prevent
 *          the user installing or running the Standard Version. In addition,
 *          the Modified Version must bear a name that is different from the
 *          name of the Standard Version.
 *
 *      (c) allow anyone who receives a copy of the Modified Version to make the
 *          Source form of the Modified Version available to others under
 *
 *          (i) the Original License or
 *
 *          (ii) a license that permits the licensee to freely copy, modify and
 *              redistribute the Modified Version using the same licensing terms
 *              that apply to the copy that the licensee received, and requires
 *              that the Source form ofthe Modified Version, and of any works
 *              derived from it, be made freely available in that license fees
 *              are prohibited but Distributor Fees are allowed.
 *
 * Distribution of Compiled Forms of the Standard Version or Modified Versions
 * without the Source
 *
 * (5) You may Distribute Compiled forms of the Standard Version without the
 * Source, provided that you include complete instructions on how to get the
 * Source of the Standard Version. Such instructions must be valid at the time
 * of your distribution. If these instructions, at any time while you are
 * carrying out such distribution, become invalid, you must provide new
 * instructions on demand or cease further distribution. If you provide valid
 * instructions or cease distribution within thirty days after you become aware
 * that the instructions are invalid, then you do not forfeit any of your rights
 * under this license.
 *
 * (6) You may Distribute a Modified Version in Compiled form without the
 * Source, provided that you comply with Section 4 with respect to the Source of
 * the Modified Version.
 *
 * Aggregating or Linking the Package
 *
 * (7) You may aggregate the Package (either the Standard Version or Modified
 * Version) with other packages and Distribute the resulting aggregation
 * provided that you do not charge a licensing fee for the Package. Distributor
 * Fees are permitted, and licensing fees for other components in the
 * aggregation are permitted. The terms of this license apply to the use and
 * Distribution of the Standard or Modified Versions as included in the
 * aggregation.
 *
 * (8) You are permitted to link Modified and Standard Versions with other
 * works, to embed the Package in a larger work of your own, or to build
 * stand-alone binary or bytecode versions of applications that include the
 * Package, and Distribute the result without restriction, provided the result
 * does not expose a direct interface to the Package.
 *
 * Items That are Not Considered Part of a Modified Version
 *
 * (9) Works (including, but not limited to, modules and scripts) that merely
 * extend or make use of the Package, do not, by themselves, cause the Package
 * to be a Modified Version. In addition, such works are not considered parts of
 * the Package itself, and are not subject to the terms of this license.
 *
 * General Provisions
 *
 * (10) Any use, modification, and distribution of the Standard or Modified
 * Versions is governed by this Artistic License. By using, modifying or
 * distributing the Package, you accept this license. Do not use, modify, or
 * distribute the Package, if you do not accept this license.
 *
 * (11) If your Modified Version has been derived from a Modified Version made
 * by someone other than you, you are nevertheless required to ensure that your
 * Modified Version complies with the requirements of this license.
 *
 * (12) This license does not grant you the right to use any trademark, service
 * mark, tradename, or logo of the Copyright Holder.
 *
 * (13) This license includes the non-exclusive, worldwide, free-of-charge
 * patent license to make, have made, use, offer to sell, sell, import and
 * otherwise transfer the Package with respect to any patent claims licensable
 * by the Copyright Holder that are necessarily infringed by the Package. If you
 * institute patent litigation (including a cross-claim or counterclaim) against
 * any party alleging that the Package constitutes direct or contributory patent
 * infringement, then this Artistic License to you shall terminate on the date
 * that such litigation is filed.
 *
 * (14) Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
 * AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES. THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY YOUR LOCAL LAW.
 * UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR CONTRIBUTOR WILL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING IN ANY WAY
 * OUT OF THE USE OF THE PACKAGE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

import org.pentaho.gwt.widgets.client.colorpicker.images.ColorPickerImageBundle;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;

/**
 * Implements the SliderBar control.
 */
@SuppressWarnings("deprecation")
public final class SliderBar extends HTML implements EventPreview
{
	private ColorPickerImageBundle cpImageBundle;
	private Image colorA;
	private Image colorB;
	private Image colorC;
	private Image colorD;
	private Image slider;
	private ColorPicker parent = null;
	private boolean captureMouse = false;

	// enum
	public static final int Saturation = 1;
	public static final int Brightness = 2;
	public static final int Hue = 3;
	public static final int Red = 4;
	public static final int Green = 5;
	public static final int Blue = 6;

	public static final int BarA = 1;
	public static final int BarB = 2;
	public static final int BarC = 3;
	public static final int BarD = 4;

	/***
	 * Initialize the SliderMap -- default mode is Saturation.
	 */
	public SliderBar(ColorPicker parent)
	{
		super();

		this.parent = parent;

		setWidth("40px"); //$NON-NLS-1$
		setHeight("256px"); //$NON-NLS-1$

		cpImageBundle = (ColorPickerImageBundle) GWT.create(ColorPickerImageBundle.class);

		colorA = cpImageBundle.bar_white().createImage();
		colorB = cpImageBundle.bar_white().createImage();
		colorC = cpImageBundle.bar_white().createImage();
		colorD = cpImageBundle.bar_saturation().createImage();
		slider = cpImageBundle.rangearrows().createImage();

		DOM.appendChild(getElement(), colorA.getElement());
		DOM.appendChild(getElement(), colorB.getElement());
		DOM.appendChild(getElement(), colorC.getElement());
		DOM.appendChild(getElement(), colorD.getElement());
		DOM.appendChild(getElement(), slider.getElement());

		DOM.setStyleAttribute(getElement(), "position", "absolute"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorA.getElement(), "border", "1px solid black"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorB.getElement(), "border", "1px solid black"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorC.getElement(), "border", "1px solid black"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorD.getElement(), "border", "1px solid black"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/***
	 * This method is called when a widget is attached to the browser's document.
	 */
	public void onAttach()
	{
		super.onAttach();

		DOM.setStyleAttribute(colorA.getElement(), "position", "absolute"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorA.getElement(), "left", "10px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorA.getElement(), "top", "0px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorB.getElement(), "position", "absolute"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorB.getElement(), "left", "10px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorB.getElement(), "top", "0px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorC.getElement(), "position", "absolute"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorC.getElement(), "left", "10px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorC.getElement(), "top", "0px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorD.getElement(), "position", "absolute"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorD.getElement(), "left", "10px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(colorD.getElement(), "top", "0px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(slider.getElement(), "position", "absolute"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(slider.getElement(), "left", "0px"); //$NON-NLS-1$ //$NON-NLS-2$
		DOM.setStyleAttribute(slider.getElement(), "top", "0px"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * Set overlay's opacity.
	 * @param alpha An opacity percentage, between 100 (fully opaque) and 0 (invisible).
	 * @param layer which bar to change opacity for, 1-4
	 */
	public void setLayerOpacity(int alpha, int layer)
	{
		if (alpha >= 0 && alpha <= 100 && isAttached())
		{
			Element colorbar;

			switch (layer)
			{
				case BarA:
					colorbar = colorA.getElement();
					break;
				case BarB:
					colorbar = colorB.getElement();
					break;
				case BarC:
					colorbar = colorC.getElement();
					break;
				case BarD:
					colorbar = colorD.getElement();
					break;
				default:
					return;
			}

			TransparencyImpl.setTransparency(colorbar, alpha);
		}
	}

	/**
	 * Sets the color of a particular layer
	 * @param color Hexadecimal notation of RGB to change the layer's color
	 * @param layer Which layer to affect
	 */
	public void setLayerColor(String color, int layer)
	{
		Element colorbar;

		switch (layer)
		{
			case BarA:
				colorbar = colorA.getElement();
				break;
			case BarB:
				colorbar = colorB.getElement();
				break;
			case BarC:
				colorbar = colorC.getElement();
				break;
			case BarD:
				colorbar = colorD.getElement();
				break;
			default:
				return;
		}

		TransparencyImpl.setBackgroundColor(colorbar, color);
	}

	/**
	 * Sets the slider's position on the y-axis.
	 * @param y Position along the y-axis to set the slider's position to.
	 */
	public void setSliderPosition(int y)
	{
		if (y < 0) y = 0;
		if (y > 256) y = 256;
		DOM.setStyleAttribute(slider.getElement(), "top", y - 4 + "px"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * Sets the color selection mode
	 * @param mode Can be one of: ColorBar.Saturation, ColorBar.Hue, ColorBar.Brightness, ColorBar.Red, ColorBar.Green, ColorBar.Blue, ColorBar.Red.
	 */
	public void setColorSelectMode(int mode)
	{
		if (!isAttached()) { return; }

		switch (mode)
		{
			case Saturation:
				cpImageBundle.bar_white().applyTo(colorA);
				cpImageBundle.bar_white().applyTo(colorB);
				cpImageBundle.bar_white().applyTo(colorC);
				cpImageBundle.bar_saturation().applyTo(colorD);
			break;

			case Brightness:
				cpImageBundle.bar_white().applyTo(colorA);
				cpImageBundle.bar_white().applyTo(colorB);
				cpImageBundle.bar_white().applyTo(colorC);
				cpImageBundle.bar_brightness().applyTo(colorD);
			break;

			case Hue:
				cpImageBundle.bar_white().applyTo(colorA);
				cpImageBundle.bar_white().applyTo(colorB);
				cpImageBundle.bar_white().applyTo(colorC);
				cpImageBundle.bar_hue().applyTo(colorD);
			break;

			case Red:
				cpImageBundle.bar_red_tl().applyTo(colorA);
				cpImageBundle.bar_red_tr().applyTo(colorB);
				cpImageBundle.bar_red_br().applyTo(colorC);
				cpImageBundle.bar_red_bl().applyTo(colorD);
			break;

			case Green:
				cpImageBundle.bar_green_tl().applyTo(colorA);
				cpImageBundle.bar_green_tr().applyTo(colorB);
				cpImageBundle.bar_green_br().applyTo(colorC);
				cpImageBundle.bar_green_bl().applyTo(colorD);
			break;

			case Blue:
				cpImageBundle.bar_blue_tl().applyTo(colorA);
				cpImageBundle.bar_blue_tr().applyTo(colorB);
				cpImageBundle.bar_blue_br().applyTo(colorC);
				cpImageBundle.bar_blue_bl().applyTo(colorD);
			break;
		}
	}

	/**
	 * Fired whenever a browser event is received.
	 * @param event Event to process
	 */
	public void onBrowserEvent(Event event)
	{
		switch (DOM.eventGetType(event))
		{
			case Event.ONMOUSEDOWN:
				captureMouse = true;
				DOM.addEventPreview(this);
				mouseEvent(event);
			break;
		}
	}

	/**
	 * Called when a browser event occurs and this event preview is on top of the preview stack.
	 * @param event Event to process
	 * @return boolean false to cancel the event.
	 */
	public boolean onEventPreview(Event event)
	{
		switch (DOM.eventGetType(event))
		{
			case Event.ONMOUSEUP:
				captureMouse = false;
				DOM.removeEventPreview(this);
			break;

			case Event.ONMOUSEMOVE:
				if (captureMouse)
				{
					mouseEvent(event);
					return false;
				}
			break;
		}
		return true;
	}

	/**
	 * Called to process a mouse event.
	 * @param event Event to process
	 */
	private void mouseEvent(Event event)
	{
		DOM.eventPreventDefault(event);

		int y = DOM.eventGetClientY(event) - getAbsoluteTop();

		if (y < 0) y = 0;
		if (y > 256) y = 256;

		DOM.setStyleAttribute(slider.getElement(), "top", y - 4 + "px"); //$NON-NLS-1$ //$NON-NLS-2$

		if (parent != null) { parent.onBarSelected(y); }
	}
}