/* automatically generated by JSCoverage - do not edit */
try {
  if (typeof top === 'object' && top !== null && typeof top.opener === 'object' && top.opener !== null) {
    // this is a browser window that was opened from another window

    if (! top.opener._$jscoverage) {
      top.opener._$jscoverage = {};
    }
  }
}
catch (e) {}

try {
  if (typeof top === 'object' && top !== null) {
    // this is a browser window

    try {
      if (typeof top.opener === 'object' && top.opener !== null && top.opener._$jscoverage) {
        top._$jscoverage = top.opener._$jscoverage;
      }
    }
    catch (e) {}

    if (! top._$jscoverage) {
      top._$jscoverage = {};
    }
  }
}
catch (e) {}

try {
  if (typeof top === 'object' && top !== null && top._$jscoverage) {
    _$jscoverage = top._$jscoverage;
  }
}
catch (e) {}
if (typeof _$jscoverage !== 'object') {
  _$jscoverage = {};
}
if (! _$jscoverage['dojo/pentaho/common/FilterIndicator.js']) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'] = [];
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][1] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][7] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][37] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][38] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][39] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][41] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][42] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][46] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][55] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][59] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][63] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][64] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][65] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][67] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][68] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][70] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][71] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][72] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][74] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][75] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][76] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][78] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][79] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][80] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][89] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][90] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][91] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][93] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][94] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][95] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][96] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][97] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][107] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][108] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][109] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][110] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][112] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][114] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][118] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][122] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][129] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][130] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][131] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][132] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][134] = 0;
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][136] = 0;
}
_$jscoverage['dojo/pentaho/common/FilterIndicator.js'].source = ["dojo<span class=\"k\">.</span>provide<span class=\"k\">(</span><span class=\"s\">\"pentaho.common.FilterIndicator\"</span><span class=\"k\">);</span>","","<span class=\"c\">/**</span>","<span class=\"c\"> * Shows a filter indicator over an anchor element to indicator the number of</span>","<span class=\"c\"> * filters currently active.</span>","<span class=\"c\"> */</span>","dojo<span class=\"k\">.</span>declare<span class=\"k\">(</span>","    <span class=\"s\">\"pentaho.common.FilterIndicator\"</span><span class=\"k\">,</span>","    <span class=\"k\">[</span>dijit<span class=\"k\">.</span>_Widget<span class=\"k\">,</span> dijit<span class=\"k\">.</span>_Templated<span class=\"k\">],</span>","<span class=\"k\">{</span>","  templateString<span class=\"k\">:</span> <span class=\"s\">'&lt;div dojoAttachPoint=\"containerNode\" class=\"hidden cursorPointer filterToolbarIndicator\"&gt;&lt;/div&gt;'</span><span class=\"k\">,</span>","  backgroundClassPrefix<span class=\"k\">:</span> <span class=\"s\">'filterIndicatorBackground_'</span><span class=\"k\">,</span>","  backgroundClassOverflow<span class=\"k\">:</span> <span class=\"s\">'9_plus'</span><span class=\"k\">,</span>","  min<span class=\"k\">:</span> <span class=\"s\">1</span><span class=\"k\">,</span>","  max<span class=\"k\">:</span> <span class=\"s\">9</span><span class=\"k\">,</span>","","  currentBackgroundClass<span class=\"k\">:</span> undefined<span class=\"k\">,</span>","","  toolbarButton<span class=\"k\">:</span> undefined<span class=\"k\">,</span>","  anchorElement<span class=\"k\">:</span> undefined<span class=\"k\">,</span>","","  defaultOffsets<span class=\"k\">:</span> <span class=\"k\">{</span>","    top<span class=\"k\">:</span> <span class=\"s\">0</span><span class=\"k\">,</span>","    left<span class=\"k\">:</span> <span class=\"s\">0</span><span class=\"k\">,</span>","    bottom<span class=\"k\">:</span> <span class=\"s\">0</span><span class=\"k\">,</span>","    right<span class=\"k\">:</span> <span class=\"s\">0</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","","  offsets<span class=\"k\">:</span> <span class=\"k\">this</span><span class=\"k\">.</span>defaultOffsets<span class=\"k\">,</span>","  ","  <span class=\"c\">/**</span>","<span class=\"c\">   * @param toolbarButton Toolbar button for Filters so we can fake mouse interaction for it when we're interacted with</span>","<span class=\"c\">   * @param offsets</span>","<span class=\"c\">   *          {@see setOffsets()}</span>","<span class=\"c\">   */</span>","  configure<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">(</span>toolbarButton<span class=\"k\">,</span> offsets<span class=\"k\">)</span> <span class=\"k\">{</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>setToolbarButton<span class=\"k\">(</span>toolbarButton<span class=\"k\">);</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>setAnchorElement<span class=\"k\">(</span>toolbarButton<span class=\"k\">.</span>domNode<span class=\"k\">);</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>setOffsets<span class=\"k\">(</span>offsets<span class=\"k\">);</span>","    ","    <span class=\"k\">this</span><span class=\"k\">.</span>_connectToToolbarButton<span class=\"k\">();</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>_updatePosition<span class=\"k\">();</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","","  setToolbarButton<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">(</span>toolbarButton<span class=\"k\">)</span> <span class=\"k\">{</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton <span class=\"k\">=</span> toolbarButton<span class=\"k\">;</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","  ","  <span class=\"c\">/**</span>","<span class=\"c\">   * @param offsets</span>","<span class=\"c\">   *          Offset (padding) to position the indicator relative to the</span>","<span class=\"c\">   *          anchorElement in pixels, e.g. {top: 2, right: 0, bottom: 0,left: 2} (Currently only left and top are used)</span>","<span class=\"c\">   */</span>","  setOffsets<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">(</span>offsets<span class=\"k\">)</span> <span class=\"k\">{</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>offsets <span class=\"k\">=</span> offsets <span class=\"k\">?</span> offsets <span class=\"k\">:</span> defaultOffsets<span class=\"k\">;</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","  ","  setAnchorElement<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">(</span>e<span class=\"k\">)</span> <span class=\"k\">{</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>anchorElement <span class=\"k\">=</span> e<span class=\"k\">;</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","","  _connectToToolbarButton<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","    dojo<span class=\"k\">.</span>connect<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">'onclick'</span><span class=\"k\">,</span> <span class=\"k\">this</span><span class=\"k\">,</span> <span class=\"k\">function</span><span class=\"k\">(</span>event<span class=\"k\">)</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_onButtonClick<span class=\"k\">(</span>event<span class=\"k\">);</span>","      dojo<span class=\"k\">.</span>stopEvent<span class=\"k\">(</span>event<span class=\"k\">);</span>","    <span class=\"k\">}</span><span class=\"k\">);</span>","    dojo<span class=\"k\">.</span>connect<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">'onmouseover'</span><span class=\"k\">,</span> <span class=\"k\">this</span><span class=\"k\">,</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_set<span class=\"k\">(</span><span class=\"s\">\"hovering\"</span><span class=\"k\">,</span> <span class=\"k\">true</span><span class=\"k\">);</span>","    <span class=\"k\">}</span><span class=\"k\">);</span>","    dojo<span class=\"k\">.</span>connect<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">'onmouseout'</span><span class=\"k\">,</span> <span class=\"k\">this</span><span class=\"k\">,</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_set<span class=\"k\">(</span><span class=\"s\">\"hovering\"</span><span class=\"k\">,</span> <span class=\"k\">false</span><span class=\"k\">);</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_set<span class=\"k\">(</span><span class=\"s\">\"active\"</span><span class=\"k\">,</span> <span class=\"k\">false</span><span class=\"k\">);</span>","    <span class=\"k\">}</span><span class=\"k\">);</span>","    dojo<span class=\"k\">.</span>connect<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">'onmousedown'</span><span class=\"k\">,</span> <span class=\"k\">this</span><span class=\"k\">,</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_set<span class=\"k\">(</span><span class=\"s\">\"hovering\"</span><span class=\"k\">,</span> <span class=\"k\">true</span><span class=\"k\">);</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_set<span class=\"k\">(</span><span class=\"s\">\"active\"</span><span class=\"k\">,</span> <span class=\"k\">true</span><span class=\"k\">);</span>","    <span class=\"k\">}</span><span class=\"k\">);</span>","    dojo<span class=\"k\">.</span>connect<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">'onmouseup'</span><span class=\"k\">,</span> <span class=\"k\">this</span><span class=\"k\">,</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_set<span class=\"k\">(</span><span class=\"s\">\"hovering\"</span><span class=\"k\">,</span> <span class=\"k\">true</span><span class=\"k\">);</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>toolbarButton<span class=\"k\">.</span>_set<span class=\"k\">(</span><span class=\"s\">\"active\"</span><span class=\"k\">,</span> <span class=\"k\">false</span><span class=\"k\">);</span>","    <span class=\"k\">}</span><span class=\"k\">);</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","  ","  <span class=\"c\">/**</span>","<span class=\"c\">   * Update the filter indicator's position relative to the anchor element and</span>","<span class=\"c\">   * offsets.</span>","<span class=\"c\">   */</span>","  _updatePosition<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","    <span class=\"k\">if</span> <span class=\"k\">(!</span><span class=\"k\">this</span><span class=\"k\">.</span>anchorElement<span class=\"k\">)</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>hide<span class=\"k\">();</span>","      <span class=\"k\">return</span><span class=\"k\">;</span>","    <span class=\"k\">}</span>","    <span class=\"k\">var</span> c <span class=\"k\">=</span> dojo<span class=\"k\">.</span>coords<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>anchorElement<span class=\"k\">);</span>","    <span class=\"k\">var</span> left <span class=\"k\">=</span> c<span class=\"k\">.</span>x <span class=\"k\">+</span> <span class=\"k\">this</span><span class=\"k\">.</span>offsets<span class=\"k\">.</span>left<span class=\"k\">;</span>","    <span class=\"k\">var</span> top <span class=\"k\">=</span> c<span class=\"k\">.</span>y <span class=\"k\">+</span> <span class=\"k\">this</span><span class=\"k\">.</span>offsets<span class=\"k\">.</span>top<span class=\"k\">;</span>","    dojo<span class=\"k\">.</span>style<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">\"left\"</span><span class=\"k\">,</span> left <span class=\"k\">+</span> <span class=\"s\">\"px\"</span><span class=\"k\">);</span>","    dojo<span class=\"k\">.</span>style<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">\"top\"</span><span class=\"k\">,</span> top <span class=\"k\">+</span> <span class=\"s\">\"px\"</span><span class=\"k\">);</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","  ","  <span class=\"c\">/**</span>","<span class=\"c\">   * Update the filter indicator to reflect the number of filters provided.</span>","<span class=\"c\">   * </span>","<span class=\"c\">   * @param numFilters</span>","<span class=\"c\">   *          Number of filters currently active.</span>","<span class=\"c\">   */</span>","  update<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">(</span>numFilters<span class=\"k\">)</span> <span class=\"k\">{</span>","    <span class=\"k\">if</span> <span class=\"k\">(!</span>numFilters <span class=\"k\">||</span> numFilters <span class=\"k\">&lt;</span> <span class=\"k\">this</span><span class=\"k\">.</span>min<span class=\"k\">)</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>hide<span class=\"k\">();</span>","    <span class=\"k\">}</span> <span class=\"k\">else</span> <span class=\"k\">if</span> <span class=\"k\">(</span>numFilters <span class=\"k\">&lt;=</span> <span class=\"k\">this</span><span class=\"k\">.</span>max<span class=\"k\">)</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>changeBackground<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>backgroundClassPrefix <span class=\"k\">+</span> numFilters<span class=\"k\">);</span>","    <span class=\"k\">}</span> <span class=\"k\">else</span> <span class=\"k\">{</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>changeBackground<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>backgroundClassPrefix <span class=\"k\">+</span> <span class=\"k\">this</span><span class=\"k\">.</span>backgroundClassOverflow<span class=\"k\">);</span>","    <span class=\"k\">}</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>_updatePosition<span class=\"k\">();</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","","  show<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","    dojo<span class=\"k\">.</span>removeClass<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">\"hidden\"</span><span class=\"k\">);</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","","  hide<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">()</span> <span class=\"k\">{</span>","   dojo<span class=\"k\">.</span>addClass<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"s\">\"hidden\"</span><span class=\"k\">);</span>","  <span class=\"k\">}</span><span class=\"k\">,</span>","","  <span class=\"c\">/**</span>","<span class=\"c\">   * Swap the background CSS class for the container node to the one provided. This will remove the existing background class.</span>","<span class=\"c\">   */</span>","  changeBackground<span class=\"k\">:</span> <span class=\"k\">function</span><span class=\"k\">(</span>className<span class=\"k\">)</span> <span class=\"k\">{</span>","    <span class=\"k\">if</span> <span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>currentBackgroundClass <span class=\"k\">!==</span> className<span class=\"k\">)</span> <span class=\"k\">{</span>","      dojo<span class=\"k\">.</span>addClass<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> className<span class=\"k\">);</span>","      <span class=\"k\">if</span> <span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>currentBackgroundClass<span class=\"k\">)</span> <span class=\"k\">{</span>","        dojo<span class=\"k\">.</span>removeClass<span class=\"k\">(</span><span class=\"k\">this</span><span class=\"k\">.</span>containerNode<span class=\"k\">,</span> <span class=\"k\">this</span><span class=\"k\">.</span>currentBackgroundClass<span class=\"k\">);</span>","      <span class=\"k\">}</span>","      <span class=\"k\">this</span><span class=\"k\">.</span>currentBackgroundClass <span class=\"k\">=</span> className<span class=\"k\">;</span>","    <span class=\"k\">}</span>","    <span class=\"k\">this</span><span class=\"k\">.</span>show<span class=\"k\">();</span>","  <span class=\"k\">}</span>","<span class=\"k\">}</span><span class=\"k\">);</span>"];
_$jscoverage['dojo/pentaho/common/FilterIndicator.js'][1]++;
dojo.provide("pentaho.common.FilterIndicator");
_$jscoverage['dojo/pentaho/common/FilterIndicator.js'][7]++;
dojo.declare("pentaho.common.FilterIndicator", [dijit._Widget, dijit._Templated], {templateString: "<div dojoAttachPoint=\"containerNode\" class=\"hidden cursorPointer filterToolbarIndicator\"></div>", backgroundClassPrefix: "filterIndicatorBackground_", backgroundClassOverflow: "9_plus", min: 1, max: 9, currentBackgroundClass: undefined, toolbarButton: undefined, anchorElement: undefined, defaultOffsets: {top: 0, left: 0, bottom: 0, right: 0}, offsets: this.defaultOffsets, configure: (function (toolbarButton, offsets) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][37]++;
  this.setToolbarButton(toolbarButton);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][38]++;
  this.setAnchorElement(toolbarButton.domNode);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][39]++;
  this.setOffsets(offsets);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][41]++;
  this._connectToToolbarButton();
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][42]++;
  this._updatePosition();
}), setToolbarButton: (function (toolbarButton) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][46]++;
  this.toolbarButton = toolbarButton;
}), setOffsets: (function (offsets) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][55]++;
  this.offsets = (offsets? offsets: defaultOffsets);
}), setAnchorElement: (function (e) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][59]++;
  this.anchorElement = e;
}), _connectToToolbarButton: (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][63]++;
  dojo.connect(this.containerNode, "onclick", this, (function (event) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][64]++;
  this.toolbarButton._onButtonClick(event);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][65]++;
  dojo.stopEvent(event);
}));
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][67]++;
  dojo.connect(this.containerNode, "onmouseover", this, (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][68]++;
  this.toolbarButton._set("hovering", true);
}));
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][70]++;
  dojo.connect(this.containerNode, "onmouseout", this, (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][71]++;
  this.toolbarButton._set("hovering", false);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][72]++;
  this.toolbarButton._set("active", false);
}));
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][74]++;
  dojo.connect(this.containerNode, "onmousedown", this, (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][75]++;
  this.toolbarButton._set("hovering", true);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][76]++;
  this.toolbarButton._set("active", true);
}));
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][78]++;
  dojo.connect(this.containerNode, "onmouseup", this, (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][79]++;
  this.toolbarButton._set("hovering", true);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][80]++;
  this.toolbarButton._set("active", false);
}));
}), _updatePosition: (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][89]++;
  if ((! this.anchorElement)) {
    _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][90]++;
    this.hide();
    _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][91]++;
    return;
  }
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][93]++;
  var c = dojo.coords(this.anchorElement);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][94]++;
  var left = (c.x + this.offsets.left);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][95]++;
  var top = (c.y + this.offsets.top);
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][96]++;
  dojo.style(this.containerNode, "left", (left + "px"));
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][97]++;
  dojo.style(this.containerNode, "top", (top + "px"));
}), update: (function (numFilters) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][107]++;
  if (((! numFilters) || (numFilters < this.min))) {
    _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][108]++;
    this.hide();
  }
  else {
    _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][109]++;
    if ((numFilters <= this.max)) {
      _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][110]++;
      this.changeBackground((this.backgroundClassPrefix + numFilters));
    }
    else {
      _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][112]++;
      this.changeBackground((this.backgroundClassPrefix + this.backgroundClassOverflow));
    }
  }
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][114]++;
  this._updatePosition();
}), show: (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][118]++;
  dojo.removeClass(this.containerNode, "hidden");
}), hide: (function () {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][122]++;
  dojo.addClass(this.containerNode, "hidden");
}), changeBackground: (function (className) {
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][129]++;
  if ((this.currentBackgroundClass !== className)) {
    _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][130]++;
    dojo.addClass(this.containerNode, className);
    _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][131]++;
    if (this.currentBackgroundClass) {
      _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][132]++;
      dojo.removeClass(this.containerNode, this.currentBackgroundClass);
    }
    _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][134]++;
    this.currentBackgroundClass = className;
  }
  _$jscoverage['dojo/pentaho/common/FilterIndicator.js'][136]++;
  this.show();
})});
